/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.function;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.entity.formula.BOSExpression;
import kd.bos.entity.formula.ExpressionContext;
import kd.bos.entity.formula.VarValueParser;
import kd.bos.entity.function.BOSBatchFunction;
import kd.bos.entity.function.BOSUDFunction;
import kd.bos.entity.function.BatchFuncRunParam;
import kd.bos.entity.function.ExprFuncCreator;
import kd.bos.entity.function.FunctionFeatures;
import kd.bos.entity.function.FunctionManage;
import kd.bos.entity.function.UDFunctionVisitor;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.Expr;
import kd.bos.formula.excel.FunCall;
import kd.bos.formula.excel.UDFunction;
import kd.bos.formula.excel.Visitor;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class BatchFuncParser {
    private Map<String, BOSUDFunction> funcExectors = new HashMap<String, BOSUDFunction>(8);
    private Map<String, List<FunCall>> exprBatchFunCalls = new HashMap<String, List<FunCall>>(8);
    private Map<String, Set<String>> exprSubFunNames = new HashMap<String, Set<String>>(8);

    public Set<BatchFuncRunParam> preCall(BOSExpression expression, ExpressionContext expContext, FunctionManage funcLib) {
        if (expression == null || expression.getExpr() == null) {
            return new HashSet<BatchFuncRunParam>(0);
        }
        List<FunCall> batchFunCalls = this.getBatchFunCalls(expression, expContext, funcLib);
        if (batchFunCalls.isEmpty()) {
            return new HashSet<BatchFuncRunParam>(0);
        }
        HashSet<BatchFuncRunParam> funcRunParams = new HashSet<BatchFuncRunParam>(batchFunCalls.size());
        Map<String, Object> varValues = VarValueParser.getVarValues(expression, expContext);
        for (FunCall batchFunc : batchFunCalls) {
            funcRunParams.add(this.calcPramValues(batchFunc, varValues, expContext, funcLib));
        }
        return funcRunParams;
    }

    public Map<BatchFuncRunParam, Object> batchCall(Set<BatchFuncRunParam> batchParams, ExpressionContext expContext, FunctionManage funcLib) {
        HashMap<String, Set> groupByFunc = new HashMap<String, Set>(4);
        for (BatchFuncRunParam param : batchParams) {
            Set group = groupByFunc.computeIfAbsent(param.getFuncName(), k -> new HashSet());
            group.add(param);
        }
        Map<BatchFuncRunParam, Object> result = this.createBatchRunResult(batchParams, expContext);
        this.funcExectors.clear();
        for (Map.Entry funcEntry : groupByFunc.entrySet()) {
            BOSUDFunction funcExecutor = this.getFuncExecutor((String)funcEntry.getKey(), expContext, funcLib);
            if (funcExecutor instanceof BOSBatchFunction) {
                result.putAll(((BOSBatchFunction)((Object)funcExecutor)).batchCall((Set)funcEntry.getValue()));
            }
            if (expContext.getBatchResultMaxCount() <= 0 || result.size() < expContext.getBatchResultMaxCount()) continue;
            break;
        }
        return result;
    }

    private BatchFuncRunParam calcPramValues(FunCall batchFunCall, Map<String, Object> varValues, ExpressionContext expContext, FunctionManage funcLib) {
        Set<String> subFunNames = this.exprSubFunNames.get(batchFunCall.toString());
        if (subFunNames == null) {
            UDFunctionVisitor subFuncVisitor = new UDFunctionVisitor();
            batchFunCall.accept((Visitor)subFuncVisitor);
            subFunNames = new HashSet<String>(subFuncVisitor.getFuncNames());
            this.exprSubFunNames.put(batchFunCall.toString(), subFunNames);
        }
        UDFunction[] functions = ExprFuncCreator.createUDFunctions(subFunNames, funcLib, expContext);
        Object[] paramValues = new Object[batchFunCall.getParams().length];
        for (int i = 0; i < batchFunCall.getParams().length; ++i) {
            paramValues[i] = FormulaEngine.execExcelFormula((Expr)batchFunCall.getParams()[i], varValues, (UDFunction[])functions);
        }
        return new BatchFuncRunParam(batchFunCall.getName(), paramValues);
    }

    private List<FunCall> getBatchFunCalls(BOSExpression expression, ExpressionContext expContext, FunctionManage funcLib) {
        List<FunCall> funCalls = this.exprBatchFunCalls.get(expression.getExpression());
        if (funCalls != null) {
            return funCalls;
        }
        funCalls = new ArrayList<FunCall>(1);
        UDFunctionVisitor funcVisitor = new UDFunctionVisitor();
        expression.getExpr().accept((Visitor)funcVisitor);
        for (FunCall funCall : funcVisitor.getFunCalls()) {
            if (!this.isBatchFunction(funCall, expContext, funcLib)) continue;
            funCalls.add(funCall);
        }
        this.exprBatchFunCalls.put(expression.getExpression(), funCalls);
        return funCalls;
    }

    private boolean isBatchFunction(FunCall funCall, ExpressionContext expContext, FunctionManage funcLib) {
        BOSUDFunction funcExecutor = this.getFuncExecutor(funCall.getName(), expContext, funcLib);
        if (funcExecutor == null || !(funcExecutor instanceof BOSBatchFunction)) {
            return false;
        }
        boolean paramSupportBatchRun = true;
        UDFunctionVisitor paramVisitor = new UDFunctionVisitor();
        funCall.accept((Visitor)paramVisitor);
        for (int i = 1; i < paramVisitor.getFunCalls().size(); ++i) {
            FunCall subFunCall = paramVisitor.getFunCalls().get(i);
            if (this.isSupportBatchRunParam(subFunCall, expContext, funcLib)) continue;
            paramSupportBatchRun = false;
        }
        return paramSupportBatchRun;
    }

    private boolean isSupportBatchRunParam(FunCall subFunCall, ExpressionContext expContext, FunctionManage funcLib) {
        BOSUDFunction subFuncExecutor = this.getFuncExecutor(subFunCall.getName(), expContext, funcLib);
        if (subFuncExecutor == null) {
            return true;
        }
        if (subFuncExecutor instanceof BOSBatchFunction) {
            return false;
        }
        FunctionFeatures features = subFuncExecutor.getClass().getAnnotation(FunctionFeatures.class);
        return features != null && features.isSupportBatchRunParam();
    }

    private BOSUDFunction getFuncExecutor(String funcName, ExpressionContext expContext, FunctionManage funcLib) {
        BOSUDFunction funcExecutor = this.funcExectors.get(funcName);
        if (funcExecutor != null) {
            return funcExecutor;
        }
        BOSUDFunction funcDefine = funcLib.getFuncMap().get(funcName);
        if (funcDefine != null) {
            funcExecutor = funcDefine.getInstance(expContext);
            this.funcExectors.put(funcExecutor.getName(), funcExecutor);
            return funcExecutor;
        }
        return null;
    }

    private Map<BatchFuncRunParam, Object> createBatchRunResult(Set<BatchFuncRunParam> batchParams, final ExpressionContext expContext) {
        LinkedHashMap<BatchFuncRunParam, Object> result = null;
        result = expContext.getBatchResultMaxCount() == 0 ? new HashMap(batchParams.size()) : new LinkedHashMap<BatchFuncRunParam, Object>(){
            private static final long serialVersionUID = 3478868504628365463L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<BatchFuncRunParam, Object> eldest) {
                return this.size() > expContext.getBatchResultMaxCount();
            }
        };
        return result;
    }
}

