/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.list;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.ComplexPropertyAttribute;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.entity.datamodel.NumberPrecision;
import kd.bos.entity.list.NumberPrecisionDeserializer;
import kd.bos.entity.list.NumberPrecisionSerializer;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class SummaryResult
implements Serializable {
    private static final long serialVersionUID = 1L;
    String fieldName;
    int summary;
    NumberPrecision numberPrecision;

    @SimplePropertyAttribute
    public int getSummary() {
        return this.summary;
    }

    public void setSummary(int summary) {
        this.summary = summary;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    @JsonSerialize(using=NumberPrecisionSerializer.class)
    @JsonDeserialize(using=NumberPrecisionDeserializer.class)
    @ComplexPropertyAttribute
    public NumberPrecision getNumberPrecision() {
        return this.numberPrecision;
    }

    public void setNumberPrecision(NumberPrecision numberPrecision) {
        this.numberPrecision = numberPrecision;
    }

    public SummaryResult() {
    }

    public SummaryResult(String fieldName, BigDecimal result, int summary) {
        this.fieldName = fieldName;
        this.numberPrecision = new NumberPrecision(result);
        this.summary = summary;
    }

    public void addResult(BigDecimal result) {
        this.numberPrecision.addResult(result);
        this.numberPrecision = new NumberPrecision(this.numberPrecision.getPrecision(), this.numberPrecision.getSign(), this.numberPrecision.isShowSign(), this.numberPrecision.getResult());
    }

    public String toString() {
        return this.numberPrecision.toString();
    }

    public String toFmtString() {
        return this.numberPrecision.getFmtString();
    }

    public Map<String, Object> createSummaryResultMap() {
        HashMap<String, Object> summaryResultMap = new HashMap<String, Object>();
        summaryResultMap.put(this.getFieldName(), this.toFmtString());
        return summaryResultMap;
    }
}

