/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.list.column;

import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.format.FormatFactory;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.format.FormatTypes;
import kd.bos.entity.format.IFormat;
import kd.bos.entity.list.column.DateTimeColumnDesc;
import kd.bos.entity.property.DateProp;
import kd.bos.service.InteTimeZone;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class DateColumnDesc
extends DateTimeColumnDesc {
    private IFormat format;

    @Override
    protected IFormat getFormat() {
        if (this.format == null) {
            this.format = FormatFactory.get(FormatTypes.Date);
        }
        return this.format;
    }

    @Override
    protected String getDefaultFmtString() {
        return "yyyy-MM-dd";
    }

    @Override
    public void setMask(String mask) {
        this.mask = mask;
    }

    @Override
    public void setDisplayFormatString(String displayFormatString) {
        this.displayFormatString = displayFormatString;
    }

    @Override
    public String getMask() {
        return StringUtils.isEmpty((CharSequence)this.mask) ? "yyyy-MM-dd" : this.mask;
    }

    @Override
    public String getDisplayFormatString() {
        return StringUtils.isEmpty((CharSequence)this.displayFormatString) ? "" : this.displayFormatString;
    }

    public DateColumnDesc(String key, DateProp dateProp, IDataEntityProperty fieldProp) {
        super(key, dateProp, fieldProp);
    }

    @Override
    protected void bindTimeZone(Object[] date, InteTimeZone zone, FormatObject fo) {
        if (fo != null && fo.isTimeNotEmpty()) {
            fo.getDateFormat().setTimeArea(zone.getTimeArea());
        }
    }
}

