/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.list.column;

import java.text.DateFormat;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.format.FormatFactory;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.format.FormatTypes;
import kd.bos.entity.format.IFormat;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.entity.property.CreateDateProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.ModifyDateProp;
import kd.bos.service.InteTimeZone;
import kd.bos.service.TransType;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class DateTimeColumnDesc
extends ColumnDesc {
    private DateTimeProp dateProp;
    private IFormat format;

    protected IFormat getFormat() {
        if (this.format == null) {
            DateTimeProp srcProp = (DateTimeProp)this.getSrcFieldProp();
            this.format = srcProp.getRegionType() == FormatTypes.Time.getValue() ? FormatFactory.get(FormatTypes.Time) : FormatFactory.get(FormatTypes.Date);
        }
        return this.format;
    }

    protected String getDefaultFmtString() {
        return "yyyy-MM-dd HH:mm:ss";
    }

    public DateTimeColumnDesc(String key, DateTimeProp dateProp, IDataEntityProperty fieldProp) {
        super(key, (IDataEntityProperty)dateProp, fieldProp);
        this.dateProp = dateProp;
    }

    @Override
    public String getMask() {
        return StringUtils.isEmpty((CharSequence)super.getMask()) ? this.getDefaultFmtString() : super.getMask();
    }

    @Override
    public String getDisplayFormatString() {
        return StringUtils.isEmpty((CharSequence)super.getDisplayFormatString()) ? "" : super.getDisplayFormatString();
    }

    @Override
    public Object getValue(DynamicObject dr) {
        Object[] results = new Object[2];
        Object value = super.getValue(dr);
        results[0] = null;
        results[1] = value;
        results[0] = value == null ? null : this.formatCell(dr, value, this.getFormaType() == 0 || this.getFormaType() == 2);
        return results;
    }

    protected Object formatCell(DynamicObject dr, Object value, boolean isFormat) {
        Object[] date = new Object[2];
        if (this.formaType == 1 && value != null) {
            date[0] = ((Date)value).getTime();
        } else {
            Long orgId = 0L;
            String orgKey = this.dateProp.getRelateOrg();
            if (StringUtils.isBlank((CharSequence)orgKey)) {
                orgKey = this.getMainOrgKey();
            }
            if (StringUtils.isNotBlank((CharSequence)orgKey)) {
                DynamicObject org;
                IDataEntityType dt = this.getFieldProp().getParent();
                boolean found = false;
                int cycle = 1;
                String objectKey = orgKey;
                while (dt != null && !found && cycle <= 10) {
                    found = dt.getProperties().containsKey((Object)orgKey);
                    if (!found) {
                        dt = dt.getParent();
                        ++cycle;
                        continue;
                    }
                    if (dt instanceof SubEntryType) {
                        objectKey = dt.getParent().getName() + "." + dt.getName() + "." + orgKey;
                        continue;
                    }
                    if (dt instanceof EntryType) {
                        objectKey = dt.getName() + "." + orgKey;
                        continue;
                    }
                    objectKey = orgKey;
                }
                if (found && (org = dr.getDynamicObject(objectKey)) != null) {
                    orgId = (Long)org.getPkValue();
                }
            }
            IFormat format = this.getFormat();
            FormatObject fo = this.getUserFormatObject();
            InteTimeZone zone = this.dateProp.getTimeZone(orgId);
            this.bindTimeZone(date, zone, fo);
            String formatString = this.getDisplayFormatString();
            if (value != null) {
                date[0] = isFormat ? (StringUtils.isBlank((CharSequence)formatString) ? (fo != null ? format.getFormat(fo).format(value) : zone.format((Date)value, (DateFormat)format.getDateTimeFormat(this.getDefaultFmtString()))) : zone.format((Date)value, (DateFormat)format.getDateTimeFormat(formatString))) : Long.valueOf(((Date)value).getTime());
            }
        }
        if (StringUtils.isBlank((Object)date[1]) || this.dateProp instanceof DateProp || this.dateProp instanceof CreateDateProp || this.dateProp instanceof ModifyDateProp) {
            return date[0];
        }
        return date;
    }

    protected void bindTimeZone(Object[] date, InteTimeZone zone, FormatObject fo) {
        if (fo != null && fo.isTimeNotEmpty()) {
            fo.getTimeFormat().setTimeArea(zone.getTimeArea());
            fo.getDateFormat().setTimeArea(zone.getTimeArea());
        }
        InteTimeZone sysTimeZone = InteTimeZone.getSysTimeZone();
        if (TransType.get((int)this.dateProp.getTimeZoneTransType()) == TransType.ORGTIMEZONE && !sysTimeZone.getTimeZone().getID().equals(zone.getTimeZone().getID())) {
            date[1] = zone.getTimeZoneDesc();
        }
    }
}

