/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.list.column;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.list.column.ComboColumnDesc;
import kd.bos.entity.list.column.DateTimeColumnDesc;
import kd.bos.entity.list.column.NumberColumnDesc;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class DynamicTextColumnDesc
extends AbstractColumnDesc {
    String formatExpression;
    List<AbstractColumnDesc> columnDescs;

    public String getFormatExpression() {
        return this.formatExpression;
    }

    public void setFormatExpression(String formatExpression) {
        this.formatExpression = formatExpression;
    }

    public DynamicTextColumnDesc(String key, List<AbstractColumnDesc> columnDescs, String formatExpression) {
        super(key);
        this.columnDescs = columnDescs;
        this.formatExpression = formatExpression;
    }

    private boolean isArray(Object obj) {
        if (obj == null) {
            return false;
        }
        return obj.getClass().isArray();
    }

    @Override
    public Object getValue(DynamicObject dr) {
        String newFormatExpression = this.formatExpression;
        Object[] values = new Object[this.columnDescs.size()];
        int i = 0;
        for (AbstractColumnDesc desc : this.columnDescs) {
            desc.setListUserOption(this.getListUserOption());
            desc.setUserFormat(this.getUserFormatObject());
            newFormatExpression = newFormatExpression.replace('.', '_');
            String fieldKey = desc.getFieldKey().replace('.', '_');
            newFormatExpression = newFormatExpression.replace(String.format("{%s}", fieldKey), String.format("%%%s$s", i + 1));
            Object value = this.getDescValue(dr, desc);
            values[i++] = value == null ? "" : value;
        }
        if (StringUtils.isBlank((CharSequence)newFormatExpression)) {
            return "";
        }
        return String.format(newFormatExpression, values);
    }

    private Object getDescValue(DynamicObject dr, AbstractColumnDesc desc) {
        Object value = null;
        if (desc instanceof ComboColumnDesc) {
            ComboColumnDesc comboColumnDesc = (ComboColumnDesc)desc;
            value = desc.getValue(dr);
            if (value != null) {
                value = comboColumnDesc.getComboProp().getItemByName(value.toString());
            }
        } else if (desc instanceof NumberColumnDesc || desc instanceof DateTimeColumnDesc) {
            value = desc.getValue(dr);
            if (this.isArray(value)) {
                Object[] arrayValues = (Object[])value;
                value = arrayValues[0];
            }
        } else {
            value = desc.getValue(dr);
        }
        if (value instanceof Object[]) {
            return ((Object[])value)[0];
        }
        return value;
    }
}

