/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.operate;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.consts.BOSExtPackage;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.DcxmlSerializer;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.operate.OpDefinitionSource;
import kd.bos.entity.operate.OperationType;
import kd.bos.entity.operate.OperationTypes;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.utils.LocalMemroyCacheUtil;
import kd.bos.utils.LocaleBuildUtils;
import kd.sdk.annotation.SdkPublic;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;

@SdkPublic
public class OperationTypeCache {
    private static final Log log = LogFactory.getLog(OperationTypeCache.class);
    private static final String OP_RREFIX = "OperationType_";
    private static final String OP_ENDSUFFIX = ".xml";
    private static final String EXTOPTYPESFROMDBCACHE = "extOpTypesFromDB";
    private static List<IDataEntityType> dts = new ArrayList<IDataEntityType>();
    private static OperationTypes cacheOpTypes;
    private static Map<String, OperationType> cacheOpTypeMap;
    private static Map<String, OperationTypes> opTypesFromDB;
    private static final String SQL_OPERATION = "SELECT a.FID, a.FKey, a.FName, a.FOperationType, a.FType, a.FModelType, a.FWebClass, a.FClass, a.FBizApp, b.FNumber as FAppNumber from t_bas_operation a left join t_meta_bizapp b on (a.FBizApp = b.FId)";
    private static final String SQL_OPERATION_LANG = "SELECT FID, FLOCALEID, FNAME from T_BAS_OPERATION_L";
    private static final String SQL_EXT_OPERATION = "select a.fid, a.fnumber, a.fapplicationrange, a.fformid, a.fmodelnumber, a.fisv, a.fformserviceclass, a.fopserviceclass, a.fwebapiclass, b.fname, b.fdesc, d.fnumber as appnumber from t_dm_operation a left join t_dm_operation_L b on b.FId=a.FId AND b.FLocaleId=? LEFT JOIN t_dm_operationapp c ON c.FId=a.FId LEFT JOIN t_meta_bizapp d ON d.FId=c.FBasedataId where a.fenable = ?";

    public static void resetCache() {
        cacheOpTypes = null;
        cacheOpTypeMap = null;
        opTypesFromDB.clear();
        LocalMemroyCacheUtil.clear(EXTOPTYPESFROMDBCACHE);
    }

    public static OperationTypes loadAll() {
        OperationTypes opTypes = new OperationTypes();
        opTypes.getOpTypes().addAll(OperationTypeCache.loadFromXml().getOpTypes());
        opTypes.getOpTypes().addAll(OperationTypeCache.loadFromDB().getOpTypes());
        opTypes.getOpTypes().addAll(OperationTypeCache.loadEXTFromDB().getOpTypes());
        return opTypes;
    }

    private static synchronized OperationTypes loadEXTFromDB() {
        String lang = Lang.get().toString();
        OperationTypes opTypes = (OperationTypes)LocalMemroyCacheUtil.get(EXTOPTYPESFROMDBCACHE);
        if (null != opTypes) {
            return opTypes;
        }
        SqlParameter langParam = new SqlParameter(12, (Object)lang);
        SqlParameter enable = new SqlParameter(1, (Object)"1");
        Object[] parameters = new SqlParameter[]{langParam, enable};
        List opTypeList = new ArrayList();
        try {
            opTypeList = (List)DB.query((DBRoute)DBRoute.meta, (String)SQL_EXT_OPERATION, (Object[])parameters, rs -> {
                HashMap<String, OperationType> map = new HashMap<String, OperationType>(32);
                while (rs.next()) {
                    OperationType opType;
                    String fid = rs.getString("fid");
                    if (!map.containsKey(fid)) {
                        opType = new OperationType();
                        opType.setId(rs.getString("fnumber"));
                        opType.setSettingFormId(rs.getString("fformid"));
                        opType.setModelType(rs.getString("fmodelnumber"));
                        String fname = rs.getString("fname");
                        LocaleString name = new LocaleString(lang, fname);
                        opType.setName(name);
                        String fdesc = rs.getString("fdesc");
                        LocaleString desc = new LocaleString(lang, fdesc);
                        opType.setDesc(desc);
                        opType.setFormServiceClass(rs.getString("fformserviceclass"));
                        opType.setOpServiceClass(rs.getString("fopserviceclass"));
                        opType.setWebApiClass(rs.getString("fwebapiclass"));
                        opType.setAppliedRange(rs.getInt("fapplicationrange"));
                        opType.setAppliedAppNumbers(rs.getString("appnumber"));
                        opType.setSrcType(OpDefinitionSource.DM_EXT);
                        opType.setSrcApp(opType.getAppliedAppNumbers());
                        map.put(fid, opType);
                        continue;
                    }
                    opType = (OperationType)map.get(fid);
                    int fapplicationrange = rs.getInt("fapplicationrange");
                    switch (fapplicationrange) {
                        case 1: {
                            String appNumbers = opType.getAppliedAppNumbers() + "," + rs.getString("appnumber");
                            opType.setAppliedAppNumbers(appNumbers);
                        }
                    }
                }
                ArrayList list = new ArrayList(map.size());
                list.addAll(map.values());
                return list;
            });
        }
        catch (Exception e) {
            log.error("operation loadEXTFromDB error:", (Throwable)e);
        }
        opTypes = new OperationTypes();
        opTypes.getOpTypes().addAll(opTypeList);
        LocalMemroyCacheUtil.put(EXTOPTYPESFROMDBCACHE, opTypes);
        return opTypes;
    }

    @Deprecated
    public static OperationTypes loadAll(String modelType, String appNumber, String entityNumber) {
        OperationTypes opTypes = OperationTypeCache.loadAll();
        for (int i = opTypes.getOpTypes().size() - 1; i >= 0; --i) {
            OperationType opType = opTypes.getOpTypes().get(i);
            boolean isMyDish = true;
            switch (opType.getAppliedRange()) {
                case 0: {
                    break;
                }
                case 1: {
                    isMyDish = isMyDish && OperationTypeCache.isMyDish(opType.getAppliedAppNumbers(), appNumber);
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    isMyDish = isMyDish && OperationTypeCache.isMyDish(opType.getAppliedEntityNumber(), entityNumber);
                    break;
                }
            }
            isMyDish = isMyDish && OperationTypeCache.isMyDish(opType.getModelType(), modelType);
            boolean bl = isMyDish = isMyDish && !opType.isDisable();
            if (isMyDish) continue;
            opTypes.getOpTypes().remove(i);
        }
        return opTypes;
    }

    public static OperationType LoadSingle(String opTypeId) {
        Map<String, OperationType> opTypeMap = OperationTypeCache.getOpTypeMap();
        if (opTypeMap.containsKey(opTypeId)) {
            return opTypeMap.get(opTypeId);
        }
        OperationTypes opTypes = OperationTypeCache.loadFromDB();
        for (OperationType opType : opTypes.getOpTypes()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)opType.getId(), (CharSequence)opTypeId)) continue;
            return opType;
        }
        OperationTypes extOpTypes = OperationTypeCache.loadEXTFromDB();
        for (OperationType opType : extOpTypes.getOpTypes()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)opType.getId(), (CharSequence)opTypeId)) continue;
            return opType;
        }
        return null;
    }

    public static Set<String> loadPublicEntityOpTypes() {
        HashSet<String> opTypeIds = new HashSet<String>();
        OperationTypes opTypes = OperationTypeCache.loadFromXml();
        for (OperationType opType : opTypes.getOpTypes()) {
            if (opType.getAppliedRange() != 0 || !StringUtils.isNotBlank((CharSequence)opType.getOpServiceClass())) continue;
            opTypeIds.add(opType.getId());
        }
        return opTypeIds;
    }

    public static boolean isEntityOperation(String opTypeId) {
        OperationType opType = OperationTypeCache.LoadSingle(opTypeId);
        return opType != null && StringUtils.isNotBlank((CharSequence)opType.getOpServiceClass());
    }

    private static synchronized OperationTypes loadFromXml() {
        String[] cloudNumbers;
        if (null != cacheOpTypes && !cacheOpTypes.isCacheOverTime()) {
            if (cacheOpTypes.isLoaded(Lang.get())) {
                return cacheOpTypes;
            }
            OperationTypeCache.fillXmlLocaleRes(cacheOpTypes, BOSExtPackage.getExtPackageNumbers(), Lang.get());
            return cacheOpTypes;
        }
        cacheOpTypes = new OperationTypes();
        cacheOpTypeMap = null;
        ArrayList<String> notExistCloudNumbers = new ArrayList<String>(200);
        ArrayList<String> existCloudNumbers = new ArrayList<String>(100);
        ArrayList<String> typeNames = new ArrayList<String>(10);
        for (String cloudNumber : cloudNumbers = BOSExtPackage.getExtPackageNumbers()) {
            try {
                OperationTypes types = OperationTypeCache.loadDefLangFromXml(cloudNumber);
                cacheOpTypes.getOpTypes().addAll(types.getOpTypes());
                if (!types.getOpTypes().isEmpty()) {
                    typeNames.clear();
                    for (OperationType opType : types.getOpTypes()) {
                        typeNames.add(opType.getId());
                        opType.setSrcType(OpDefinitionSource.XML);
                        opType.setSrcApp(cloudNumber);
                    }
                    existCloudNumbers.add(String.format("%s:[%s]", cloudNumber, StringUtils.join((Object[])typeNames.toArray(), (String)",")));
                    continue;
                }
                notExistCloudNumbers.add(cloudNumber);
            }
            catch (Throwable exp) {
                log.error(exp);
            }
        }
        cacheOpTypes.setLoaded(Lang.zh_CN);
        Lang currentLang = Lang.get();
        if (currentLang != Lang.zh_CN) {
            OperationTypeCache.fillXmlLocaleRes(cacheOpTypes, cloudNumbers, currentLang);
        }
        log.info(String.format("\u64cd\u4f5c\u8bfb\u53d6\u5b8c\u6bd5\uff1a[%s]; \u65e0\u64cd\u4f5c\u7684\u5e94\u7528: [%s]", StringUtils.join((Object[])existCloudNumbers.toArray(), (String)","), StringUtils.join((Object[])notExistCloudNumbers.toArray(), (String)",")));
        return cacheOpTypes;
    }

    private static void fillXmlLocaleRes(OperationTypes defOpTypes, String[] cloudNumbers, Lang lang) {
        for (String cloudNumber : cloudNumbers) {
            try {
                OperationTypes localeTypes = OperationTypeCache.loadFromXml(cloudNumber, lang);
                HashMap<String, OperationType> typeMap = new HashMap<String, OperationType>(16);
                for (OperationType operationType : defOpTypes.getOpTypes()) {
                    typeMap.put(operationType.getId(), operationType);
                }
                String langStr = lang.toString();
                for (OperationType tType : localeTypes.getOpTypes()) {
                    OperationType type3 = (OperationType)typeMap.get(tType.getId());
                    if (null == type3) continue;
                    LocaleString tName = tType.getName();
                    LocaleString tDesc = tType.getDesc();
                    if (null != tName && StringUtils.isNotBlank((CharSequence)((CharSequence)tName.getItem(langStr)))) {
                        type3.getName().setItem(langStr, tName.getItem(langStr));
                    }
                    if (null == tDesc || !StringUtils.isNotBlank((CharSequence)((CharSequence)tDesc.getItem(langStr)))) continue;
                    type3.getDesc().setItem(langStr, tDesc.getItem(langStr));
                }
                if (Boolean.getBoolean("sys.domainmodel.oldlocale.disable")) continue;
                OperationTypes operationTypes = OperationTypeCache.loadOldLocaleRes(cloudNumber, lang);
                for (OperationType tType : operationTypes.getOpTypes()) {
                    OperationType type4 = (OperationType)typeMap.get(tType.getId());
                    if (null == type4) continue;
                    LocaleString tName = tType.getName();
                    LocaleString tDesc = tType.getDesc();
                    if (null != tName && StringUtils.equals((CharSequence)((CharSequence)tName.getItem(langStr)), (CharSequence)((CharSequence)tName.getItem(Lang.zh_CN.toString())))) {
                        type4.getName().setItem(langStr, tName.getItem(langStr));
                    }
                    if (null == tDesc || !StringUtils.equals((CharSequence)((CharSequence)tDesc.getItem(langStr)), (CharSequence)((CharSequence)tDesc.getItem(Lang.zh_CN.toString())))) continue;
                    type4.getDesc().setItem(langStr, tDesc.getItem(langStr));
                }
            }
            catch (Throwable exp) {
                log.error(exp);
            }
        }
        defOpTypes.setLoaded(lang);
    }

    private static OperationTypes loadDefLangFromXml(String cloudNumber) {
        OperationTypes operationTypes = OperationTypeCache.loadFromXml(cloudNumber, Lang.zh_CN);
        operationTypes.setLoaded(Lang.zh_CN);
        return operationTypes;
    }

    private static OperationTypes loadFromXml(String cloudNumber, Lang lang) {
        String fileName = OP_RREFIX + cloudNumber.toLowerCase() + OP_ENDSUFFIX;
        URL url = OperationTypes.class.getClassLoader().getResource(fileName);
        if (null == url) {
            return new OperationTypes();
        }
        try {
            DcxmlSerializer ser = new DcxmlSerializer(dts);
            String langStr = lang.toString();
            ser.getBinder().setLCId(langStr);
            SAXReader xmlReader = LocaleBuildUtils.getSaxReader();
            Document document = xmlReader.read(url);
            LocaleBuildUtils.replaceLocaleVars(fileName, document, langStr);
            return (OperationTypes)ser.deserialize(document, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static OperationTypes loadOldLocaleRes(String cloudNumber, Lang lang) {
        String fileName = OP_RREFIX + cloudNumber.toLowerCase() + "." + lang.toString() + OP_ENDSUFFIX;
        URL url = OperationTypes.class.getClassLoader().getResource(fileName);
        if (null == url) {
            return new OperationTypes();
        }
        DcxmlSerializer ser = new DcxmlSerializer(dts);
        ser.getBinder().setLCId(lang.toString());
        return (OperationTypes)ser.deserialize(url, null);
    }

    private static synchronized OperationTypes loadFromDB() {
        String cacheKey = CacheKeyUtil.getAcctId() + "." + Lang.get().toString();
        OperationTypes opTypes = opTypesFromDB.get(cacheKey);
        if (null != opTypes && opTypes.isCacheOverTime()) {
            return opTypes;
        }
        Object[] sqlParas = new SqlParameter[]{};
        Map localeMap = (Map)DB.query((DBRoute)DBRoute.meta, (String)SQL_OPERATION_LANG, (Object[])sqlParas, rs -> {
            HashMap<Long, LocaleString> map = new HashMap<Long, LocaleString>();
            while (rs.next()) {
                long id = rs.getLong("FID");
                String localeId = rs.getString("FLOCALEID");
                String name = rs.getString("FNAME");
                LocaleString locale = (LocaleString)map.get(id);
                if (null == locale) {
                    map.put(id, new LocaleString(localeId, name));
                    continue;
                }
                locale.put(localeId, (Object)name);
            }
            return map;
        });
        List opTypeList = (List)DB.query((DBRoute)DBRoute.meta, (String)SQL_OPERATION, (Object[])sqlParas, rs -> {
            ArrayList<OperationType> list = new ArrayList<OperationType>(32);
            while (rs.next()) {
                long id = rs.getLong("FID");
                LocaleString locale = (LocaleString)localeMap.get(id);
                if (null == locale) {
                    String name = rs.getString("FName");
                    locale = new LocaleString(name);
                }
                OperationType opType = new OperationType();
                opType.setSeq(id);
                opType.setName(locale);
                opType.setDesc(locale);
                opType.setAppliedRange(1);
                opType.setId(rs.getString("FKey"));
                opType.setModelType(rs.getString("FModelType"));
                opType.setFormServiceClass(rs.getString("FWebClass"));
                opType.setOpServiceClass(rs.getString("FClass"));
                opType.setAppliedAppNumbers(rs.getString("FAppNumber"));
                opType.setSrcType(OpDefinitionSource.DB);
                opType.setSrcApp(opType.getAppliedAppNumbers());
                list.add(opType);
            }
            return list;
        });
        opTypes = new OperationTypes();
        opTypes.getOpTypes().addAll(opTypeList);
        opTypesFromDB.put(cacheKey, opTypes);
        return opTypesFromDB.get(cacheKey);
    }

    private static synchronized Map<String, OperationType> getOpTypeMap() {
        if (cacheOpTypeMap == null) {
            OperationTypes opTypes = OperationTypeCache.loadFromXml();
            cacheOpTypeMap = new HashMap<String, OperationType>();
            for (OperationType opType : opTypes.getOpTypes()) {
                cacheOpTypeMap.put(opType.getId(), opType);
            }
        }
        return cacheOpTypeMap;
    }

    private static boolean isMyDish(String me, String dish) {
        String[] numbers;
        if (StringUtils.isBlank((CharSequence)me)) {
            return true;
        }
        if (StringUtils.isBlank((CharSequence)dish)) {
            return true;
        }
        for (String number : numbers = me.split(",")) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)number, (CharSequence)dish)) continue;
            return true;
        }
        return false;
    }

    static {
        dts.add(OrmUtils.getDataEntityType(OperationTypes.class));
        dts.add(OrmUtils.getDataEntityType(OperationType.class));
        opTypesFromDB = new HashMap<String, OperationTypes>();
    }
}

