/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.operate.bizrule.asyncbizrule;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.bizrule.AbstractOpBizRuleAction;
import kd.bos.entity.operate.bizrule.asyncbizrule.AsyncOpBizRuleServiceMsgInfo;
import kd.bos.entity.operate.bizrule.asyncbizrule.AsyncServiceParam;
import kd.bos.entity.operate.bizrule.asyncbizrule.enums.AsyncStatusEnum;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.service.DispatchService;
import kd.bos.service.lookup.ServiceLookup;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public abstract class AbstractAsyncOpBizRuleAction
extends AbstractOpBizRuleAction {
    private AsyncOpBizRuleServiceMsgInfo serviceMessageInfo = null;
    private static final String ASYNC_STATUS = "asyncstatus";

    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add(ASYNC_STATUS);
    }

    @Override
    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        this.setServiceMessageBaseInfo();
        this.setMServiceParam(this.serviceMessageInfo, e.getDataEntities());
        this.setAsyncLogID();
    }

    @Override
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        this.setBillAsyncStatusUnfinished(e.getDataEntities());
    }

    @Override
    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        this.publishMsg();
    }

    public abstract void setMServiceParam(AsyncOpBizRuleServiceMsgInfo var1, DynamicObject[] var2);

    private void setServiceMessageBaseInfo() {
        String operator = (String)this.operateMeta.get("type");
        String operatorName = (String)((Map)this.operateMeta.get("name")).get(ResManager.getLanguage());
        String opRuleKey = this.getBizRule().getKey();
        String opRuleName = this.getBizRule().getName().getLocaleValue();
        String entity = this.billEntityType.getName();
        this.serviceMessageInfo = new AsyncOpBizRuleServiceMsgInfo(operator, operatorName, opRuleKey, opRuleName, entity);
        this.serviceMessageInfo.setOperateOption(this.operateOption);
    }

    private void setAsyncLogID() {
        String serviceMessageInfoSer = SerializationUtils.serializeToBase64((Object)this.serviceMessageInfo);
        DispatchService service = (DispatchService)ServiceLookup.lookup(DispatchService.class, (String)"bos");
        serviceMessageInfoSer = (String)service.invoke("kd.bos.service.ServiceFactory", "AsyncOpBizRuleActionService", "setAsyncLogID", new Object[]{serviceMessageInfoSer});
        this.serviceMessageInfo = (AsyncOpBizRuleServiceMsgInfo)SerializationUtils.deSerializeFromBase64((String)serviceMessageInfoSer);
    }

    private void publishMsg() {
        this.deleteFailBillAsyncLog();
        String serviceMessageInfoSer = SerializationUtils.serializeToBase64((Object)this.serviceMessageInfo);
        DispatchService service = (DispatchService)ServiceLookup.lookup(DispatchService.class, (String)"bos");
        service.invoke("kd.bos.service.ServiceFactory", "AsyncOpBizRuleActionService", "publishMsg", new Object[]{serviceMessageInfoSer});
    }

    private void setBillAsyncStatusUnfinished(DynamicObject[] dataEntities) {
        HashSet<Object> asycBillIds = new HashSet<Object>(this.serviceMessageInfo.getAsycParams().size());
        for (AsyncServiceParam asycParam : this.serviceMessageInfo.getAsycParams()) {
            asycBillIds.add(asycParam.getBillID());
        }
        for (DynamicObject billDyc : dataEntities) {
            if (!asycBillIds.contains(billDyc.getPkValue())) continue;
            billDyc.set(ASYNC_STATUS, (Object)AsyncStatusEnum.UNFINISHED.getValue());
        }
    }

    private void deleteFailBillAsyncLog() {
        List<Object> successPkIds = this.getOperationResult().getSuccessPkIds();
        List<AsyncServiceParam> asycParams = this.serviceMessageInfo.getAsycParams();
        ArrayList<AsyncServiceParam> newAsyncServiceParams = new ArrayList<AsyncServiceParam>(asycParams.size());
        ArrayList<Long> failLogPkIds = new ArrayList<Long>(16);
        for (AsyncServiceParam asyncServiceParam : asycParams) {
            if (successPkIds.contains(asyncServiceParam.getBillID())) {
                newAsyncServiceParams.add(asyncServiceParam);
                continue;
            }
            failLogPkIds.add(asyncServiceParam.getLogID());
        }
        this.serviceMessageInfo.setMServiceParam(newAsyncServiceParams);
        if (failLogPkIds.size() > 0) {
            String asyncLogTable = EntityMetadataCache.getDataEntityType("bos_log_asyncop").getAlias();
            SqlBuilder sqlBuilder = new SqlBuilder();
            sqlBuilder.append(String.format("delete from %s where ", asyncLogTable), new Object[0]);
            sqlBuilder.appendIn("fid", failLogPkIds);
            try (TXHandle h = TX.requiresNew();){
                DB.execute((DBRoute)DBRoute.log, (SqlBuilder)sqlBuilder);
            }
        }
    }
}

