/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.operate.result;

import java.util.Comparator;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperateInfo;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.SubEntryProp;

public class OperateInfoComparator
implements Comparator<OperateInfo> {
    private MainEntityType mainType;
    private int sortType = 0;
    public static final int SORT_TYPE_PROP_ROW = 0;
    public static final int SORT_TYPE_ROW_PROP = 0;
    private static final int ENTRY_PROP_INDEX_FACTOR = 10000;

    public OperateInfoComparator(MainEntityType mainType, int sortType) {
        this.mainType = mainType;
        this.sortType = sortType;
    }

    @Override
    public int compare(OperateInfo o1, OperateInfo o2) {
        int r2;
        int r1 = this.compareEntityType(o1, o2);
        if (r1 != 0) {
            return r1;
        }
        int n = r2 = this.sortType == 0 ? this.compareProp(o1, o2) : this.compareRow(o1, o2);
        if (r2 != 0) {
            return r2;
        }
        int r3 = this.sortType == 0 ? this.compareRow(o1, o2) : this.compareProp(o1, o2);
        return r3;
    }

    private int compareEntityType(OperateInfo o1, OperateInfo o2) {
        if (this.mainType == null) {
            return 0;
        }
        if (StringUtils.isBlank((CharSequence)o1.getEntityKey()) && StringUtils.isBlank((CharSequence)o2.getEntityKey())) {
            return 0;
        }
        if (StringUtils.equals((CharSequence)o1.getEntityKey(), (CharSequence)o2.getEntityKey())) {
            return 0;
        }
        if (StringUtils.isBlank((CharSequence)o1.getEntityKey())) {
            return -1;
        }
        if (StringUtils.isBlank((CharSequence)o2.getEntityKey())) {
            return 1;
        }
        IDataEntityProperty p1 = this.mainType.findProperty(o1.getEntityKey());
        IDataEntityProperty p2 = this.mainType.findProperty(o2.getEntityKey());
        if (!(p1 instanceof EntryProp) && !(p2 instanceof EntryProp)) {
            return 0;
        }
        if (!(p1 instanceof EntryProp)) {
            return -1;
        }
        if (!(p2 instanceof EntryProp)) {
            return 1;
        }
        int index1 = this.getEntryPropIndex((EntryProp)p1);
        int index2 = this.getEntryPropIndex((EntryProp)p2);
        return index1 - index2;
    }

    private int compareProp(OperateInfo o1, OperateInfo o2) {
        if (this.mainType == null) {
            return 0;
        }
        if (StringUtils.isBlank((CharSequence)o1.getFieldKey()) && StringUtils.isBlank((CharSequence)o2.getFieldKey())) {
            return 0;
        }
        if (StringUtils.equals((CharSequence)o1.getFieldKey(), (CharSequence)o2.getFieldKey())) {
            return 0;
        }
        if (StringUtils.isBlank((CharSequence)o1.getFieldKey())) {
            return -1;
        }
        if (StringUtils.isBlank((CharSequence)o2.getFieldKey())) {
            return 1;
        }
        IDataEntityProperty p1 = this.mainType.findProperty(o1.getFieldKey());
        IDataEntityProperty p2 = this.mainType.findProperty(o2.getFieldKey());
        if (p1 == null && p2 == null) {
            return 0;
        }
        if (p1 == null) {
            return -1;
        }
        if (p2 == null) {
            return 1;
        }
        return p1.getOrdinal() - p2.getOrdinal();
    }

    private int compareRow(OperateInfo o1, OperateInfo o2) {
        int dataIndexResult = o1.getDataEntityIndex() - o2.getDataEntityIndex();
        if (dataIndexResult != 0) {
            return dataIndexResult;
        }
        int rowIndexResult = o1.getRowIndex() - o2.getRowIndex();
        if (rowIndexResult != 0) {
            return rowIndexResult;
        }
        return o1.getSubRowIndex() - o2.getSubRowIndex();
    }

    private int getEntryPropIndex(EntryProp entryProp) {
        IDataEntityProperty parentProp;
        if (this.mainType == null || entryProp == null) {
            return 0;
        }
        int index = 0;
        index = entryProp instanceof SubEntryProp ? ((parentProp = this.mainType.findProperty(entryProp.getParent().getName())) == null ? 10000 + entryProp.getOrdinal() : parentProp.getOrdinal() * 10000 + entryProp.getOrdinal()) : entryProp.getOrdinal() * 10000;
        return index;
    }
}

