/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.property;

import java.math.BigDecimal;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.IntegerPrecision;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.datamodel.NumberPrecision;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.list.column.IntegerColumnDesc;
import kd.bos.entity.property.DecimalProp;
import kd.bos.exception.KDBizException;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public class IntegerProp
extends DecimalProp {
    private static final String BOS_ENTITY_METADATA = "bos-entity-metadata";
    private static final long serialVersionUID = -5575741726651721249L;

    public IntegerProp() {
        this._defaultValue = 0;
    }

    @Override
    public int getDbType() {
        return 4;
    }

    @Override
    public Class<?> getPropertyType() {
        return Integer.class;
    }

    @Override
    public AbstractColumnDesc getListColumnDesc(ListField col) {
        IntegerColumnDesc desc = new IntegerColumnDesc(col.getKey(), this, col.getFieldProp());
        desc.setDisplayFormatString(col.getDisplayFormatString());
        desc.setMask(col.getMask());
        desc.setZeroShow(col.isZeroShow());
        return desc;
    }

    @Override
    @KSMethod
    public void setFieldValue(IDataModel model, Object dataEntity, Object Value) {
        this.setValueFast(dataEntity, Value);
    }

    @Override
    public void setFieldValueForWebApi(IDataModel model, Object dataEntity, Object value, boolean checkImportable) {
        BigDecimal realValue;
        if (value instanceof String && StringUtils.isNotBlank((Object)value)) {
            value = this.trimZero((String)value);
        }
        LocaleString displayName = this.getDisplayName();
        if (checkImportable && !this.isImportable()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u4e0d\u5141\u8bb8\u5bfc\u5165", (String)"IntegerProp_0", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]), StringUtils.isNotBlank((Object)displayName) ? displayName.toString() : this.getName()));
        }
        if (value != null && !Pattern.compile("^-?\\d+(\\d+)?$").matcher(value.toString()).matches()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6570\u503c\u5b57\u6bb5\u201c%1$s\u201d\u683c\u5f0f\u4e0d\u6b63\u786e\uff1a%2$s", (String)"IntegerProp_3", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]), displayName != null ? displayName.toString() : this.getName(), value));
        }
        if (StringUtils.isNotBlank((CharSequence)this.getDataScope()) && !this.checkScope(value)) {
            throw new KDBizException(this.getDataScopeMessage(value));
        }
        BigDecimal srcValue = value == null ? BigDecimal.ZERO : new BigDecimal(value.toString());
        this.setFieldValue(model, dataEntity, value);
        Object afterValue = this.getValueFast(dataEntity);
        BigDecimal bigDecimal = realValue = afterValue == null ? BigDecimal.ZERO : new BigDecimal(afterValue.toString());
        if (srcValue.compareTo(realValue) != 0) {
            String err = String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c%1$s\u201d\u7684\u503c%2$s\u8d85\u51fa\u9650\u5b9a\u8303\u56f4%3$s\u3002", (String)"IntegerProp_4", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]), displayName != null ? displayName.toString() : this.getName(), srcValue.toString(), this.getDefaultConvertScope());
            throw new KDBizException(err);
        }
    }

    protected String getDefaultConvertScope() {
        return "[-2147483648,2147483647]";
    }

    private String trimZero(String valStr) {
        StringBuilder sb = new StringBuilder(valStr);
        int i = sb.indexOf(".");
        if (i >= 0) {
            for (int j = sb.length() - 1; j > i; --j) {
                if (sb.charAt(j) == '0') continue;
                sb.setLength(j + 1);
                return sb.toString();
            }
            valStr = sb.substring(0, i);
        }
        return valStr;
    }

    @Override
    public long getEstimatedLen() {
        return 4L;
    }

    @Override
    public NumberPrecision create(FormatObject formatObject) {
        return new IntegerPrecision(formatObject);
    }
}

