/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.property;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.script.annotations.KSMethod;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class ItemClassTypeProp
extends ComboProp {
    private static final long serialVersionUID = -5329135896117414931L;
    private Map<String, DynamicObjectType> itemTypes = new HashMap<String, DynamicObjectType>();
    private List<String> baseEntityIds;
    private Map<String, String> baseEntities = new HashMap<String, String>();

    public Map<String, String> getBaseEntities() {
        return this.baseEntities;
    }

    public void setBaseEntities(Map<String, String> baseEntities) {
        this.baseEntities = baseEntities;
    }

    @SimplePropertyAttribute
    public List<String> getBaseEntityIds() {
        return this.baseEntityIds;
    }

    public void setBaseEntityIds(List<String> v) {
        this.baseEntityIds = v;
    }

    public IDataEntityType getItemType(String entityId) {
        return (IDataEntityType)this.itemTypes.get(entityId);
    }

    public void setItemType(DynamicObjectType dt) {
        if (dt != null) {
            this.itemTypes.put(dt.getName(), dt);
        }
    }

    public Map<String, DynamicObjectType> getItemTypes() {
        return this.itemTypes;
    }

    @Override
    @KSMethod
    public boolean isEmptyItems() {
        return this.getBaseEntityIds().isEmpty();
    }

    @Override
    @KSMethod
    public boolean isExistItem(String name) {
        for (String baseEntityId : this.getBaseEntityIds()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)baseEntityId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setFieldValue(IDataModel model, Object dataEntity, Object value) {
        String oldValue = (String)this.getValueFast(dataEntity);
        if (!StringUtils.equals((CharSequence)oldValue, (CharSequence)String.valueOf(value))) {
            MainEntityType dt = model.getDataEntityType();
            for (IDataEntityProperty prop : dt.getAllFields().values()) {
                if (!(prop instanceof ItemClassProp) || !((ItemClassProp)prop).getTypePropName().equals(this.getName())) continue;
                this.clearItemClassPropValue(model, dataEntity, (ItemClassProp)prop);
            }
        }
        super.setFieldValue(model, dataEntity, value);
    }

    private void clearItemClassPropValue(IDataModel model, Object dataEntity, ItemClassProp prop) {
        block6: {
            block7: {
                block8: {
                    block5: {
                        if (!this.getParent().getName().equals(prop.getParent().getName())) break block5;
                        prop.setFieldValue(model, dataEntity, null);
                        break block6;
                    }
                    if (!(this.getParent() instanceof MainEntityType)) break block7;
                    if (!(prop.getParent() instanceof SubEntryType)) break block8;
                    DynamicObjectCollection entryRows = model.getEntryEntity(prop.getParent().getParent().getName());
                    for (DynamicObject entryRow : entryRows) {
                        DynamicObjectCollection subEntryRows = entryRow.getDynamicObjectCollection(prop.getParent().getName());
                        for (DynamicObject subEntryRow : subEntryRows) {
                            prop.setFieldValue(model, subEntryRow, null);
                        }
                    }
                    break block6;
                }
                if (!(prop.getParent() instanceof EntryType)) break block6;
                DynamicObjectCollection rows = model.getEntryEntity(prop.getParent().getName());
                for (DynamicObject row : rows) {
                    prop.setFieldValue(model, row, null);
                }
                break block6;
            }
            if (this.getParent() instanceof EntryType && this.getParent().getProperties().containsKey((Object)prop.getParent().getName())) {
                DynamicObjectCollection subEntryRows = ((DynamicObject)dataEntity).getDynamicObjectCollection(prop.getParent().getName());
                for (DynamicObject subEntryRow : subEntryRows) {
                    prop.setFieldValue(model, subEntryRow, null);
                }
            }
        }
    }

    public void fixItemTypes() {
        List<String> baseEntityIds = this.getBaseEntityIds();
        for (String baseEntityId : baseEntityIds) {
            this.setItemType(EntityMetadataCache.getDataEntityType(baseEntityId));
        }
    }
}

