/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.property.org;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperateInfoComparator;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.entity.property.org.ExchangeOrgContext;
import kd.bos.entity.property.org.IPropExchangeOrg;

public class MainOrgExchanger {
    private IDataModel model;
    private MainOrgProp mainOrgProp;
    private OperationResult exchangeResult;

    public MainOrgExchanger(IDataModel model, MainOrgProp mainOrgProp) {
        this.model = model;
        this.mainOrgProp = mainOrgProp;
    }

    public IDataModel getModel() {
        return this.model;
    }

    public MainOrgProp getMainOrgProp() {
        return this.mainOrgProp;
    }

    public OperationResult getExchangeResult() {
        return this.exchangeResult;
    }

    public void exchangeMainOrg(long newOrgId) {
        this.exchangeResult = new OperationResult();
        if (this.getModel() == null || this.getMainOrgProp() == null) {
            return;
        }
        ExchangeOrgContext context = new ExchangeOrgContext(this.getModel(), this.getMainOrgProp(), newOrgId);
        context.setExchangeResult(this.exchangeResult);
        MainEntityType mainType = this.getModel().getDataEntityType();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        ExtendedDataEntitySet extDataEntity = new ExtendedDataEntitySet();
        extDataEntity.Parse(new DynamicObject[]{dataEntity}, mainType);
        List<EntityType> entityTypes = this.getSortEntitys(mainType);
        for (EntityType entityType : entityTypes) {
            ExtendedDataEntity[] entityRows = extDataEntity.FindByEntityKey(entityType.getName());
            if (entityRows == null || entityRows.length == 0) continue;
            List<IPropExchangeOrg> propExchangeOrgs = this.getSortPropExchangeOrg(context, entityType);
            for (IPropExchangeOrg propExchangeOrg : propExchangeOrgs) {
                propExchangeOrg.exchangeOrg(entityRows);
            }
        }
        this.exchangeResult = context.getExchangeResult();
        OperateInfoComparator comparator = new OperateInfoComparator(mainType, 0);
        this.exchangeResult.getAllErrorInfo().sort(comparator);
    }

    private List<EntityType> getSortEntitys(MainEntityType mainType) {
        ArrayList<EntityType> entitys = new ArrayList<EntityType>(mainType.getAllEntities().values());
        entitys.sort(new Comparator<EntityType>(){

            @Override
            public int compare(EntityType e1, EntityType e2) {
                int l1 = MainOrgExchanger.this.getEntityLevel(e1);
                int l2 = MainOrgExchanger.this.getEntityLevel(e2);
                return l1 - l2;
            }
        });
        return entitys;
    }

    private List<IPropExchangeOrg> getSortPropExchangeOrg(ExchangeOrgContext context, EntityType entityType) {
        ArrayList<IPropExchangeOrg> propExchangeOrgs = new ArrayList<IPropExchangeOrg>(entityType.getProperties().size());
        for (IDataEntityProperty prop : entityType.getProperties()) {
            IPropExchangeOrg propExchangeOrg = IPropExchangeOrg.create(context, prop);
            propExchangeOrgs.add(propExchangeOrg);
        }
        propExchangeOrgs.sort(new Comparator<IPropExchangeOrg>(){

            @Override
            public int compare(IPropExchangeOrg o1, IPropExchangeOrg o2) {
                int seq = o1.getExchangeSeq() - o2.getExchangeSeq();
                if (seq != 0) {
                    return seq;
                }
                return o1.getProp().getOrdinal() - o2.getProp().getOrdinal();
            }
        });
        return propExchangeOrgs;
    }

    private int getEntityLevel(EntityType entityType) {
        int level = 0;
        if (entityType instanceof SubEntryType) {
            level = 2;
        } else if (entityType instanceof EntryType) {
            level = 1;
        }
        return level;
    }
}

