/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.qing;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.qing.Field;
import kd.bos.entity.qing.QingFieldType;

public class AnalysisField {
    private String entityKey;
    private String refEntityId;
    private String fullFieldName;
    private IDataEntityProperty srcFieldProp;
    private IDataEntityProperty refProp1;
    private String refDisplayName1;
    private IDataEntityProperty refProp2;
    private String refDisplayName2;
    private IDataEntityProperty fieldProp;
    private ArrayList<ValueMapItem> comboItems;
    private boolean isForeignkey_i;
    private static final String FBASEDATAID = "fbasedataid";
    private static final String FBASEDATAID2 = ".fbasedataid";

    public AnalysisField(MainEntityType mainType, IDataEntityProperty srcFieldProp, IDataEntityProperty refProp1, IDataEntityProperty refProp2, String refEntityId) {
        this.refEntityId = refEntityId;
        this.fieldProp = srcFieldProp;
        this.srcFieldProp = srcFieldProp;
        this.entityKey = this.srcFieldProp.getParent().getName();
        this.refProp1 = refProp1;
        if (refProp1 != null) {
            this.fieldProp = refProp1;
        }
        this.refProp2 = refProp2;
        if (refProp2 != null) {
            this.fieldProp = refProp2;
        }
        this.fullFieldName = this.buildFullFieldName();
        this.comboItems = new ArrayList();
        this.comboItems.addAll(this.buildComboItems());
    }

    public IDataEntityProperty getRefProp1() {
        return this.refProp1;
    }

    public IDataEntityProperty getRefProp2() {
        return this.refProp2;
    }

    public void setRefDisplayName1(String refDisplayName1) {
        this.refDisplayName1 = refDisplayName1;
    }

    public void setRefDisplayName2(String refDisplayName2) {
        this.refDisplayName2 = refDisplayName2;
    }

    private String buildFullFieldName() {
        ArrayList<String> propNames = new ArrayList<String>();
        boolean isNeedToAddPrefix = this.srcFieldProp instanceof MulBasedataProp && this.refProp1 != null && !FBASEDATAID.equals(this.refProp1.getName());
        String srcFieldPropName = isNeedToAddPrefix ? this.srcFieldProp.getName() + FBASEDATAID2 : this.srcFieldProp.getName();
        String srcPropFullName = FilterField.buildPropORMFullNameByName(srcFieldPropName, this.srcFieldProp.getParent());
        propNames.add(srcPropFullName);
        if (this.refProp1 != null) {
            String refProp1Name = this.refProp1 instanceof MulBasedataProp ? this.refProp1.getName() + FBASEDATAID2 : this.refProp1.getName();
            String refProp1FullName = FilterField.buildPropORMFullNameByName(refProp1Name, this.refProp1.getParent());
            propNames.add(refProp1FullName);
            if (this.refProp2 != null) {
                String refProp2Name = this.refProp2 instanceof MulBasedataProp ? this.refProp2.getName() + FBASEDATAID2 : this.refProp2.getName();
                String refProp2FullName = FilterField.buildPropORMFullNameByName(refProp2Name, this.refProp2.getParent());
                propNames.add(refProp2FullName);
            }
        }
        return StringUtils.join((Object[])propNames.toArray(), (String)".");
    }

    private List<ValueMapItem> buildComboItems() {
        ArrayList<ValueMapItem> list = new ArrayList<ValueMapItem>();
        if (this.fieldProp instanceof ComboProp) {
            list.addAll(((ComboProp)this.fieldProp).getComboItems());
        } else if (this.fieldProp instanceof BooleanProp) {
            ValueMapItem comboItem1 = new ValueMapItem();
            comboItem1.setValue("1");
            comboItem1.setName(new LocaleString(ResManager.loadKDString((String)"\u662f", (String)"AnalysisField_0", (String)"bos-entity-metadata", (Object[])new Object[0])));
            ValueMapItem comboItem2 = new ValueMapItem();
            comboItem2.setValue("0");
            comboItem2.setName(new LocaleString(ResManager.loadKDString((String)"\u5426", (String)"AnalysisField_1", (String)"bos-entity-metadata", (Object[])new Object[0])));
            list.add(comboItem1);
            list.add(comboItem2);
        }
        return list;
    }

    public boolean isAnalysis() {
        return this.checkAliasNotEmpty() && ((IFieldHandle)this.fieldProp).isAnalysisField() && (StringUtils.isNotEmpty((CharSequence)this.srcFieldProp.getAlias()) || this.srcFieldProp instanceof MuliLangTextProp);
    }

    private boolean checkAliasNotEmpty() {
        if (null != this.refProp1) {
            if (StringUtils.isEmpty((CharSequence)this.refProp1.getAlias())) {
                return false;
            }
            if (null != this.refProp2) {
                return StringUtils.isNotEmpty((CharSequence)this.refProp2.getAlias());
            }
            return true;
        }
        return StringUtils.isNotEmpty((CharSequence)this.fieldProp.getAlias());
    }

    public IDataEntityProperty getFieldProp() {
        return this.fieldProp;
    }

    public String getFullFieldCaption(boolean withEntityName) {
        EntityType entityType;
        ArrayList<String> propCaptions = new ArrayList<String>();
        if (withEntityName && (entityType = (EntityType)this.srcFieldProp.getParent()) instanceof EntryType) {
            if (entityType.getDisplayName() != null) {
                propCaptions.add(entityType.getDisplayName().toString());
            } else {
                propCaptions.add(entityType.getName());
            }
        }
        if (((DynamicProperty)this.srcFieldProp).getDisplayName() != null) {
            propCaptions.add(((DynamicProperty)this.srcFieldProp).getDisplayName().toString());
        } else {
            propCaptions.add(this.srcFieldProp.getName());
        }
        if (this.refProp1 != null) {
            if (this.refDisplayName1 != null) {
                propCaptions.add(this.refDisplayName1);
            } else if (((DynamicProperty)this.refProp1).getDisplayName() != null) {
                propCaptions.add(((DynamicProperty)this.refProp1).getDisplayName().toString());
            } else {
                propCaptions.add(this.refProp1.getName());
            }
        }
        if (this.refProp2 != null) {
            if (this.refDisplayName2 != null) {
                propCaptions.add(this.refDisplayName2);
            } else if (((DynamicProperty)this.refProp2).getDisplayName() != null) {
                propCaptions.add(((DynamicProperty)this.refProp2).getDisplayName().toString());
            } else {
                propCaptions.add(this.refProp2.getName());
            }
        }
        return StringUtils.join((Object[])propCaptions.toArray(), (String)".");
    }

    public String getFullFieldName() {
        return this.fullFieldName;
    }

    public String getEntityKey() {
        return this.entityKey;
    }

    public String getRefEntityId() {
        return this.refEntityId;
    }

    public List<ValueMapItem> getComboItems() {
        return this.comboItems;
    }

    public IDataEntityProperty getSrcFieldProp() {
        return this.srcFieldProp;
    }

    public void setForeignkey(boolean isForeignkey) {
        this.isForeignkey_i = isForeignkey;
    }

    public boolean isForeignkey() {
        return this.isForeignkey_i;
    }

    public boolean isFlexField() {
        return false;
    }

    public Field buildField() {
        Field field = new Field();
        this.setFieldProperDatas(field);
        return field;
    }

    protected void setFieldProperDatas(Field field) {
        List<ValueMapItem> valueMapItems;
        String refEntity;
        field.setEntity(this.getEntityKey());
        field.setKey(this.getFullFieldName());
        field.setName(new LocaleString(this.getFullFieldCaption(false)));
        IFieldHandle fieldHandle = (IFieldHandle)this.getFieldProp();
        QingFieldType fieldType = QingFieldType.valueOfSqlType(fieldHandle.getDbType());
        field.setFieldType(fieldType.toNumber());
        if (this.isForeignkey() && (refEntity = this.getRefEntityId()) != null && !refEntity.isEmpty()) {
            field.setRefEntity(refEntity);
        }
        if (this.srcFieldProp instanceof MulBasedataProp) {
            field.addCustomInfo("MulBaseData", Boolean.TRUE);
        }
        if ((valueMapItems = this.getComboItems()) != null && !valueMapItems.isEmpty()) {
            HashMap<String, LocaleString> enumItems = new HashMap<String, LocaleString>(16);
            for (ValueMapItem valueMapItem : valueMapItems) {
                enumItems.put(valueMapItem.getValue(), valueMapItem.getName());
            }
            field.setEnumItems(enumItems);
        }
    }
}

