/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.qing;

import java.util.List;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.flex.FlexEntityMetaUtils;
import kd.bos.entity.flex.FlexProperty;
import kd.bos.entity.qing.AnalysisField;
import kd.bos.entity.qing.Field;
import kd.bos.entity.qing.FlexField;
import kd.bos.entity.qing.QingFieldType;

public class FlexAnalysisField
extends AnalysisField {
    private List<FlexProperty> flexProperties;
    private static final int BASE_DATA_TYPE = 0;

    public FlexAnalysisField(MainEntityType mainType, IDataEntityProperty srcFieldProp, DynamicObjectType dynamicObjectType, int flexTypeId) {
        super(mainType, srcFieldProp, (IDataEntityProperty)dynamicObjectType.getProperty("value"), null, dynamicObjectType.getName());
        this.flexProperties = FlexEntityMetaUtils.getFlexProperties(flexTypeId);
    }

    @Override
    public boolean isFlexField() {
        return true;
    }

    @Override
    public Field buildField() {
        FlexField flexField = new FlexField();
        this.setFieldProperDatas(flexField);
        flexField.setOrmKey(this.getFullFieldName());
        flexField.setRowKey(this.getFullFieldName().replace(".", "_"));
        this.flexProperties.forEach(fp -> {
            Field field = new Field();
            field.setKey(fp.getFlexField());
            field.setEntity(fp.getValueSource());
            if (fp.getValueType().equals("1") || fp.getValueType().equals("2")) {
                field.setFieldType(0);
            } else {
                field.setFieldType(QingFieldType.String.toNumber());
            }
            field.setName(fp.getName());
            flexField.addField(field);
            flexField.addFlexProp(fp.getFlexField(), (FlexProperty)fp);
        });
        return flexField;
    }
}

