/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.qing;

import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.entity.qing.QingFieldType;

public class QingFieldTypeConverter {
    private static Set<String> strClassSets = new HashSet<String>();
    private static Set<String> intClassSets = new HashSet<String>();
    private static Set<String> numberClassSets = new HashSet<String>();
    private static Set<String> booleanClassSets = new HashSet<String>();
    private static Set<String> dateClassSets = new HashSet<String>();
    private static Set<String> dateTimeClassSets = new HashSet<String>();

    public static QingFieldType convert(Class classType) {
        String className = classType.getName();
        if (strClassSets.contains(className) || classType.isAssignableFrom(ILocaleString.class)) {
            return QingFieldType.String;
        }
        if (intClassSets.contains(className)) {
            return QingFieldType.Int;
        }
        if (numberClassSets.contains(className)) {
            return QingFieldType.Number;
        }
        if (booleanClassSets.contains(className)) {
            return QingFieldType.Boolean;
        }
        if (dateClassSets.contains(className)) {
            return QingFieldType.Date;
        }
        if (dateTimeClassSets.contains(className)) {
            return QingFieldType.DateTime;
        }
        return QingFieldType.String;
    }

    static {
        strClassSets.add("java.lang.String");
        strClassSets.add("java.lang.Character");
        intClassSets.add("java.lang.Long");
        intClassSets.add("java.lang.Integer");
        intClassSets.add("java.lang.Short");
        numberClassSets.add("java.lang.Float");
        numberClassSets.add("java.lang.Double");
        numberClassSets.add("java.math.BigDecimal");
        booleanClassSets.add("java.lang.Boolean");
        dateClassSets.add("java.util.Date");
        dateClassSets.add("java.sql.Date");
        dateTimeClassSets.add("java.sql.Timestamp");
    }
}

