/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.report;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.entity.NumberFormatProvider;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.report.ReportColumn;
import kd.bos.script.annotations.KSMethod;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class ComboReportColumn
extends ReportColumn {
    private int ComboShowStyle;
    private List<ValueMapItem> comboItems = new ArrayList<ValueMapItem>();

    @KSMethod
    @CollectionPropertyAttribute(name="ComboItems", collectionItemPropertyType=ValueMapItem.class)
    public List<ValueMapItem> getComboItems() {
        return this.comboItems;
    }

    public void setComboItems(List<ValueMapItem> comboItems) {
        this.comboItems = comboItems;
    }

    @SimplePropertyAttribute
    public int getComboShowStyle() {
        return this.ComboShowStyle;
    }

    public void setComboShowStyle(int comboShowStyle) {
        this.ComboShowStyle = comboShowStyle;
    }

    @Override
    public Map<String, Object> createColumn() {
        Map<String, Object> map = super.createColumn();
        HashMap<String, Object> editor = new HashMap<String, Object>();
        editor.put("type", "combo");
        editor.put("showStyle", this.getComboShowStyle());
        editor.put("st", ComboReportColumn.getStore(this.getComboShowStyle(), this.getComboItems()));
        map.put("editor", editor);
        return map;
    }

    @Override
    public Object getValue(DynamicObject rowData, NumberFormatProvider numberFormatProvider) {
        ComboProp p = (ComboProp)this.getFieldProperty();
        Object oV = p.getValueFast(rowData);
        return oV == null ? "" : oV;
    }

    private static List<Object> getStore(int showStyle, List<ValueMapItem> items) {
        ArrayList<Object> myItems = new ArrayList<Object>(20);
        for (ValueMapItem item : items) {
            if (item == null) continue;
            myItems.add(ComboReportColumn.createEnumItem(item.getValue(), item.getName(), item.getImageKey(), showStyle));
        }
        myItems.add(ComboReportColumn.createEnumItem("******", new LocaleString("******"), "", showStyle));
        return myItems;
    }

    private static List<Object> createEnumItem(Object value, LocaleString displayValue, String imageKey, int showStyle) {
        ArrayList<Object> item = new ArrayList<Object>();
        item.add(value);
        switch (showStyle) {
            case 1: {
                item.add(null);
                item.add(imageKey);
                break;
            }
            case 2: {
                item.add(displayValue);
                item.add(imageKey);
                break;
            }
            default: {
                item.add(displayValue);
                item.add(null);
            }
        }
        return item;
    }
}

