/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.rule;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.formula.CalcExprParser;
import kd.bos.entity.formula.ExpressionParameter;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.IFieldRuleHandle;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.RefBillProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class FieldRuleHelper {
    private static Log LOG = LogFactory.getLog(FieldRuleHelper.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isMustInput(MainEntityType mainEntityType, DynamicObject dataEntity, String prop) {
        IDataEntityProperty property = mainEntityType.findProperty(prop);
        boolean mustProp = false;
        if (property instanceof FieldProp) {
            mustProp = ((FieldProp)property).isMustInput();
        } else if (property instanceof MulBasedataProp) {
            mustProp = ((MulBasedataProp)property).isMustInput();
        } else if (property instanceof BasedataProp) {
            mustProp = ((BasedataProp)property).isMustInput();
        } else if (property instanceof RefBillProp) {
            mustProp = ((RefBillProp)property).isMustInput();
        }
        if (!mustProp) {
            return false;
        }
        boolean mustInput = false;
        if (!(property instanceof IFieldRuleHandle)) return true;
        String mustInputCondition = ((IFieldRuleHandle)property).getMustInputCondition();
        if (!StringUtils.isNotBlank((CharSequence)mustInputCondition)) return true;
        try {
            Map mustInputMap = (Map)SerializationUtils.fromJsonString((String)mustInputCondition, HashMap.class);
            String express = (String)mustInputMap.get("RuleCondition");
            if (!StringUtils.isNotBlank((CharSequence)express)) return mustInput;
            RowDataModel rowModel = new RowDataModel(mainEntityType.getName(), mainEntityType);
            ExpressionParameter parameter = new ExpressionParameter(express, rowModel);
            parameter.setActiveRow(dataEntity);
            parameter.setRowIndex(0);
            Object expValue = CalcExprParser.getExpressionValue(parameter);
            if (expValue == null) return mustInput;
            if ((Boolean)expValue == false) return mustInput;
            return true;
        }
        catch (Exception exception) {
            LOG.error((Throwable)exception);
            return false;
        }
    }
}

