/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.rule;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;

class GetDownDataEntities {
    private IDataModel model;
    private IDataEntityType eventTable;
    private IDataEntityType targetTable;
    private List<RowDataEntity> eventDataEntities;

    public GetDownDataEntities(IDataModel model, IDataEntityType eventTable, IDataEntityType targetTable, List<RowDataEntity> eventDataEntities) {
        this.model = model;
        this.eventTable = eventTable;
        this.targetTable = targetTable;
        this.eventDataEntities = eventDataEntities;
    }

    public List<RowDataEntity> getRowDataEntitys() {
        if (this.targetTable.getParent() == null) {
            return this.eventDataEntities;
        }
        if (StringUtils.equals((CharSequence)this.eventTable.getName(), (CharSequence)this.targetTable.getParent().getName())) {
            return this.getSonRows(this.eventDataEntities, this.targetTable.getName());
        }
        return this.getGrandSonRows();
    }

    private List<RowDataEntity> getSonRows(List<RowDataEntity> parentRows, String targetEntityKey) {
        ArrayList<RowDataEntity> list = new ArrayList<RowDataEntity>();
        if (!parentRows.isEmpty() && parentRows.get(0).getDataEntity().getDataEntityType().getProperties().containsKey((Object)targetEntityKey)) {
            for (RowDataEntity eventRow : parentRows) {
                DynamicObjectCollection rows = eventRow.getDataEntity().getDynamicObjectCollection(targetEntityKey);
                for (int i = 0; i < rows.size(); ++i) {
                    list.add(new RowDataEntity(i, (DynamicObject)rows.get(i)));
                }
            }
        }
        return list;
    }

    private List<RowDataEntity> getGrandSonRows() {
        IDataEntityType parent;
        ArrayList<String> entryKeys = new ArrayList<String>();
        entryKeys.add(this.targetTable.getName());
        for (parent = this.targetTable.getParent(); parent != null && !StringUtils.equals((CharSequence)this.eventTable.getName(), (CharSequence)parent.getName()); parent = parent.getParent()) {
            entryKeys.add(parent.getName());
        }
        if (parent == null) {
            return new ArrayList<RowDataEntity>();
        }
        List<RowDataEntity> sonRows = this.eventDataEntities;
        for (int i = entryKeys.size() - 1; i >= 0; --i) {
            sonRows = this.getSonRows(sonRows, (String)entryKeys.get(i));
        }
        return sonRows;
    }
}

