/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.rule.kflow;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.RaiseEventType;
import kd.bos.entity.rule.BR;
import kd.bos.entity.rule.RuleExecuteContext;
import kd.bos.entity.rule.kflow.FlowServiceUtil;
import kd.bos.kflow.api.FlowParam;
import kd.bos.kflow.api.IFlowService;
import kd.bos.kflow.api.ServiceResult;
import kd.bos.kflow.api.enums.ErrorCode;
import kd.bos.kflow.api.enums.ValueType;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;

public class KR
extends BR {
    private String refId;
    private String kfId;
    private int triggerTime;
    private String objectId;
    private String bizAppId;
    private String event;
    private String scene;
    private static final String TRACE_TYPE_KFLOW = "kflowrule";
    private static final String BOS_ENTITY_METADATA = "bos-entity-metadata";
    private static final ThreadLocal<Set<Object>> kfExecuteThreadLocal = new ThreadLocal();
    private IFlowService flowService;

    @SimplePropertyAttribute(name="RefId")
    public String getRefId() {
        return this.refId;
    }

    public void setRefId(String refId) {
        this.refId = refId;
    }

    @SimplePropertyAttribute(name="KFId")
    public String getKFId() {
        return this.kfId;
    }

    public void setKFId(String kfId) {
        this.kfId = kfId;
    }

    @SimplePropertyAttribute(name="TriggerTime")
    public int getTriggerTime() {
        return this.triggerTime;
    }

    public void setTriggerTime(int triggerTime) {
        this.triggerTime = triggerTime;
    }

    @SimplePropertyAttribute(name="BizAppId")
    public String getBizAppId() {
        return this.bizAppId;
    }

    public void setBizAppId(String bizAppId) {
        this.bizAppId = bizAppId;
    }

    @SimplePropertyAttribute(name="ObjectId")
    public String getObjectId() {
        return this.objectId;
    }

    public void setObjectId(String objectId) {
        this.objectId = objectId;
    }

    @SimplePropertyAttribute(name="Event")
    public String getEvent() {
        return this.event;
    }

    public void setEvent(String event) {
        this.event = event;
    }

    @SimplePropertyAttribute(name="Scene")
    public String getScene() {
        return this.scene;
    }

    public void setScene(String scene) {
        this.scene = scene;
    }

    private IFlowService getFlowService() {
        if (this.flowService == null) {
            this.flowService = new FlowServiceUtil().getFlowService();
        }
        return this.flowService;
    }

    public KR convertFromBR(BR br) {
        this.setDescription(br.getDescription());
        this.setPreDescription(br.getPreDescription());
        this.setSeq(br.getSeq());
        this.setEnabled(br.isEnabled());
        this.setRuleType(br.getRuleType());
        Map<String, Object> extProps = br.getExtProps();
        if (!CollectionUtils.isEmpty(extProps)) {
            this.setKFId((String)extProps.get("KFId"));
            this.setRefId((String)extProps.get("RefId"));
            this.setTriggerTime((Integer)extProps.get("TriggerTime"));
            this.setScene((String)extProps.get("Scene"));
            this.setObjectId((String)extProps.get("ObjectId"));
            this.setBizAppId((String)extProps.get("BizAppId"));
        }
        return this;
    }

    private ServiceResult executeKFlow(KR rule, RuleExecuteContext context) {
        IFlowService service = this.getFlowService();
        Object view = context.getContextObj().get("view");
        Object entityId = context.getContextObj().get("view.entityId");
        int eventType = context.getRaiseEventSources().get(0).getRaiseEventType().getValue();
        HashMap<String, FlowParam> paraMap = new HashMap<String, FlowParam>(2);
        List params = service.getParameterByFlowId(rule.getKFId());
        boolean hasViewParam = false;
        for (FlowParam param : params) {
            HashMap<String, FlowParam> cusParamMap;
            if (ValueType.View.equals((Object)param.getValueType())) {
                hasViewParam = true;
                paraMap.put(param.getName(), new FlowParam(param.getName(), ValueType.View, view));
                continue;
            }
            if (RaiseEventType.forValue(eventType) == RaiseEventType.FieldChanged) {
                if (!"FieldChangedEvent".equals(param.getTypeName()) || !ValueType.Custom.equals((Object)param.getValueType())) continue;
                cusParamMap = new HashMap<String, FlowParam>();
                cusParamMap.put("rowIndex", new FlowParam("rowIndex", ValueType.Long, (Object)context.getRaiseEventSources().get(0).getDataEntities().get(0).getRowIndex()));
                cusParamMap.put("parentRowIndex", new FlowParam("parentRowIndex", ValueType.Long, (Object)context.getRaiseEventSources().get(0).getDataEntities().get(0).getParentRowIndex()));
                cusParamMap.put("fieldName", new FlowParam("fieldName", ValueType.String, (Object)context.getRaiseEventSources().get(0).getProperty().getName()));
                paraMap.put(param.getName(), new FlowParam(param.getName(), ValueType.Custom, cusParamMap));
                continue;
            }
            if (RaiseEventType.forValue(eventType) == RaiseEventType.ItemAdded) {
                if (!"ItemAdded".equals(param.getTypeName()) || !ValueType.Custom.equals((Object)param.getValueType())) continue;
                cusParamMap = new HashMap();
                cusParamMap.put("rowIndex", new FlowParam("rowIndex", ValueType.Long, (Object)context.getRaiseEventSources().get(0).getDataEntities().get(0).getRowIndex()));
                cusParamMap.put("parentRowIndex", new FlowParam("parentRowIndex", ValueType.Long, (Object)context.getRaiseEventSources().get(0).getDataEntities().get(0).getParentRowIndex()));
                paraMap.put(param.getName(), new FlowParam(param.getName(), ValueType.Custom, cusParamMap));
                continue;
            }
            if (RaiseEventType.forValue(eventType) != RaiseEventType.Initialized || !"Initialized".equals(param.getTypeName()) || !ValueType.Custom.equals((Object)param.getValueType())) continue;
            cusParamMap = new HashMap();
            cusParamMap.put("rowIndex", new FlowParam("rowIndex", ValueType.Long, (Object)context.getRaiseEventSources().get(0).getDataEntities().get(0).getRowIndex()));
            cusParamMap.put("parentRowIndex", new FlowParam("parentRowIndex", ValueType.Long, (Object)context.getRaiseEventSources().get(0).getDataEntities().get(0).getParentRowIndex()));
            paraMap.put(param.getName(), new FlowParam(param.getName(), ValueType.Custom, cusParamMap));
        }
        if (!hasViewParam) {
            ServiceResult serviceResult = new ServiceResult();
            serviceResult.setSuccess(Boolean.valueOf(false));
            serviceResult.setErrorCode(ErrorCode.NoSuchParam.getCodeNum());
            serviceResult.setError((Exception)new RuntimeException(String.format("flow %s view type parameter is not defined.", rule.getKFId())));
            return serviceResult;
        }
        ServiceResult serviceResult = service.executeByRefId(rule.getRefId(), paraMap);
        return serviceResult;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute(RuleExecuteContext context) {
        try (EntityTraceSpan span = EntityTracer.create((String)TRACE_TYPE_KFLOW, (String)"KR.execute");){
            Object krList;
            if (span.isRealtime()) {
                span.addLocaleTag("description", (Object)this.getDescription());
                span.addLocaleTag("flowNum", (Object)this.getNumber());
                span.addLocaleTag("referenceId", (Object)this.getRefId());
            }
            if (context.getContextObj() == null || !((krList = context.getContextObj().get("kRules")) instanceof List)) return;
            List rules = (List)krList;
            for (KR rule : rules) {
                try {
                    Set<Object> kfInstanceSet = kfExecuteThreadLocal.get();
                    if (kfInstanceSet == null) {
                        kfInstanceSet = new HashSet<Object>();
                        kfExecuteThreadLocal.set(kfInstanceSet);
                    }
                    String kfExecCacheKey = rule.getKFId();
                    if (context.getRaiseEventSources().get(0).getRaiseEventType() == RaiseEventType.FieldChanged) {
                        kfExecCacheKey = String.format("%s_%s", rule.getKFId(), context.getRaiseEventSources().get(0).getProperty().getName());
                    }
                    if (!kfInstanceSet.add(kfExecCacheKey)) continue;
                    ServiceResult result = this.executeKFlow(rule, context);
                    if (span.isRealtime()) {
                        span.addLocaleTag("result", (Object)result);
                    }
                    if (result.getSuccess().booleanValue()) continue;
                    RuntimeException ex = new RuntimeException(String.format(ResManager.loadKDString((String)"K\u6d41\u7f16\u7801:%1$s%n\u72b6\u6001\u7801:%2$s%n\u5f02\u5e38\u4fe1\u606f:%3$s%n\u6570\u636e\u7c7b\u578b:%4$s%n\u8fd4\u56de\u6570\u636e:%5$s%n", (String)"KR_0", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]), rule.getNumber(), result.getErrorCode(), result.getError(), result.getData(), result.getDataType()));
                    ex.setStackTrace(result.getError().getStackTrace());
                    throw ex;
                }
                catch (RuntimeException e) {
                    if (StringUtils.isNotBlank((CharSequence)e.getMessage())) {
                        String[] msg = e.getMessage().split("!");
                        String errorCode = "400009";
                        if (msg.length > 0 && StringUtils.isNotBlank((CharSequence)msg[0]) && errorCode.equals(msg[0])) {
                            RuntimeException ex = new RuntimeException(ResManager.loadKDString((String)"\u8be5\u9875\u9762\u5f15\u7528\u7684K\u6d41\u88ab\u7981\u7528\uff0c\u8bf7\u68c0\u67e5K\u6d41\u7ba1\u7406\u3002", (String)"KR_1", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]), e);
                            ex.setStackTrace(e.getStackTrace());
                            throw ex;
                        }
                    }
                    RuntimeException ex = new RuntimeException(String.format(ResManager.loadKDString((String)"K\u6d41\u7f16\u7801:%1$s%n\u5f02\u5e38\u4fe1\u606f:%2$s%n", (String)"KR_2", (String)BOS_ENTITY_METADATA, (Object[])new Object[0]), rule.getNumber(), e.getMessage()), e);
                    ex.setStackTrace(e.getStackTrace());
                    throw ex;
                    return;
                }
            }
        }
    }

    private String getNumber() {
        String number = null;
        ORM orm = ORM.create();
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(this.getKFId()))};
        DynamicObject object = orm.queryOne("kf_instance", "id,number", qFilters);
        if (object != null) {
            number = object.getString("number");
        }
        return number;
    }
}

