/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.validate;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class ValidateResultCollection
implements Serializable {
    private static final long serialVersionUID = 1276407205932367299L;
    List<ValidateResult> validateErrors = new ArrayList<ValidateResult>();
    boolean success = true;
    private String message = "";
    private HashSet<Object> errorPkIds = new HashSet();
    private HashSet<Integer> errorDataIndexs = new HashSet();

    @SimplePropertyAttribute(isPrimaryKey=true)
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Deprecated
    @SimplePropertyAttribute
    public HashSet<Object> getErrorPkIds() {
        return this.errorPkIds;
    }

    public void setErrorPkIds(HashSet<Object> errorPkIds) {
        this.errorPkIds = errorPkIds;
    }

    @SimplePropertyAttribute
    public HashSet<Integer> getErrorDataIndexs() {
        return this.errorDataIndexs;
    }

    public void setErrorDataIndexs(HashSet<Integer> errorDataIndex) {
        this.errorDataIndexs = errorDataIndex;
    }

    public boolean isSuccess() {
        if (!this.success) {
            return false;
        }
        for (ValidateResult validateResult : this.validateErrors) {
            for (OperateErrorInfo errorInfo : validateResult.getAllErrorInfo()) {
                if (errorInfo.getLevel() == ErrorLevel.Info) continue;
                return false;
            }
        }
        return this.success;
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=ValidateResult.class)
    public List<ValidateResult> getValidateErrors() {
        return this.validateErrors;
    }

    protected void setValidateErrors(List<ValidateResult> validateErrors) {
        this.validateErrors = validateErrors;
    }

    public List<ValidateResult> getValidateErrors(String validatorKey) {
        ArrayList<ValidateResult> ret = new ArrayList<ValidateResult>();
        for (ValidateResult result : this.validateErrors) {
            if (!result.getValidatorKey().equals(validatorKey)) continue;
            ret.add(result);
        }
        return ret;
    }

    public void addValidateError(String validatorKey, ValidateResult result) {
        result.setValidatorKey(validatorKey);
        this.validateErrors.add(result);
        this.addErrorPkIds(result);
    }

    public int errorSize() {
        return this.errorSize(false);
    }

    public int errorSize(boolean reset) {
        if (reset) {
            this.errorDataIndexs.clear();
            this.errorPkIds.clear();
            for (ValidateResult validateResult : this.validateErrors) {
                this.addErrorPkIds(validateResult);
            }
        }
        return this.errorDataIndexs.size();
    }

    private void addErrorPkIds(ValidateResult result) {
        for (IOperateInfo iOperateInfo : result.getAllErrorInfo()) {
            this.errorPkIds.add(iOperateInfo.getPkValue());
            if (!(iOperateInfo instanceof ValidationErrorInfo)) continue;
            this.errorDataIndexs.add(((ValidationErrorInfo)iOperateInfo).getDataEntityIndex());
        }
    }
}

