/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.validate;

import java.io.Serializable;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class ValidationErrorInfo
extends OperateErrorInfo
implements Serializable {
    private static final long serialVersionUID = -6940637054955042231L;
    private static final String BOS_ENTITY_METADATA = "bos-entity-metadata";
    private String displayToFieldKey;

    public String getDisplayToFieldKey() {
        return this.displayToFieldKey;
    }

    public ValidationErrorInfo() {
    }

    public ValidationErrorInfo(String displayToFieldKey, ExtendedDataEntity dataEntity, String errCode, String title, String message, ErrorLevel level) {
        this(displayToFieldKey, dataEntity.getBillPkId(), dataEntity.getDataEntityIndex(), dataEntity.getRowIndex(), errCode, title, message, level);
    }

    public ValidationErrorInfo(String displayToFieldKey, Object pkId, int dataEntityIndex, int rowIndex, String errCode, String title, String message, ErrorLevel level, String pattern) {
        this(displayToFieldKey, pkId, dataEntityIndex, rowIndex, errCode, title, message, level);
        this.pattern = pattern;
    }

    public ValidationErrorInfo(String displayToFieldKey, Object pkId, int dataEntityIndex, int rowIndex, String errCode, String title, String message, ErrorLevel level) {
        super(errCode, level, pkId);
        if (StringUtils.isBlank((CharSequence)errCode)) {
            throw new KDException(BosErrorCode.bOS, new Object[]{"errCode", ResManager.loadKDString((String)"\u9519\u8bef\u7801\u4e3a\u7a7a", (String)"ValidationErrorInfo_0", (String)BOS_ENTITY_METADATA, (Object[])new Object[0])});
        }
        if (dataEntityIndex < 0) {
            throw new KDException(BosErrorCode.bOS, new Object[]{"dataEntityIndex", ResManager.loadKDString((String)"\u4e0b\u6807\u8d8a\u754c", (String)"ValidationErrorInfo_1", (String)BOS_ENTITY_METADATA, (Object[])new Object[0])});
        }
        if (rowIndex < 0) {
            throw new KDException(BosErrorCode.bOS, new Object[]{"rowIndex", ResManager.loadKDString((String)"\u4e0b\u6807\u8d8a\u754c", (String)"ValidationErrorInfo_1", (String)BOS_ENTITY_METADATA, (Object[])new Object[0])});
        }
        this.displayToFieldKey = displayToFieldKey;
        this.dataEntityIndex = dataEntityIndex;
        this.rowIndex = rowIndex;
        this.errorCode = errCode;
        this.message = message;
        this.level = level;
        this.pkValue = pkId;
        this.title = title;
    }

    public String getDisplayFieldsCaption(DynamicObjectType entityType, String sFieldDelimChar) {
        if (StringUtils.isBlank((CharSequence)this.displayToFieldKey)) {
            return "";
        }
        String[] displayFields = this.displayToFieldKey.split(sFieldDelimChar);
        StringBuilder fieldCaptions = new StringBuilder();
        for (String fieldKey : displayFields) {
            DynamicProperty element = entityType.getProperty(fieldKey);
            if (element != null) {
                fieldCaptions.append(String.format("{0},", element.getName()));
                continue;
            }
            fieldCaptions.append(String.format("{0},", fieldKey));
        }
        return StringUtils.remove((String)fieldCaptions.toString(), (String)sFieldDelimChar);
    }
}

