/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.base;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import kd.bos.bill.BillLayoutSchemeService;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.MobileBillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.DifferentialControlInfo;
import kd.bos.entity.LayoutControlInfo;
import kd.bos.entity.bill.BillLayoutParameter;
import kd.bos.entity.bill.BillLayoutSchemeAssignEntity;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.plugin.Plugin;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.FieldEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.util.ExceptionUtils;

public class BillLayoutScheme {
    private static final Log log = LogFactory.getLog(BillLayoutScheme.class);
    private static final String BILLLAYOUT_SCHEMEID = "BILLLAYOUT_SCHEMEID";
    private IBillModel model;
    private BillShowParameter billShowParameter;
    BillLayoutParameter layoutValue = new BillLayoutParameter();

    public BillLayoutParameter getLayoutValue() {
        return this.layoutValue;
    }

    public BillLayoutScheme(IBillModel model, BillShowParameter billShowParameter, BillLayoutParameter param) {
        this.model = model;
        this.billShowParameter = billShowParameter;
        if (StringUtils.isBlank((CharSequence)param.getOrgFunc())) {
            this.layoutValue.setOrgFunc(this.getOrgFunc());
        } else {
            this.layoutValue.setOrgFunc(param.getOrgFunc());
        }
        this.layoutValue.setOrgId(this.getLayoutOrgId(param.getOrgId()));
        this.layoutValue.setBillTypeId(this.getLayoutBillTypeId(param.getBillTypeId()));
    }

    public String getLayoutNumber() {
        BillLayoutSchemeAssignEntity layoutScheme = this.getLayoutScheme();
        String layoutNumber = this.getOriginalFormId();
        if (layoutScheme != null && StringUtils.isNotBlank((CharSequence)layoutScheme.getLayoutNumber())) {
            layoutNumber = layoutScheme.getLayoutNumber();
        }
        return layoutNumber;
    }

    public BillLayoutSchemeAssignEntity getLayoutScheme() {
        if (this.billShowParameter instanceof MobileBillShowParameter) {
            return null;
        }
        String entityNumber = this.billShowParameter.getFormConfig().getEntityTypeId();
        return BillLayoutSchemeService.getLayoutScheme((String)entityNumber, (BillLayoutParameter)this.layoutValue);
    }

    public BillShowParameter convertLayoutShowParameter(BillShowParameter formShowParameter) {
        return this.convertLayoutShowParameter(formShowParameter, false);
    }

    public BillShowParameter convertLayoutShowParameter(BillShowParameter formShowParameter, boolean isBillTypeHidden) {
        String layoutNumber;
        if (formShowParameter instanceof MobileBillShowParameter) {
            return null;
        }
        long mainOrgId = this.layoutValue.getOrgId();
        long billType = this.layoutValue.getBillTypeId();
        String originalFormId = this.getOriginalFormId();
        BillLayoutSchemeAssignEntity layoutScheme = this.getLayoutScheme();
        if (layoutScheme == null) {
            layoutNumber = originalFormId;
        } else {
            layoutNumber = layoutScheme.getLayoutNumber();
            if (StringUtils.isBlank((CharSequence)layoutNumber)) {
                layoutNumber = originalFormId;
            }
        }
        Long schemeId = formShowParameter.getLayoutSchemeId();
        if (LayoutControlInfo.isOutLog()) {
            StackTraceElement[] stackTrace;
            Long tmpid = null;
            if (layoutScheme != null) {
                tmpid = layoutScheme.getId();
            }
            log.info(String.format("layoutlog - layoutScheme is null:%s, layoutScheme.getId:%s, originalFormId:%s, layoutNumber:%s, schemeId:%s", layoutScheme == null, tmpid, originalFormId, layoutNumber, schemeId));
            StringBuilder sb = new StringBuilder();
            sb.append("layoutlog - ");
            for (StackTraceElement stackTraceElement : stackTrace = Thread.currentThread().getStackTrace()) {
                String className = stackTraceElement.getClassName();
                String methodName = stackTraceElement.getMethodName();
                sb.append(className).append(',').append(methodName).append(System.lineSeparator());
            }
            log.warn(sb.toString());
        }
        if (layoutScheme == null && (schemeId == null || schemeId == 0L) || layoutScheme != null && schemeId != null && layoutScheme.getId() == schemeId.longValue()) {
            return null;
        }
        if (layoutScheme != null && isBillTypeHidden && layoutScheme.getOrg() == 0L && layoutScheme.getBillType() != 0L) {
            return null;
        }
        formShowParameter.setFormId(layoutNumber);
        if (billType != 0L) {
            formShowParameter.setBillTypeId(String.valueOf(billType));
        }
        formShowParameter.getOpenStyle().setShowType(ShowType.InCurrentForm);
        if (mainOrgId != 0L) {
            formShowParameter.setCustomParam("SELECT_ORG_ID", String.valueOf(mainOrgId));
        }
        formShowParameter.setLayoutMainOrgId(mainOrgId);
        if (layoutScheme != null) {
            formShowParameter.setLayoutSchemeId(layoutScheme.getId());
        } else {
            formShowParameter.setLayoutSchemeId(null);
        }
        formShowParameter.setCustomParam("KD_LAYOUT_ORIGINALFORMID", originalFormId);
        List<Plugin> plugins = formShowParameter.getFormConfig().getPlugins();
        formShowParameter.setFormConfig(FormMetadataCache.getFormConfig(layoutNumber));
        for (Plugin plugin : plugins) {
            if (!plugin.isDynamicPlugin()) continue;
            formShowParameter.addCustPlugin(plugin.getClassName());
        }
        return formShowParameter;
    }

    public void updateBillLayout(IFormView view) {
        FormShowParameter formShowParameter = view.getFormShowParameter();
        String originalFormId = (String)formShowParameter.getCustomParam("KD_LAYOUT_ORIGINALFORMID");
        if (StringUtils.isBlank((CharSequence)originalFormId)) {
            return;
        }
        Long layoutSchemeId = this.getLayoutScheme().getId();
        this.updateBillLayout(view, layoutSchemeId);
    }

    public void updateBillLayout(IFormView view, Long layoutSchemeId) {
        try (TraceSpan span = Tracer.create((String)"billlayout", (String)"BillLayoutScheme.updateBillLayout2");){
            boolean isChangeLayout;
            FormShowParameter formShowParameter = view.getFormShowParameter();
            if (!(formShowParameter instanceof BillShowParameter)) {
                return;
            }
            BillShowParameter billShowParameter = (BillShowParameter)formShowParameter;
            BillOperationStatus billStatus = billShowParameter.getBillStatus();
            IPageCache pageCache = (IPageCache)view.getService(IPageCache.class);
            String lastLayoutSchemeId = pageCache.get(BILLLAYOUT_SCHEMEID);
            boolean bl = isChangeLayout = StringUtils.isNotBlank((CharSequence)lastLayoutSchemeId) && !Objects.equals(String.valueOf(layoutSchemeId), lastLayoutSchemeId);
            if (isChangeLayout) {
                List<DifferentialControlInfo> lastDiffInfos = StringUtils.isBlank((CharSequence)lastLayoutSchemeId) ? null : this.loadDifferentialControlInfosFromCache(view.getEntityId(), Long.parseLong(lastLayoutSchemeId));
                BillLayoutScheme.recoveryLayoutControl(lastDiffInfos, billStatus, view);
                view.getPageCache().remove("fieldViByLayout");
            }
            List<DifferentialControlInfo> diffInfos = this.loadDifferentialControlInfosFromCache(view.getEntityId(), layoutSchemeId);
            pageCache.put(BILLLAYOUT_SCHEMEID, String.valueOf(layoutSchemeId));
            if (log.isInfoEnabled()) {
                if (diffInfos == null) {
                    log.info(String.format("layout id = %s, diff info is null.", layoutSchemeId));
                } else {
                    String diffInfoStr = SerializationUtils.toJsonString(diffInfos);
                    log.info(String.format("layout id = %s, diff info : %s", layoutSchemeId, diffInfoStr));
                }
            }
            if (diffInfos != null) {
                HashMap<String, Boolean> visibleMap = new HashMap<String, Boolean>(diffInfos.size());
                for (DifferentialControlInfo diffInfo : diffInfos) {
                    FieldEdit fieldEdit = (FieldEdit)view.getControl(diffInfo.getFieldKey());
                    if (fieldEdit == null) continue;
                    if (diffInfo.isMustInput() != null) {
                        if (StringUtils.isNotBlank((CharSequence)fieldEdit.getEntryKey())) {
                            EntryGrid grid = (EntryGrid)view.getControl(fieldEdit.getEntryKey());
                            grid.setMustInput(diffInfo.getFieldKey(), diffInfo.isMustInput());
                        } else {
                            fieldEdit.setMustInput(diffInfo.isMustInput());
                        }
                    }
                    if (diffInfo.isVisible(billStatus.name()) != null) {
                        if (StringUtils.isNotBlank((CharSequence)fieldEdit.getEntryKey())) {
                            Object entry = view.getControl(fieldEdit.getEntryKey());
                            if (entry instanceof CardEntry) {
                                ((CardEntry)entry).setChildVisible(diffInfo.isVisible(billStatus.name()), -1, fieldEdit.getKey());
                            } else {
                                fieldEdit.setVisible(BILLLAYOUT_SCHEMEID, diffInfo.isVisible(billStatus.name()));
                            }
                        } else {
                            fieldEdit.setVisible(BILLLAYOUT_SCHEMEID, diffInfo.isVisible(billStatus.name()));
                        }
                        visibleMap.put(fieldEdit.getKey(), diffInfo.isVisible(billStatus.name()) != null && diffInfo.isVisible(billStatus.name()) != false);
                    }
                    if (diffInfo.isLock(billStatus.name()) == null) continue;
                    fieldEdit.setEnable(BILLLAYOUT_SCHEMEID, diffInfo.isLock(billStatus.name()) == false, -1);
                }
                view.getPageCache().put("fieldViByLayout", SerializationUtils.toJsonString(visibleMap));
            }
        }
    }

    private List<DifferentialControlInfo> loadDifferentialControlInfosFromCache(String entityId, Long layoutSchemeId) {
        try {
            Class<?> flexMeta = Class.forName("kd.bos.metadata.billlayout.BillLayoutReader");
            Method loadDifferentialControlInfosFromCache = flexMeta.getMethod("loadDifferentialControlInfosFromCache", String.class, Long.TYPE);
            try {
                Object ret = loadDifferentialControlInfosFromCache.invoke(null, entityId, layoutSchemeId);
                return (List)ret;
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                String msg = e.getMessage();
                if (msg == null) {
                    msg = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
                }
                throw new KDException((Throwable)e, BosErrorCode.cannotLoadBeanClass, new Object[]{msg});
            }
        }
        catch (ClassNotFoundException | NoSuchMethodException | SecurityException e) {
            throw new KDException((Throwable)e, BosErrorCode.cannotLoadBeanClass, new Object[]{e.getMessage()});
        }
    }

    private static void recoveryLayoutControl(List<DifferentialControlInfo> beforeCtlInfos, BillOperationStatus billStatus, IFormView view) {
        if (beforeCtlInfos != null) {
            for (DifferentialControlInfo diffInfo : beforeCtlInfos) {
                FieldEdit fieldEdit = (FieldEdit)view.getControl(diffInfo.getFieldKey());
                if (fieldEdit == null) continue;
                if (diffInfo.isMustInput() != null) {
                    if (StringUtils.isNotBlank((CharSequence)fieldEdit.getEntryKey())) {
                        EntryGrid grid = (EntryGrid)view.getControl(fieldEdit.getEntryKey());
                        grid.setMustInput(diffInfo.getFieldKey(), false);
                    } else {
                        fieldEdit.setMustInput(false);
                    }
                }
                if (diffInfo.isVisible(billStatus.name()) != null && diffInfo.isVisible(billStatus.name()) == Boolean.FALSE) {
                    fieldEdit.setVisible(BILLLAYOUT_SCHEMEID, true);
                }
                if (diffInfo.isLock(billStatus.name()) == null || diffInfo.isLock(billStatus.name()) != Boolean.TRUE) continue;
                fieldEdit.setEnable(BILLLAYOUT_SCHEMEID, true, -1);
            }
        }
    }

    private String getOrgFunc() {
        MainOrgProp mainOrgProp = ((BillEntityType)this.model.getDataEntityType()).getMainOrgProperty();
        String orgFunc = "";
        if (mainOrgProp != null) {
            orgFunc = mainOrgProp.getOrgFunc();
        }
        return orgFunc;
    }

    private long getLayoutOrgId(long newOrgId) {
        Long oid;
        String mainOrgField = this.model.getDataEntityType().getMainOrg();
        long orgId = newOrgId;
        if (StringUtils.isNotBlank((CharSequence)mainOrgField) && newOrgId == 0L && (oid = this.model.getMainOrgId()) != null) {
            orgId = oid;
        }
        return orgId;
    }

    private long getLayoutBillTypeId(long billType) {
        long billTypeId = 0L;
        if (billType != 0L) {
            billTypeId = billType;
        } else {
            DynamicObject billTypeObj;
            BillEntityType dt = (BillEntityType)this.model.getDataEntityType();
            String billTypeKey = dt.getBillType();
            if (StringUtils.isNotBlank((CharSequence)billTypeKey) && (billTypeObj = (DynamicObject)this.model.getValue(billTypeKey)) != null && billTypeObj.getPkValue() != null) {
                billTypeId = (Long)billTypeObj.getPkValue();
            }
        }
        return billTypeId;
    }

    private String getOriginalFormId() {
        String originalFormId = (String)this.billShowParameter.getCustomParam("KD_LAYOUT_ORIGINALFORMID");
        if (StringUtils.isBlank((CharSequence)originalFormId)) {
            return this.billShowParameter.getFormId();
        }
        return originalFormId;
    }
}

