/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.filter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterScheme;
import kd.bos.filter.SchemeCodeType;
import kd.bos.orm.util.CollectionUtils;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public final class FilterSchemeService {
    private static final String SCHEME = "scheme";

    private FilterSchemeService() {
    }

    static FilterScheme getDefaultScheme(List<FilterScheme> filterSchemes, String schemeId) {
        FilterScheme defaultScheme = null;
        if (StringUtils.isNotBlank((CharSequence)schemeId)) {
            for (FilterScheme filterScheme : filterSchemes) {
                if (StringUtils.isNotBlank((CharSequence)filterScheme.getLocaleName().toString())) {
                    filterScheme.setSchemeName(filterScheme.getLocaleName().toString());
                }
                if (!filterScheme.getId().equals(schemeId)) continue;
                filterScheme.setDefault(true);
                defaultScheme = filterScheme;
            }
        } else {
            defaultScheme = FilterSchemeService.getDefaultSchemeFromAll(filterSchemes);
        }
        return defaultScheme;
    }

    public static FilterScheme getDefaultSchemeFromAll(List<FilterScheme> filterSchemes) {
        FilterScheme defaultScheme = null;
        for (FilterScheme filterScheme : filterSchemes) {
            if (StringUtils.isNotBlank((CharSequence)filterScheme.getLocaleName().toString())) {
                filterScheme.setSchemeName(filterScheme.getLocaleName().toString());
            }
            if (FilterSchemeService.cannotSetDefeault(filterScheme) || (defaultScheme = filterScheme).isFixed()) continue;
            break;
        }
        return defaultScheme;
    }

    private static boolean cannotSetDefeault(FilterScheme filterScheme) {
        return !filterScheme.isDefault();
    }

    static void initFilterSchemesToDefaultToFalseById(List<FilterScheme> filterSchemes, FilterScheme defaultScheme) {
        for (FilterScheme filterScheme : filterSchemes) {
            if (defaultScheme.getId().equals(filterScheme.getId())) continue;
            filterScheme.setDefault(false);
        }
    }

    static void initFilterSchemesToDefaultToFalse(List<FilterScheme> filterSchemes) {
        for (FilterScheme filterScheme : filterSchemes) {
            filterScheme.setDefault(false);
        }
    }

    static List<Map<String, Object>> getSchemeList(List<FilterScheme> filterSchemes, boolean isSimple, SchemeCodeType schemeCodeType) {
        ArrayList<Map<String, Object>> schemeList = new ArrayList<Map<String, Object>>(10);
        List<FilterScheme> orderedFilterSchemes = FilterSchemeService.getOrderedFilterSchemes(filterSchemes);
        for (FilterScheme filterScheme : orderedFilterSchemes) {
            Map<String, Object> schemeMap = FilterSchemeService.createSchemeMap(filterScheme, isSimple, schemeCodeType);
            schemeList.add(schemeMap);
        }
        return schemeList;
    }

    private static List<FilterScheme> getOrderedFilterSchemes(List<FilterScheme> filterSchemes) {
        ArrayList<FilterScheme> orderedFilterSchemes = new ArrayList<FilterScheme>();
        ArrayList<FilterScheme> notShareNullLastFilterSchemes = new ArrayList<FilterScheme>();
        ArrayList<FilterScheme> shareFilterSchemes = new ArrayList<FilterScheme>();
        ArrayList<FilterScheme> notShareNotNullFilterSchemes = new ArrayList<FilterScheme>();
        for (FilterScheme filterScheme : filterSchemes) {
            if (filterScheme.getCreateTime() == null && !filterScheme.isFixed() && !filterScheme.isShare()) {
                notShareNullLastFilterSchemes.add(filterScheme);
                continue;
            }
            if (filterScheme.getCreateTime() != null && !filterScheme.isFixed() && !filterScheme.isShare()) {
                notShareNotNullFilterSchemes.add(filterScheme);
                continue;
            }
            if (filterScheme.isFixed()) {
                orderedFilterSchemes.add(filterScheme);
                continue;
            }
            if (!filterScheme.isShare() || filterScheme.isFixed()) continue;
            shareFilterSchemes.add(filterScheme);
        }
        orderedFilterSchemes.addAll(notShareNotNullFilterSchemes);
        orderedFilterSchemes.addAll(notShareNullLastFilterSchemes);
        orderedFilterSchemes.addAll(shareFilterSchemes);
        return orderedFilterSchemes;
    }

    private static Map<String, Object> getSimpleScheme(FilterScheme scheme) {
        String localeValue;
        HashMap<String, Object> sch = new HashMap<String, Object>(16);
        sch.put("id", scheme.getId());
        String name = scheme.getSchemeName();
        if (scheme.getLocaleName() != null && StringUtils.isNotBlank((CharSequence)(localeValue = scheme.getLocaleName().getLocaleValue()))) {
            name = localeValue;
        }
        sch.put("name", name);
        sch.put("default", scheme.isDefault());
        sch.put("fixed", scheme.isFixed());
        return sch;
    }

    static List<Map<String, Object>> getSharedSchemeList(List<FilterScheme> filterSchemeList, List<FilterScheme> filterSchemes, boolean isSimple, SchemeCodeType schemeCodeType, List<Object> ownerSchemeIdList, Map<String, Integer> map) {
        ArrayList<Map<String, Object>> schemeList = new ArrayList<Map<String, Object>>(10);
        for (FilterScheme filterScheme : filterSchemes) {
            Map scheme;
            if (!isSimple) {
                Map schemeValue;
                scheme = schemeValue = FilterSchemeService.getDcJsonSerializer().serializeToMap((Object)filterScheme, null);
                if (schemeCodeType == SchemeCodeType.BASE64) {
                    scheme.put(SCHEME, SerializationUtils.deSerializeFromBase64((String)scheme.get(SCHEME).toString()));
                } else if (schemeCodeType == SchemeCodeType.JSON) {
                    scheme.put(SCHEME, SerializationUtils.fromJsonString((String)scheme.get(SCHEME).toString(), Map.class));
                }
                if (!CollectionUtils.isEmpty(map) && map.containsKey(filterScheme.getId()) && map.get(filterScheme.getId()) == 1) {
                    scheme.put("default", true);
                }
            } else {
                scheme = FilterSchemeService.getSimpleScheme(filterScheme);
            }
            scheme.put("type", 2);
            DynamicObject currentUser = FilterSchemeService.getCurrentUser("name", filterScheme.getUserId());
            if (currentUser != null) {
                scheme.put("creator", currentUser.get("name").toString());
            }
            if (ownerSchemeIdList.contains(scheme.get("id"))) continue;
            schemeList.add(scheme);
        }
        return schemeList;
    }

    public static Map<String, Object> createSchemeMap(FilterScheme filterScheme, boolean isSimple, SchemeCodeType schemeCodeType) {
        Map scheme;
        if (!isSimple) {
            Map schemeValue;
            scheme = schemeValue = FilterSchemeService.getDcJsonSerializer().serializeToMap((Object)filterScheme, null);
            if (schemeCodeType == SchemeCodeType.BASE64) {
                scheme.put(SCHEME, SerializationUtils.deSerializeFromBase64((String)scheme.get(SCHEME).toString()));
            } else if (schemeCodeType == SchemeCodeType.JSON) {
                scheme.put(SCHEME, SerializationUtils.fromJsonString((String)scheme.get(SCHEME).toString(), Map.class));
            }
            scheme.put("name", filterScheme.getLocaleName());
        } else {
            scheme = FilterSchemeService.getSimpleScheme(filterScheme);
        }
        FilterSchemeService.fixSchemeMap(filterScheme, scheme);
        return scheme;
    }

    static void fixSchemeMap(FilterScheme filterScheme, Map<String, Object> scheme) {
        if (scheme != null) {
            scheme.put("id", filterScheme.getId());
            if (filterScheme.isShare() && !filterScheme.isFixed()) {
                scheme.put("type", 1);
                DynamicObject currentUser = FilterSchemeService.getCurrentUser("name", filterScheme.getUserId());
                if (currentUser != null) {
                    scheme.put("creator", currentUser.get("name").toString());
                }
            } else {
                scheme.put("type", 0);
            }
        }
    }

    private static DcJsonSerializer getDcJsonSerializer() {
        ArrayList<IDataEntityType> dts = new ArrayList<IDataEntityType>();
        dts.add(OrmUtils.getDataEntityType(FilterScheme.class));
        return new DcJsonSerializer(dts);
    }

    static DynamicObject getCurrentUser(String fieldName, long userId) {
        ArrayList<String> selectFields = new ArrayList<String>();
        selectFields.add("id");
        selectFields.add(fieldName);
        Map loadFromCache = BusinessDataReader.loadFromCache((Object[])new Object[]{userId}, (DynamicObjectType)((MainEntityType)EntityMetadataCache.getSubDataEntityType((String)"bos_user", selectFields)));
        return (DynamicObject)loadFromCache.get(userId);
    }
}

