/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.filter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.filter.CompareType;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.property.AdminDivisionProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.list.ListColumnCompareType;
import org.jetbrains.annotations.NotNull;

public class ListColumnCompareHelper {
    private static final String FILTER = "filter";
    private static final String COMBO = "combo";
    private static final String VALUE = "value";
    private static final String EDITOR = "editor";
    public static final String SORT = "sort";

    private ListColumnCompareHelper() {
    }

    public static void setColumnCompareOperators(FilterField filterField, Map<String, Object> column, Map<String, List<CompareType>> fieldCompareTypeMap, String fieldName, Function<List<ValueMapItem>, List<ValueMapItem>> functionCombo, Function<List<ListColumnCompareType>, List<ListColumnCompareType>> functionCompareType, boolean isListColumnBasedataFilter) {
        ListColumnCompareHelper.setColumnCompareOperators(filterField, column, fieldCompareTypeMap, fieldName, null, functionCombo, functionCompareType, new ArrayList<String>(), isListColumnBasedataFilter, new HashSet<String>(0));
    }

    public static void setColumnCompareOperators(FilterField filterField, Map<String, Object> column, Map<String, List<CompareType>> fieldCompareTypeMap, String fieldName, Function<List<ValueMapItem>, List<ValueMapItem>> functionCombo, Function<List<ListColumnCompareType>, List<ListColumnCompareType>> functionCompareType, boolean isListColumnBasedataFilter, Set<String> canNotReadFields) {
        ListColumnCompareHelper.setColumnCompareOperators(filterField, column, fieldCompareTypeMap, fieldName, null, functionCombo, functionCompareType, new ArrayList<String>(), isListColumnBasedataFilter, canNotReadFields);
    }

    public static void setColumnCompareOperators(FilterField filterField, Map<String, Object> column, Map<String, List<CompareType>> fieldCompareTypeMap, String fieldName, String type, Function<List<ValueMapItem>, List<ValueMapItem>> functionCombo, Function<List<ListColumnCompareType>, List<ListColumnCompareType>> functionCompareType, List<String> excludeCompareIds, boolean isListColumnBasedataFilter) {
        ListColumnCompareHelper.setColumnCompareOperators(filterField, column, fieldCompareTypeMap, fieldName, type, functionCombo, functionCompareType, excludeCompareIds, isListColumnBasedataFilter, new HashSet<String>(0));
    }

    public static void setColumnCompareOperators(FilterField filterField, Map<String, Object> column, Map<String, List<CompareType>> fieldCompareTypeMap, String fieldName, String type, Function<List<ValueMapItem>, List<ValueMapItem>> functionCombo, Function<List<ListColumnCompareType>, List<ListColumnCompareType>> functionCompareType, List<String> excludeCompareIds, boolean isListColumnBasedataFilter, Set<String> canNotReadFields) {
        if (filterField == null || filterField.getFieldName() == null) {
            column.put(SORT, false);
            column.put(FILTER, false);
        } else if (filterField.getFieldName() != null && filterField.getFieldName().toLowerCase().lastIndexOf(".seq") != -1 || filterField.getLatestParent() instanceof IBasedataField && filterField.getFieldProp() instanceof PKFieldProp) {
            column.put(SORT, false);
            column.put(FILTER, false);
        } else {
            IDataEntityProperty fieldProp;
            ISimpleProperty srcprop;
            HashMap editor = (HashMap)column.get(EDITOR);
            if (editor.get("type") != null && type == null) {
                type = editor.get("type").toString();
            }
            if (COMBO.equals(type) || "checkbox".equals(type) || "mulcombo".equals(type) || "radiooptgroup".equals(type) || "checkboxgroup".equals(type) || filterField.getFieldProp() instanceof ComboProp) {
                ArrayList<Map<String, Object>> comboItems = new ArrayList<Map<String, Object>>(10);
                List comboItems2 = filterField.getComboItems();
                if (functionCombo != null) {
                    List<ValueMapItem> listColumnCompareTypesSetListenerByComboItems = functionCombo.apply(comboItems2);
                    for (ValueMapItem v : listColumnCompareTypesSetListenerByComboItems) {
                        comboItems.add(ListColumnCompareHelper.createComboItem(v));
                    }
                } else {
                    for (ValueMapItem v : comboItems2) {
                        comboItems.add(ListColumnCompareHelper.createComboItem(v));
                    }
                }
                if (comboItems.isEmpty()) {
                    column.put(FILTER, false);
                } else {
                    column.put("comboItems", comboItems);
                }
            } else {
                if (filterField.getFieldProp() instanceof DateTimeProp || filterField.getFieldProp() instanceof TimeProp || filterField.getFieldProp() instanceof IntegerProp || filterField.getFieldProp() instanceof LongProp || filterField.getFieldProp() instanceof DecimalProp) {
                    type = filterField.getFilterControlType();
                    editor.put("type", type);
                }
                List<CompareType> compareTypes = ListColumnCompareHelper.getCompareTypes(filterField, type, fieldCompareTypeMap, fieldName, excludeCompareIds, isListColumnBasedataFilter);
                ArrayList<ListColumnCompareType> listColumnCompareTypes = new ArrayList<ListColumnCompareType>(compareTypes.size());
                for (CompareType compareType : compareTypes) {
                    listColumnCompareTypes.add(new ListColumnCompareType(compareType.getId(), compareType.getName(), compareType.getValue(), compareType.getInputCtlType(), "67".equals(compareType.getId()) || "110".equals(compareType.getId()) || "800".equals(compareType.getId())));
                }
                if (listColumnCompareTypes.isEmpty()) {
                    column.put(FILTER, false);
                } else {
                    IDataEntityProperty fieldProp2;
                    List<ListColumnCompareType> listColumnCompareTypesSetListenerByCompareTypes = listColumnCompareTypes;
                    if (functionCompareType != null) {
                        listColumnCompareTypesSetListenerByCompareTypes = functionCompareType.apply(listColumnCompareTypes);
                    }
                    if ((fieldProp2 = filterField.getLatestParent()) instanceof ItemClassProp) {
                        ListColumnCompareHelper.getItemClassFieldCompareType(filterField, column, (ItemClassProp)fieldProp2);
                    } else if (isListColumnBasedataFilter) {
                        column.put("enableBasedataEnumFilter", isListColumnBasedataFilter);
                    }
                    column.put("filterItems", listColumnCompareTypesSetListenerByCompareTypes);
                }
            }
            if (filterField.getSrcFieldProp() instanceof ISimpleProperty && ((srcprop = (ISimpleProperty)filterField.getSrcFieldProp()).isEncrypt() || srcprop.getPrivacyType() != 0L)) {
                column.put(SORT, false);
                if (srcprop instanceof DateTimeProp) {
                    column.put(FILTER, false);
                }
            }
            if ((fieldProp = filterField.getFieldProp()) instanceof TimeProp) {
                column.put(SORT, false);
                column.put(FILTER, false);
            } else if (fieldProp instanceof AdminDivisionProp) {
                column.put(SORT, false);
                column.put(FILTER, false);
            }
            if (filterField.getMainType() instanceof QueryEntityType && filterField.getLatestParent() instanceof MulBasedataProp) {
                column.put(SORT, false);
            }
            if (canNotReadFields.contains(filterField.getSrcFieldKey())) {
                column.put(SORT, false);
                column.put(FILTER, false);
            }
        }
    }

    @NotNull
    private static Map<String, Object> createComboItem(ValueMapItem v) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("id", "17");
        map.put("name", v.getName());
        map.put(VALUE, v.getValue());
        return map;
    }

    private static void getItemClassFieldCompareType(FilterField filterField, Map<String, Object> column, ItemClassProp classProp) {
        ItemClassTypeProp typeProp = ListColumnCompareHelper.getTypeProp(filterField.getMainType(), classProp, filterField.getSrcFieldProp());
        if (typeProp == null) {
            column.put(FILTER, false);
            return;
        }
        ArrayList fieldList = new ArrayList();
        Map itemTypes = new HashMap();
        List entityIds = null;
        LocaleString caption = null;
        if (typeProp != null) {
            itemTypes = typeProp.getItemTypes();
            entityIds = typeProp.getBaseEntityIds();
            caption = typeProp.getDisplayName();
        }
        HashMap<String, Object> typeMap = new HashMap<String, Object>();
        Set keySet = itemTypes.keySet();
        ArrayList items = new ArrayList();
        if (entityIds != null && !entityIds.isEmpty()) {
            for (String s : entityIds) {
                HashMap<String, String> item = new HashMap<String, String>();
                item.put("id", "17");
                DynamicObjectType entityType = (DynamicObjectType)itemTypes.get(s);
                item.put("name", (String)entityType.getDisplayName());
                item.put(VALUE, s);
                items.add(item);
            }
        } else {
            Map finalItemTypes = itemTypes;
            keySet.forEach(key -> {
                HashMap<String, String> item = new HashMap<String, String>();
                item.put("id", "17");
                DynamicObjectType entityType = (DynamicObjectType)finalItemTypes.get(key);
                item.put("name", (String)entityType.getDisplayName());
                item.put(VALUE, (String)key);
                items.add(item);
            });
        }
        typeMap.put("items", items);
        typeMap.put("type", COMBO);
        typeMap.put("caption", caption);
        typeMap.put("fieldName", "itemclassprop_" + classProp.getTypePropName());
        fieldList.add(typeMap);
        column.put("otherFilterItems", fieldList);
    }

    private static ItemClassTypeProp getTypeProp(MainEntityType mainType, ItemClassProp itemClassProp, IDataEntityProperty srcFieldProp) {
        if (mainType == null || itemClassProp == null || StringUtils.isBlank((CharSequence)itemClassProp.getTypePropName())) {
            return null;
        }
        if (!itemClassProp.equals((Object)srcFieldProp)) {
            return null;
        }
        IDataEntityProperty prop = mainType.findProperty(itemClassProp.getTypePropName());
        if (prop instanceof ItemClassTypeProp) {
            return (ItemClassTypeProp)prop;
        }
        return null;
    }

    private static List<CompareType> getCompareTypes(FilterField filterField, String type, Map<String, List<CompareType>> fieldCompareTypeMap, String fieldName, List<String> excludeCompareIds, boolean isListColumnBasedataFilter) {
        ArrayList<CompareType> compareTypes = new ArrayList<CompareType>();
        if (fieldCompareTypeMap.containsKey(fieldName)) {
            List<CompareType> thisCompareTypes = fieldCompareTypeMap.get(fieldName);
            for (CompareType compareType2 : thisCompareTypes) {
                compareTypes.add(compareType2);
            }
        }
        List customCompareTypes = filterField.getCustomCompareTypes();
        for (CompareType compareType2 : customCompareTypes) {
            if (compareType2.isNeedInput()) continue;
            compareTypes.add(compareType2);
        }
        List filterFieldCompareTypes = filterField.getCompareTypes();
        if (!filterFieldCompareTypes.isEmpty()) {
            filterFieldCompareTypes.removeIf(compareType -> excludeCompareIds.contains(compareType.getId()));
        }
        compareTypes.addAll(ListColumnCompareHelper.getCompareTypesByColumnType(filterFieldCompareTypes, type, isListColumnBasedataFilter));
        return compareTypes;
    }

    private static List<CompareType> getCompareTypesByColumnType(List<CompareType> compareTypes, String type, boolean enableBasedataEnumFilter) {
        List<Object> compareList = new ArrayList(10);
        if ("text".equals(type) || "textarea".equals(type) || "localeText".equals(type) || "address".equals(type) || "telephone".equals(type) || "email".equals(type) || "cascademenu".equals(type)) {
            List commonTypeList = Stream.of("67", "83", "59", "58", "60", "211", "37", "9", "114", "110", "800", "801", "802", "803", "806", "807", "808", "809").collect(Collectors.toList());
            if (compareTypes != null) {
                compareTypes.removeIf(compareType -> !commonTypeList.contains(compareType.getId()));
            }
            HashMap<String, Integer> map = new HashMap<String, Integer>(16);
            if (enableBasedataEnumFilter) {
                map.put("67", 0);
                map.put("110", 0);
                map.put("800", 0);
                map.put("59", 1);
                map.put("802", 1);
                map.put("58", 2);
                map.put("803", 2);
            } else {
                map.put("59", 0);
                map.put("802", 0);
                map.put("58", 1);
                map.put("803", 1);
                map.put("67", 2);
                map.put("110", 2);
                map.put("800", 2);
            }
            map.put("83", 3);
            map.put("114", 3);
            map.put("801", 3);
            map.put("60", 4);
            map.put("808", 4);
            map.put("211", 5);
            map.put("809", 5);
            map.put("37", 6);
            map.put("806", 6);
            map.put("9", 7);
            map.put("807", 7);
            if (compareTypes != null && !compareTypes.isEmpty()) {
                compareTypes.sort((c1, c2) -> (Integer)map.get(c1.getId()) - (Integer)map.get(c2.getId()));
                compareList.addAll(compareTypes);
            }
        } else if ("number".equals(type)) {
            compareList = compareTypes;
        } else if ("datetime".equals(type) || "date".equals(type)) {
            List commonTypeList = Stream.of("13", "10", "63", "92", "51", "24", "67", "1").collect(Collectors.toList());
            if (compareTypes != null) {
                compareTypes.removeIf(compareType -> !commonTypeList.contains(compareType.getId()));
            }
            compareList = compareTypes;
        } else {
            compareList = "time".equals(type) ? compareTypes.stream().filter(p -> "67".equals(p.getId()) || "83".equals(p.getId())).collect(Collectors.toList()) : (type != null && (COMBO.equals(type) || "checkbox".equals(type) || "mulcombo".equals(type)) ? compareTypes.stream().filter(p -> "17".equals(p.getId())).collect(Collectors.toList()) : compareTypes);
        }
        return compareList;
    }
}

