/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.DataEntitySerializerOption;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid8;
import kd.bos.entity.EntryType;
import kd.bos.entity.LoadingType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.FlexGridConfigRow;
import kd.bos.entity.operate.GridConfigurationRow;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.param.AppParam;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.FieldPos;
import kd.bos.entity.validate.GroupFieldsUniqueValidateResult;
import kd.bos.entity.validate.ValidataErrorCode;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.form.BinderMap;
import kd.bos.form.ClientCallbackListener;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FieldTip;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxLink;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.container.FormRoot;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.BasedataPropEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.gridconfig.GridConfigRenderUtils;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.list.IListView;
import kd.bos.msgjet.MsgSendFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.param.ParameterReader;
import kd.bos.param.service.IParameterHelperService;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.service.ServiceSvcFactory;
import kd.bos.session.SystemPropertyUtils;
import kd.bos.userconfig.GridConfigDAO;
import kd.sdk.annotation.SdkPublic;
import org.apache.commons.collections4.map.CaseInsensitiveMap;

@KSObject
@SdkPublic
public abstract class AbstractFormView
implements IFormView {
    protected Map<Class<?>, Object> services = new HashMap();
    protected FormShowParameter formShowParameter;
    protected Map<String, Control> cacheControls = new CaseInsensitiveMap();
    protected Set<String> customControls = new HashSet<String>();
    protected Map<String, Object> parameter;
    private static final String MESSAGEETYPE = "messageType";
    private static final String CONFIRMCALLBACKLISTENER = "ConfirmCallBackListener.";
    private static final String BOS_FORM_METADATA = "bos-form-metadata";
    private static final String CONTENT = "content";
    private static final String DURATION = "duration";
    private static final String ARGS = "args";
    private static final String DevAppId = "83bfebc800003dac";
    public static final String SHOW_TIP_DURATION = "showtipduration";
    protected Object returnData;
    protected IFormView parentView;
    protected Object returnToParentData;
    private static final String SPAN_TYPE_NAME = "sortErrorMsg";
    protected static final String ClientMethodCallbackCachePrefix = "ClientMethodCallback";

    public final OperationStatus getStatus() {
        return this.getFormShowParameter().getStatus();
    }

    @Override
    public void setStatus(OperationStatus value) {
        try (EntityTraceSpan span = EntityTracer.create((String)"AbstractFormView", (String)"AbstractFormView.setBillStatus");){
            span.addTag("value", String.valueOf((Object)value));
            this.getFormShowParameter().setStatus(value);
            this.getClientProxy().removeAction("setFormStatus");
            this.getClientProxy().addAction("setFormStatus", value.getValue());
        }
    }

    @Override
    @KSMethod
    public <T> T getService(Class<?> clazz) {
        return (T)this.services.get(clazz);
    }

    @Override
    public void addService(Class<?> clazz, Object service) {
        this.services.put(clazz, service);
    }

    @Override
    @KSMethod
    public void addCustomControls(String ... key) {
        for (String k : key) {
            this.customControls.add(k.toLowerCase());
        }
    }

    @Override
    @KSMethod
    public String getPageId() {
        return this.getFormShowParameter().getPageId();
    }

    @Override
    @KSMethod
    public FormShowParameter getFormShowParameter() {
        return this.formShowParameter;
    }

    protected FormViewPluginProxy getPluginProxy() {
        return (FormViewPluginProxy)this.getService(FormViewPluginProxy.class);
    }

    @Override
    @KSMethod
    public void sendFormAction(IFormView view) {
        List<Object> acts = view.getActionResult();
        this.sendFormAction(view.getPageId(), acts);
    }

    protected void sendFormAction(String pageId, List<Object> acts) {
        if (!acts.isEmpty()) {
            HashMap<String, Object> arg = new HashMap<String, Object>(3);
            arg.put("pageId", pageId);
            arg.put("actions", acts);
            this.getClientProxy().addAction("sendDynamicFormAction", arg);
        }
    }

    @Override
    @KSMethod
    public Object getReturnData() {
        return this.returnData;
    }

    @Override
    @KSMethod
    public void setReturnData(Object value) {
        this.returnData = value;
    }

    @Override
    public void setClientReturnData(Object retValue) {
        this.getClientProxy().addAction("setReturnData", retValue);
    }

    @Override
    @KSMethod
    public IDataModel getModel() {
        return (IDataModel)this.getService(IDataModel.class);
    }

    @Override
    @KSMethod
    public IFormView getParentView() {
        if (this.parentView == null) {
            this.parentView = this.getView(this.formShowParameter.getParentPageId());
        }
        return this.parentView;
    }

    @Override
    @KSMethod
    public void returnDataToParent(Object value) {
        this.returnToParentData = value;
    }

    @Override
    @KSMethod
    public void executeClientCommand(String cmdName, Object ... parameter) {
        HashMap<String, Object> jo = new HashMap<String, Object>();
        jo.put("cmdName", cmdName);
        jo.put(ARGS, parameter);
        this.getClientProxy().addAction("executeClientCommand", jo);
    }

    @Override
    public void executeClientMethodCallback(String method, Map<String, Object> args, ClientCallbackListener listener) {
        String callbackId = "ClientMethodCallback." + Uuid8.generateShortUuid();
        this.getPageCache().put(callbackId, SerializationUtils.toJsonString((Object)listener));
        args.put("id", callbackId);
        this.getClientProxy().addAction(method, args);
    }

    @Override
    @KSMethod
    public void showMessage(String msg) {
        this.showMessage(msg, "", MessageTypes.Default);
    }

    @Override
    @KSMethod
    public void showMessage(String msg, String detail, MessageTypes type) {
        Map postMap;
        HashMap<String, Object> jo = new HashMap<String, Object>();
        if (msg != null && msg.contains("\"msgcode\":") && msg.contains("\"msg\":")) {
            postMap = (Map)SerializationUtils.fromJsonString((String)msg, Map.class);
            String msgcode = (String)postMap.get("msgcode");
            msg = (String)postMap.get("msg");
            String tenantId = RequestContext.get().getTenantId();
            String tipsOn = SystemPropertyUtils.getProptyByTenant((String)"bos.hottips.on", (String)tenantId);
            if (!"FALSE".equalsIgnoreCase(tipsOn)) {
                jo.put("msgcode", msgcode);
                jo.put("href", postMap.get("href"));
            }
        }
        if (detail != null && detail.contains("\"msgcode\":") && detail.contains("\"msg\":")) {
            postMap = (Map)SerializationUtils.fromJsonString((String)detail, Map.class);
            detail = (String)postMap.get("msg");
        }
        jo.put("msg", msg == null ? "" : this.convertToFormName(msg));
        jo.put("detail", detail == null ? "" : this.convertToFormName(detail));
        jo.put(MESSAGEETYPE, type == null ? MessageTypes.Default : Integer.valueOf(type.getValue()));
        this.getClientProxy().addAction("showMessage", jo);
    }

    @KSMethod
    public void showMessage(String msg, String type, ConfirmCallBackListener callBack) {
        this.showMessage(msg, MessageTypes.valueOf(type), callBack);
    }

    @Override
    public void showMessage(String msg, MessageTypes type, ConfirmCallBackListener callBack) {
        HashMap<String, Object> jo = new HashMap<String, Object>();
        if (callBack != null) {
            jo.put("id", callBack.getCallBackId());
            IPageCache cache = (IPageCache)this.getService(IPageCache.class);
            cache.put(CONFIRMCALLBACKLISTENER + callBack.getCallBackId(), SerializationUtils.toJsonString((Object)callBack));
        }
        if (msg != null && msg.contains("\"msgcode\":") && msg.contains("\"msg\":")) {
            Map postMap = (Map)SerializationUtils.fromJsonString((String)msg, Map.class);
            String msgcode = (String)postMap.get("msgcode");
            msg = (String)postMap.get("msg");
            String tenantId = RequestContext.get().getTenantId();
            String tipsOn = SystemPropertyUtils.getProptyByTenant((String)"bos.hottips.on", (String)tenantId);
            if (!"FALSE".equalsIgnoreCase(tipsOn)) {
                jo.put("msgcode", msgcode);
                jo.put("href", postMap.get("href"));
            }
        }
        jo.put("msg", msg == null ? "" : this.convertToFormName(msg));
        jo.put(MESSAGEETYPE, type == null ? MessageTypes.Default : Integer.valueOf(type.getValue()));
        this.getClientProxy().addAction("showMessage", jo);
    }

    @Override
    public void showMessage(String msg, String iconfont, MessageTypes type, ConfirmCallBackListener callBack) {
        HashMap<String, Object> jo = new HashMap<String, Object>();
        if (callBack != null) {
            jo.put("id", callBack.getCallBackId());
            IPageCache cache = (IPageCache)this.getService(IPageCache.class);
            cache.put(CONFIRMCALLBACKLISTENER + callBack.getCallBackId(), SerializationUtils.toJsonString((Object)callBack));
        }
        if (StringUtils.isNotBlank((CharSequence)iconfont)) {
            jo.put("icon", iconfont);
        }
        if (msg != null && msg.contains("\"msgcode\":") && msg.contains("\"msg\":")) {
            Map postMap = (Map)SerializationUtils.fromJsonString((String)msg, Map.class);
            String msgcode = (String)postMap.get("msgcode");
            msg = (String)postMap.get("msg");
            String tenantId = RequestContext.get().getTenantId();
            String tipsOn = SystemPropertyUtils.getProptyByTenant((String)"bos.hottips.on", (String)tenantId);
            if (!"FALSE".equalsIgnoreCase(tipsOn)) {
                jo.put("msgcode", msgcode);
                jo.put("href", postMap.get("href"));
            }
        }
        jo.put("msg", msg == null ? "" : this.convertToFormName(msg));
        jo.put(MESSAGEETYPE, type == null ? MessageTypes.Default : Integer.valueOf(type.getValue()));
        this.getClientProxy().addAction("showMessage", jo);
    }

    @Override
    public void showMessage(String tempMsg, List<MessageBoxLink> msglinks, MessageTypes type, ConfirmCallBackListener callBack) {
        HashMap<String, Object> jo = new HashMap<String, Object>();
        HashMap<String, Object> msgObj = new HashMap<String, Object>();
        if (tempMsg != null && tempMsg.contains("\"msgcode\":") && tempMsg.contains("\"msg\":")) {
            Map postMap = (Map)SerializationUtils.fromJsonString((String)tempMsg, Map.class);
            String msgcode = (String)postMap.get("msgcode");
            tempMsg = (String)postMap.get("msg");
            String tenantId = RequestContext.get().getTenantId();
            String tipsOn = SystemPropertyUtils.getProptyByTenant((String)"bos.hottips.on", (String)tenantId);
            if (!"FALSE".equalsIgnoreCase(tipsOn)) {
                jo.put("msgcode", msgcode);
                jo.put("href", postMap.get("href"));
            }
        }
        msgObj.put("temp", tempMsg == null ? "" : this.convertToFormName(tempMsg));
        msgObj.put(ARGS, msglinks);
        if (callBack != null) {
            jo.put("id", callBack.getCallBackId());
            IPageCache cache = (IPageCache)this.getService(IPageCache.class);
            cache.put(CONFIRMCALLBACKLISTENER + callBack.getCallBackId(), SerializationUtils.toJsonString((Object)callBack));
        }
        jo.put("msg", msgObj);
        jo.put(MESSAGEETYPE, type == null ? MessageTypes.Default : Integer.valueOf(type.getValue()));
        this.getClientProxy().addAction("showMessage", jo);
    }

    @KSMethod
    public IClientViewProxy getClientProxy() {
        return (IClientViewProxy)this.getService(IClientViewProxy.class);
    }

    @Override
    public IPageCache getPageCache() {
        return (IPageCache)this.getService(IPageCache.class);
    }

    @Override
    @KSMethod
    public void showErrMessage(String msg, String title) {
        Map postMap;
        HashMap<String, Object> jo = new HashMap<String, Object>();
        MessageBoxOptions options = MessageBoxOptions.OK;
        if (title != null && title.contains("\"msgcode\":") && title.contains("\"msg\":")) {
            postMap = (Map)SerializationUtils.fromJsonString((String)title, Map.class);
            title = (String)postMap.get("msg");
        }
        if (msg != null && msg.contains("\"msgcode\":") && msg.contains("\"msg\":")) {
            postMap = (Map)SerializationUtils.fromJsonString((String)msg, Map.class);
            msg = (String)postMap.get("msg");
        }
        jo.put("errorTitle", title);
        jo.put("errorInfo", this.convertToFormName(msg));
        jo.put("option", options.getValue());
        this.getClientProxy().addAction("showErrMsg", jo);
    }

    @Override
    @KSMethod
    public void showOperationResult(OperationResult operationResult) {
        this.showOperationResult(operationResult, "");
    }

    @Override
    public void showPictureView(String[] urls, int activeIndex) {
        HashMap<String, Object> jo = new HashMap<String, Object>();
        jo.put("urls", urls);
        jo.put("activeIndex", activeIndex);
        this.getClientProxy().addAction("showPictureView", jo);
    }

    private Map<String, List<String>> getLayoutFieldSort() {
        if (this instanceof IListView) {
            return null;
        }
        Control rootControl = this.getRootControl();
        HashMap<String, List<String>> layoutFieldSort = new HashMap<String, List<String>>(2);
        ArrayList<String> sortList = new ArrayList<String>();
        ArrayList<String> hideItems = new ArrayList<String>();
        if (rootControl instanceof FormRoot) {
            List<Control> items = ((FormRoot)rootControl).getItems();
            this.getSubItems(items, sortList, hideItems, false);
        }
        this.handleBillTypeOrLayout(hideItems);
        layoutFieldSort.put("sortList", sortList);
        layoutFieldSort.put("hideItems", hideItems);
        return layoutFieldSort;
    }

    private void handleBillTypeOrLayout(List<String> hideItems) {
        String str1;
        String str = this.getPageCache().get("fieldViByBillType");
        if (StringUtils.isNotBlank((CharSequence)str)) {
            Map fieldViByBillType = (Map)SerializationUtils.fromJsonString((String)str, Map.class);
            for (Map.Entry map : fieldViByBillType.entrySet()) {
                if (hideItems.contains(map.getKey()) || ((Boolean)map.getValue()).booleanValue()) continue;
                hideItems.add((String)map.getKey());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(str1 = this.getPageCache().get("fieldViByLayout")))) {
            Map fieldViByLayout = (Map)SerializationUtils.fromJsonString((String)str1, Map.class);
            for (Map.Entry map : fieldViByLayout.entrySet()) {
                if (hideItems.contains(map.getKey()) || ((Boolean)map.getValue()).booleanValue()) continue;
                hideItems.add((String)map.getKey());
            }
        }
    }

    private void getSubItems(List<Control> items, List<String> sortList, List<String> hideItems, boolean isHide) {
        if (!items.isEmpty()) {
            for (Control item : items) {
                String itemKey = item.getKey();
                if (item.isInvisible() || item.isDesignHidden() || this.isHide(item) || isHide) {
                    if (item instanceof Container) {
                        this.getSubItems(((Container)item).getItems(), sortList, hideItems, true);
                    } else {
                        hideItems.add(itemKey);
                        continue;
                    }
                }
                if (item instanceof EntryGrid) {
                    List<Map<String, String>> initField;
                    List<Control> entryGridItems = ((Container)item).getItems();
                    boolean isShowConfig = ((EntryGrid)item).isShowGridConfig();
                    if (isShowConfig) {
                        GridConfigDAO gridConfigDAO = new GridConfigDAO();
                        List gridConfigByDB = gridConfigDAO.getGridConfig(this.getFormShowParameter().getFormId(), itemKey);
                        ArrayList<GridConfigurationRow> flexGridConfig = new ArrayList<GridConfigurationRow>(10);
                        List<GridConfigurationRow> gridConfigByMeta = GridConfigRenderUtils.getFieldApInfo(this, this.getFormShowParameter().getFormId(), itemKey);
                        List<GridConfigurationRow> configurationRows = AbstractFormView.combineRuntimeMeta(gridConfigByMeta, gridConfigByDB, flexGridConfig);
                        if (!CollectionUtils.isEmpty(configurationRows)) {
                            this.getGridItems(entryGridItems, hideItems, false);
                            this.getSubConfig(configurationRows, sortList, hideItems, false);
                            continue;
                        }
                    }
                    if (!CollectionUtils.isEmpty(initField = ((EntryGrid)item).getInitField())) {
                        HashMap<String, String> resMap = new HashMap<String, String>(initField.size());
                        for (Map<String, String> map : initField) {
                            resMap.put(map.get("fieldkey"), map.get("isvisible"));
                        }
                        this.getEntrySubItems(resMap, entryGridItems, sortList, hideItems, false);
                        continue;
                    }
                    this.getSubItems(entryGridItems, sortList, hideItems, false);
                    continue;
                }
                if (item instanceof Container) {
                    this.getSubItems(((Container)item).getItems(), sortList, hideItems, false);
                    continue;
                }
                sortList.add(itemKey);
            }
        }
    }

    private void getEntrySubItems(Map<String, String> resMap, List<Control> items, List<String> sortList, List<String> hideItems, boolean isHide) {
        if (!items.isEmpty()) {
            for (Control item : items) {
                boolean isInitField;
                String itemKey = item.getKey();
                boolean bl = isInitField = resMap.containsKey(itemKey) && !Boolean.parseBoolean(resMap.get(itemKey));
                if (item.isInvisible() || item.isDesignHidden() || this.isHide(item) || isHide || isInitField) {
                    if (item instanceof Container) {
                        this.getEntrySubItems(resMap, ((Container)item).getItems(), sortList, hideItems, true);
                    } else {
                        hideItems.add(itemKey);
                        continue;
                    }
                }
                if (item instanceof Container) {
                    this.getEntrySubItems(resMap, ((Container)item).getItems(), sortList, hideItems, false);
                    continue;
                }
                sortList.add(itemKey);
            }
        }
    }

    private void getGridItems(List<Control> items, List<String> hideItems, boolean isHide) {
        if (!items.isEmpty()) {
            for (Control item : items) {
                String itemKey = item.getKey();
                if (!item.isInvisible() && !item.isDesignHidden() && !this.isHide(item) && !isHide) continue;
                if (item instanceof Container) {
                    this.getGridItems(((Container)item).getItems(), hideItems, true);
                    continue;
                }
                hideItems.add(itemKey);
            }
        }
    }

    private void getSubConfig(List<GridConfigurationRow> gridConfigurationRows, List<String> sortList, List<String> hideItems, boolean isHide) {
        if (!CollectionUtils.isEmpty(gridConfigurationRows)) {
            for (GridConfigurationRow row : gridConfigurationRows) {
                List children = row.getChildren();
                if (row.isHide() || isHide) {
                    if (!CollectionUtils.isEmpty((Collection)children)) {
                        this.getSubConfig(children, sortList, hideItems, true);
                    } else {
                        hideItems.add(row.getFieldKey());
                        continue;
                    }
                }
                if (!CollectionUtils.isEmpty((Collection)children)) {
                    this.getSubConfig(children, sortList, hideItems, false);
                    continue;
                }
                sortList.add(row.getFieldKey());
            }
        }
    }

    private static List<GridConfigurationRow> combineRuntimeMeta(List<GridConfigurationRow> metaGridConfig, List<GridConfigurationRow> userGridConfig, List<GridConfigurationRow> flexGridConfig) {
        if (CollectionUtils.isEmpty(metaGridConfig)) {
            return metaGridConfig;
        }
        Map colsMetaMap = metaGridConfig.stream().collect(Collectors.toMap(GridConfigurationRow::getFieldKey, Function.identity(), (o, o2) -> o, LinkedHashMap::new));
        if (CollectionUtils.isEmpty(userGridConfig)) {
            for (GridConfigurationRow row : colsMetaMap.values()) {
                if (!(row instanceof FlexGridConfigRow)) continue;
                flexGridConfig.add(row);
            }
            return metaGridConfig;
        }
        ArrayList<GridConfigurationRow> newMeta = new ArrayList<GridConfigurationRow>(metaGridConfig.size());
        for (GridConfigurationRow userConfig : userGridConfig) {
            String fieldKey = userConfig.getFieldKey();
            GridConfigurationRow colMeta = (GridConfigurationRow)colsMetaMap.get(fieldKey);
            if (colMeta == null) continue;
            userConfig.setFieldName(colMeta.getFieldName());
            newMeta.add(userConfig);
            List children = colMeta.getChildren();
            userConfig.setChildren(AbstractFormView.combineRuntimeMeta(children, userConfig.getChildren(), flexGridConfig));
            if (colMeta instanceof FlexGridConfigRow) {
                FlexGridConfigRow flexRow = new FlexGridConfigRow();
                flexRow.copy(colMeta);
                flexRow.setDefaultSplit(((FlexGridConfigRow)colMeta).isDefaultSplit());
                flexRow.setFlexSplit(userConfig.getFlexSplit());
                List userChildren = userConfig.getChildren();
                if (!userChildren.isEmpty()) {
                    ArrayList<GridConfigurationRow> flexRowChildren = new ArrayList<GridConfigurationRow>(userChildren.size());
                    for (GridConfigurationRow userRow : userChildren) {
                        GridConfigurationRow flexChildRow = new GridConfigurationRow();
                        flexChildRow.copy(userRow);
                        flexRowChildren.add(flexChildRow);
                    }
                    flexRow.setChildren(flexRowChildren);
                }
                flexGridConfig.add((GridConfigurationRow)flexRow);
            }
            colsMetaMap.remove(fieldKey);
        }
        for (GridConfigurationRow row : colsMetaMap.values()) {
            if (row instanceof FlexGridConfigRow) {
                flexGridConfig.add(row);
            }
            newMeta.add(row);
        }
        return newMeta;
    }

    private boolean isHide(Control item) {
        int statusVal;
        Integer visibleValue = item.getVisibleIntegerVal();
        if (visibleValue == null) {
            visibleValue = 63;
        }
        if ((visibleValue & 8) != 8) {
            return true;
        }
        boolean isHide = false;
        FormShowParameter formShowParameter = this.getFormShowParameter();
        int n = statusVal = formShowParameter instanceof BillShowParameter ? ((BillShowParameter)formShowParameter).getBillStatus().getValue() : formShowParameter.getStatus().getValue();
        if (statusVal == 0 && (visibleValue & 1) != 1 || statusVal == 1 && (visibleValue & 2) != 2 || statusVal == 2 && (visibleValue & 4) != 4 || statusVal == 4 && (visibleValue & 0x10) != 16 || statusVal == 5 && (visibleValue & 0x20) != 32) {
            isHide = true;
        }
        return isHide;
    }

    @Override
    @KSMethod
    public void showOperationResult(OperationResult operationResult, String operateName) {
        List errorInfos = operationResult.getAllErrorOrValidateInfo();
        this.showOperationAllFieldLoc(operationResult);
        int size = errorInfos.size() + operationResult.getSuccessPkIds().size();
        if (size > 1) {
            this.showOperationResultMulti(operationResult, operateName);
        } else if (!errorInfos.isEmpty()) {
            OperateErrorInfo errorInfo = (OperateErrorInfo)errorInfos.get(0);
            String errorCode = errorInfo.getErrorCode();
            String msg = errorInfo.getMessage() == null ? "" : errorInfo.getMessage();
            String errMsg = this.sortErrMsg(operationResult, errorInfo);
            boolean atttimeoutError = ValidataErrorCode.AttTimeout.getCode().equals(errorInfo.getErrorCode());
            if (atttimeoutError) {
                this.showConfirm(errorInfo.getMessage(), MessageBoxOptions.OK);
            } else if (msg.length() > 40 && this.getFormShowParameter().getOpenStyle().getShowType() == ShowType.Modal && !"datamutex".equals(errorCode)) {
                this.showMessage(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25", (String)"AbstractFormView_0", (String)BOS_FORM_METADATA, (Object[])new Object[0]), errorInfo.getMessage(), MessageTypes.Default);
            } else if (errorInfo.getLevel() == ErrorLevel.Warning || errorInfo.getLevel() == ErrorLevel.Error) {
                this.showTipNotification(errMsg, this.getDuration());
            } else {
                this.showErrorNotification(errMsg);
            }
        } else if (!operationResult.isSuccess()) {
            String msg;
            String string = msg = operationResult.getMessage() == null ? "" : operationResult.getMessage();
            if (msg.length() > 40 && this.getFormShowParameter().getOpenStyle().getShowType() == ShowType.Modal) {
                this.showMessage(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25", (String)"AbstractFormView_0", (String)BOS_FORM_METADATA, (Object[])new Object[0]), operationResult.getMessage(), MessageTypes.Default);
            } else {
                this.showErrorNotification(operationResult.getMessage());
            }
        } else {
            this.showSuccessNotification(operationResult.getMessage(), 3000);
        }
    }

    private String sortErrMsg(OperationResult operationResult, OperateErrorInfo errorInfo) {
        String errMsg = errorInfo.getMessage();
        boolean isGrpUnique = false;
        GroupFieldsUniqueValidateResult validateResult = null;
        List validateErrors = operationResult.getValidateResult().getValidateErrors();
        for (ValidateResult validateError : validateErrors) {
            if (!(validateError instanceof GroupFieldsUniqueValidateResult)) continue;
            validateResult = (GroupFieldsUniqueValidateResult)validateError;
            isGrpUnique = true;
            break;
        }
        if (isGrpUnique) {
            List fieldKeys = validateResult.getFieldKeys();
            errMsg = this.getGrpUniqueMsg(fieldKeys, errorInfo);
        }
        return errMsg;
    }

    private String getGrpUniqueMsg(List<String> fieldKeys, OperateErrorInfo errorInfo) {
        String errMsg = errorInfo.getMessage();
        String patternStr = errorInfo.getPattern();
        if (StringUtils.isBlank((CharSequence)patternStr)) {
            return errMsg;
        }
        MainEntityType dataEntityType = this.getModel().getDataEntityType();
        Map<String, List<String>> layoutFieldSort = this.getLayoutFieldSort();
        if (layoutFieldSort != null && !layoutFieldSort.isEmpty()) {
            List<String> sortList = layoutFieldSort.get("sortList");
            List<String> hideItems = layoutFieldSort.get("hideItems");
            ArrayList<String> hideFieldKeys = new ArrayList<String>(fieldKeys.size());
            String[] arrFieldKey = new String[fieldKeys.size()];
            int[] arrIndex = new int[fieldKeys.size()];
            int n = 0;
            block0: for (String fieldkey : fieldKeys) {
                if (hideItems.contains(fieldkey)) {
                    hideFieldKeys.add(fieldkey);
                    continue;
                }
                for (int j = 0; j < sortList.size(); ++j) {
                    if (!sortList.get(j).equals(fieldkey)) continue;
                    arrFieldKey[m] = fieldkey;
                    arrIndex[m] = j;
                    for (int m = n; m > 0 && arrIndex[m] < arrIndex[m - 1]; --m) {
                        String temp = arrFieldKey[m];
                        int index = arrIndex[m];
                        arrFieldKey[m] = arrFieldKey[m - 1];
                        arrIndex[m] = arrIndex[m - 1];
                        arrFieldKey[m - 1] = temp;
                        arrIndex[m - 1] = index;
                    }
                    ++n;
                    continue block0;
                }
            }
            if (arrFieldKey.length > 0) {
                for (String it : arrFieldKey) {
                    if (it != null) continue;
                    return errMsg;
                }
            }
            List sortFieldKeys = Arrays.stream(arrFieldKey).collect(Collectors.toList());
            sortFieldKeys.addAll(hideFieldKeys);
            sortFieldKeys.removeAll(Collections.singleton(null));
            ArrayList<String> names = new ArrayList<String>(sortFieldKeys.size());
            for (String fieldKey : sortFieldKeys) {
                String name2 = dataEntityType.findProperty(fieldKey).getDisplayName().toString();
                names.add(name2);
            }
            String joincharacter = ResManager.loadKDString((String)"\u3001", (String)"AbstractFormView_7", (String)BOS_FORM_METADATA, (Object[])new Object[0]);
            String fldNames = names.stream().map(name -> String.format(ResManager.loadKDString((String)"\u201c%s\u201d", (String)"AbstractFormView_6", (String)BOS_FORM_METADATA, (Object[])new Object[0]), name)).collect(Collectors.joining(joincharacter));
            errMsg = String.format(patternStr, fldNames);
        }
        return errMsg;
    }

    private List<FieldPos> fieldsSort(OperationResult operationResult, List<FieldPos> fieldPos) {
        ArrayList<FieldPos> finalFieldPos = new ArrayList<FieldPos>();
        if (fieldPos.size() <= 1) {
            return fieldPos;
        }
        Map<String, List<String>> layoutFieldSort = this.getLayoutFieldSort();
        if (!CollectionUtils.isEmpty(layoutFieldSort)) {
            List<String> sortList = layoutFieldSort.get("sortList");
            List<String> hideItems = layoutFieldSort.get("hideItems");
            ArrayList<FieldPos> hideFieldPos = new ArrayList<FieldPos>(fieldPos.size());
            FieldPos[] arrField = new FieldPos[fieldPos.size()];
            int[] arrIndex = new int[fieldPos.size()];
            int n = 0;
            block0: for (FieldPos pos : fieldPos) {
                if (pos == null) continue;
                String fieldkey = pos.getF();
                if (hideItems.contains(fieldkey)) {
                    hideFieldPos.add(pos);
                    continue;
                }
                for (int i = 0; i < sortList.size(); ++i) {
                    if (!sortList.get(i).equals(fieldkey)) continue;
                    arrField[m] = pos;
                    arrIndex[m] = i;
                    for (int m = n; m > 0 && arrIndex[m] < arrIndex[m - 1]; --m) {
                        FieldPos temp = arrField[m];
                        int index = arrIndex[m];
                        arrField[m] = arrField[m - 1];
                        arrIndex[m] = arrIndex[m - 1];
                        arrField[m - 1] = temp;
                        arrIndex[m - 1] = index;
                    }
                    ++n;
                    continue block0;
                }
            }
            List sortFieldPos = Arrays.stream(arrField).collect(Collectors.toList());
            LinkedHashMap entryEntityMap = new LinkedHashMap();
            for (FieldPos fieldPos2 : sortFieldPos) {
                int row;
                ArrayList<FieldPos> rowPos;
                if (fieldPos2 == null) continue;
                boolean isHead = fieldPos2.isH();
                if (isHead) {
                    finalFieldPos.add(fieldPos2);
                    continue;
                }
                String entryKey = fieldPos2.getEk();
                if (!StringUtils.isNotBlank((CharSequence)entryKey)) continue;
                HashMap<Integer, ArrayList<FieldPos>> entityPos = (HashMap<Integer, ArrayList<FieldPos>>)entryEntityMap.get(entryKey);
                if (entityPos == null) {
                    entityPos = new HashMap<Integer, ArrayList<FieldPos>>();
                }
                if ((rowPos = (ArrayList<FieldPos>)entityPos.get(row = fieldPos2.getR())) == null) {
                    rowPos = new ArrayList<FieldPos>();
                }
                rowPos.add(fieldPos2);
                entityPos.put(row, rowPos);
                entryEntityMap.put(entryKey, entityPos);
            }
            for (Map.Entry entry : entryEntityMap.entrySet()) {
                Map rowPos = (Map)entry.getValue();
                for (Map.Entry pos : rowPos.entrySet()) {
                    finalFieldPos.addAll((Collection)pos.getValue());
                }
            }
            finalFieldPos.addAll(hideFieldPos);
            finalFieldPos.removeAll(Collections.singleton(null));
        }
        return finalFieldPos;
    }

    protected Integer getDuration() {
        int duration = 3000;
        String formId = "";
        formId = this instanceof IListView ? ((IListView)((Object)this)).getBillFormId() : this.getEntityId();
        if (StringUtils.isNotBlank((CharSequence)formId)) {
            try {
                Map<String, Object> sysParam = this.loadDevpotalParam();
                Object durationConfig = sysParam.get(SHOW_TIP_DURATION);
                if (durationConfig instanceof Integer) {
                    duration = (Integer)durationConfig * 1000;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return duration;
    }

    private Map<String, Object> loadDevpotalParam() {
        AppParam param = new AppParam();
        param.setAppId(DevAppId);
        param.setViewType("15");
        param.setOrgId(Long.valueOf(((IParameterHelperService)ServiceSvcFactory.getService(IParameterHelperService.class)).getParamRootOrgId()));
        return ParameterReader.loadSystemParameterFromCache((AppParam)param);
    }

    public void showOperationResultPage(OperationResult operationResult, String operateName) {
        this.showOperationResultMulti(operationResult, operateName);
    }

    protected void showOperationResultMulti(OperationResult operationResult, String operateName) {
        Map billNos;
        String billNo;
        this.errorInfoConvertToFormName(operationResult);
        List errorOrValidateInfos = operationResult.getAllErrorOrValidateInfo();
        FormShowParameter parameters = new FormShowParameter();
        parameters.getOpenStyle().setShowType(ShowType.Modal);
        parameters.setFormId("bos_operationresult");
        parameters.setShowTitle(false);
        parameters.setCustomParam("operateName", operateName);
        HashMap<Object, Object> pkNumbers = new HashMap();
        if (operationResult.getSuccessPkIds() != null && !operationResult.getSuccessPkIds().isEmpty()) {
            if (!operationResult.getBillNos().isEmpty()) {
                pkNumbers.putAll(operationResult.getBillNos());
            } else {
                pkNumbers = this.getNumberById(operationResult.getSuccessPkIds());
            }
        }
        parameters.setCustomParam("pkNumbers", pkNumbers);
        IPageCache pageCache = (IPageCache)this.getService(IPageCache.class);
        DataEntitySerializerOption option = new DataEntitySerializerOption();
        option.setIncludeComplexProperty(true);
        String serialResult = DataEntitySerializer.serializerToString((Object)operationResult, (DataEntitySerializerOption)option);
        pageCache.put("operationresult", serialResult);
        List<String> tipList = this.sortErrorMsg(operationResult, errorOrValidateInfos);
        parameters.setCustomParam("hasMore", errorOrValidateInfos.size() > 5);
        parameters.setCustomParam("errorMsg", tipList);
        String message = operationResult.getMessage();
        if (StringUtils.isNotBlank((CharSequence)message) && operationResult.getMessageType() == 1) {
            parameters.setCustomParam("message", operationResult.getMessage());
        }
        int billCount = operationResult.getBillCount();
        int successCount = operationResult.getSuccessPkIds().size();
        int validError = billCount - successCount;
        String title = operationResult.getBillCount() == 1 && !operationResult.getBillNos().isEmpty() ? (StringUtils.isEmpty((CharSequence)(billNo = (String)(billNos = operationResult.getBillNos()).values().iterator().next())) ? String.format(ResManager.loadKDString((String)"\u672c\u5355%1$s\u5931\u8d25", (String)"AbstractFormView_1", (String)BOS_FORM_METADATA, (Object[])new Object[0]), StringUtils.isBlank((CharSequence)operateName) ? "" : operateName) : (validError > 0 ? String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d%2$s\u5931\u8d25", (String)"AbstractFormView_2", (String)BOS_FORM_METADATA, (Object[])new Object[0]), billNo, StringUtils.isBlank((CharSequence)operateName) ? "" : operateName) : String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d%2$s\u6210\u529f", (String)"AbstractFormView_3", (String)BOS_FORM_METADATA, (Object[])new Object[0]), billNo, StringUtils.isBlank((CharSequence)operateName) ? "" : operateName))) : (validError > 0 ? String.format(ResManager.loadKDString((String)"\u5171%1$s\u6761\u5355\u636e\uff0c%2$s\u6210\u529f%3$s\u6761\uff0c\u5931\u8d25%4$s\u6761", (String)"AbstractFormView_4", (String)BOS_FORM_METADATA, (Object[])new Object[0]), billCount, StringUtils.isBlank((CharSequence)operateName) ? "" : operateName, successCount, validError) : String.format(ResManager.loadKDString((String)"\u5171%1$s\u6761\u5355\u636e\uff0c%2$s\u6210\u529f%3$s\u6761", (String)"AbstractFormView_5", (String)BOS_FORM_METADATA, (Object[])new Object[0]), billCount, StringUtils.isBlank((CharSequence)operateName) ? "" : operateName, successCount));
        parameters.setCustomParam("title", title);
        this.showForm(parameters);
    }

    private List<String> sortErrorMsg(OperationResult operationResult, List<IOperateInfo> errorOrValidateInfos) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"AbstractFormView.sortErrorMsg");){
            boolean showOpResultFieldLoc;
            ArrayList<String> tipList = new ArrayList<String>();
            ArrayList<Object> sortTips = new ArrayList<Object>();
            List promptField = operationResult.getPromptField();
            boolean bl = showOpResultFieldLoc = this.needShowOpResultFieldLoc() && SystemPropertyUtils.getBooleanExt((String)RequestContext.get().getTenantId(), (String)"showvalidatetip", (Boolean)true) != false;
            if (promptField != null && !promptField.isEmpty() && showOpResultFieldLoc) {
                int i;
                LinkedHashSet<String> tips = new LinkedHashSet<String>(promptField.size());
                for (FieldPos pos : promptField) {
                    tips.add(pos.getFullMsg());
                }
                List validateErrors = operationResult.getValidateResult().getValidateErrors();
                HashMap<String, String> grpTipMap = new HashMap<String, String>();
                for (ValidateResult validateError : validateErrors) {
                    if (!(validateError instanceof GroupFieldsUniqueValidateResult)) continue;
                    List allErrorInfo = validateError.getAllErrorInfo();
                    List fieldKeys = ((GroupFieldsUniqueValidateResult)validateError).getFieldKeys();
                    for (OperateErrorInfo operateErrorInfo : allErrorInfo) {
                        String grpUniqueMsg = this.getGrpUniqueMsg(fieldKeys, operateErrorInfo);
                        grpTipMap.put(operateErrorInfo.getMessage(), grpUniqueMsg);
                    }
                }
                sortTips = new ArrayList(tips);
                if (!CollectionUtils.isEmpty(grpTipMap)) {
                    for (int i2 = 0; i2 < sortTips.size(); ++i2) {
                        String tip = (String)sortTips.get(i2);
                        if (grpTipMap.get(tip) == null) continue;
                        sortTips.set(i2, grpTipMap.get(tip));
                    }
                    for (String value : grpTipMap.values()) {
                        if (sortTips.contains(value)) continue;
                        sortTips.add(value);
                    }
                }
                int len = errorOrValidateInfos.size();
                for (i = 0; i < 5 && i < len; ++i) {
                    IOperateInfo errorInfo = errorOrValidateInfos.get(i);
                    String message = errorInfo.getMessage();
                    if (grpTipMap.containsKey(message) || sortTips.contains(message)) continue;
                    sortTips.add(message);
                }
                if (span.isRealtime()) {
                    span.addLocaleTag("tips", tips);
                    span.addLocaleTag("grpTipMap", grpTipMap);
                    span.addLocaleTag("sortTips", sortTips);
                }
                len = sortTips.size();
                for (i = 0; i < 5 && i < len; ++i) {
                    tipList.add((String)sortTips.get(i));
                }
            } else {
                int len = errorOrValidateInfos.size();
                for (int i = 0; i < 5 && i < len; ++i) {
                    IOperateInfo errorInfo = errorOrValidateInfos.get(i);
                    tipList.add(errorInfo.getMessage());
                }
            }
            tipList.removeAll(Collections.singleton(null));
            if (span.isRealtime()) {
                span.addLocaleTag("errorOrValidateInfos", errorOrValidateInfos);
                span.addLocaleTag("operationResult", (Object)operationResult);
                span.addLocaleTag("tipList", tipList);
            }
            ArrayList<String> arrayList = tipList;
            return arrayList;
        }
    }

    protected HashMap<Object, Object> getNumberById(List<Object> pkIds) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (Object key : pkIds) {
            map.put(key, key);
        }
        return map;
    }

    @Override
    @KSMethod
    public void openUrl(String url) {
        this.getClientProxy().addAction("openUrl", url);
    }

    @Override
    @KSMethod
    public void download(String url) {
        this.getClientProxy().addAction("download", url);
    }

    @Override
    @KSMethod
    public void setVisible(Boolean value, String ... ctlKeys) {
        ArrayList<String> list = new ArrayList<String>();
        for (String ctlKey : ctlKeys) {
            Object ctl = this.getControl(ctlKey);
            if (ctl instanceof FieldEdit) {
                if (((FieldEdit)ctl).getProperty().getParent() instanceof EntryType) {
                    ((FieldEdit)ctl).setVisible("", value);
                    continue;
                }
                list.add(ctlKey);
                continue;
            }
            list.add(ctlKey);
        }
        if (!list.isEmpty()) {
            HashMap<String, Object> visableMap = new HashMap<String, Object>();
            visableMap.put("policy", "");
            visableMap.put("visible", value);
            visableMap.put("keys", list.toArray());
            this.getClientProxy().addAction("setVisible", visableMap);
        }
    }

    @Override
    @KSMethod
    public void setEnable(Boolean value, String ... ctlKeys) {
        HashMap<String, Object> enableMap = new HashMap<String, Object>();
        enableMap.put("policy", "");
        enableMap.put("enable", value);
        enableMap.put("keys", ctlKeys);
        this.getClientProxy().addAction("setEnable", enableMap);
    }

    @Override
    @KSMethod
    public void setEnable(Boolean value, int rowIndex, String ... ctlKeys) {
        for (String ctlKey : ctlKeys) {
            Object ctl = this.getControl(ctlKey);
            if (!(ctl instanceof FieldEdit) || !(((FieldEdit)ctl).getProperty().getParent() instanceof EntryType)) continue;
            ((FieldEdit)ctl).setEnable("", value, rowIndex);
        }
    }

    @Override
    @KSMethod
    public void showFieldTip(FieldTip tip) {
        ArrayList<FieldTip> tips = new ArrayList<FieldTip>();
        tips.add(tip);
        this.showFieldTips(tips);
    }

    @Override
    @KSMethod
    public void showFieldTips(List<FieldTip> tips) {
        if (tips != null && !tips.isEmpty()) {
            List tipsList = SerializationUtils.fromJsonStringToList((String)SerializationUtils.toJsonString(tips), Map.class);
            this.getClientProxy().addAction("showFieldTips", tipsList);
        }
    }

    @Override
    @KSMethod
    public void showFormValidMsg(FieldPos fieldPosition) {
        ArrayList<FieldPos> fieldPositionList = new ArrayList<FieldPos>();
        fieldPositionList.add(fieldPosition);
        this.showFormValidMsg(fieldPositionList);
    }

    @Override
    @KSMethod
    public void showFormValidMsg(List<FieldPos> fieldPositions) {
        if (fieldPositions != null && !fieldPositions.isEmpty()) {
            ArrayList<Map> formValidMsgList = new ArrayList<Map>(fieldPositions.size());
            for (FieldPos fieldPos : fieldPositions) {
                formValidMsgList.add(fieldPos.buildActionData());
            }
            this.getClientProxy().addAction("showFormValidMsg", formValidMsgList);
        }
    }

    @KSMethod
    public void showConfirm(String msg, String options) {
        this.showConfirm(msg, MessageBoxOptions.valueOf(options));
    }

    @Override
    public void showConfirm(String msg, MessageBoxOptions options) {
        this.showConfirm(msg, options, null);
    }

    @KSMethod
    public void showConfirm(String msg, String options, ConfirmCallBackListener callBack) {
        this.showConfirm(msg, MessageBoxOptions.valueOf(options), callBack);
    }

    @Override
    public void showConfirm(String msg, MessageBoxOptions options, ConfirmCallBackListener callBack) {
        this.showConfirm(msg, options, null, callBack);
    }

    @Override
    public void showConfirm(String msg, MessageBoxOptions options, ConfirmTypes confirmTypes, ConfirmCallBackListener callBack) {
        this.showConfirm(msg, (String)null, options, confirmTypes, callBack);
    }

    @Override
    public void showConfirm(String msg, String detail, MessageBoxOptions options, ConfirmTypes confirmTypes, ConfirmCallBackListener callBack) {
        this.showConfirm(msg, detail, options, confirmTypes, callBack, null);
    }

    @Override
    public void showConfirm(String msg, String detail, MessageBoxOptions options, ConfirmTypes confirmTypes, ConfirmCallBackListener callBack, Map<Integer, String> btnNameMaps) {
        this.showConfirm(msg, detail, options, confirmTypes, callBack, btnNameMaps, "");
    }

    @Override
    public void showConfirm(String msg, String detail, MessageBoxOptions options, ConfirmTypes confirmTypes, ConfirmCallBackListener callBack, Map<Integer, String> btnNameMaps, String customValue) {
        this.showConfirm("", msg, detail, options, confirmTypes, callBack, btnNameMaps, customValue);
    }

    @Override
    public void showConfirm(String title, String msg, MessageBoxOptions options) {
        this.showConfirm(title, msg, null, options, null, null, null, "");
    }

    @Override
    public void showConfirm(String title, String msg, String detail, MessageBoxOptions options, ConfirmTypes confirmTypes, ConfirmCallBackListener callBack, Map<Integer, String> btnNameMaps, String customValue) {
        Map postMap;
        HashMap<String, Object> jo = new HashMap<String, Object>();
        if (callBack != null) {
            jo.put("id", callBack.getCallBackId());
            IPageCache cache = (IPageCache)this.getService(IPageCache.class);
            cache.put(CONFIRMCALLBACKLISTENER + callBack.getCallBackId(), SerializationUtils.toJsonString((Object)callBack));
        }
        if (title != null && title.contains("\"msgcode\":") && title.contains("\"msg\":")) {
            postMap = (Map)SerializationUtils.fromJsonString((String)title, Map.class);
            title = (String)postMap.get("msg");
        }
        if (msg != null && msg.contains("\"msgcode\":") && msg.contains("\"msg\":")) {
            postMap = (Map)SerializationUtils.fromJsonString((String)msg, Map.class);
            msg = (String)postMap.get("msg");
        }
        if (detail != null && detail.contains("\"msgcode\":") && detail.contains("\"msg\":")) {
            postMap = (Map)SerializationUtils.fromJsonString((String)detail, Map.class);
            detail = (String)postMap.get("msg");
        }
        jo.put("confirmType", confirmTypes == null ? ConfirmTypes.Default.getValue() : confirmTypes.getValue());
        jo.put("msg", this.convertToFormName(msg));
        if (detail != null) {
            jo.put("detail", this.convertToFormName(detail));
        }
        jo.put("button_type", options == null ? MessageBoxOptions.None.getValue() : options.getValue());
        if (btnNameMaps != null && btnNameMaps.size() > 0) {
            jo.put("btn_names", btnNameMaps);
        }
        jo.put("callbackValue", customValue);
        if (StringUtils.isNotBlank((CharSequence)title)) {
            jo.put("title", title);
        }
        this.getClientProxy().addAction("showConfirm", jo);
    }

    @Override
    public void showConfirm(String tempMsg, List<MessageBoxLink> msglinks, MessageBoxOptions options, ConfirmTypes confirmTypes, ConfirmCallBackListener callBack) {
        this.showConfirm(tempMsg, msglinks, options, confirmTypes, callBack, null);
    }

    @Override
    public void showConfirm(String tempMsg, List<MessageBoxLink> msglinks, MessageBoxOptions options, ConfirmTypes confirmTypes, ConfirmCallBackListener callBack, Map<Integer, String> btnNameMaps) {
        HashMap<String, Object> jo = new HashMap<String, Object>();
        HashMap<String, Object> msgObj = new HashMap<String, Object>();
        if (tempMsg != null && tempMsg.contains("\"msgcode\":") && tempMsg.contains("\"msg\":")) {
            Map postMap = (Map)SerializationUtils.fromJsonString((String)tempMsg, Map.class);
            tempMsg = (String)postMap.get("msg");
        }
        msgObj.put("temp", this.convertToFormName(tempMsg));
        msgObj.put(ARGS, msglinks);
        if (callBack != null) {
            jo.put("id", callBack.getCallBackId());
            IPageCache cache = (IPageCache)this.getService(IPageCache.class);
            cache.put(CONFIRMCALLBACKLISTENER + callBack.getCallBackId(), SerializationUtils.toJsonString((Object)callBack));
        }
        jo.put("confirmType", confirmTypes == null ? ConfirmTypes.Default.getValue() : confirmTypes.getValue());
        jo.put("msg", msgObj);
        jo.put("button_type", options == null ? MessageBoxOptions.None.getValue() : options.getValue());
        if (btnNameMaps != null && btnNameMaps.size() > 0) {
            jo.put("btn_names", btnNameMaps);
        }
        this.getClientProxy().addAction("showConfirm", jo);
    }

    @Override
    @KSMethod
    public void showTopConfirm(String title, String msg, MessageBoxOptions options) {
        this.showTopConfirm(title, msg, null, options, null, null, null, null);
    }

    @Override
    @KSMethod
    public void showTopConfirm(String title, String msg, String detail, MessageBoxOptions options, ConfirmTypes confirmTypes, ConfirmCallBackListener callBack, Map<Integer, String> btnNameMaps, String customValue) {
        Map postMap;
        HashMap<String, Object> jo = new HashMap<String, Object>();
        if (callBack != null) {
            jo.put("id", callBack.getCallBackId());
            IPageCache cache = (IPageCache)this.getService(IPageCache.class);
            cache.put(CONFIRMCALLBACKLISTENER + callBack.getCallBackId(), SerializationUtils.toJsonString((Object)callBack));
        }
        if (title != null && title.contains("\"msgcode\":") && title.contains("\"msg\":")) {
            postMap = (Map)SerializationUtils.fromJsonString((String)title, Map.class);
            title = (String)postMap.get("msg");
        }
        if (msg != null && msg.contains("\"msgcode\":") && msg.contains("\"msg\":")) {
            postMap = (Map)SerializationUtils.fromJsonString((String)msg, Map.class);
            msg = (String)postMap.get("msg");
        }
        if (detail != null && detail.contains("\"msgcode\":") && detail.contains("\"msg\":")) {
            postMap = (Map)SerializationUtils.fromJsonString((String)detail, Map.class);
            detail = (String)postMap.get("msg");
        }
        jo.put("confirmType", confirmTypes == null ? ConfirmTypes.Default.getValue() : confirmTypes.getValue());
        jo.put("msg", this.convertToFormName(msg));
        if (detail != null) {
            jo.put("detail", this.convertToFormName(detail));
        }
        jo.put("button_type", options == null ? MessageBoxOptions.Minimize.getValue() : options.getValue());
        if (btnNameMaps != null && btnNameMaps.size() > 0) {
            jo.put("btn_names", btnNameMaps);
        }
        jo.put("callbackValue", customValue);
        if (StringUtils.isNotBlank((CharSequence)title)) {
            jo.put("title", title);
        }
        this.getClientProxy().addAction("showGlobalConfirm", jo);
    }

    @Override
    @KSMethod
    public void updateUIMetadatas(Map<String, Object> ctls) {
        this.getClientProxy().addAction("updateUIMetadatas", ctls);
    }

    @Override
    @KSMethod
    public void updateControlMetadata(String key, Map<String, Object> ctl) {
        ArrayList<Object> paras = new ArrayList<Object>(2);
        paras.add(key);
        paras.add(ctl);
        this.getClientProxy().addAction("updateControlMetadata", paras);
    }

    @KSMethod
    private void showNotification(String msg, Integer duration, int type) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        Integer tempDuration = duration;
        if (tempDuration == null) {
            tempDuration = 3500;
        }
        if (msg != null && msg.contains("\"msgcode\":") && msg.contains("\"msg\":")) {
            Map postMap = (Map)SerializationUtils.fromJsonString((String)msg, Map.class);
            String msgcode = (String)postMap.get("msgcode");
            msg = (String)postMap.get("msg");
            String tenantId = RequestContext.get().getTenantId();
            String tipsOn = SystemPropertyUtils.getProptyByTenant((String)"bos.hottips.on", (String)tenantId);
            if (type == 1 && !"FALSE".equalsIgnoreCase(tipsOn)) {
                param.put("msgcode", msgcode);
                param.put("href", postMap.get("href"));
            }
        }
        param.put(CONTENT, msg == null ? "" : this.convertToFormName(msg));
        param.put("type", type);
        param.put(DURATION, tempDuration);
        this.getClientProxy().addNotificationMsg(param);
    }

    @KSMethod
    private void showNotification(String msg, Integer duration, int type, List<MessageBoxLink> msglinks, ConfirmCallBackListener callBack) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        Integer tempDuration = duration;
        if (tempDuration == null) {
            tempDuration = 3500;
        }
        if (msg != null && msg.contains("\"msgcode\":") && msg.contains("\"msg\":")) {
            Map postMap = (Map)SerializationUtils.fromJsonString((String)msg, Map.class);
            String msgcode = (String)postMap.get("msgcode");
            msg = (String)postMap.get("msg");
            String tenantId = RequestContext.get().getTenantId();
            String tipsOn = SystemPropertyUtils.getProptyByTenant((String)"bos.hottips.on", (String)tenantId);
            if (type == 1 && !"FALSE".equalsIgnoreCase(tipsOn)) {
                param.put("msgcode", msgcode);
                param.put("href", postMap.get("href"));
            }
        }
        param.put(CONTENT, msg == null ? "" : this.convertToFormName(msg));
        param.put("type", type);
        param.put(DURATION, tempDuration);
        if (callBack != null && msglinks != null && !msglinks.isEmpty()) {
            param.put(ARGS, msglinks);
            param.put("hasLink", true);
            param.put("id", callBack.getCallBackId());
            IPageCache cache = (IPageCache)this.getService(IPageCache.class);
            cache.put(CONFIRMCALLBACKLISTENER + callBack.getCallBackId(), SerializationUtils.toJsonString((Object)callBack));
        }
        this.getClientProxy().addAction("ShowNotificationMsg", param);
    }

    @Override
    @KSMethod
    public void showSuccessNotification(String msg, Integer duration) {
        this.showNotification(msg, duration, 0);
    }

    @Override
    @KSMethod
    public void showSuccessNotification(String msg, Integer duration, List<MessageBoxLink> msglinks, ConfirmCallBackListener callBack) {
        this.showNotification(msg, duration, 0, msglinks, callBack);
    }

    @Override
    @KSMethod
    public void showSuccessNotification(String msg) {
        this.showNotification(msg, 2000, 0);
    }

    @Override
    @KSMethod
    public void showSuccessNotification(String msg, List<MessageBoxLink> msglinks, ConfirmCallBackListener callBack) {
        this.showNotification(msg, 2000, 0, msglinks, callBack);
    }

    @Override
    @KSMethod
    public void showErrorNotification(String msg) {
        this.showNotification(msg, null, 1);
    }

    @Override
    @KSMethod
    public void showErrorNotification(String msg, List<MessageBoxLink> msglinks, ConfirmCallBackListener callBack) {
        this.showNotification(msg, null, 1, msglinks, callBack);
    }

    @Override
    @KSMethod
    public void showRobotMessage(String msg) {
        this.showRobotMessage(msg, 0);
    }

    @Override
    @KSMethod
    public void showRobotMessage(String msg, int duration) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        if (msg != null && msg.contains("\"msgcode\":") && msg.contains("\"msg\":")) {
            Map postMap = (Map)SerializationUtils.fromJsonString((String)msg, Map.class);
            msg = (String)postMap.get("msg");
        }
        param.put(CONTENT, msg);
        if (duration > 0) {
            param.put(DURATION, duration);
        }
        this.getClientProxy().addAction("showRobotMessage", param);
    }

    @Override
    @KSMethod
    public void closeRobotMessage() {
        this.getClientProxy().addAction("closeRobotMessage", new HashMap());
    }

    @Override
    @KSMethod
    public void showTipNotification(String msg) {
        this.showNotification(msg, null, 2);
    }

    @Override
    @KSMethod
    public void showTipNotification(String msg, List<MessageBoxLink> msglinks, ConfirmCallBackListener callBack) {
        this.showNotification(msg, null, 2, msglinks, callBack);
    }

    @Override
    @KSMethod
    public void showTipNotification(String msg, Integer duration) {
        this.showNotification(msg, duration, 2);
    }

    @Override
    @KSMethod
    public void showTipNotification(String msg, Integer duration, List<MessageBoxLink> msglinks, ConfirmCallBackListener callBack) {
        this.showNotification(msg, duration, 2, msglinks, callBack);
    }

    @Override
    @KSMethod
    public void previewAttachment(Map<String, Object> fileInfo) {
        if (fileInfo != null && fileInfo.size() > 0) {
            this.getClientProxy().addAction("previewAttachment", fileInfo);
        }
    }

    @Override
    @KSMethod
    public void addClientCallBack(String callBackName) {
        this.addClientCallBack(callBackName, 0);
    }

    @Override
    @KSMethod
    public void addClientCallBack(String callBackName, Integer duration) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("name", callBackName);
        param.put(DURATION, duration);
        this.getClientProxy().addAction("addClientCallBack", param);
    }

    @Override
    @KSMethod
    public void showLoading(LocaleString msg) {
        this.showLoading(msg, 0);
    }

    @Override
    @KSMethod
    public void showProgressLoading(LocaleString msg, int progress) {
        this.loading(msg, true, LoadingType.Progress, progress, 0, true);
    }

    @Override
    @KSMethod
    public void showLoading(LocaleString msg, int closeDuration) {
        this.showLoading(msg, closeDuration, true);
    }

    @Override
    @KSMethod
    public void showLoading(LocaleString msg, int closeDuration, boolean async) {
        this.loading(msg, true, LoadingType.Default, 0, closeDuration, async);
    }

    @Override
    @KSMethod
    public void hideLoading() {
        this.hideLoading(true);
    }

    @Override
    @KSMethod
    public void hideLoading(boolean async) {
        this.loading(null, false, LoadingType.Default, 0, 0, async);
    }

    private void loading(LocaleString msg, boolean visiable, LoadingType type, int progress, int duration, boolean async) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        ArrayList paraList = new ArrayList();
        HashMap<String, Object> paraMap = new HashMap<String, Object>();
        if (msg != null) {
            paraMap.put("text", msg.toString());
        }
        if (type == null) {
            paraMap.put("type", LoadingType.Default.getType());
        } else {
            paraMap.put("type", type.getType());
            if (LoadingType.Progress.getType().equals(type.getType())) {
                paraMap.put("progress", progress);
            }
        }
        if (duration != 0) {
            paraMap.put(DURATION, duration);
        }
        paraMap.put("visible", visiable);
        paraMap.put("pageId", this.getPageId());
        paraList.add(paraMap);
        data.put("p", paraList);
        data.put("a", "setPageLoading");
        ArrayList<HashMap<String, Object>> result = new ArrayList<HashMap<String, Object>>();
        result.add(data);
        if (async) {
            MsgSendFactory.getSender().send(this.getFormShowParameter().getRootPageId(), SerializationUtils.toJsonString(result));
        } else {
            ArrayList<Object> actions = new ArrayList<Object>(1);
            actions.addAll(result);
            this.sendFormAction(this.getFormShowParameter().getRootPageId(), actions);
        }
    }

    @Override
    @KSMethod
    public void setFormTitle(LocaleString title) {
        HashMap<String, Object> paraMap = new HashMap<String, Object>();
        ArrayList<HashMap<String, Object>> paraList = new ArrayList<HashMap<String, Object>>();
        if (title == null) {
            paraMap.put("formTitle", title);
        } else {
            paraMap.put("formTitle", title.toString());
        }
        paraList.add(paraMap);
        this.getClientProxy().addAction("setFormTitle", paraList);
    }

    private void errorInfoConvertToFormName(OperationResult result) {
        if (result != null && result.getValidateResult() != null && result.getValidateResult().getValidateErrors() != null) {
            for (ValidateResult res : result.getValidateResult().getValidateErrors()) {
                List errorInfos = res.getAllErrorInfo();
                if (!kd.bos.util.CollectionUtils.isNotEmpty((Collection)errorInfos)) continue;
                for (OperateErrorInfo info : errorInfos) {
                    info.setMessage(this.convertToFormName(info.getMessage()));
                }
            }
            result.setMessage(this.convertToFormName(result.getMessage()));
        }
    }

    private String convertToFormName(String msg) {
        return msg;
    }

    private String getLockMsg(String msg, Map<String, String> placeholderMap, Map<String, String> entityFormNameMap) {
        if (!CollectionUtils.isEmpty(entityFormNameMap)) {
            for (Map.Entry<String, String> map : entityFormNameMap.entrySet()) {
                if (msg.indexOf(map.getKey()) <= -1) continue;
                String placeholder = this.getPlaceholder(placeholderMap.size(), true);
                if (msg.indexOf(placeholder) > -1) {
                    placeholder = this.getPlaceholder(placeholderMap.size(), false);
                }
                msg = msg.replaceAll(map.getKey(), placeholder);
                placeholderMap.put(placeholder, map.getValue());
            }
        }
        return msg;
    }

    private Map<String, String> getEntityFormNameMap() {
        TreeMap<String, String> entityFormNameMap = new TreeMap<String, String>(new Comparator<String>(){

            @Override
            public int compare(String str1, String str2) {
                if (StringUtils.isEmpty((CharSequence)str1)) {
                    str1 = "";
                }
                if (StringUtils.isEmpty((CharSequence)str2)) {
                    str2 = "";
                }
                if (str1.length() > str2.length()) {
                    return -1;
                }
                if (str1.length() < str2.length()) {
                    return 1;
                }
                return str1.compareTo(str2);
            }
        });
        boolean existDiff = false;
        HashSet<String> entityFormKeySet = new HashSet<String>(10);
        for (Map.Entry<String, Control> map : this.cacheControls.entrySet()) {
            String entityName;
            String formName;
            IDataEntityProperty property;
            Control control = map.getValue();
            if (!(control instanceof FieldEdit) || (property = this.getModel().getProperty(((FieldEdit)control).getFieldKey())) == null || StringUtils.isEmpty((CharSequence)(formName = ((FieldEdit)control).getDisplayName() == null ? "" : ((FieldEdit)control).getDisplayName().toString()))) continue;
            String string = entityName = property.getDisplayName() == null ? "" : property.getDisplayName().toString();
            if (control instanceof BasedataPropEdit) {
                entityName = formName;
            }
            if (StringUtils.isEmpty((CharSequence)entityName)) continue;
            if (!formName.equals(entityName)) {
                existDiff = true;
            }
            entityFormNameMap.put(entityName, formName);
            entityFormKeySet.add(property.getName());
        }
        if (existDiff && !CollectionUtils.isEmpty(entityFormKeySet)) {
            Map allEntityFields = this.getModel().getDataEntityType().getAllFields();
            for (Map.Entry obj : allEntityFields.entrySet()) {
                String entityName;
                if (entityFormKeySet.contains(obj.getKey())) continue;
                String string = entityName = ((IDataEntityProperty)obj.getValue()).getDisplayName() == null ? "" : ((IDataEntityProperty)obj.getValue()).getDisplayName().toString();
                if (StringUtils.isEmpty((CharSequence)entityName)) continue;
                entityFormNameMap.put(entityName, entityName);
            }
        }
        return existDiff ? entityFormNameMap : null;
    }

    private String getPlaceholder(int num, boolean isdefault) {
        String reg = "__" + num + "%%";
        if (!isdefault) {
            reg = "!!" + num + "@@";
        }
        return reg;
    }

    public void showOperationAllFieldLoc(OperationResult operationResult) {
        if (!this.needShowOpResultFieldLoc() || !SystemPropertyUtils.getBooleanExt((String)RequestContext.get().getTenantId(), (String)"showvalidatetip", (Boolean)true).booleanValue()) {
            return;
        }
        List promptFieldPositions = operationResult.getPromptField();
        if (promptFieldPositions == null || promptFieldPositions.isEmpty()) {
            return;
        }
        boolean isHasBinderMap = this.getFormShowParameter().getFormConfig().isHasBinderMap();
        HashSet<FieldPos> clientDatas = new HashSet<FieldPos>(promptFieldPositions.size());
        BinderMap binderMap = null;
        if (isHasBinderMap) {
            binderMap = FormMetadataCache.getBinderMap(this.getFormShowParameter().getFormId());
        }
        for (FieldPos pos : promptFieldPositions) {
            List<String> sf;
            if (StringUtils.isBlank((CharSequence)pos.getF())) continue;
            Object control = this.getControl(pos.getF());
            if (control instanceof FieldEdit && StringUtils.equalsIgnoreCase((CharSequence)((FieldEdit)control).getFieldKey(), (CharSequence)pos.getF())) {
                clientDatas.add(FieldPos.copy((FieldPos)pos));
            }
            if (binderMap == null || (sf = binderMap.getMap().get(pos.getF().toLowerCase())) == null || sf.isEmpty()) continue;
            for (String ctlKey : sf) {
                Object refCtl;
                if (StringUtils.isBlank((CharSequence)ctlKey) || !((refCtl = this.getControl(ctlKey)) instanceof FieldEdit) || ((FieldEdit)refCtl).getProperty() == null || !StringUtils.equalsIgnoreCase((CharSequence)((FieldEdit)refCtl).getProperty().getName(), (CharSequence)pos.getF())) continue;
                FieldPos data = FieldPos.copy((FieldPos)pos);
                data.setF(((Control)refCtl).getKey());
                clientDatas.add(data);
            }
        }
        if (!clientDatas.isEmpty()) {
            List<FieldPos> fieldPos = this.fieldsSort(operationResult, new ArrayList<FieldPos>(clientDatas));
            operationResult.setPromptField(fieldPos);
            this.showFormValidMsg(fieldPos);
        }
    }

    protected boolean needShowOpResultFieldLoc() {
        return false;
    }
}

