/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.card.ICardPlugin;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.ComplexPropertyAttribute;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.plugin.DynamicScriptPlugin;
import kd.bos.entity.plugin.Plugin;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.ShowType;
import kd.bos.form.container.FormRoot;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.license.api.ICoreLicenseService;
import kd.bos.script.ProjectInitializerManager;
import kd.bos.script.ScriptExecutor;
import kd.bos.script.ScriptInfo;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.script.util.SimpleScriptInfo;
import kd.bos.service.ServiceFactory;
import kd.sdk.annotation.SdkPublic;
import kd.sdk.kingscript.mixture.MixtureFactory;
import kd.sdk.kingscript.mixture.MixtureProxy;
import kd.sdk.kingscript.mixture.PluginMixtureProxy;

@KSObject
@SdkPublic
public class FormConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private LocaleString caption;
    private List<Plugin> plugins = new ArrayList<Plugin>();
    private String version;
    private String bosver;
    private String entityTypeId;
    private LocaleString width;
    private LocaleString height;
    private String modelType;
    private boolean showTitle = true;
    private boolean customForm;
    private boolean hasBinderMap;
    private int hdFieldCount;
    private int ruleCount;
    private boolean tabLayout;
    private boolean is_ShowWidget;
    private ShowType showType = ShowType.forValue(7);
    private String appId;
    private String bizAppNumber;
    private boolean is_QingView;
    private String userGuide;
    private boolean allowDoubleClick;
    private Map<String, Object> menu;
    private static final String ENV_SCRIPT = "/FormPlugin.js";
    private String envScript;
    private ScriptExecutor scriptExecutor;
    private static final String SCRIPTNUMBER = "scriptnumber";
    private static final String SCRIPTTYPE = "scripttype";
    private FormRoot formRoot;
    private String fieldHashCode;
    private String kdEncoding = "base64";
    private String listFormId = "bos_list";
    private String f7ListFormId = "bos_listf7";
    private String listUserOption;
    private ShowType viewShowType = ShowType.forValue(7);
    private String listOpenLayoutBill;

    @SimplePropertyAttribute
    @KSMethod
    public String getKdEncoding() {
        return this.kdEncoding;
    }

    public void setKdEncoding(String kdEncoding) {
        this.kdEncoding = kdEncoding;
    }

    @SimplePropertyAttribute
    @KSMethod
    public String getBOSVer() {
        return this.bosver;
    }

    public void setBOSVer(String bosver) {
        this.bosver = bosver;
    }

    private void getjs() {
        try (InputStream in = FormConfig.class.getResourceAsStream(ENV_SCRIPT);){
            this.envScript = FormConfig.getContent(in);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getContent(InputStream in) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(in, "UTF-8"));
        String line = null;
        StringBuilder sb = new StringBuilder();
        while ((line = br.readLine()) != null) {
            sb.append(line);
            sb.append("\n");
        }
        in.close();
        return sb.toString();
    }

    @SimplePropertyAttribute
    @KSMethod
    public final ShowType getShowType() {
        return this.showType;
    }

    public final void setShowType(ShowType value) {
        this.showType = value;
    }

    @SimplePropertyAttribute
    @KSMethod
    public final ShowType getViewShowType() {
        return this.viewShowType;
    }

    public final void setViewShowType(ShowType viewShowType) {
        this.viewShowType = viewShowType;
    }

    @SimplePropertyAttribute
    @KSMethod
    public LocaleString getCaption() {
        return this.caption;
    }

    public void setCaption(LocaleString caption) {
        this.caption = caption;
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=Plugin.class)
    public List<Plugin> getPlugins() {
        return this.plugins;
    }

    public void setPlugins(List<Plugin> plugins) {
        this.plugins = plugins;
    }

    public void setPlugin(Plugin plugin) {
        if (!this.plugins.contains(plugin)) {
            this.plugins.add(plugin);
        }
    }

    @SimplePropertyAttribute
    @KSMethod
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @SimplePropertyAttribute
    @KSMethod
    public String getEntityTypeId() {
        return this.entityTypeId;
    }

    public void setEntityTypeId(String entityTypeId) {
        this.entityTypeId = entityTypeId;
    }

    public List<IFormPlugin> createPlugin(Class<?> scriptPluginClass, String formId) {
        try (EntityTraceSpan span = EntityTracer.create((String)"plugin", (String)"createPlugin");){
            ArrayList<Object> formPlugins = new ArrayList<Object>();
            int modeType = this.getProductModeType();
            String proEnable = System.getProperty("sys.productmodelsetting.enable", "true");
            if (span.isRealtime()) {
                span.addLocaleTag("modeType", (Object)("" + modeType));
                span.addLocaleTag("sys.productmodelsetting.enable", (Object)proEnable);
            }
            if (Boolean.parseBoolean(proEnable) && this.isUltimateMode()) {
                formPlugins.add(TypesContainer.createInstance((String)"kd.bos.form.product.ProductControlPlugin"));
                span.addLocaleTag("plugin" + formPlugins.size(), (Object)"kd.bos.form.product.ProductControlPlugin");
            }
            if (this.plugins != null) {
                for (Plugin ins : this.plugins) {
                    IFormPlugin splugin;
                    HashMap<String, FormConfig> tags;
                    if (0 == ins.getType()) {
                        try {
                            formPlugins.add((IFormPlugin)TypesContainer.createInstance((String)ins.getClassName()));
                            span.addLocaleTag("plugin" + formPlugins.size(), (Object)ins.getClassName());
                            continue;
                        }
                        catch (Exception e) {
                            tags = new HashMap<String, FormConfig>(1);
                            tags.put("formConfig", this);
                            EntityTracer.throwException((String)"FormConfig", (String)"createPlugin", null, (Throwable)e, tags);
                            ErrorCode errorCode = new ErrorCode("bos.createPluginError", e.getMessage());
                            throw new KDException(errorCode, e.getMessage(), (Throwable)e);
                        }
                    }
                    if (1 == ins.getType()) {
                        try {
                            splugin = null;
                            if (ins instanceof DynamicScriptPlugin) {
                                DynamicScriptPlugin scriptIns = (DynamicScriptPlugin)ins;
                                splugin = this.createScriptPlugin(formId, scriptIns.getScriptNumber(), scriptIns.getScript());
                            } else {
                                splugin = this.createScriptPlugin(formId, ins.getClassName());
                            }
                            if (splugin == null) continue;
                            splugin.setPluginName(ins.getClassName());
                            formPlugins.add(splugin);
                            span.addLocaleTag("plugin" + formPlugins.size(), (Object)ins.getClassName());
                            continue;
                        }
                        catch (Exception e) {
                            tags = new HashMap(1);
                            tags.put("formConfig", this);
                            EntityTracer.throwException((String)"FormConfig", (String)"createPlugin", null, (Throwable)e, tags);
                            throw e;
                        }
                    }
                    if (4 != ins.getType() || !Plugin.enableRunKingScript()) continue;
                    try {
                        splugin = (IFormPlugin)MixtureFactory.createMixtureProxy((MixtureProxy)new PluginMixtureProxy(ins.getClassName(), scriptPath -> ProjectInitializerManager.getEngineAutoDebug(scriptPath)));
                        if (splugin != null) {
                            formPlugins.add(splugin);
                        }
                        span.addLocaleTag("plugin" + formPlugins.size(), (Object)ins.getClassName());
                    }
                    catch (Exception e) {
                        tags = new HashMap(1);
                        tags.put("formConfig", this);
                        EntityTracer.throwException((String)"FormConfig", (String)"createPlugin", null, (Throwable)e, tags);
                        ErrorCode errorCode = new ErrorCode("bos.createPluginError", e.getMessage());
                        throw new KDException(errorCode, e.getMessage(), (Throwable)e);
                    }
                }
            }
            ArrayList<Object> arrayList = formPlugins;
            return arrayList;
        }
    }

    private boolean isUltimateMode() {
        int modeType = this.getProductModeType();
        return modeType == 2 || modeType == 4;
    }

    private int getProductModeType() {
        ICoreLicenseService licService = (ICoreLicenseService)ServiceFactory.getService(ICoreLicenseService.class);
        return licService.getModeType();
    }

    public List<ICardPlugin> createCardPlugin(String formId) {
        ArrayList<ICardPlugin> formPlugins = new ArrayList<ICardPlugin>();
        if (this.plugins != null) {
            for (Plugin ins : this.plugins) {
                if (0 == ins.getType()) {
                    formPlugins.add((ICardPlugin)TypesContainer.createInstance((String)ins.getClassName()));
                    continue;
                }
                if (1 != ins.getType()) continue;
                try {
                    ICardPlugin splugin = null;
                    if (ins instanceof DynamicScriptPlugin) {
                        DynamicScriptPlugin scriptIns = (DynamicScriptPlugin)ins;
                        splugin = (ICardPlugin)((Object)this.createScriptPlugin(formId, scriptIns.getScriptNumber(), scriptIns.getScript()));
                    } else {
                        splugin = (ICardPlugin)this.innerCreateScriptPlugin(formId, ins.getClassName());
                    }
                    if (splugin == null) continue;
                    formPlugins.add(splugin);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return formPlugins;
    }

    public synchronized IFormPlugin createScriptPlugin(String formId, String classname) {
        return (IFormPlugin)this.innerCreateScriptPlugin(classname);
    }

    public synchronized IFormPlugin createScriptPlugin(String formId, String classname, String scriptContent) {
        return (IFormPlugin)this.innerCreateScriptPlugin(classname, scriptContent);
    }

    private Object innerCreateScriptPlugin(String classname) {
        if (StringUtils.isBlank((CharSequence)classname)) {
            return null;
        }
        Map<String, String> scritpInfo = this.getScriptInfo(classname);
        if (scritpInfo == null) {
            return null;
        }
        String scriptContent = scritpInfo.get("scriptcontext");
        String scriptNumber = scritpInfo.get(SCRIPTNUMBER);
        String scriptType = scritpInfo.get(SCRIPTTYPE);
        this.getjs();
        if (this.scriptExecutor == null) {
            this.scriptExecutor = ScriptExecutor.getOrCreate();
            this.scriptExecutor.init(ctx -> ctx.require(new String[]{"/ScriptModule.conf"}));
            this.scriptExecutor.begin();
        }
        if ("6".equals(scriptType)) {
            this.scriptExecutor.exec(new String[]{scriptContent});
            return null;
        }
        this.scriptExecutor.exec(new ScriptInfo[]{new SimpleScriptInfo(ENV_SCRIPT, this.envScript, false), new SimpleScriptInfo(scriptNumber, scriptContent, true)});
        return this.scriptExecutor.getContext().get("plugin");
    }

    private Object innerCreateScriptPlugin(String classname, String scriptContent) {
        if (StringUtils.isBlank((CharSequence)classname)) {
            return null;
        }
        Map<String, String> scritpInfo = this.getScriptInfo(classname);
        if (scritpInfo == null) {
            return null;
        }
        String scriptNumber = scritpInfo.get(SCRIPTNUMBER);
        String scriptType = scritpInfo.get(SCRIPTTYPE);
        this.getjs();
        if (this.scriptExecutor == null) {
            this.scriptExecutor = ScriptExecutor.getOrCreate();
            this.scriptExecutor.init(ctx -> ctx.require(new String[]{"/ScriptModule.conf"}));
            this.scriptExecutor.begin();
        }
        if ("6".equals(scriptType)) {
            this.scriptExecutor.exec(new String[]{scriptContent});
            return null;
        }
        this.scriptExecutor.exec(new ScriptInfo[]{new SimpleScriptInfo(ENV_SCRIPT, this.envScript, false), new SimpleScriptInfo(scriptNumber, scriptContent, true)});
        return this.scriptExecutor.getContext().get("plugin");
    }

    private Map<String, String> getScriptInfo(String classname) {
        HashMap<String, String> map;
        block15: {
            map = new HashMap<String, String>();
            String sql = "select fscriptnumber,fscriptcontext_tag,fscripttype from t_meta_pluginscript where fclassname = ?";
            Object[] params = new Object[]{classname};
            try (DataSet ds = DB.queryDataSet((String)"FormConfig.t_meta_pluginscript.getScriptInfo", (DBRoute)DBRoute.meta, (String)sql, (Object[])params);){
                Iterator iter = ds.iterator();
                if (iter.hasNext()) {
                    Row row = (Row)iter.next();
                    map.put(SCRIPTNUMBER, row.getString("fscriptnumber"));
                    map.put(SCRIPTTYPE, row.getString("fscripttype"));
                    map.put("scriptcontext", row.getString("fscriptcontext_tag"));
                    break block15;
                }
                Map<String, String> map2 = null;
                return map2;
            }
        }
        return map;
    }

    public void destory() {
        if (this.scriptExecutor != null) {
            this.scriptExecutor.end();
        }
    }

    @SimplePropertyAttribute
    @KSMethod
    public LocaleString getWidth() {
        return this.width;
    }

    public void setWidth(LocaleString width) {
        this.width = width;
    }

    @SimplePropertyAttribute
    @KSMethod
    public LocaleString getHeight() {
        return this.height;
    }

    public void setHeight(LocaleString height) {
        this.height = height;
    }

    @SimplePropertyAttribute
    @KSMethod
    public String getModelType() {
        return this.modelType;
    }

    public void setModelType(String modelType) {
        this.modelType = modelType;
    }

    @SimplePropertyAttribute(name="ShowTitle")
    @DefaultValueAttribute(value="true")
    @KSMethod
    public boolean isShowTitle() {
        return this.showTitle;
    }

    public void setShowTitle(boolean showTitle) {
        this.showTitle = showTitle;
    }

    @SimplePropertyAttribute(name="AllowDoubleClick")
    public boolean isAllowDoubleClick() {
        return this.allowDoubleClick;
    }

    public void setAllowDoubleClick(boolean allowDoubleClick) {
        this.allowDoubleClick = allowDoubleClick;
    }

    public Map<String, Object> getMenu() {
        return this.menu;
    }

    public void setMenu(Map<String, Object> menu) {
        this.menu = menu;
    }

    @SimplePropertyAttribute
    public String getListOpenLayoutBill() {
        return this.listOpenLayoutBill;
    }

    public void setListOpenLayoutBill(String listOpenLayoutBill) {
        this.listOpenLayoutBill = listOpenLayoutBill;
    }

    @SimplePropertyAttribute(name="CustomForm")
    public boolean isCustomForm() {
        return this.customForm;
    }

    public void setCustomForm(boolean customForm) {
        this.customForm = customForm;
    }

    @SimplePropertyAttribute(name="ShowWidget")
    @KSMethod
    public boolean isShowWidget() {
        return this.is_ShowWidget;
    }

    public void setShowWidget(boolean isShowWidget) {
        this.is_ShowWidget = isShowWidget;
    }

    @SimplePropertyAttribute(name="HasBinderMap")
    public boolean isHasBinderMap() {
        return this.hasBinderMap;
    }

    public void setHasBinderMap(boolean hasBinderMap) {
        this.hasBinderMap = hasBinderMap;
    }

    @SimplePropertyAttribute(name="RuleCount")
    public int getRuleCount() {
        return this.ruleCount;
    }

    public void setRuleCount(int value) {
        this.ruleCount = value;
    }

    @SimplePropertyAttribute(name="TabLayout")
    public boolean isTabLayout() {
        return this.tabLayout;
    }

    public void setTabLayout(boolean tabLayout) {
        this.tabLayout = tabLayout;
    }

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="bos_list")
    public String getListFormId() {
        return this.listFormId;
    }

    public void setListFormId(String listFormId) {
        this.listFormId = listFormId;
    }

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="bos_listf7")
    public String getF7ListFormId() {
        return this.f7ListFormId;
    }

    public void setF7ListFormId(String f7listFormId) {
        this.f7ListFormId = f7listFormId;
    }

    @SimplePropertyAttribute(name="QingView")
    public boolean isQingView() {
        return this.is_QingView;
    }

    public void setQingView(boolean isQingView) {
        this.is_QingView = isQingView;
    }

    @SimplePropertyAttribute
    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    @SimplePropertyAttribute
    public String getBizAppNumber() {
        return this.bizAppNumber;
    }

    public void setBizAppNumber(String bizAppNumber) {
        this.bizAppNumber = bizAppNumber;
    }

    @SimplePropertyAttribute
    public String getListUserOption() {
        return this.listUserOption;
    }

    public void setListUserOption(String listUserOption) {
        this.listUserOption = listUserOption;
    }

    @SimplePropertyAttribute
    public String getUserGuide() {
        return this.userGuide;
    }

    public void setUserGuide(String userGuide) {
        this.userGuide = userGuide;
    }

    @ComplexPropertyAttribute
    public FormRoot getFormRoot() {
        return this.formRoot;
    }

    public void setFormRoot(FormRoot formRoot) {
        this.formRoot = formRoot;
    }

    @SimplePropertyAttribute
    public int getHDFieldCount() {
        return this.hdFieldCount;
    }

    public void setHDFieldCount(int hdFieldCount) {
        this.hdFieldCount = hdFieldCount;
    }

    @SimplePropertyAttribute
    public String getFieldHashCode() {
        return this.fieldHashCode;
    }

    public void setFieldHashCode(String fieldHashCode) {
        this.fieldHashCode = fieldHashCode;
    }
}

