/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageType;
import kd.bos.form.SimpleBaseData;

public class MessageProxy {
    List<Map<String, Object>> noticeMessageListMap = new ArrayList<Map<String, Object>>();
    List<Map<String, Object>> warningMessageListMap = new ArrayList<Map<String, Object>>();
    List<Map<String, Object>> errorMessageListMap = new ArrayList<Map<String, Object>>();
    List<Map<String, Object>> confirmMessageListMap = new ArrayList<Map<String, Object>>();
    IFormView formView;
    IClientViewProxy viewProxy;
    private static final String TITLE = "title";
    private static final String OPTION = "option";
    private static final String ID = "id";
    private static final String MSG = "msg";

    public MessageProxy(IFormView formView) {
        this.formView = formView;
        this.viewProxy = (IClientViewProxy)this.formView.getService(IClientViewProxy.class);
    }

    public void showNotice(String titile, Object message) {
        this.addNotice(null, titile, message);
        this.viewProxy.addAction(MessageType.Notice.toString(), this.noticeMessageListMap);
    }

    public void addNotice(String titile, Object message) {
        this.addNotice(null, titile, message);
    }

    public void addNotice(Object id, String titile, Object message) {
        HashMap<String, Object> noticeMessageMap = new HashMap<String, Object>();
        noticeMessageMap.put(ID, id == null ? Uuid16.create().toString() : id);
        noticeMessageMap.put(TITLE, titile);
        noticeMessageMap.put(MSG, message);
        noticeMessageMap.put(OPTION, (Object)MessageBoxOptions.None);
        this.noticeMessageListMap.add(noticeMessageMap);
    }

    public void showWarning(String titile, Object message, ErrorLevel errorLevel) {
        this.addWarning(titile, message, errorLevel);
        this.viewProxy.addAction(MessageType.Advise.toString(), this.warningMessageListMap);
    }

    public void addWarning(String titile, Object message, ErrorLevel errorLevel) {
        this.addWarning(null, titile, message, errorLevel);
    }

    public void addWarning(Object id, String titile, Object message, ErrorLevel errorLevel) {
        HashMap<String, Object> warningMessageMap = new HashMap<String, Object>();
        warningMessageMap.put(ID, id == null ? Uuid16.create().toString() : id);
        warningMessageMap.put(TITLE, titile);
        warningMessageMap.put(MSG, message);
        warningMessageMap.put(OPTION, (Object)MessageBoxOptions.None);
        warningMessageMap.put("msgType", errorLevel);
        this.warningMessageListMap.add(warningMessageMap);
    }

    public void showError(String titile, Object message) {
        this.addError(titile, message);
        this.viewProxy.addAction(MessageType.Error.toString(), this.errorMessageListMap);
    }

    public void addError(String titile, Object message) {
        this.addError(null, titile, message);
    }

    public void addError(Object id, String titile, Object message) {
        HashMap<String, Object> errorMessageMap = new HashMap<String, Object>();
        errorMessageMap.put("errorTitle", titile);
        errorMessageMap.put("errorInfo", message);
        errorMessageMap.put(OPTION, (Object)MessageBoxOptions.None);
        this.errorMessageListMap.add(errorMessageMap);
    }

    public void showConfirm(String titile, Object message, MessageBoxOptions messageBoxOptions) {
        this.addConfirm(titile, message, messageBoxOptions);
        this.viewProxy.addAction(MessageType.Confirm.toString(), this.confirmMessageListMap);
    }

    public void addConfirm(String titile, Object message, MessageBoxOptions messageBoxOptions) {
        HashMap<String, Object> confirmMessageMap = new HashMap<String, Object>();
        confirmMessageMap.put(TITLE, titile);
        confirmMessageMap.put(MSG, message);
        confirmMessageMap.put(OPTION, (Object)messageBoxOptions);
        this.confirmMessageListMap.add(confirmMessageMap);
    }

    public void sendToAction() {
        if (!this.noticeMessageListMap.isEmpty()) {
            this.viewProxy.addAction("ShowNotificationMsg", this.noticeMessageListMap);
        }
        if (!this.warningMessageListMap.isEmpty()) {
            this.viewProxy.addAction("ShowWarnningMsg", this.warningMessageListMap);
        }
        if (!this.errorMessageListMap.isEmpty()) {
            this.viewProxy.addAction("showErrMsg", this.errorMessageListMap);
        }
        if (!this.confirmMessageListMap.isEmpty()) {
            this.viewProxy.addAction("showConfirm", this.confirmMessageListMap);
        }
    }

    public static void sendBaseDataSetValueActionForMob(String key, String fieldKey, String fieldName, BasedataEntityType entityType, ListSelectedRowCollection rows, IFormView formView, int clientType, int rowIndex, String clientMethodName) {
        MessageProxy.sendBaseBaseSetValueActionInner(key, fieldKey, fieldName, entityType, rows, formView, clientType, rowIndex, clientMethodName, true);
    }

    public static void sendBaseDataSetValueAction(String key, String fieldKey, String fieldName, BasedataEntityType entityType, ListSelectedRowCollection rows, IFormView formView, int clientType, int rowIndex, String clientMethodName) {
        MessageProxy.sendBaseBaseSetValueActionInner(key, fieldKey, fieldName, entityType, rows, formView, clientType, rowIndex, clientMethodName, false);
    }

    private static void sendBaseBaseSetValueActionInner(String key, String fieldKey, String fieldName, BasedataEntityType entityType, ListSelectedRowCollection rows, IFormView formView, int clientType, int rowIndex, String clientMethodName, boolean isMob) {
        IClientViewProxy viewProxy = (IClientViewProxy)formView.getService(IClientViewProxy.class);
        HashMap<String, Object> clientMeta = new HashMap<String, Object>();
        clientMeta.put("fieldName", fieldName);
        clientMeta.put("clientType", clientType);
        clientMeta.put("rowIndex", rowIndex);
        if (!isMob && "setCommonF7Value".equals(clientMethodName)) {
            List pkValues = Arrays.stream(rows.getPrimaryKeyValues()).map(Object::toString).collect(Collectors.toList());
            clientMeta.put("value", pkValues);
            clientMeta.put(ID, pkValues);
        } else {
            SimpleBaseData simpleBaseData = SimpleBaseData.loadSimpleBaseData(entityType, rows, fieldKey);
            clientMeta.put("value", simpleBaseData.getValues());
            clientMeta.put(ID, simpleBaseData.getIds());
        }
        viewProxy.invokeControlMethod(key, clientMethodName, clientMeta);
    }

    private static List<Object> setNormalFieldValue(IDataEntityProperty property, BasedataEntityType entityType, List<String> pList, Map<Object, DynamicObject> mapObjects) {
        ArrayList<Object> values = new ArrayList<Object>();
        if (property != null) {
            for (DynamicObject entry : mapObjects.values()) {
                if (property.getParent() instanceof EntryType) {
                    DynamicObjectCollection dynamicObjectCollection = (DynamicObjectCollection)entry.get(property.getParent().getName());
                    for (DynamicObject dynamicObject : dynamicObjectCollection) {
                        if (!pList.contains(entry.getPkValue() + "_" + dynamicObject.getPkValue())) continue;
                        MessageProxy.setPropertyValue(property, values, dynamicObject);
                    }
                    continue;
                }
                MessageProxy.setPropertyValue(property, values, entry);
            }
        }
        return values;
    }

    private static void setPropertyValue(IDataEntityProperty property, List<Object> values, DynamicObject entry) {
        Object value = property.getValue((Object)entry);
        if (value != null) {
            values.add(value.toString());
        }
    }

    public static void sendRefBillSetValueAction(String key, String fieldKey, String fieldName, BillEntityType entityType, ListSelectedRowCollection rows, IFormView formView, int clientType, int rowIndex, String clientMethodName) {
        IClientViewProxy viewProxy = (IClientViewProxy)formView.getService(IClientViewProxy.class);
        ArrayList<Object> pkValues = new ArrayList<Object>();
        if (rows != null && !rows.isEmpty()) {
            for (ListSelectedRow row : rows) {
                pkValues.add(row.getPrimaryKeyValue());
            }
        }
        Map mapObjects = formView.getModel().loadReferenceDataBatch((DynamicObjectType)entityType, pkValues.toArray(new Object[0]));
        ArrayList<String> ids = new ArrayList<String>(10);
        for (DynamicObject entry : mapObjects.values()) {
            ids.add(entry.getPkValue().toString());
        }
        IDataEntityProperty property = entityType.findProperty(fieldKey);
        if (property == null) {
            property = entityType.getProperty(entityType.getBillNo());
        }
        ArrayList<Object> values = new ArrayList<Object>();
        if (property != null) {
            for (DynamicObject entry : mapObjects.values()) {
                MessageProxy.setPropertyValue(property, values, entry);
            }
        }
        HashMap<String, Object> clientMeta = new HashMap<String, Object>();
        clientMeta.put("fieldName", fieldName);
        clientMeta.put("clientType", clientType);
        clientMeta.put("rowIndex", rowIndex);
        if (values != null) {
            clientMeta.put("value", values);
        }
        if (ids != null) {
            clientMeta.put(ID, ids);
        }
        viewProxy.invokeControlMethod(key, clientMethodName, clientMeta);
    }

    public static void sendBaseDataSetValueAction(String key, String fieldName, IFormView formView, int clientType, int rowIndex, String clientMethodName, List<String> ids, List<Object> values) {
        IClientViewProxy viewProxy = (IClientViewProxy)formView.getService(IClientViewProxy.class);
        HashMap<String, Object> clientMeta = new HashMap<String, Object>();
        clientMeta.put("fieldName", fieldName);
        clientMeta.put("clientType", clientType);
        clientMeta.put("rowIndex", rowIndex);
        clientMeta.put("value", values);
        clientMeta.put(ID, ids);
        viewProxy.invokeControlMethod(key, clientMethodName, clientMeta);
    }
}

