/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.chart;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.form.chart.ChartType;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.chart.Label;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class Series {
    private static final String COLOR = "color";
    private static final String NORMAL = "normal";
    private static final String ITEMSTYLE = "itemStyle";
    private List<List<Object>> funcPaths = new ArrayList<List<Object>>();
    protected Map<String, Object> values = new HashMap<String, Object>();
    Label label;

    public String getName() {
        return (String)this.values.get("name");
    }

    public void setName(String name) {
        this.values.put("name", name);
    }

    public ChartType getType() {
        return ChartType.valueOf((String)this.values.get("type"));
    }

    public void setType(ChartType type) {
        this.values.put("type", type.name());
    }

    protected Object getPropValue(String propName) {
        return this.values.get(propName);
    }

    public void setPropValue(String propName, Object propValue) {
        this.values.put(propName, propValue);
    }

    public void setAnimationDuration(int duration) {
        this.values.put("animationDuration", duration);
    }

    public void setStack(String stack) {
        this.values.put("stack", stack);
    }

    public String getStack() {
        return (String)this.values.get("stack");
    }

    public List<Object> getData() {
        return (List)this.values.get("data");
    }

    public void setData(ItemValue[] data) {
        for (ItemValue item : data) {
            this.addData(item);
        }
    }

    public void addData(ItemValue value) {
        this.addData(value.getName(), value.getValue(), value.getColor());
    }

    public void addData(String name, Number value, String color) {
        List<Object> datas = this.getData();
        if (datas == null) {
            datas = new ArrayList<Object>();
            this.values.put("data", datas);
        }
        HashMap<String, Object> val = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)name)) {
            val.put("name", name);
        }
        val.put("value", value);
        if (!StringUtils.isEmpty((String)color)) {
            HashMap style = new HashMap();
            HashMap<String, String> normalMap = new HashMap<String, String>();
            normalMap.put(COLOR, color);
            style.put(NORMAL, normalMap);
            val.put(ITEMSTYLE, style);
        }
        datas.add(val);
    }

    public void setAreaColor(String color) {
        Map<String, Object> normal = this.getAreaNormalStyle();
        if (color == null) {
            normal.remove(COLOR);
        } else {
            normal.put(COLOR, color);
        }
    }

    public void setItemColor(String color) {
        Map<String, Object> normal = this.getItemNormalStyle();
        if (color == null) {
            normal.remove(COLOR);
        } else {
            normal.put(COLOR, color);
        }
    }

    public Map<String, Object> getItemNormalStyle() {
        HashMap normal;
        HashMap style = (HashMap)this.values.get(ITEMSTYLE);
        if (style == null) {
            style = new HashMap();
            this.values.put(ITEMSTYLE, style);
        }
        if ((normal = (HashMap)style.get(NORMAL)) == null) {
            normal = new HashMap();
            style.put(NORMAL, normal);
        }
        return normal;
    }

    public Map<String, Object> getAreaNormalStyle() {
        HashMap normal;
        HashMap style = (HashMap)this.values.get("areaStyle");
        if (style == null) {
            style = new HashMap();
            this.values.put("areaStyle", style);
        }
        if ((normal = (HashMap)style.get(NORMAL)) == null) {
            normal = new HashMap();
            style.put(NORMAL, normal);
        }
        return normal;
    }

    @SdkInternal
    public void addFuncPath(List<Object> path) {
        this.funcPaths.add(path);
    }

    @SdkInternal
    protected List<List<Object>> getFuncPaths() {
        return this.funcPaths;
    }

    protected Map<String, Object> getValues() {
        return this.values;
    }

    public String toString() {
        return this.values.toString();
    }

    public Label getLabel() {
        return this.label;
    }

    public void setLabel(Label label) {
        this.label = label;
        HashMap<String, Label> labelMap = new HashMap<String, Label>();
        labelMap.put(NORMAL, label);
        this.values.put("label", labelMap);
    }
}

