/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.container;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.container.Container;
import kd.bos.form.container.TabPage;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.TabBatchCloseEvent;
import kd.bos.form.control.events.TabBatchCloseListener;
import kd.bos.form.control.events.TabCloseEvent;
import kd.bos.form.control.events.TabCloseListener;
import kd.bos.form.control.events.TabOperationEvent;
import kd.bos.form.control.events.TabOperationListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public class Tab
extends Container {
    protected List<TabSelectListener> tabSelectListeners;
    private static final String TAB_ITEMS_TABPAGEKEYS = "_Tab_Items_TabPageKeys";
    private static final String SPAN_TYPE_PLUGIN = "plugin";
    protected List<ItemClickListener> barItemClickListeners = new ArrayList<ItemClickListener>();
    protected List<TabCloseListener> tabCloseListeners = new ArrayList<TabCloseListener>();
    protected List<TabBatchCloseListener> tabBatchCloseListeners = new ArrayList<TabBatchCloseListener>();
    protected List<TabOperationListener> tabReOpenListeners = new ArrayList<TabOperationListener>();

    @KSMethod
    public void addTabSelectListener(TabSelectListener listener) {
        if (this.tabSelectListeners == null) {
            this.tabSelectListeners = new ArrayList<TabSelectListener>();
        }
        this.tabSelectListeners.add(listener);
    }

    @KSMethod
    public void activeTab(String tabKey) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "activeTab", tabKey);
    }

    @KSMethod
    public void selectTab(String tabKey) {
        IPageCache cache = (IPageCache)this.getView().getService(IPageCache.class);
        cache.put("_Tab_Selected_" + this.getKey(), tabKey);
        IFormView formView = this.getView().getViewNoPlugin(tabKey);
        if (formView != null) {
            Set<String> tabPageKeys;
            String chcheString = cache.get(TAB_ITEMS_TABPAGEKEYS);
            Set set = tabPageKeys = StringUtils.isEmpty((CharSequence)chcheString) ? new HashSet() : (Set)SerializationUtils.fromJsonString((String)chcheString, HashSet.class);
            if (tabPageKeys == null) {
                tabPageKeys = new HashSet();
            }
            tabPageKeys.add(tabKey);
            cache.put(TAB_ITEMS_TABPAGEKEYS, SerializationUtils.toJsonString(tabPageKeys));
        }
        TabSelectEvent evt = new TabSelectEvent(this, tabKey);
        if (this.tabSelectListeners != null) {
            for (TabSelectListener l : this.tabSelectListeners) {
                EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(l.getClass().getName() + ".tabSelected"));
                Throwable throwable = null;
                try {
                    l.tabSelected(evt);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (span == null) continue;
                    if (throwable != null) {
                        try {
                            span.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    span.close();
                }
            }
        }
    }

    @Override
    @CollectionPropertyAttribute(collectionItemPropertyType=Control.class)
    @KSMethod
    public List<Control> getItems() {
        this.items = super.getItems();
        if (this.getView() == null) {
            return this.items;
        }
        IPageCache cache = (IPageCache)this.getView().getService(IPageCache.class);
        String casheString = cache.get(TAB_ITEMS_TABPAGEKEYS);
        if (StringUtils.isEmpty((CharSequence)casheString)) {
            return this.items;
        }
        Set tabPageKeys = (Set)SerializationUtils.fromJsonString((String)casheString, HashSet.class);
        if (tabPageKeys != null) {
            ArrayList<String> itemIds = new ArrayList<String>(10);
            for (Control item : this.items) {
                itemIds.add(item.getKey());
            }
            Iterator iterator = tabPageKeys.iterator();
            while (iterator.hasNext()) {
                String tabPageKey = (String)iterator.next();
                if (itemIds.contains(tabPageKey)) {
                    Iterator iteIiterator = this.items.iterator();
                    while (iteIiterator.hasNext()) {
                        Control item = (Control)iteIiterator.next();
                        if (!tabPageKey.equals(item.getKey()) || this.getView().existView(tabPageKey)) continue;
                        iteIiterator.remove();
                    }
                    continue;
                }
                if (!this.getView().existView(tabPageKey)) {
                    iterator.remove();
                    cache.put(TAB_ITEMS_TABPAGEKEYS, SerializationUtils.toJsonString((Object)tabPageKeys));
                    continue;
                }
                TabPage page = new TabPage();
                page.setKey(tabPageKey);
                if (this.getView() != null) {
                    page.setView(this.getView());
                }
                this.items.add(page);
            }
        }
        return this.items;
    }

    public List<Control> getNoFilterItems() {
        return this.items;
    }

    @KSMethod
    public void setMessageColor(String color) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.setFieldProperty(this.getKey(), "mc", color);
    }

    @KSMethod
    public String getCurrentTab() {
        IPageCache cache = (IPageCache)this.getView().getService(IPageCache.class);
        String tabKey = cache.get("_Tab_Selected_" + this.getKey());
        if (tabKey == null && !this.getItems().isEmpty()) {
            tabKey = this.getItems().get(0).getKey();
        }
        return tabKey;
    }

    @KSMethod
    public void menuInfoClick(String controlKey, String id, String operationKey) {
        BeforeItemClickEvent evt = new BeforeItemClickEvent(this, controlKey, id);
        this.fireBeforeItemClick(evt);
        if (!evt.isCancel()) {
            if (StringUtils.isNotBlank((CharSequence)operationKey)) {
                this.getView().invokeOperation(operationKey);
            }
            ItemClickEvent evt1 = new ItemClickEvent(this, controlKey, id);
            this.fireItemClick(evt1);
        }
    }

    private void fireBeforeItemClick(BeforeItemClickEvent e) {
        for (ItemClickListener l : this.barItemClickListeners) {
            EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(l.getClass().getName() + ".beforeItemClick"));
            Throwable throwable = null;
            try {
                l.beforeItemClick(e);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (span == null) continue;
                if (throwable != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                span.close();
            }
        }
    }

    private void fireItemClick(ItemClickEvent e) {
        for (ItemClickListener l : this.barItemClickListeners) {
            EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(l.getClass().getName() + ".itemClick"));
            Throwable throwable = null;
            try {
                l.itemClick(e);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (span == null) continue;
                if (throwable != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                span.close();
            }
        }
    }

    @Override
    public void addItemClickListener(ItemClickListener listener) {
        this.barItemClickListeners.add(listener);
    }

    public void clickTabFixed(LinkedHashMap<String, Object> linkedHashMap) {
        ClickEvent evt = new ClickEvent(this, linkedHashMap);
        for (ClickListener l : this.clickListeners) {
            EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(l.getClass().getName() + ".click"));
            Throwable throwable = null;
            try {
                l.click(evt);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (span == null) continue;
                if (throwable != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                span.close();
            }
        }
    }

    public void setHomePageTabFixed(List<Map<String, Object>> dataMaps) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "setHomePageTabFixed", dataMaps);
    }

    public void addTabCloseListener(TabCloseListener listener) {
        this.tabCloseListeners.add(listener);
    }

    @Deprecated
    public void closeTabs(List<String> tabKeys) {
        TabCloseEvent evt = new TabCloseEvent(this, tabKeys);
        if (this.tabCloseListeners != null) {
            for (TabCloseListener l : this.tabCloseListeners) {
                l.tabClose(evt);
            }
        }
    }

    public void addTabBatchCloseListener(TabBatchCloseListener listener) {
        this.tabBatchCloseListeners.add(listener);
    }

    public void batchCloseTabs(List<String> tabKeys) {
        TabBatchCloseEvent evt = new TabBatchCloseEvent(this, tabKeys);
        for (TabBatchCloseListener l : this.tabBatchCloseListeners) {
            l.tabBatchClose(evt);
            List<String> preparedCloseTabs = evt.getTabKeys();
            if (!evt.isForce() && !preparedCloseTabs.isEmpty()) {
                this.closeTabClientAction(preparedCloseTabs);
            }
            if (!evt.isForce()) continue;
            for (int i = 0; i < preparedCloseTabs.size(); ++i) {
                IFormView formView = this.getView().getViewNoPlugin(preparedCloseTabs.get(i));
                if (formView == null) continue;
                formView.close();
            }
            this.closeTabClientAction(preparedCloseTabs);
        }
    }

    private void closeTabClientAction(List<String> tabKeys) {
        ArrayList tabListClose = new ArrayList(10);
        for (String tabKey : tabKeys) {
            HashMap<String, String> arg = new HashMap<String, String>();
            arg.put("pageId", tabKey);
            tabListClose.add(arg);
        }
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.addAction("closeWindow", tabListClose);
    }

    @KSMethod
    public void updateTabName(Map<String, String> tabInfo) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "updateTabName", tabInfo);
    }

    @KSMethod
    public void updateTabName(String tabKey, String tabName) {
        HashMap<String, String> tabInfo = new HashMap<String, String>();
        tabInfo.put(tabKey, tabName);
        this.updateTabName(tabInfo);
    }

    @KSMethod
    public void click(Map<String, Object> paramsMap) {
        ClickEvent evt = new ClickEvent(this, paramsMap);
        for (ClickListener l : this.clickListeners) {
            EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(l.getClass().getName() + ".click"));
            Throwable throwable = null;
            try {
                l.click(evt);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (span == null) continue;
                if (throwable != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                span.close();
            }
        }
    }

    public void addTabReOpenListener(TabOperationListener listener) {
        this.tabReOpenListeners.add(listener);
    }

    @KSMethod
    public void reOpenTab(String tabKey) {
        TabOperationEvent evt = new TabOperationEvent(this, tabKey);
        if (this.tabReOpenListeners != null) {
            for (TabOperationListener l : this.tabReOpenListeners) {
                l.tabReOpen(evt);
            }
        }
    }
}

