/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.control;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.RefEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.filter.FilterUtil;
import kd.bos.entity.property.AssistantProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.property.IRefBillField;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.entity.property.MasterBasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.RefBillProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.filter.helper.RefBillDataSearchHelper;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.EntryGridSetRowDataConfig;
import kd.bos.form.control.events.EntryGridSetRowDataEvent;
import kd.bos.form.control.events.EntryGridSetRowDataListener;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.RefBillEdit;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.Distinctable;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.WithEntityEntryDistinctable;
import kd.bos.permission.api.PermissionService;
import kd.bos.service.ServiceFactory;
import kd.bos.util.CollectionUtils;
import kd.bos.util.JSONUtils;

public class EntryGridSetRowData {
    private static final Log log = LogFactory.getLog(EntryGridSetRowData.class);
    private static final String SPAN_TYPE_NAME = "EntryGridSetRowData";
    private static final String SPAN_METHOD_NAME = "EntryGridSetRowDataListener";
    private static final String MUL_SPLIT_KEY = ",|;|\uff1b";
    private static final String SYSTEM_TYPE = "bos-form-metadata";
    private final List<EntryGridSetRowDataListener> setRowDataListeners;
    private final EntryGrid entryGrid;
    private static final Integer MAX_ROW_SIZE = 1000;
    private final EntryGridSetRowDataConfig setRowDataConfig;

    public EntryGridSetRowData(EntryGrid entryGrid) {
        this.entryGrid = entryGrid;
        this.setRowDataListeners = entryGrid.getSetRowDataListeners();
        this.setRowDataConfig = entryGrid.getSetRowDataConfig();
    }

    private boolean supportNameConfig() {
        if (this.setRowDataConfig != null) {
            return this.setRowDataConfig.isSupportName();
        }
        return true;
    }

    private boolean disabledConfig() {
        if (this.setRowDataConfig != null) {
            return this.setRowDataConfig.isDisabled();
        }
        return "true".equals(this.entryGrid.getView().getPageCache().get("BOS.setRowDataByNumberDisable"));
    }

    private boolean addRowDisabledConfig() {
        if (this.setRowDataConfig != null) {
            return this.setRowDataConfig.isAddRowDisabled();
        }
        return "false".equals(this.entryGrid.getView().getPageCache().get("BOS.setRowDataByNumberAutoAddRow"));
    }

    private boolean updateViewConfig() {
        if (this.setRowDataConfig != null) {
            return this.setRowDataConfig.isUpdateView();
        }
        return "true".equals(this.entryGrid.getView().getPageCache().get("BOS.setRowDataByNumberUpdateView"));
    }

    private int getMaxRowSize() {
        int maxRowSize = 0;
        if (this.setRowDataConfig != null) {
            maxRowSize = this.setRowDataConfig.getMaxRowSize();
        } else {
            try {
                maxRowSize = Integer.parseInt(this.entryGrid.getView().getPageCache().get("BOS.setRowDataByNumberMaxRowSize"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (maxRowSize <= 0) {
            maxRowSize = MAX_ROW_SIZE;
        }
        return maxRowSize;
    }

    private EntryGridSetRowDataEvent triggerBeforeSetRowDataEvent(Map<String, List<Tuple<Integer, Object>>> columnMap) {
        IDataModel model = this.entryGrid.getModel();
        IDataEntityType entryType = ((ICollectionProperty)model.getProperty(this.entryGrid.getEntryKey())).getItemType();
        EntryGridSetRowDataEvent setRowDataEvent = new EntryGridSetRowDataEvent(this, entryType, columnMap);
        for (EntryGridSetRowDataListener listener : this.setRowDataListeners) {
            EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)SPAN_METHOD_NAME);
            Throwable throwable = null;
            try {
                listener.entryGridSetRowData(setRowDataEvent);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (span == null) continue;
                if (throwable != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                span.close();
            }
        }
        return setRowDataEvent;
    }

    private List<QFilter> buildRowDataFilter(IDataEntityType dataEntityType, IDataEntityProperty prop) {
        List qFilters;
        ListShowParameter listShowParameter;
        Object edit;
        List fieldFilters;
        IDataModel model = this.entryGrid.getModel();
        IFormView formView = this.entryGrid.getView();
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        if (prop instanceof BasedataProp || prop instanceof MulBasedataProp) {
            fieldFilters = FilterUtil.buildBaseDataF7QFilters((IBasedataField)((IBasedataField)prop), (IDataModel)model, (String)formView.getFormShowParameter().getAppId(), (String)dataEntityType.getName(), new ArrayList(), (String)"47150e89000000ac", (boolean)true);
            qFilterList.addAll(fieldFilters);
        } else if (prop instanceof RefBillProp) {
            fieldFilters = FilterUtil.buildRefBillF7QFilters((IRefBillField)((IRefBillField)prop), (IDataModel)model, (String)formView.getFormShowParameter().getAppId(), (String)dataEntityType.getName(), new ArrayList(), (String)"47150e89000000ac", (boolean)true);
            qFilterList.addAll(fieldFilters);
        }
        PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
        QFilter qfilter = permissionService.getDataRuleForBdProp(RequestContext.get().getCurrUserId(), null, model.getDataEntityType().getName(), prop.getName());
        if (qfilter != null) {
            qFilterList.add(qfilter);
        }
        if ((edit = formView.getControl(prop.getName())) instanceof BasedataEdit) {
            List qFilters2;
            ListShowParameter listShowParameter2 = ((BasedataEdit)edit).getListShowParameter("setItemByNumber");
            if (listShowParameter2 != null && listShowParameter2.getListFilterParameter() != null && (qFilters2 = listShowParameter2.getListFilterParameter().getQFilters()) != null && !qFilters2.isEmpty()) {
                qFilterList.addAll(qFilters2);
            }
        } else if (edit instanceof RefBillEdit && (listShowParameter = ((RefBillEdit)edit).getListShowParameter("setItemByNumber")) != null && listShowParameter.getListFilterParameter() != null && (qFilters = listShowParameter.getListFilterParameter().getQFilters()) != null && !qFilters.isEmpty()) {
            qFilterList.addAll(qFilters);
        }
        return qFilterList;
    }

    public void setRowData(List<Map<String, Object>> rowData) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)SPAN_METHOD_NAME);){
            span.addTag("entryKey", this.entryGrid.getEntryKey());
            span.addTag("disabled", this.disabledConfig() ? "true" : "false");
            span.addTag("addRowDisabled", this.addRowDisabledConfig() ? "true" : "false");
            span.addTag("maxRowSize", MAX_ROW_SIZE.toString());
            span.addTag("inputRowSize", (rowData != null ? rowData.size() : 0) + "");
            try {
                span.addTag("rowData", rowData != null ? JSONUtils.toString(rowData) : "null");
            }
            catch (IOException e) {
                log.error("setRowData input rowData format error:%s", (Object)e.getMessage());
            }
        }
        if (this.disabledConfig() || CollectionUtils.isEmpty(rowData)) {
            return;
        }
        if (rowData.size() > this.getMaxRowSize()) {
            String msg = String.format(ResManager.loadKDString((String)"\u5355\u6b21\u64cd\u4f5c\u4e0d\u5141\u8bb8\u8d85\u8fc7%s\u884c\uff0c\u8bf7\u51cf\u5c11\u884c\u6570\u518d\u8bd5\u3002", (String)"EntryGridSetRowData_0", (String)SYSTEM_TYPE, (Object[])new Object[0]), this.getMaxRowSize());
            this.entryGrid.getView().showTipNotification(msg);
            return;
        }
        boolean addRowDisabled = this.addRowDisabledConfig();
        int entryRowCount = this.entryGrid.getRowCount();
        int maxRowCount = 0;
        LinkedHashMap<String, List<Tuple<Integer, Object>>> columnMap = new LinkedHashMap<String, List<Tuple<Integer, Object>>>(16);
        for (Map<String, Object> rowMap : rowData) {
            int rk = (Integer)rowMap.get("rk");
            maxRowCount = Math.max(rk + 1, maxRowCount);
            if (addRowDisabled && maxRowCount > entryRowCount) {
                maxRowCount = entryRowCount;
                continue;
            }
            Map colMap = (Map)rowMap.get("data");
            for (Map.Entry columnEntry : colMap.entrySet()) {
                String key = (String)columnEntry.getKey();
                Object value = columnEntry.getValue();
                if (!columnMap.containsKey(key)) {
                    columnMap.put(key, new ArrayList(rowData.size()));
                }
                ((List)columnMap.get(key)).add(new Tuple((Object)rk, value));
            }
        }
        boolean updateView = this.updateViewConfig();
        if (updateView) {
            this.entryGrid.getModel().beginInit();
        }
        if (maxRowCount > entryRowCount && !this.entryGrid.getModel().isFilterAndSortModel(this.entryGrid.getEntryKey())) {
            this.entryGrid.getModel().batchCreateNewEntryRow(this.entryGrid.getEntryKey(), maxRowCount - entryRowCount);
        }
        EntryGridSetRowDataEvent setRowDataEvent = this.triggerBeforeSetRowDataEvent(columnMap);
        Map<String, List<QFilter>> columnQFilter = setRowDataEvent.getQFilters();
        Map<String, List<RowDataObject>> newColumnMap = this.createRowDataObject(columnMap);
        this.setRowDataHandler(newColumnMap, columnQFilter);
        if (updateView) {
            this.entryGrid.getModel().endInit();
            this.entryGrid.getView().updateView(this.entryGrid.getEntryKey());
        }
    }

    private Map<String, List<RowDataObject>> createRowDataObject(Map<String, List<Tuple<Integer, Object>>> columnMap) {
        LinkedHashMap<String, List<RowDataObject>> newColumnMap = new LinkedHashMap<String, List<RowDataObject>>(columnMap.size());
        IDataModel model = this.entryGrid.getModel();
        IDataEntityType entryType = ((ICollectionProperty)model.getProperty(this.entryGrid.getEntryKey())).getItemType();
        for (Map.Entry<String, List<Tuple<Integer, Object>>> item : columnMap.entrySet()) {
            String key = item.getKey();
            IDataEntityProperty prop = (IDataEntityProperty)entryType.getProperties().get((Object)key);
            List<Tuple<Integer, Object>> valueList = item.getValue();
            ArrayList<RowDataObject> newValueList = new ArrayList<RowDataObject>(valueList.size());
            for (Tuple<Integer, Object> tuple : valueList) {
                if (prop instanceof ItemClassTypeProp || prop instanceof BasedataProp || prop instanceof RefBillProp || prop instanceof MulBasedataProp) {
                    String value;
                    String string = value = tuple.item2 == null ? "" : tuple.item2.toString();
                    if (prop instanceof MulBasedataProp) {
                        String[] itemList = value.split(MUL_SPLIT_KEY);
                        for (int i = 0; i < itemList.length; ++i) {
                            String str = itemList[i];
                            newValueList.add(new RowDataObject((Integer)tuple.item1, str, i));
                        }
                        continue;
                    }
                    newValueList.add(new RowDataObject((Integer)tuple.item1, value, 0));
                    continue;
                }
                if (prop instanceof BooleanProp) {
                    if (tuple.item2 == null) {
                        newValueList.add(new RowDataObject((Integer)tuple.item1, false, 0));
                        continue;
                    }
                    newValueList.add(new RowDataObject((Integer)tuple.item1, tuple.item2, 0));
                    continue;
                }
                newValueList.add(new RowDataObject((Integer)tuple.item1, tuple.item2, 0));
            }
            newColumnMap.put(key, newValueList);
        }
        return newColumnMap;
    }

    private IDataEntityProperty getProperty(String columnName) {
        IDataModel model = this.entryGrid.getModel();
        IDataEntityType entryType = ((ICollectionProperty)model.getProperty(this.entryGrid.getEntryKey())).getItemType();
        DataEntityPropertyCollection properties = entryType.getProperties();
        return (IDataEntityProperty)properties.get((Object)columnName);
    }

    private void setRowDataHandler(Map<String, List<RowDataObject>> columnMap, Map<String, List<QFilter>> columnQFilter) {
        IDataModel model = this.entryGrid.getModel();
        for (Map.Entry<String, List<RowDataObject>> columnEntry : columnMap.entrySet()) {
            IDataEntityProperty prop = this.getProperty(columnEntry.getKey());
            if (prop == null) continue;
            boolean isSimpleValue = true;
            List<RowDataObject> rkValues = columnMap.get(prop.getName());
            if (prop instanceof FlexProp || prop instanceof ItemClassProp || prop instanceof ItemClassTypeProp) continue;
            if (prop instanceof BasedataProp) {
                isSimpleValue = false;
                this.baseDataPropHandler(prop, rkValues, columnQFilter);
            } else if (prop instanceof MulBasedataProp) {
                isSimpleValue = false;
                this.multiBaseDataPropHandler(prop, rkValues, columnQFilter);
            } else if (prop instanceof RefBillProp) {
                isSimpleValue = false;
                this.refBillPropHandler(prop, rkValues, columnQFilter);
            }
            ArrayList<Tuple> tupleList = new ArrayList<Tuple>(rkValues.size());
            if (prop instanceof MulBasedataProp) {
                HashMap valueMap = new HashMap();
                rkValues.sort(Comparator.comparingInt(x -> ((RowDataObject)x).index));
                for (RowDataObject rowDataObject : rkValues) {
                    if (valueMap.containsKey(rowDataObject.getRowNumber())) {
                        ((List)valueMap.get(rowDataObject.getRowNumber())).add(rowDataObject.getNumber());
                        continue;
                    }
                    ArrayList<Object> objects = new ArrayList<Object>(5);
                    objects.add(rowDataObject.getNumber());
                    valueMap.put(rowDataObject.getRowNumber(), objects);
                }
                for (Map.Entry entry : valueMap.entrySet()) {
                    tupleList.add(new Tuple(entry.getKey(), (Object)StringUtils.join((Object[])((List)entry.getValue()).toArray(), (String)";")));
                }
            } else {
                rkValues.forEach(x -> tupleList.add(new Tuple((Object)x.getRowNumber(), x.getNumber())));
            }
            for (Tuple tuple : tupleList) {
                BeforeFieldPostBackEvent e;
                Integer n = (Integer)tuple.item1;
                Object value = tuple.item2;
                if (isSimpleValue) {
                    if (prop instanceof TimeProp) {
                        value = TimeProp.timeToSecond((Object)value, (String)prop.getName());
                    }
                    if ((e = this.triggerBeforeFieldPost(prop, model, value, n)).isCancel()) continue;
                    model.setValue(prop.getName(), value, n.intValue());
                    continue;
                }
                e = this.triggerBeforeFieldPost(prop, model, value.toString(), n);
                if (e.isCancel()) continue;
                ArrayList qFilters = new ArrayList(columnQFilter.get(prop.getName()));
                model.setItemValueByNumber(prop.getName(), value.toString(), n.intValue(), qFilters);
            }
        }
    }

    private BeforeFieldPostBackEvent triggerBeforeFieldPost(IDataEntityProperty prop, IDataModel model, Object value, int rowIndex) {
        FieldEdit edit = (FieldEdit)this.entryGrid.getView().getControl(prop.getName());
        int parentRowIndex = -1;
        if (prop.getParent() instanceof SubEntryType) {
            parentRowIndex = model.getEntryCurrentRowIndex(prop.getParent().getParent().getName());
        }
        BeforeFieldPostBackEvent e = new BeforeFieldPostBackEvent(edit, value, rowIndex, parentRowIndex);
        e.setKey(prop.getName());
        ((FormViewPluginProxy)this.entryGrid.getView().getService(FormViewPluginProxy.class)).fireBeforeFieldPostBack(e);
        return e;
    }

    private void baseDataPropHandler(IDataEntityProperty prop, List<RowDataObject> rkValues, Map<String, List<QFilter>> columnQFilter) {
        BasedataEntityType dataEntityType = (BasedataEntityType)((BasedataProp)prop).getDynamicComplexPropertyType();
        if (dataEntityType == null) {
            return;
        }
        columnQFilter.computeIfAbsent(prop.getName(), k -> new ArrayList());
        columnQFilter.get(prop.getName()).addAll(this.buildRowDataFilter((IDataEntityType)dataEntityType, prop));
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>((Collection)columnQFilter.get(prop.getName()));
        String searchKey = dataEntityType.getSearchNumberKey();
        String name = dataEntityType.getNameProperty();
        IDataEntityProperty nameProp = (IDataEntityProperty)dataEntityType.getProperties().get((Object)name);
        this.loadRowDataByName(prop, (DynamicObjectType)dataEntityType, nameProp, rkValues, searchKey);
        this.loadRowDataByNumber((DynamicObjectType)dataEntityType, rkValues, searchKey, qFilterList);
    }

    private void multiBaseDataPropHandler(IDataEntityProperty prop, List<RowDataObject> rkValues, Map<String, List<QFilter>> columnQFilter) {
        BasedataEntityType dataEntityType = (BasedataEntityType)((BasedataProp)((MulBasedataProp)prop).getRefBaseProp()).getDynamicComplexPropertyType();
        if (dataEntityType == null) {
            return;
        }
        columnQFilter.computeIfAbsent(prop.getName(), k -> new ArrayList());
        columnQFilter.get(prop.getName()).addAll(this.buildRowDataFilter((IDataEntityType)dataEntityType, prop));
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>((Collection)columnQFilter.get(prop.getName()));
        String searchKey = dataEntityType.getSearchNumberKey();
        String name = dataEntityType.getNameProperty();
        IDataEntityProperty nameProp = (IDataEntityProperty)dataEntityType.getProperties().get((Object)name);
        this.loadRowDataByName(prop, (DynamicObjectType)dataEntityType, nameProp, rkValues, searchKey);
        this.loadRowDataByNumber((DynamicObjectType)dataEntityType, rkValues, searchKey, qFilterList);
    }

    private void refBillPropHandler(IDataEntityProperty prop, List<RowDataObject> rkValues, Map<String, List<QFilter>> columnQFilter) {
        BasedataEntityType dataEntityType = (BasedataEntityType)((RefBillProp)prop).getComplexType();
        if (dataEntityType == null) {
            return;
        }
        columnQFilter.computeIfAbsent(prop.getName(), k -> new ArrayList());
        columnQFilter.get(prop.getName()).addAll(this.buildRowDataFilter((IDataEntityType)dataEntityType, prop));
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>((Collection)columnQFilter.get(prop.getName()));
        String searchKey = dataEntityType.getBillNo();
        DynamicObjectType dynamicObjectType = ((RefBillProp)prop).getDynamicComplexPropertyType();
        String name = dataEntityType.getNameProperty();
        IDataEntityProperty nameProp = (IDataEntityProperty)dataEntityType.getProperties().get((Object)name);
        String refBillDisplayName = prop.getDisplayName() == null ? prop.getName() : prop.getDisplayName().toString();
        RefBillDataSearchHelper.checkRefBillIsExistTableFields((BillEntityType)dataEntityType, refBillDisplayName, searchKey);
        this.loadRowDataByName(prop, dynamicObjectType, nameProp, rkValues, searchKey);
        this.loadRowDataByNumber(dynamicObjectType, rkValues, searchKey, qFilterList);
    }

    private DynamicObjectType getMasterType(DynamicObjectType dynamicObjectType) {
        IDataEntityProperty masterIdProp;
        BasedataEntityType dt;
        if (dynamicObjectType instanceof BasedataEntityType && StringUtils.isNotBlank((CharSequence)(dt = (BasedataEntityType)dynamicObjectType).getMasteridPropName()) && dt.getMasteridType() == 2 && (masterIdProp = dt.findProperty(dt.getMasteridPropName())) instanceof MasterBasedataProp) {
            return (RefEntityType)((MasterBasedataProp)masterIdProp).getComplexType();
        }
        return dynamicObjectType;
    }

    private void loadRowDataByName(IDataEntityProperty prop, DynamicObjectType dynamicObjectType, IDataEntityProperty nameProp, List<RowDataObject> rowDataObjectList, String searchNumberKey) {
        EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"loadRowDataByName");
        Object object = null;
        try {
            span.addTag("entryKey", this.entryGrid.getEntryKey());
            span.addTag("propName", prop.getName());
            span.addTag("typeName", dynamicObjectType.getName());
            span.addTag("alias", dynamicObjectType.getAlias());
            span.addTag("nameProp", nameProp != null ? nameProp.getName() : "");
            span.addTag("searchKey", searchNumberKey);
            span.addTag("supportName", this.supportNameConfig() ? "true" : "false");
            try {
                span.addTag("rowData", rowDataObjectList != null ? JSONUtils.toString(rowDataObjectList) : "null");
            }
            catch (IOException e) {
                log.error("loadRowDataByName input rowDataObjectList format error:%s", (Object)e.getMessage());
            }
        }
        catch (Throwable e) {
            object = e;
            throw e;
        }
        finally {
            if (span != null) {
                if (object != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable e) {
                        ((Throwable)object).addSuppressed(e);
                    }
                } else {
                    span.close();
                }
            }
        }
        if (!this.supportNameConfig() || !(nameProp instanceof MuliLangTextProp) || rowDataObjectList == null) {
            return;
        }
        HashSet<Object> nameList = new HashSet<Object>(rowDataObjectList.size());
        for (RowDataObject rowDataObject : rowDataObjectList) {
            if (!StringUtils.isNotBlank((Object)rowDataObject.getRowData())) continue;
            nameList.add(rowDataObject.getRowData());
        }
        if (nameList.isEmpty()) {
            return;
        }
        HashMap result = new HashMap(16);
        DynamicObjectType masterType = this.getMasterType(dynamicObjectType);
        String nameField = null;
        if (masterType instanceof BasedataEntityType) {
            nameField = ((BasedataEntityType)masterType).getNameProperty();
        } else if (masterType instanceof RefEntityType) {
            nameField = ((RefEntityType)masterType).getNameProperty();
        }
        if (StringUtils.isEmpty((CharSequence)nameField)) {
            return;
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>(4);
        filters.add(new QFilter(nameField, "in", (Object)nameList.toArray()));
        if (masterType.getProperty("enable") != null) {
            filters.add(new QFilter("enable", "=", (Object)"1"));
        }
        if (!"bd_material".equals(masterType.getName())) {
            String statusField = null;
            if (masterType instanceof BasedataEntityType) {
                statusField = ((BasedataEntityType)masterType).getBillStatus();
            } else if (masterType instanceof RefEntityType) {
                statusField = ((RefEntityType)masterType).getBillStatus();
            }
            if (StringUtils.isNotEmpty((CharSequence)statusField)) {
                filters.add(new QFilter(statusField, "=", (Object)"C"));
            }
        }
        if (prop instanceof AssistantProp) {
            filters.add(new QFilter("group", "=", (Object)Long.parseLong(((AssistantProp)prop).getAsstTypeId())));
        }
        ORM orm = ORM.create();
        Throwable throwable = null;
        try (DataSet ds = orm.queryDataSet("EntryGridSetRowData.queryByName", masterType.getName(), "id," + nameField, filters.toArray(new QFilter[0]), null, -1, (Distinctable)WithEntityEntryDistinctable.get());){
            ds.forEach(row -> {
                Object id = row.get(0);
                String name = row.getString(1);
                if (result.containsKey(name)) {
                    ((List)result.get(name)).add(id);
                } else {
                    ArrayList<Object> list = new ArrayList<Object>();
                    list.add(id);
                    result.put(name, list);
                }
            });
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
        if (result.isEmpty()) {
            return;
        }
        for (RowDataObject rowDataObject : rowDataObjectList) {
            String string = rowDataObject.getRowData().toString();
            if (!result.containsKey(string)) continue;
            rowDataObject.setLoaded(true);
            rowDataObject.setNumber("");
        }
        HashMap nameIdMap = new HashMap(16);
        for (Map.Entry entry : result.entrySet()) {
            if (((List)entry.getValue()).size() != 1) continue;
            nameIdMap.put(entry.getKey(), ((List)entry.getValue()).get(0));
        }
        if (nameIdMap.isEmpty()) {
            return;
        }
        Map map = BusinessDataReader.loadFromCache((Object[])nameIdMap.values().toArray(), (DynamicObjectType)masterType);
        String[] stringArray = searchNumberKey.split("\\.");
        String numberKey = stringArray.length == 2 ? stringArray[1] : stringArray[0];
        for (RowDataObject rowDataObject : rowDataObjectList) {
            DynamicObject dynamicObject;
            String name = rowDataObject.getRowData().toString();
            if (!nameIdMap.containsKey(name) || !map.containsKey(nameIdMap.get(name)) || !(dynamicObject = (DynamicObject)map.get(nameIdMap.get(name))).containsProperty(numberKey) || dynamicObject.get(numberKey) == null) continue;
            rowDataObject.setNumber(dynamicObject.get(numberKey));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadRowDataByNumber(DynamicObjectType dataEntityType, List<RowDataObject> rowDataObjectList, String searchNumberKey, List<QFilter> qFilterList) {
        Object number;
        EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_NAME, (String)"loadRowDataByNumber");
        Object object = null;
        try {
            span.addTag("entryKey", this.entryGrid.getEntryKey());
            span.addTag("typeName", dataEntityType.getName());
            span.addTag("alias", dataEntityType.getAlias());
            span.addTag("searchKey", searchNumberKey);
            try {
                span.addTag("rowData", rowDataObjectList != null ? JSONUtils.toString(rowDataObjectList) : "null");
            }
            catch (IOException e) {
                log.error("loadRowDataByNumber input rowDataObjectList format error:%s", (Object)e.getMessage());
            }
        }
        catch (Throwable e) {
            object = e;
            throw e;
        }
        finally {
            if (span != null) {
                if (object != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable e) {
                        ((Throwable)object).addSuppressed(e);
                    }
                } else {
                    span.close();
                }
            }
        }
        if (rowDataObjectList == null) {
            return;
        }
        HashSet<Object> numberList = new HashSet<Object>(rowDataObjectList.size());
        for (RowDataObject rowDataObject : rowDataObjectList) {
            if (!StringUtils.isNotBlank((Object)rowDataObject.getNumber())) continue;
            numberList.add(rowDataObject.getNumber());
        }
        if (numberList.isEmpty()) {
            return;
        }
        qFilterList.add(new QFilter(searchNumberKey, "in", numberList));
        Map data = this.entryGrid.getModel().loadReferenceDataBatch(dataEntityType, qFilterList);
        ArrayList<Object> keys = new ArrayList<Object>();
        for (DynamicObject dynamicObject : data.values()) {
            block26: {
                number = null;
                try {
                    if (!StringUtils.isNotBlank((Object)dynamicObject.get(searchNumberKey))) break block26;
                    number = dynamicObject.getString(searchNumberKey);
                }
                catch (Throwable throwable) {
                    if (StringUtils.isBlank(number)) {
                        String numberKey;
                        String[] keyArr = searchNumberKey.split("\\.");
                        String string = numberKey = keyArr.length == 2 ? keyArr[1] : keyArr[0];
                        if (dynamicObject.containsProperty(numberKey) && StringUtils.isNotBlank((Object)dynamicObject.get(numberKey))) {
                            number = dynamicObject.getString(numberKey);
                        }
                    }
                    throw throwable;
                }
            }
            if (StringUtils.isBlank((CharSequence)number)) {
                String numberKey;
                String[] keyArr = searchNumberKey.split("\\.");
                String string = numberKey = keyArr.length == 2 ? keyArr[1] : keyArr[0];
                if (dynamicObject.containsProperty(numberKey) && StringUtils.isNotBlank((Object)dynamicObject.get(numberKey))) {
                    number = dynamicObject.getString(numberKey);
                }
            }
            if (!StringUtils.isNotBlank((CharSequence)number)) continue;
            keys.add(number);
        }
        for (RowDataObject rowDataObject : rowDataObjectList) {
            number = rowDataObject.getNumber();
            if (!StringUtils.isNotBlank((Object)number) || keys.contains(number)) continue;
            rowDataObject.setNumber("");
        }
    }

    static class RowDataObject {
        private Integer rowNumber;
        private Object rowData;
        private Boolean loaded;
        private Object number;
        private Integer index;

        public RowDataObject(Integer rowNumber, Object rowData, int index) {
            this.rowNumber = rowNumber;
            this.rowData = rowData;
            this.loaded = false;
            this.number = this.rowData;
            this.index = index;
        }

        public Integer getRowNumber() {
            return this.rowNumber;
        }

        public void setRowNumber(Integer rowNumber) {
            this.rowNumber = rowNumber;
        }

        public Object getRowData() {
            return this.rowData;
        }

        public void setRowData(Object rowData) {
            this.rowData = rowData;
        }

        public Boolean getLoaded() {
            return this.loaded;
        }

        public void setLoaded(Boolean loaded) {
            this.loaded = loaded;
        }

        public Object getNumber() {
            return this.number;
        }

        public void setNumber(Object number) {
            this.number = number;
        }

        public Integer getIndex() {
            return this.index;
        }

        public void setIndex(Integer index) {
            this.index = index;
        }
    }
}

