/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.control;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.decode.DecodeHandlerFactory;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.RefEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.CompareType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.filter.FilterUtil;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.PermissionFilterUtil;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.property.CreateExtendFilterFieldsResult;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.RefBillProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.BindingContext;
import kd.bos.form.CloseCallBack;
import kd.bos.form.CoreShowFormHelper;
import kd.bos.form.CoreSingleOrgContextHelper;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageProxy;
import kd.bos.form.ShowType;
import kd.bos.form.SimpleBaseData;
import kd.bos.form.StyleCss;
import kd.bos.form.container.Container;
import kd.bos.form.control.FilterCompareTypeList;
import kd.bos.form.control.events.FilterGridF7ClickEvent;
import kd.bos.form.control.events.FilterGridF7ClickListener;
import kd.bos.form.control.events.FilterGridF7CloseCallBackEvent;
import kd.bos.form.control.events.FilterGridF7CloseCallBackListener;
import kd.bos.form.control.events.FilterGridValueClickEvent;
import kd.bos.form.control.events.FilterGridValueClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.list.SelectedRowCondition;
import kd.bos.orm.query.QFilter;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.service.InteTimeZone;
import kd.bos.service.KDDateUtils;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public class FilterGrid
extends Container
implements ICloseCallBack {
    private static final String VALUE = "value";
    private List<Map<String, Object>> filterColumns;
    private List<Map<String, Object>> fieldColumns = new ArrayList<Map<String, Object>>();
    private List<String> filterFieldKeys = new ArrayList<String>();
    private static final String CONSTANT_FILTER_COLUMNS = "filterColumns";
    private static final String FIELD_NAME = "fieldName";
    private MainEntityType mainEntityType;
    private String entityNumber;
    private FilterGridState filterGridState;
    private static final int REDISBATCHSIZE = 30;
    private static final String POSTDATACACHEKEY = "pd";
    private static final String FILTERCONDITIONKEY = "fc";
    private List<Map<String, Object>> postData = null;
    private static final String REF_BILL_CALLBACK_PREFIX = "RefBill";
    private static final String SPAN_TYPE_FILTERGRID = "FilterGrid";
    List<BeforeFilterF7SelectListener> beforeF7SelectListeners = new ArrayList<BeforeFilterF7SelectListener>();
    List<FilterGridF7ClickListener> filterGridF7ClickListeners = new ArrayList<FilterGridF7ClickListener>();
    List<FilterGridValueClickListener> filterGridValueClickListeners = new ArrayList<FilterGridValueClickListener>(10);
    List<FilterGridF7CloseCallBackListener> filterGridF7CloseCallBackListeners = new ArrayList<FilterGridF7CloseCallBackListener>();
    private Map<String, List<CompareType>> fieldCompareTypeMap;
    private Set<String> flexFields = new HashSet<String>(16);

    private String getPostDataKey() {
        return this.getKey() + "_" + POSTDATACACHEKEY;
    }

    private String getFilterConditionKey() {
        return this.getKey() + "_" + FILTERCONDITIONKEY;
    }

    private String getFilterColumnsKey() {
        return this.getKey() + "_" + CONSTANT_FILTER_COLUMNS;
    }

    private List<Map<String, Object>> loadPostDataCache() {
        IPageCache pageCache = (IPageCache)this.view.getService(IPageCache.class);
        if (this.postData == null && pageCache.get(this.getPostDataKey()) != null) {
            this.postData = SerializationUtils.fromJsonStringToList((String)pageCache.get(this.getPostDataKey()), Map.class);
        }
        if (this.postData == null) {
            this.postData = new ArrayList<Map<String, Object>>();
        }
        return this.postData;
    }

    private void savePostData(List<Map<String, Object>> postData) {
        this.postData = postData;
        IPageCache pageCache = (IPageCache)this.view.getService(IPageCache.class);
        pageCache.put(this.getPostDataKey(), SerializationUtils.toJsonString(postData));
    }

    private FilterGridState loadFilterGridState() {
        IPageCache pageCache = (IPageCache)this.view.getService(IPageCache.class);
        if (this.filterGridState == null && pageCache.get(this.getFilterConditionKey()) != null) {
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)pageCache.get(this.getFilterConditionKey()), FilterCondition.class);
            this.filterGridState = new FilterGridState(this.getKey(), filterCondition);
        }
        if (this.filterGridState == null) {
            this.filterGridState = new FilterGridState(this.getKey(), new FilterCondition());
        }
        return this.filterGridState;
    }

    private void saveFilterGridState(FilterCondition filterCondition) {
        IPageCache pageCache = (IPageCache)this.view.getService(IPageCache.class);
        pageCache.put(this.getFilterConditionKey(), SerializationUtils.toJsonString((Object)filterCondition));
    }

    public List<BeforeFilterF7SelectListener> getBeforeF7SelectListeners() {
        return this.beforeF7SelectListeners;
    }

    public void setBeforeF7SelectListeners(List<BeforeFilterF7SelectListener> beforeF7SelectListeners) {
        this.beforeF7SelectListeners = beforeF7SelectListeners;
    }

    public void addBeforeF7SelectListener(BeforeFilterF7SelectListener listener) {
        this.beforeF7SelectListeners.add(listener);
    }

    public List<FilterGridF7ClickListener> getFilterGridF7ClickEvents() {
        return this.filterGridF7ClickListeners;
    }

    public void setFilterGridF7ClickEvents(List<FilterGridF7ClickListener> filterGridF7ClickListeners) {
        this.filterGridF7ClickListeners = filterGridF7ClickListeners;
    }

    public void addFilterGridF7ClickEvents(FilterGridF7ClickListener listener) {
        this.filterGridF7ClickListeners.add(listener);
    }

    public void addFilterGridValueClickListener(FilterGridValueClickListener listener) {
        this.filterGridValueClickListeners.add(listener);
    }

    @KSMethod
    public void filterGridValueClick(int row) {
        FilterGridValueClickEvent event = new FilterGridValueClickEvent(this, row);
        for (FilterGridValueClickListener filterGridValueClickListener : this.filterGridValueClickListeners) {
            filterGridValueClickListener.filterGridValueClick(event);
        }
    }

    public List<FilterGridF7CloseCallBackListener> getFilterGridF7CloseCallBackListeners() {
        return this.filterGridF7CloseCallBackListeners;
    }

    public void setFilterGridF7CloseCallBackListeners(List<FilterGridF7CloseCallBackListener> filterGridF7CloseCallBackListeners) {
        this.filterGridF7CloseCallBackListeners = filterGridF7CloseCallBackListeners;
    }

    public void addFilterGridF7CloseCallBackListeners(FilterGridF7CloseCallBackListener listener) {
        this.filterGridF7CloseCallBackListeners.add(listener);
    }

    public String getEntityNumber() {
        String cacheKey = String.format("%s_%s_%s", this.getKey(), "prop", "entityNumber");
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        if (pageCache.get(cacheKey) != null) {
            this.entityNumber = pageCache.get(cacheKey);
        }
        return this.entityNumber;
    }

    @KSMethod
    public void setEntityNumber(String entityNumber) {
        String entityNumber2 = this.getEntityNumber();
        if (StringUtils.isBlank((CharSequence)entityNumber) || !entityNumber.equalsIgnoreCase(entityNumber2)) {
            String cacheKey = String.format("%s_%s_%s", this.getKey(), "prop", "entityNumber");
            IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
            pageCache.put(cacheKey, entityNumber);
            this.mainEntityType = null;
            pageCache.remove(this.getFilterColumnsKey());
            pageCache.remove(this.getPostDataKey());
            pageCache.remove(this.getFilterConditionKey());
        }
    }

    private String getFieldCompareTypeMapKey() {
        return this.getKey() + "_fieldCompareTypeMapKey";
    }

    @SdkInternal
    Map<String, List<CompareType>> getFieldCompareTypeMap() {
        if (this.fieldCompareTypeMap != null) {
            return this.fieldCompareTypeMap;
        }
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        String fieldCompareTypeMapStr = pageCache.get(this.getFieldCompareTypeMapKey());
        if (StringUtils.isNotBlank((CharSequence)fieldCompareTypeMapStr)) {
            FilterCompareTypeList filterCompareTypeList = (FilterCompareTypeList)SerializationUtils.fromJsonString((String)fieldCompareTypeMapStr, FilterCompareTypeList.class);
            this.fieldCompareTypeMap = filterCompareTypeList.toFieldCompareTypeMap();
        }
        return this.fieldCompareTypeMap;
    }

    @SdkInternal
    private void setFieldCompareTypeMap(Map<String, List<CompareType>> fieldCompareTypeMap) {
        this.fieldCompareTypeMap = fieldCompareTypeMap;
        FilterCompareTypeList filterCompareTypeList = FilterCompareTypeList.create(fieldCompareTypeMap);
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        pageCache.put(this.getFieldCompareTypeMapKey(), SerializationUtils.toJsonString((Object)filterCompareTypeList));
    }

    public void addCustomCompareTypes(String fieldName, CompareType compareType) {
        this.addCustomCompareTypes(fieldName, Collections.singletonList(compareType));
    }

    public void addFlexField(String flexField) {
        this.flexFields.add(flexField);
    }

    public void addCustomCompareTypes(String fieldName, List<CompareType> compareTypes) {
        Map<String, List<CompareType>> fieldCompareTypeMap1 = this.getFieldCompareTypeMap();
        if (fieldCompareTypeMap1 == null) {
            fieldCompareTypeMap1 = new HashMap<String, List<CompareType>>(1);
            fieldCompareTypeMap1.put(fieldName, compareTypes);
        } else {
            List<CompareType> compareTypes1 = fieldCompareTypeMap1.get(fieldName);
            if (compareTypes1 == null) {
                compareTypes1 = new ArrayList<CompareType>(10);
            }
            compareTypes1.addAll(compareTypes);
            fieldCompareTypeMap1.put(fieldName, compareTypes1);
        }
        this.setFieldCompareTypeMap(fieldCompareTypeMap1);
    }

    public void setMainEntityType(MainEntityType mainEntityType) {
        this.mainEntityType = mainEntityType;
    }

    private MainEntityType getMainEntityType() {
        if (this.mainEntityType == null && StringUtils.isNotBlank((CharSequence)this.getEntityNumber())) {
            this.mainEntityType = EntityMetadataCache.getDataEntityType((String)this.getEntityNumber());
        } else if (this.mainEntityType == null) {
            this.mainEntityType = this.getView().getModel().getDataEntityType();
        }
        return this.mainEntityType;
    }

    public void setBtnStatus() {
        this.clientViewProxy.invokeControlMethod(this.getKey(), "setAddBtnStatus", true);
    }

    public void setEncoding() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("default", "");
        this.clientViewProxy.invokeControlMethod(this.getKey(), "setEncodingKeys", map);
    }

    public List<Map<String, Object>> getFieldColumns() {
        return this.fieldColumns;
    }

    public void setFieldColumns(List<Map<String, Object>> fieldColumns) {
        this.fieldColumns = fieldColumns;
    }

    public List<String> getFilterFieldKeys() {
        return this.filterFieldKeys;
    }

    public void setFilterFieldKeys(List<String> filterFieldKeys) {
        this.filterFieldKeys = filterFieldKeys;
    }

    public List<Map<String, Object>> getFilterColumns() {
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        String filterColumnsKey = this.getFilterColumnsKey();
        if (this.filterColumns == null && pageCache.get(filterColumnsKey) != null) {
            this.filterColumns = this.getCachedFilterColumns(pageCache.get(filterColumnsKey), filterColumnsKey);
        }
        if (this.filterColumns == null) {
            this.filterColumns = new ArrayList<Map<String, Object>>();
        }
        return this.filterColumns;
    }

    public void setFilterColumns(List<Map<String, Object>> filterColumns) {
        ArrayList<Map<String, Object>> filterFilterColumns = new ArrayList<Map<String, Object>>();
        block0: for (Map<String, Object> filterColumn : filterColumns) {
            if (this.filterFieldKeys.isEmpty()) {
                filterFilterColumns.add(filterColumn);
                continue;
            }
            for (String filterFieldKey : this.filterFieldKeys) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)filterColumn.get(FIELD_NAME).toString(), (CharSequence)filterFieldKey)) continue;
                filterFilterColumns.add(filterColumn);
                continue block0;
            }
        }
        this.filterColumns = filterFilterColumns;
        String filterColumnsKey = this.getFilterColumnsKey();
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        int size = filterFilterColumns.size();
        ArrayList filterFilterColumns2 = new ArrayList(size);
        pageCache.put(filterColumnsKey, Integer.toString(size / 30 + (size % 30 == 0 ? 0 : 1)));
        for (int i = 1; i <= size; ++i) {
            filterFilterColumns2.add(filterFilterColumns.get(i - 1));
            if (i % 30 != 0) continue;
            pageCache.put(filterColumnsKey + "_" + i / 30, SerializationUtils.toJsonString(filterFilterColumns2));
            filterFilterColumns2 = new ArrayList();
        }
        if (size % 30 != 0) {
            pageCache.put(filterColumnsKey + "_" + (size / 30 + 1), SerializationUtils.toJsonString(filterFilterColumns2));
        }
    }

    public void SetValue(List<Map<String, List<Object>>> value) {
        this.postBack(value);
        this.clientViewProxy.invokeControlMethod(this.getKey(), "loadCommonConditions", value);
    }

    public void SetValue(FilterCondition filterCondition) {
        super.postBack(null);
        if (filterCondition == null) {
            return;
        }
        FilterGridState myFilterGridState = new FilterGridState(this.getKey(), new FilterCondition());
        ArrayList filterRows = new ArrayList();
        filterRows.addAll(filterCondition.getFilterRow());
        myFilterGridState.getFilterCondition().getFilterRow().addAll(filterRows);
        this.filterGridState = myFilterGridState;
        this.saveFilterGridState(filterCondition);
        this.clientViewProxy.invokeControlMethod(this.getKey(), "loadCommonConditions", myFilterGridState.getFilterCondition().createMetaData());
    }

    @Override
    @SdkInternal
    public void postBack(Object postValue) {
        postValue = this.decodePropertyValue(postValue);
        List state = (List)postValue;
        this.savePostData(state);
        this.filterGridState = this.convertPostDataToFilterCondition(state);
        this.saveFilterGridState(this.filterGridState.getFilterCondition());
    }

    private Object decodePropertyValue(Object param) {
        if (!(param instanceof String)) {
            return param;
        }
        String type = this.getView().getFormShowParameter().getFormConfig().getKdEncoding();
        String decodeStr = DecodeHandlerFactory.getDecodeHandler(type).decode((String)param);
        return SerializationUtils.fromJsonStringToList((String)decodeStr, Map.class);
    }

    private FilterGridState convertPostDataToFilterCondition(List<Map<String, Object>> state) {
        FilterGridState filterGridState2 = new FilterGridState(this.getKey(), new FilterCondition());
        for (Map<String, Object> map : state) {
            String id = (String)map.get("id");
            String leftBracket = (String)map.get("leftBracket");
            String compareType = map.get("compareType").toString();
            String fieldName = (String)map.get(FIELD_NAME);
            String rightBracket = (String)map.get("rightBracket");
            String logic = (String)map.get("logic");
            List valueList = (List)map.get(VALUE);
            List idList = (List)map.get("baseDataIds");
            FilterGridF7ClickEvent f7ClickEvent = new FilterGridF7ClickEvent(this, fieldName);
            for (FilterGridF7ClickListener filterGridF7ClickConsumer : this.filterGridF7ClickListeners) {
                filterGridF7ClickConsumer.filterGridF7Click(f7ClickEvent);
            }
            MainEntityType dataEntityType = StringUtils.isEmpty((CharSequence)f7ClickEvent.getEntityNumber()) ? this.getMainEntityType() : EntityMetadataCache.getDataEntityType((String)f7ClickEvent.getEntityNumber());
            if (!f7ClickEvent.isCancel()) {
                FilterField filterField = this.getFilterField(fieldName, dataEntityType);
                if (filterField == null) {
                    KDBizException e = new KDBizException(BosErrorCode.fieldNotExist, new Object[]{dataEntityType.getName(), String.format(ResManager.loadKDString((String)"%1$s\uff0c\u9519\u8bef\u4ee3\u7801: %2$s", (String)"FilterGrid_1", (String)"bos-form-metadata", (Object[])new Object[0]), fieldName, "FIELDNOTEXISTS000013")});
                    HashMap<String, String> tags = new HashMap<String, String>(2);
                    tags.put(FIELD_NAME, fieldName);
                    tags.put("dataEntityType", (String)dataEntityType);
                    EntityTracer.throwException((String)SPAN_TYPE_FILTERGRID, (String)"convertPostDataToFilterCondition", null, (Throwable)e, tags);
                    throw e;
                }
                String filterFieldName = filterField.getFieldName();
                int lastIndexOf = filterFieldName.lastIndexOf(".");
                String preFitlerName = filterFieldName;
                if (lastIndexOf > -1) {
                    preFitlerName = filterFieldName.substring(0, lastIndexOf);
                }
                CompareType fieldCompareType = FilterBuilder.getCompareType((String)preFitlerName, (FilterField)filterField, (String)compareType, this.getFieldCompareTypeMap());
                List newValueList = FilterUtil.getValidValues((List)valueList);
                if (newValueList.isEmpty() && fieldCompareType.isNeedInput()) continue;
            }
            ArrayList<FilterValue> values = new ArrayList<FilterValue>(10);
            for (Object value : valueList) {
                FilterValue filterValue = new FilterValue();
                filterValue.setValue(value);
                values.add(filterValue);
            }
            ArrayList<FilterValue> ids = new ArrayList<FilterValue>(10);
            if (idList != null) {
                for (Object value : idList) {
                    FilterValue filterValue = new FilterValue();
                    filterValue.setValue(value);
                    ids.add(filterValue);
                }
            }
            SimpleFilterRow simpleFilterRow = new SimpleFilterRow(id, leftBracket, compareType, fieldName, rightBracket, logic, values);
            simpleFilterRow.setBaseDataIds(ids);
            filterGridState2.put(simpleFilterRow);
        }
        return filterGridState2;
    }

    private FilterField getFlexFilterField(String fieldName, MainEntityType dataEntityType) {
        HashMap<String, FilterField> filterFieldMap = new HashMap<String, FilterField>(16);
        for (String flexField : this.flexFields) {
            IDataEntityProperty property = dataEntityType.findProperty(flexField);
            if (!(property instanceof FlexProp)) continue;
            CreateExtendFilterFieldsResult createExtendFilterFieldsResult = ((FlexProp)property).createExtendFilterFields(dataEntityType);
            List filterFields = createExtendFilterFieldsResult.getFilterFields();
            for (FilterField field : filterFields) {
                filterFieldMap.put(field.getFieldName(), field);
            }
        }
        return (FilterField)filterFieldMap.get(fieldName);
    }

    public void setFilterFields(List<?> filterColumns) {
        IClientViewProxy proxy = (IClientViewProxy)this.view.getService(IClientViewProxy.class);
        proxy.setFieldProperty(this.getKey(), "setFilterFields", filterColumns);
    }

    @Deprecated
    @SdkInternal
    public void setCompareFilterFields(List<?> filterColumns) {
        IClientViewProxy proxy = (IClientViewProxy)this.view.getService(IClientViewProxy.class);
        proxy.setFieldProperty(this.getKey(), "setCompareFilterFields", filterColumns);
    }

    @KSMethod
    @Deprecated
    @SdkInternal
    public void setEnabled(boolean value) {
        IClientViewProxy proxy = (IClientViewProxy)this.view.getService(IClientViewProxy.class);
        proxy.setFieldProperty(this.getKey(), "eb", value);
    }

    @SdkInternal
    private void setFilterMetaData(Consumer<List<Map<String, Object>>> onFilterMetaReady) {
        if (this.filterColumns == null) {
            String filterColumnsKey;
            IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
            if (pageCache.get(filterColumnsKey = this.getFilterColumnsKey()) != null) {
                this.filterColumns = this.getCachedFilterColumns(pageCache.get(filterColumnsKey), filterColumnsKey);
            }
            if (this.filterColumns == null) {
                this.setFilterColumns(EntityTypeUtil.getInstance().getFilterColumns((IDataEntityType)this.getMainEntityType()));
            }
        }
        if (onFilterMetaReady != null) {
            onFilterMetaReady.accept(this.filterColumns);
        }
        HashMap<String, List<Map<String, Object>>> fieldMap = new HashMap<String, List<Map<String, Object>>>();
        fieldMap.put(CONSTANT_FILTER_COLUMNS, this.filterColumns);
        fieldMap.put("fieldColumns", this.fieldColumns);
        CoreSingleOrgContextHelper.createFilterGridSingleOrgContext(fieldMap, this.getMainEntityType());
        this.clientViewProxy.invokeControlMethod(this.getKey(), "createFilterColumns", fieldMap);
    }

    private List<Map<String, Object>> getCachedFilterColumns(String content, String filterColumnsKey) {
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        int batchsize = 0;
        ArrayList<Map<String, Object>> cacheFilterColumns = new ArrayList<Map<String, Object>>();
        if (content != null) {
            batchsize = Integer.parseInt(content);
        }
        if (batchsize > 0) {
            for (int i = 1; i <= batchsize; ++i) {
                cacheFilterColumns.addAll(SerializationUtils.fromJsonStringToList((String)pageCache.get(filterColumnsKey + "_" + i), Map.class));
            }
        }
        return cacheFilterColumns;
    }

    public FilterGridState getFilterGridState() {
        if (this.filterGridState == null) {
            this.filterGridState = this.loadFilterGridState();
        }
        return this.filterGridState;
    }

    public void f7Click(String entityId, String fieldName, String compareTypeId, int clientType, int rowIndex) {
        QFilter qFilter;
        QFilter mainOrgFilter;
        FilterGridF7ClickEvent f7ClickEvent = new FilterGridF7ClickEvent(this, fieldName);
        f7ClickEvent.setF7ClickArgs(entityId, compareTypeId, clientType, rowIndex);
        for (FilterGridF7ClickListener filterGridF7ClickConsumer : this.filterGridF7ClickListeners) {
            filterGridF7ClickConsumer.filterGridF7Click(f7ClickEvent);
        }
        if (f7ClickEvent.isCancel()) {
            return;
        }
        MainEntityType mainType = StringUtils.isBlank((CharSequence)f7ClickEvent.getEntityNumber()) ? this.getMainEntityType() : EntityMetadataCache.getDataEntityType((String)f7ClickEvent.getEntityNumber());
        FilterField filterField = this.getFilterField(fieldName, mainType);
        if (filterField == null) {
            KDBizException e = new KDBizException(BosErrorCode.fieldNotExist, new Object[]{mainType.getName(), String.format(ResManager.loadKDString((String)"%1$s\uff0c\u9519\u8bef\u4ee3\u7801: %2$s", (String)"FilterGrid_1", (String)"bos-form-metadata", (Object[])new Object[0]), fieldName, "FIELDNOTEXISTS000014")});
            HashMap<String, Object> tags = new HashMap<String, Object>(2);
            tags.put("mainEntityType", mainType);
            tags.put(FIELD_NAME, fieldName);
            EntityTracer.throwException((String)SPAN_TYPE_FILTERGRID, (String)"f7Click", null, (Throwable)e, tags);
            throw e;
        }
        if (filterField != null && filterField.getLatestParent() instanceof RefBillProp) {
            this.showRefBillF7Form(fieldName, true, true, null, "setF7Value", -1, -1, filterField);
            return;
        }
        String refEntityId = this.getF7RefEntityId(filterField, entityId, rowIndex);
        IBasedataField basedataProp = (IBasedataField)filterField.getLatestParent();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        IDataEntityType parent = ((IDataEntityProperty)basedataProp).getParent();
        if (EntityTypeUtil.isMainOrgProp((IDataEntityProperty)((IDataEntityProperty)basedataProp)) && parent instanceof BillEntityType && (mainOrgFilter = PermissionFilterUtil.getMainOrgFilter((IBasedataField)basedataProp, (String)parent.getName(), (String)"", null, (String)"", (int)-1, (String)"47150e89000000ac")) != null) {
            qFilters.add(mainOrgFilter);
        }
        int index = 0;
        ArrayList<Object> filterValues = new ArrayList<Object>(10);
        boolean isSelectedId = false;
        for (Map<String, Object> map : this.loadPostDataCache()) {
            String postFieldName = (String)map.get(FIELD_NAME);
            List valueList = (List)map.get(VALUE);
            Object baseDataIds = map.get("baseDataIds");
            if (index == rowIndex && fieldName.equals(postFieldName)) {
                if (baseDataIds != null && !((List)baseDataIds).isEmpty()) {
                    isSelectedId = true;
                    for (Object object : (List)baseDataIds) {
                        if (object == null || !StringUtils.isNotEmpty((CharSequence)object.toString())) continue;
                        filterValues.add(object);
                    }
                } else {
                    for (Object filterValue : valueList) {
                        if (filterValue == null || !StringUtils.isNotEmpty((CharSequence)filterValue.toString())) continue;
                        filterValues.add(filterValue);
                    }
                }
                break;
            }
            ++index;
        }
        BeforeFilterF7SelectEvent evt = new BeforeFilterF7SelectEvent(refEntityId, filterField.getRefPropKey(), filterField.getCompareType(compareTypeId).isMulti(), fieldName, new Object[0], qFilters);
        evt.setRowIndex(rowIndex);
        for (BeforeFilterF7SelectListener l : this.beforeF7SelectListeners) {
            l.beforeF7Select(evt);
        }
        if (evt.isCancel()) {
            return;
        }
        ListShowParameter para = evt.isMulti() ? CoreShowFormHelper.createShowListForm(evt.getRefEntityId(), true) : CoreShowFormHelper.createShowListForm(evt.getRefEntityId(), false);
        para.setUseOrgId(evt.getUseOrgId());
        para.setCustomParams(evt.getCustomParams());
        if (basedataProp instanceof OrgProp) {
            String string = ((OrgProp)basedataProp).getOrgFunc();
            if (string == null) {
                para.setCustomParam("islockfunc", false);
            } else {
                para.setCustomParam("islockfunc", true);
                para.setCustomParam("orgFuncId", string);
            }
        }
        if ((qFilter = PermissionFilterUtil.getApprovedFilter((EntityType)EntityMetadataCache.getDataEntityType((String)entityId))) != null) {
            qFilters.add(qFilter);
        }
        if (!filterValues.isEmpty()) {
            if (isSelectedId) {
                para.setSelectedRows(filterValues.toArray(new Object[0]));
            } else {
                para.setSelectedRowCondition(new SelectedRowCondition(filterValues, filterField.getRefPropKey()));
            }
        }
        para.getListFilterParameter().setQFilters(evt.getMergeQFilters());
        para.setF7ClickByFilter(true);
        Object showDisabledCheckbox = evt.getCustomParams().get("showDisabledCheckbox");
        if (showDisabledCheckbox != null && "false".equals(showDisabledCheckbox.toString())) {
            para.setF7ClickByFilter(false);
        }
        CloseCallBack closeCallBack = new CloseCallBack();
        closeCallBack.setControlKey(this.getKey());
        closeCallBack.setActionId(evt.getRefEntityId() + "$" + clientType + "$" + rowIndex + "$" + evt.getRefPropKey() + "$" + fieldName + "$" + (f7ClickEvent.getEntityNumber() == null ? "" : f7ClickEvent.getEntityNumber()));
        para.setCloseCallBack(closeCallBack);
        this.view.showForm(para);
    }

    private FilterField getFilterField(String fieldName, MainEntityType mainType) {
        FilterField filterField = FilterField.create((MainEntityType)mainType, (String)fieldName);
        if (filterField == null) {
            filterField = this.getFlexFilterField(fieldName, mainType);
        }
        return filterField;
    }

    private String getF7RefEntityId(FilterField filterField, String defEntityId, int rowIndex) {
        String refEntityId = defEntityId;
        if (filterField.getSrcFieldProp() instanceof ItemClassProp) {
            ItemClassProp itemClassProp = (ItemClassProp)filterField.getSrcFieldProp();
            FilterGridState myFilterGridState = this.getFilterGridState();
            if (myFilterGridState != null && myFilterGridState.getFilterCondition() != null && myFilterGridState.getFilterCondition().getFilterRow() != null) {
                String value;
                SimpleFilterRow row;
                int i;
                for (i = rowIndex - 1; i >= 0; --i) {
                    if (i >= myFilterGridState.getFilterCondition().getFilterRow().size() || !StringUtils.equals((CharSequence)String.valueOf((row = (SimpleFilterRow)myFilterGridState.getFilterCondition().getFilterRow().get(i)).getFieldName()), (CharSequence)itemClassProp.getTypePropName()) || !StringUtils.isNotBlank((CharSequence)(value = String.valueOf(((FilterValue)row.getValue().get(0)).getValue())))) continue;
                    refEntityId = value;
                    return refEntityId;
                }
                for (i = rowIndex + 1; i < myFilterGridState.getFilterCondition().getFilterRow().size(); ++i) {
                    row = (SimpleFilterRow)myFilterGridState.getFilterCondition().getFilterRow().get(i);
                    if (!StringUtils.equals((CharSequence)String.valueOf(row.getFieldName()), (CharSequence)itemClassProp.getTypePropName()) || !StringUtils.isNotBlank((CharSequence)(value = String.valueOf(((FilterValue)row.getValue().get(0)).getValue())))) continue;
                    refEntityId = value;
                    return refEntityId;
                }
            }
        }
        return refEntityId;
    }

    @SdkInternal
    public void ShowTextForm() {
    }

    @Override
    @SdkInternal
    public void bindData(BindingContext bctx) {
        MainEntityType mainEntityType = this.getMainEntityType();
        this.setFilterMetaData(conditions -> {
            for (Map condition : conditions) {
                DynamicProperty prop = mainEntityType.getProperty((String)condition.get(FIELD_NAME));
                if (!(prop instanceof DateTimeProp)) continue;
                condition.put("today", prop instanceof DateProp ? KDDateUtils.today() : KDDateUtils.now());
            }
        });
        super.bindData(bctx);
    }

    private void closeCallBackForText(ClosedCallBackEvent e, String[] actionIds) {
        Object value = e.getReturnData();
        int rowIndex = Integer.parseInt(actionIds[1]);
        String fieldName = actionIds[2];
        IClientViewProxy viewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap<String, Object> clientMeta = new HashMap<String, Object>();
        clientMeta.put(FIELD_NAME, fieldName);
        clientMeta.put("rowIndex", rowIndex);
        value = this.convertMultiValueToArray(value);
        clientMeta.put(VALUE, value);
        viewProxy.invokeControlMethod(this.key, "setFieldValue", clientMeta);
    }

    private Object convertMultiValueToArray(Object value) {
        if (value == null || "".equals(value.toString().trim())) {
            return "";
        }
        String s = value.toString().trim();
        s = s.replaceAll(",", "\n");
        String[] array = s.split("\n");
        return array;
    }

    private void closeCallBackForBaseData(ClosedCallBackEvent e, String[] actionIds) {
        if (!(e.getReturnData() instanceof ListSelectedRowCollection)) {
            return;
        }
        String methodName = "setF7Value";
        ListSelectedRowCollection rows = (ListSelectedRowCollection)e.getReturnData();
        if (rows == null) {
            return;
        }
        String entityId = actionIds[0];
        int clientType = Integer.parseInt(actionIds[1]);
        int rowIndex = Integer.parseInt(actionIds[2]);
        String fieldKey = actionIds[3];
        String fieldName = actionIds[4];
        String selfEntityNumber = null;
        if (actionIds.length >= 6) {
            selfEntityNumber = actionIds[5];
        }
        FilterGridF7CloseCallBackEvent f7CloseCallBackEvent = new FilterGridF7CloseCallBackEvent(this, fieldName);
        f7CloseCallBackEvent.setRows(rows);
        f7CloseCallBackEvent.setActionIds(actionIds);
        for (FilterGridF7CloseCallBackListener filterGridF7ClickConsumer : this.filterGridF7CloseCallBackListeners) {
            filterGridF7ClickConsumer.filterGridF7CloseCallBack(f7CloseCallBackEvent);
        }
        if (f7CloseCallBackEvent.isCancel()) {
            HashMap<String, Object> clientMeta = new HashMap<String, Object>();
            clientMeta.put(FIELD_NAME, fieldName);
            clientMeta.put("clientType", clientType);
            clientMeta.put("rowIndex", rowIndex);
            if (!f7CloseCallBackEvent.getValues().isEmpty()) {
                clientMeta.put(VALUE, f7CloseCallBackEvent.getValues());
            }
            IClientViewProxy viewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            viewProxy.invokeControlMethod(this.getKey(), methodName, clientMeta);
            return;
        }
        MainEntityType dataEntityType = StringUtils.isEmpty((CharSequence)selfEntityNumber) ? this.getMainEntityType() : EntityMetadataCache.getDataEntityType((String)selfEntityNumber);
        String mainOrgKey = dataEntityType.getMainOrg();
        if (StringUtils.isNotBlank((CharSequence)mainOrgKey) && StringUtils.isNotBlank((CharSequence)fieldName) && mainOrgKey.equalsIgnoreCase(fieldName.split("\\.")[0])) {
            Object[] pkIds = rows.getPrimaryKeyValues();
            this.setFilterMetaData(conditions -> {
                for (Map condition : conditions) {
                    DynamicProperty prop = dataEntityType.getProperty((String)condition.get(FIELD_NAME));
                    if (!(prop instanceof DateTimeProp)) continue;
                    DateTimeProp datetimeProp = (DateTimeProp)prop;
                    HashSet<String> utc = new HashSet<String>();
                    if (pkIds != null && pkIds.length > 0 && InteTimeZone.TransType.get((int)datetimeProp.getTimeZoneTransType()) == InteTimeZone.TransType.OrgTimeZone) {
                        for (Object orgId : pkIds) {
                            InteTimeZone zone = datetimeProp.getTimeZone((Long)orgId);
                            utc.add(zone.getTimeZoneDesc());
                        }
                        if (utc.size() == 1) {
                            condition.put("timeZone", utc.iterator().next());
                        } else {
                            condition.put("timeZone", "");
                            if (utc.size() > 1) {
                                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u5b58\u5728\u65f6\u533a\u8f6c\u6362\u7c7b\u578b\u4e3a\u7ec4\u7ec7\u65f6\u533a\u7684\u957f\u65e5\u671f\u5b57\u6bb5\u65f6\uff0c\u8fc7\u6ee4\u6761\u4ef6\u53ea\u80fd\u9009\u62e9\u540c\u4e00\u65f6\u533a\u7684\u7ec4\u7ec7\uff01", (String)"FilterGrid_2", (String)"bos-form-metadata", (Object[])new Object[0]));
                            }
                        }
                    }
                    condition.put("today", prop instanceof DateProp ? KDDateUtils.today() : KDDateUtils.now());
                }
            });
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityId);
        SimpleBaseData simpleBaseData = SimpleBaseData.loadSimpleBaseDataWithPkToName((BasedataEntityType)entityType, rows, fieldKey, dataEntityType, fieldName);
        MessageProxy.sendBaseDataSetValueAction(this.getKey(), fieldName, this.getView(), clientType, rowIndex, methodName, simpleBaseData.getIds(), simpleBaseData.getValues());
    }

    @Override
    @SdkInternal
    public void closedCallBack(ClosedCallBackEvent e) {
        String[] actionIds = e.getActionId().split("\\$");
        if ("text".equals(actionIds[0])) {
            this.closeCallBackForText(e, actionIds);
        } else if (REF_BILL_CALLBACK_PREFIX.equalsIgnoreCase(actionIds[0])) {
            this.closeCallBackForRefBill(e, actionIds);
        } else {
            this.closeCallBackForBaseData(e, actionIds);
        }
    }

    public void fieldValueClick(String entityId, String fieldName, String compareTypeId, int clientType, int rowIndex) {
        MainEntityType entityType;
        if (entityId == null) {
            entityId = "bos_multitext";
        }
        if ((entityType = this.getMainEntityType()) == null) {
            throw new KDBizException(BosErrorCode.fieldNotExist, new Object[]{entityType, entityType});
        }
        FilterField filterColumn = FilterField.create((MainEntityType)entityType, (String)fieldName);
        if (filterColumn == null) {
            KDBizException e = new KDBizException(BosErrorCode.fieldNotExist, new Object[]{entityType.getName(), fieldName});
            HashMap<String, String> tags = new HashMap<String, String>(2);
            tags.put(FIELD_NAME, fieldName);
            tags.put("entityType", (String)entityType);
            EntityTracer.throwException((String)SPAN_TYPE_FILTERGRID, (String)"fieldValueClick", null, (Throwable)e, tags);
            throw e;
        }
        if ("text".equals(filterColumn.getFilterControlType())) {
            Object value = this.getValueByFieldName(fieldName, this.loadPostDataCache(), rowIndex);
            FormShowParameter lsp = new FormShowParameter();
            lsp.setFormId(entityId);
            lsp.getOpenStyle().setShowType(ShowType.Modal);
            lsp.setCustomParam("params", value);
            lsp.setCaption(filterColumn.getCaption().toString());
            CloseCallBack closeCallBack = new CloseCallBack();
            closeCallBack.setControlKey(this.getKey());
            closeCallBack.setActionId(filterColumn.getFilterControlType() + "$" + rowIndex + "$" + fieldName);
            lsp.setCloseCallBack(closeCallBack);
            this.view.showForm(lsp);
        }
    }

    private Object getValueByFieldName(String fieldName, List<Map<String, Object>> filter, int rowindex) {
        Object value = "";
        if (filter == null) {
            return "";
        }
        int index = 0;
        for (int i = 0; i < filter.size(); ++i) {
            Map<String, Object> map = filter.get(i);
            if (map.get(FIELD_NAME).equals(fieldName) && index == rowindex) {
                value = map.get(VALUE);
                break;
            }
            ++index;
        }
        return value;
    }

    private void showRefBillF7Form(String fieldName, boolean isMulti, boolean isLookUP, List<String> selectedIds, String clientMethodName, int clientType, int rowIndex, FilterField filterField) {
        RefBillProp refBillProp = (RefBillProp)filterField.getLatestParent();
        RefEntityType refEntityType = (RefEntityType)refBillProp.getComplexType();
        String refEntityId = refEntityType.getName();
        ListShowParameter para = new ListShowParameter();
        para.setBillFormId(refEntityId);
        if (isLookUP) {
            para.setLookUp(true);
            para.getOpenStyle().setShowType(ShowType.Modal);
            StyleCss css = new StyleCss();
            css.setWidth("960px");
            css.setHeight("580px");
            para.getOpenStyle().setInlineStyleCss(css);
            para.setF7Style(2);
        }
        para.setFormId("bos_listf7");
        FormConfig listFormConfig = FormMetadataCache.getListFormConfig(refEntityId);
        para.setCaption(listFormConfig.getCaption().toString());
        para.setMultiSelect(isMulti);
        para.setShowTitle(false);
        para.setHasRight(true);
        para.setShowUsed(false);
        para.setShowApproved(true);
        if (!refBillProp.isShowOnlyAudited()) {
            para.setF7ClickByFilter(true);
        }
        if (selectedIds != null && selectedIds.size() > 0) {
            if (refEntityType.getPrimaryKey() instanceof LongProp) {
                ArrayList<Long> pkIds = new ArrayList<Long>(selectedIds.size());
                for (String selectedId : selectedIds) {
                    long pkId = StringUtils.isBlank((CharSequence)selectedId) ? 0L : Long.parseLong(selectedId);
                    pkIds.add(pkId);
                }
                para.setSelectedRows(pkIds.toArray());
            } else {
                para.setSelectedRows(selectedIds.toArray());
            }
        }
        CloseCallBack closeCallBack = new CloseCallBack();
        closeCallBack.setControlKey(this.getKey());
        String refPropKey = filterField.getRefPropKey();
        closeCallBack.setActionId("RefBill$" + refEntityId + "$" + clientType + "$" + rowIndex + "$" + refPropKey + "$" + clientMethodName + "$" + fieldName);
        para.setCloseCallBack(closeCallBack);
        this.getView().showForm(para);
    }

    private void closeCallBackForRefBill(ClosedCallBackEvent e, String[] actionIds) {
        if (!(e.getReturnData() instanceof ListSelectedRowCollection)) {
            return;
        }
        int clientType = Integer.parseInt(actionIds[2]);
        int rowIndex = Integer.parseInt(actionIds[3]);
        String fieldKey = actionIds[4];
        String clientMethodName = actionIds[5];
        String fieldName = actionIds[6];
        ListSelectedRowCollection rows = (ListSelectedRowCollection)e.getReturnData();
        if (rows == null) {
            return;
        }
        if (rows.isClearFlag()) {
            MessageProxy.sendBaseDataSetValueAction(this.getKey(), fieldName, this.getView(), clientType, rowIndex, clientMethodName, new ArrayList<String>(), new ArrayList<Object>());
            return;
        }
        BillEntityType billEntityType = (BillEntityType)EntityMetadataCache.getDataEntityType((String)actionIds[1]);
        if ("setCommonF7Value".equals(clientMethodName)) {
            MessageProxy.sendRefBillSetValueAction(this.getKey(), fieldKey, fieldName, billEntityType, rows, this.getView(), clientType, rowIndex, clientMethodName);
        } else {
            ArrayList<Object> pkValues = new ArrayList<Object>();
            if (!rows.isEmpty()) {
                for (ListSelectedRow row : rows) {
                    pkValues.add(row.getPrimaryKeyValue());
                }
            }
            Map mapObjects = this.getModel().loadReferenceDataBatch((DynamicObjectType)billEntityType, pkValues.toArray(new Object[0]));
            ArrayList<String> ids = new ArrayList<String>(10);
            for (DynamicObject entry : mapObjects.values()) {
                ids.add(entry.getPkValue().toString());
            }
            IDataEntityProperty property = billEntityType.findProperty(fieldKey);
            if (property == null) {
                property = billEntityType.getProperty(billEntityType.getBillNo());
            }
            ArrayList<Object> values = new ArrayList<Object>();
            if (property != null) {
                for (DynamicObject entry : mapObjects.values()) {
                    Object value = property.getValue((Object)entry);
                    if (value == null) continue;
                    values.add(value.toString());
                }
            }
            MessageProxy.sendBaseDataSetValueAction(this.getKey(), fieldName, this.getView(), clientType, rowIndex, clientMethodName, ids, values);
        }
    }

    public static class FilterGridState {
        private String key;
        private FilterCondition filterCondition;

        public FilterGridState(String key, FilterCondition filterCondition) {
            this.key = key;
            this.filterCondition = filterCondition;
        }

        public final String getKey() {
            return this.key;
        }

        public FilterCondition getFilterCondition() {
            return this.filterCondition;
        }

        public FilterCondition setState(FilterCondition filterCondition) {
            this.filterCondition = filterCondition;
            return this.filterCondition;
        }

        public void put(SimpleFilterRow simpleFilterRow) {
            this.filterCondition.addFilterRow(simpleFilterRow);
        }
    }
}

