/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.control;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.decode.DecodeHandlerFactory;
import kd.bos.exception.KDBizException;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.DesignerBarListener;
import kd.bos.form.control.DesignerCallListener;
import kd.bos.form.control.FormDesigner;
import kd.bos.form.control.events.DesignerBarAction;
import kd.bos.form.control.events.DesignerBarEvent;
import kd.bos.form.control.events.DesignerCallEvent;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;

@KSObject
public class ProFormDesigner
extends FormDesigner {
    private List<DesignerBarListener> barListeners = new ArrayList<DesignerBarListener>();
    private List<DesignerCallListener> callListeners = new ArrayList<DesignerCallListener>();
    public static final String METAMENUID = "metaMenuId";
    private static final String CALL_ACTION_PARSE_RISE_EVENT_TYPES = "parseRiseEventTypes";
    private static final String CALL_ACTION_PARSE_RISE_EVENT_VALUES = "parseRiseEventValues";
    private static final String CALL_ACTION_SHOW_FUNCTION_SETTING = "showFunctionSetting";
    private static final String CALL_ACTION_SHOW_CUSTOM_RULE_SERVICE_SETTING = "showCustomRuleServiceSetting";
    private static final String VALIDATE_FORMULA = "validateFormula";

    public void addBarListener(DesignerBarListener barListener) {
        this.barListeners.add(barListener);
    }

    public void addCallListener(DesignerCallListener callListener) {
        this.callListeners.add(callListener);
    }

    public void designerTypeChange(String key) {
        if (this.barListeners != null) {
            DesignerBarEvent e = new DesignerBarEvent();
            e.setActionId(DesignerBarAction.Change);
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("key", key);
            e.setBarItemKey(key);
            e.setParam(param);
            for (DesignerBarListener l : this.barListeners) {
                l.designerTypeChange(e);
            }
        }
    }

    public void designerBarClick(String key) {
        this.designerBarClick(key, "");
    }

    public void designerBarClick(String key, String formType) {
        if (this.barListeners != null) {
            DesignerBarEvent e = new DesignerBarEvent();
            e.setActionId(DesignerBarAction.Click);
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("batItemKey", key);
            param.put(METAMENUID, formType);
            e.setBarItemKey(key);
            e.setParam(param);
            for (DesignerBarListener l : this.barListeners) {
                l.designerBarClick(e);
            }
        }
    }

    @Deprecated
    public void designerBarClickBefore(String key) {
        this.designerBarClickBefore(key, "");
    }

    public void designerBarClickBefore(String key, String formType) {
        if (this.barListeners != null) {
            DesignerBarEvent e = new DesignerBarEvent();
            e.setActionId(DesignerBarAction.Click);
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("barItemKey", key);
            param.put(METAMENUID, formType);
            param.put("isBeforeClick", true);
            e.setBarItemKey(key);
            e.setParam(param);
            for (DesignerBarListener l : this.barListeners) {
                l.beforeDesignerBarClick(e);
            }
        }
    }

    public void openLayoutList() {
        if (this.barListeners != null) {
            DesignerBarEvent e = new DesignerBarEvent();
            e.setActionId(DesignerBarAction.OpenLayoutList);
            for (DesignerBarListener l : this.barListeners) {
                l.designerBarClick(e);
            }
        }
    }

    public void setProFormDesignerBar(Map<String, Object> properties) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "setProFormDesignerBar", properties);
    }

    public void setFocusDesignerBarPage(String pageId) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "setProformdesignerVisibleId ", pageId);
    }

    @Override
    @Deprecated
    public void open(String modelType, Map<String, Object> doc) {
        throw new KDBizException("error designer data");
    }

    public void open(String modelType, List<Map<String, Object>> doc) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.key, "open", modelType, true, doc);
    }

    @Override
    public void resetSideBar(String[] items) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "resetSideBar", Arrays.asList(items).toArray(new Object[items.length]));
    }

    public void parseRiseEventTypes(List<Map<String, Object>> rets) {
        if (this.callListeners != null) {
            DesignerCallEvent e = new DesignerCallEvent();
            e.setActionId(CALL_ACTION_PARSE_RISE_EVENT_TYPES);
            e.setParam(rets);
            for (DesignerCallListener l : this.callListeners) {
                l.doCall(e);
            }
        }
    }

    public void parseRiseEventValues(List<Map<String, List<String>>> data) {
        if (this.callListeners != null) {
            DesignerCallEvent e = new DesignerCallEvent();
            e.setActionId(CALL_ACTION_PARSE_RISE_EVENT_VALUES);
            e.setParam(data);
            for (DesignerCallListener l : this.callListeners) {
                l.doCall(e);
            }
        }
    }

    @KSMethod
    public void showFunctionSetting(String fuctionId, String fieldTreeStr) {
        if (this.callListeners != null) {
            DesignerCallEvent e = new DesignerCallEvent();
            e.setActionId(CALL_ACTION_SHOW_FUNCTION_SETTING);
            HashMap<String, String> param = new HashMap<String, String>(2);
            param.put("fuctionId", fuctionId);
            param.put("fieldTreeStr", fieldTreeStr);
            e.setParam(param);
            for (DesignerCallListener l : this.callListeners) {
                l.doCall(e);
            }
        }
    }

    @KSMethod
    public void showCustomRuleServiceSetting(String param) {
        if (this.callListeners != null) {
            DesignerCallEvent e = new DesignerCallEvent();
            e.setActionId(CALL_ACTION_SHOW_CUSTOM_RULE_SERVICE_SETTING);
            e.setParam(param);
            for (DesignerCallListener l : this.callListeners) {
                l.doCall(e);
            }
        }
    }

    @KSMethod
    public void validateFormula(String formula) {
        if (this.callListeners != null) {
            DesignerCallEvent e = new DesignerCallEvent();
            String type = this.getView().getFormShowParameter().getFormConfig().getKdEncoding();
            formula = String.valueOf(DecodeHandlerFactory.getDecodeHandler(type).decode(formula));
            e.setActionId(VALIDATE_FORMULA);
            e.setParam(formula);
            for (DesignerCallListener l : this.callListeners) {
                l.doCall(e);
            }
        }
    }

    public void refreshEntityData() {
        if (this.callListeners != null) {
            DesignerCallEvent e = new DesignerCallEvent();
            e.setActionId("refreshEntityData");
            for (DesignerCallListener l : this.callListeners) {
                l.doCall(e);
            }
        }
    }
}

