/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.control;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.form.container.Container;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.script.annotations.KSMethod;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class Search
extends Container {
    private static final String SPAN_TYPE_PLUGIN = "plugin";
    private int showModel;
    @SdkInternal
    protected List<SearchEnterListener> searchEnterListeners = new ArrayList<SearchEnterListener>();
    @SdkInternal
    protected List<ItemClickListener> itemClickListeners = new ArrayList<ItemClickListener>();

    @SimplePropertyAttribute(name="ShowModel")
    public int getShowModel() {
        return this.showModel;
    }

    @SdkInternal
    public void setShowModel(int showModel) {
        this.showModel = showModel;
    }

    @Override
    @KSMethod
    public void addClickListener(ClickListener listener) {
        super.addClickListener(listener);
    }

    public void addEnterListener(SearchEnterListener listener) {
        this.searchEnterListeners.add(listener);
    }

    @Override
    @KSMethod
    public void addItemClickListener(ItemClickListener listener) {
        this.itemClickListeners.add(listener);
    }

    @Override
    @SdkInternal
    public void click() {
        super.click();
    }

    @SdkInternal
    public void itemClick(Map<String, Object> args) {
        ItemClickEvent event = new ItemClickEvent(this, args);
        for (ItemClickListener listener : this.itemClickListeners) {
            EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(listener.getClass().getName() + ".itemClick"));
            Throwable throwable = null;
            try {
                listener.itemClick(event);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (span == null) continue;
                if (throwable != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                span.close();
            }
        }
    }

    @SdkInternal
    public void search(List<?> args) {
        if (args == null) {
            return;
        }
        SearchEnterEvent event = null;
        event = args.isEmpty() ? new SearchEnterEvent((Object)this, "") : (args.get(0) instanceof String ? new SearchEnterEvent((Object)this, (String)((Object)args.get(0))) : new SearchEnterEvent((Object)this, args));
        for (SearchEnterListener listener : this.searchEnterListeners) {
            EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(listener.getClass().getName() + ".search"));
            Throwable throwable = null;
            try {
                listener.search(event);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (span == null) continue;
                if (throwable != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                span.close();
            }
        }
    }

    @SdkInternal
    @KSMethod
    public void getSearchResultList(String args) {
        SearchEnterEvent event = new SearchEnterEvent((Object)this, args);
        for (SearchEnterListener listener : this.searchEnterListeners) {
            if (this.getShowModel() == 3) {
                this.clientViewProxy.invokeControlMethod(this.key, "setAutoCompleteItems", listener.getComPlexSearchList(event));
                continue;
            }
            this.clientViewProxy.invokeControlMethod(this.key, "setAutoCompleteItems", listener.getSearchList(event));
        }
    }

    @KSMethod
    public String getSearchKey() {
        return (String)this.clientViewProxy.getViewState(this.getKey());
    }

    @KSMethod
    public void setSearchKey(String text) {
        super.postBack(text);
        this.clientViewProxy.setFieldProperty(this.getKey(), "v", text);
    }
}

