/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.control;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.SegmentedControlSelectEvent;
import kd.bos.form.control.events.SegmentedControlSelectListener;
import kd.bos.script.annotations.KSMethod;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class SegmentedControl
extends Control {
    private static final String SPAN_TYPE_PLUGIN = "plugin";
    private List<SegmentedControlSelectListener> segmentedControlSelectListeners;

    @KSMethod
    public void addSegmentedControlSelectListener(SegmentedControlSelectListener listener) {
        if (this.segmentedControlSelectListeners == null) {
            this.segmentedControlSelectListeners = new ArrayList<SegmentedControlSelectListener>(10);
        }
        this.segmentedControlSelectListeners.add(listener);
    }

    @SdkInternal
    @KSMethod
    public void selectSegment(String segmentKey) {
        SegmentedControlSelectEvent event = new SegmentedControlSelectEvent(this, segmentKey);
        if (this.segmentedControlSelectListeners != null) {
            for (SegmentedControlSelectListener listener : this.segmentedControlSelectListeners) {
                EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(listener.getClass().getName() + ".segmentedControlSelected"));
                Throwable throwable = null;
                try {
                    listener.segmentedControlSelected(event);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (span == null) continue;
                    if (throwable != null) {
                        try {
                            span.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    span.close();
                }
            }
        }
    }

    @KSMethod
    public void setActiveSegment(String segmentKey) {
        IClientViewProxy proxy = (IClientViewProxy)this.view.getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "setActiveSegment", segmentKey);
    }
}

