/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.control;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.SliderEvent;
import kd.bos.form.control.events.SliderListener;
import kd.bos.script.annotations.KSMethod;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class Slider
extends Control {
    private static final String SPAN_TYPE_PLUGIN = "plugin";
    private List<SliderListener> sliderListeners;

    @KSMethod
    public void addSliderListener(SliderListener listener) {
        if (this.sliderListeners == null) {
            this.sliderListeners = new ArrayList<SliderListener>();
        }
        this.sliderListeners.add(listener);
    }

    @KSMethod
    public void setSliderMarks(Map<String, Map<String, Object>> markMap) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "setSliderMarks", markMap);
    }

    @KSMethod
    public void setSliderValue(Number v1, Number v2) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.invokeControlMethod(this.getKey(), "setSliderValue", v1, v2);
    }

    @SdkInternal
    @KSMethod
    public void updateSliderValue(Number v1, Number v2) {
        SliderEvent event = new SliderEvent(this);
        event.setValue(new Number[]{v1, v2});
        if (this.sliderListeners != null) {
            for (SliderListener l : this.sliderListeners) {
                EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(l.getClass().getName() + ".update"));
                Throwable throwable = null;
                try {
                    l.update(event);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (span == null) continue;
                    if (throwable != null) {
                        try {
                            span.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    span.close();
                }
            }
        }
    }
}

