/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.control;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.OperationColumn;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.field.FieldEdit;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.util.CollectionUtils;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public class TreeEntryGrid
extends EntryGrid {
    private static final String SPAN_TYPE_PLUGIN = "plugin";
    protected List<TreeNodeQueryListener> treeNodeQueryListeners;

    @KSMethod
    public void addCellClickListener(TreeNodeQueryListener listener) {
        if (this.treeNodeQueryListeners == null) {
            this.treeNodeQueryListeners = new ArrayList<TreeNodeQueryListener>();
        }
        this.treeNodeQueryListeners.add(listener);
    }

    @KSMethod
    public void queryTreeNodeChildren() {
        TreeNodeEvent evt = new TreeNodeEvent(this);
        if (this.treeNodeQueryListeners != null) {
            for (TreeNodeQueryListener l : this.treeNodeQueryListeners) {
                EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(l.getClass().getName() + ".queryTreeNodeChildren"));
                Throwable throwable = null;
                try {
                    l.queryTreeNodeChildren(evt);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (span == null) continue;
                    if (throwable != null) {
                        try {
                            span.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    span.close();
                }
            }
        }
    }

    @Override
    public Map<String, Integer> getDataIndex() {
        if (this.dataIndex == null) {
            this.dataIndex = new HashMap();
            this.dataIndex.put("rk", 0);
            this.dataIndex.put("seq", 1);
            this.dataIndex.put("id", 2);
            this.dataIndex.put("pid", 3);
            this.dataIndex.put("isgroupnode", 4);
            int i = 5;
            for (Control ctl : this.getControls()) {
                if (ctl instanceof FieldEdit) {
                    FieldEdit edit = (FieldEdit)ctl;
                    this.dataIndex.put(edit.getKey(), i);
                    ++i;
                    continue;
                }
                if (!(ctl instanceof OperationColumn)) continue;
                this.dataIndex.put(ctl.getKey(), i);
                ++i;
            }
            this.dataIndex.put("l", i);
            this.dataIndex.put("s", i + 1);
            this.dataIndex.put("vi", i + 2);
            this.dataIndex.put("cprop", i + 3);
        }
        return this.dataIndex;
    }

    @Override
    @KSMethod
    public void setCollapse(boolean isCollapse) {
        if (isCollapse) {
            this.clientViewProxy.invokeControlMethod(this.getKey(), "collapseAllNode", new Object[]{new int[0]});
        } else {
            this.clientViewProxy.invokeControlMethod(this.getKey(), "expandAllNode", new Object[]{new int[0]});
        }
    }

    @KSMethod
    public void collapse(int[] rows) {
        this.clientViewProxy.invokeControlMethod(this.getKey(), "collapseAllNode", new Object[]{rows});
    }

    @KSMethod
    public void collapseOne(int row) {
        this.collapseOne(new int[]{row});
    }

    @KSMethod
    public void collapseOne(int[] rows) {
        this.clientViewProxy.invokeControlMethod(this.getKey(), "collapseNode", new Object[]{rows});
    }

    @KSMethod
    public void collapse(int row) {
        this.collapse(new int[]{row});
    }

    @KSMethod
    public void expand(int[] rows) {
        this.clientViewProxy.invokeControlMethod(this.getKey(), "expandAllNode", new Object[]{rows});
    }

    @KSMethod
    public void expand(int row) {
        this.expand(new int[]{row});
    }

    @KSMethod
    public void expandOne(int row) {
        this.expandOne(new int[]{row});
    }

    @KSMethod
    public void expandOne(int[] rows) {
        this.clientViewProxy.invokeControlMethod(this.getKey(), "expandNode", new Object[]{rows});
    }

    @KSMethod
    public void focus(int pRowKey, int rowKey) {
        this.expand(pRowKey);
        this.clientViewProxy.invokeControlMethod(this.getKey(), "selectRows", rowKey);
    }

    public void loadChildrenData(Object value) {
        TreeNodeEvent evt = new TreeNodeEvent(this);
        Map map = (Map)value;
        evt.setNodeId(map.get("id"));
        evt.setRowKey((Integer)map.get("rowkey"));
        if (this.treeNodeQueryListeners != null) {
            for (TreeNodeQueryListener l : this.treeNodeQueryListeners) {
                EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(l.getClass().getName() + ".queryTreeNodeChildren"));
                Throwable throwable = null;
                try {
                    l.queryTreeNodeChildren(evt);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (span == null) continue;
                    if (throwable != null) {
                        try {
                            span.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    span.close();
                }
            }
        }
    }

    @SdkInternal
    public void postExpandNodes(Object value) {
        this.clientViewProxy.postBack("expandNodes", value);
    }

    @SdkInternal
    public Object getExpandNodes() {
        return this.clientViewProxy.getViewState("expandNodes");
    }

    @Override
    public boolean isNeedPaged() {
        return false;
    }

    public int[] resetSelectRowIndexs(DynamicObjectCollection entryEntity, int[] rowIndexs) {
        boolean result = this.hasNotRootNode(entryEntity, rowIndexs);
        if (result) {
            rowIndexs = this.removalRepeatIndex(rowIndexs);
            this.selectRows(rowIndexs, rowIndexs[0]);
        }
        return rowIndexs;
    }

    private boolean hasNotRootNode(DynamicObjectCollection entryEntity, int[] rowIndexs) {
        if (entryEntity == null || entryEntity.size() <= 0) {
            return false;
        }
        HashMap<Object, Tuple<Object, Object>> entryMap = new HashMap<Object, Tuple<Object, Object>>(entryEntity.size());
        for (DynamicObject dynamicObject : entryEntity) {
            entryMap.put(dynamicObject.get("id"), new Tuple(dynamicObject.get("pid"), dynamicObject.get("seq")));
        }
        boolean hasNotRootNode = false;
        for (int i = 0; i < rowIndexs.length; ++i) {
            Object originateSeq;
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(rowIndexs[i]);
            Object pid = dynamicObject.get("pid");
            if (entryMap.get(pid) == null || (originateSeq = this.getOriginateSeq(entryMap, pid)) == null) continue;
            rowIndexs[i] = (Integer)originateSeq - 1;
            hasNotRootNode = true;
        }
        return hasNotRootNode;
    }

    private Object getOriginateSeq(Map<Object, Tuple<Object, Object>> entryMap, Object id) {
        Tuple<Object, Object> objectTuple = entryMap.get(id);
        if (objectTuple != null) {
            Tuple<Object, Object> twoObjectTuple = entryMap.get(objectTuple.item1);
            if (twoObjectTuple != null) {
                Object pid = twoObjectTuple.item1;
                if (pid == null || "".equals(String.valueOf(pid)) || "0".equals(String.valueOf(pid))) {
                    return twoObjectTuple.item2;
                }
                return this.getOriginateSeq(entryMap, twoObjectTuple.item1);
            }
            return objectTuple.item2;
        }
        return null;
    }

    private int[] removalRepeatIndex(int[] rowIndexs) {
        int i;
        ArrayList<Integer> resultList = new ArrayList<Integer>();
        for (i = 0; i < rowIndexs.length; ++i) {
            if (resultList.contains(rowIndexs[i])) continue;
            resultList.add(rowIndexs[i]);
        }
        if (CollectionUtils.isNotEmpty(resultList) && resultList.size() != rowIndexs.length) {
            rowIndexs = new int[resultList.size()];
            for (i = 0; i < resultList.size(); ++i) {
                rowIndexs[i] = (Integer)resultList.get(i);
            }
        }
        return rowIndexs;
    }
}

