/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.control;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.form.BindingContext;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.Control;
import kd.bos.form.control.WorkCalendarData;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ISuportClick;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.sdk.annotation.SdkPublic;

@KSObject(name="WorkCalendar")
@SdkPublic
public class WorkCalendar
extends Control
implements ISuportClick {
    private static final String SPAN_TYPE_PLUGIN = "plugin";
    protected List<ClickListener> clickListeners = new ArrayList<ClickListener>();
    protected List<ItemClickListener> itemClickListeners = new ArrayList<ItemClickListener>();
    private int year;
    private List<Map<String, String>> workDataList = null;
    private ArrayList<String> dateList = null;
    private String dateType = null;
    private String holidayColor;
    private String workDayColor;
    private String halfWorkDayColor;
    private String weekendColor;
    private boolean is_PassDayLocked;
    private String lockedDayColor;
    private boolean openPanel;
    private String today;

    @KSMethod
    public String getToday() {
        return this.today;
    }

    @KSMethod
    public void setToday(String today) {
        this.today = today;
    }

    @KSMethod
    public int getYear() {
        return this.year;
    }

    @KSMethod
    public void setYear(int year) {
        this.year = year;
    }

    @KSMethod
    public List<Map<String, String>> getWorkDataList() {
        return this.workDataList;
    }

    @KSMethod
    public void setWorkDataList(List<Map<String, String>> workDataList) {
        this.workDataList = workDataList;
    }

    @KSMethod
    public ArrayList<String> getDateList() {
        return this.dateList;
    }

    public void setDateList(ArrayList<String> dateList) {
        this.dateList = dateList;
    }

    @KSMethod
    public String getDateType() {
        return this.dateType;
    }

    public void setDateType(String dateType) {
        this.dateType = dateType;
    }

    @SimplePropertyAttribute
    @KSMethod
    public String getHolidayColor() {
        return this.holidayColor;
    }

    @KSMethod
    public void setHolidayColor(String holidayColor) {
        this.holidayColor = holidayColor;
    }

    @SimplePropertyAttribute
    @KSMethod
    public String getWorkDayColor() {
        return this.workDayColor;
    }

    @KSMethod
    public void setWorkDayColor(String workDayColor) {
        this.workDayColor = workDayColor;
    }

    @SimplePropertyAttribute
    @KSMethod
    public String getHalfWorkDayColor() {
        return this.halfWorkDayColor;
    }

    @KSMethod
    public void setHalfWorkDayColor(String halfWorkDayColor) {
        this.halfWorkDayColor = halfWorkDayColor;
    }

    @SimplePropertyAttribute
    @KSMethod
    public String getWeekendColor() {
        return this.weekendColor;
    }

    @KSMethod
    public void setWeekendColor(String weekendColor) {
        this.weekendColor = weekendColor;
    }

    @SimplePropertyAttribute
    @KSMethod
    public boolean isPassDayLocked() {
        return this.is_PassDayLocked;
    }

    @KSMethod
    public void setPassDayLocked(boolean isPassDayLocked) {
        this.is_PassDayLocked = isPassDayLocked;
    }

    @SimplePropertyAttribute
    @KSMethod
    public String getLockedDayColor() {
        return this.lockedDayColor;
    }

    @KSMethod
    public void setLockedDayColor(String lockedDayColor) {
        this.lockedDayColor = lockedDayColor;
    }

    @SimplePropertyAttribute
    @KSMethod
    public boolean isOpenPanel() {
        return this.openPanel;
    }

    @KSMethod
    public void setOpenPanel(boolean openPanel) {
        this.openPanel = openPanel;
    }

    public void setData(WorkCalendarData data) {
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        data.setWorkCalendar(this);
        clientViewProxy.setFieldProperty(this.getKey(), "data", data.toWorkCalendarData());
    }

    public void setData() {
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.setFieldProperty(this.getKey(), "data", this.getPropertiesMap());
    }

    @KSMethod
    public Map<String, Object> getPropertiesMap() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("year", this.year);
        data.put("data", this.workDataList == null ? new ArrayList(0) : this.workDataList);
        data.put("holidayColor", this.holidayColor);
        data.put("workDayColor", this.workDayColor);
        data.put("halfWorkDayColor", this.halfWorkDayColor);
        data.put("weekendColor", this.weekendColor);
        data.put("isPassDayLocked", this.is_PassDayLocked);
        data.put("lockedDayColor", this.lockedDayColor);
        data.put("openPanel", this.openPanel);
        data.put("today", this.today);
        return data;
    }

    public void setDateType(Object[] param) {
        BeforeClickEvent e = new BeforeClickEvent(this);
        this.fireBeforeClick(e);
        if (!e.isCancel()) {
            ClickEvent e1 = new ClickEvent(this);
            this.fireClick(e1);
        }
    }

    public void setDateType(ArrayList<String> dateList, Integer dateType) {
        this.setDateType(dateList, dateType.toString());
    }

    public void setDateType(ArrayList<String> dateList, String dateType) {
        BeforeClickEvent e = new BeforeClickEvent(this);
        this.setDateList(dateList);
        this.setDateType(dateType);
        this.fireBeforeClick(e);
        if (!e.isCancel()) {
            ClickEvent e1 = new ClickEvent(this);
            this.fireClick(e1);
        }
    }

    public void setDateTypeCallBack(List<String> dateList, String dateType) {
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.invokeControlMethod(this.getKey(), "setDateType", dateList, dateType);
    }

    public void sendDate(ArrayList<String> dateList) {
        BeforeClickEvent e = new BeforeClickEvent(this);
        this.setDateList(dateList);
        this.fireBeforeClick(e);
        if (!e.isCancel()) {
            ClickEvent e1 = new ClickEvent(this);
            this.fireClick(e1);
        }
    }

    @Override
    @KSMethod
    public void addClickListener(ClickListener listener) {
        this.clickListeners.add(listener);
    }

    @Override
    @KSMethod
    public void addItemClickListener(ItemClickListener listener) {
        this.itemClickListeners.add(listener);
    }

    @Override
    public void bindData(BindingContext object) {
    }

    @KSMethod
    public void click() {
        BeforeClickEvent e = new BeforeClickEvent(this);
        this.fireBeforeClick(e);
        if (!e.isCancel()) {
            ClickEvent e1 = new ClickEvent(this);
            this.fireClick(e1);
        }
    }

    @KSMethod
    public void itemClick(String id, String operationKey) {
        ItemClickEvent evt = new ItemClickEvent(this, id, operationKey);
        for (ItemClickListener l : this.itemClickListeners) {
            EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(l.getClass().getName() + ".itemClick"));
            Throwable throwable = null;
            try {
                l.itemClick(evt);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (span == null) continue;
                if (throwable != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                span.close();
            }
        }
    }

    private void fireBeforeClick(BeforeClickEvent e) {
        for (ClickListener l : this.clickListeners) {
            EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(l.getClass().getName() + ".beforeClick"));
            Throwable throwable = null;
            try {
                l.beforeClick(e);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (span == null) continue;
                if (throwable != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                span.close();
            }
        }
    }

    private void fireClick(ClickEvent e) {
        if (this.clickListeners != null) {
            for (ClickListener l : this.clickListeners) {
                EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(l.getClass().getName() + ".click"));
                Throwable throwable = null;
                try {
                    l.click(e);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (span == null) continue;
                    if (throwable != null) {
                        try {
                            span.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    span.close();
                }
            }
        }
    }
}

