/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.control.grid;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.BindingContext;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.grid.DataGridSelectedRow;
import kd.bos.form.control.grid.RowSelectAct;
import kd.bos.form.control.grid.column.DataGridColumn;
import kd.bos.form.control.grid.events.BeforeCreateDataGridColumnsEvent;
import kd.bos.form.control.grid.events.BeforeCreateDataGridColumnsListener;
import kd.bos.form.control.grid.events.DataGridBindDataEvent;
import kd.bos.form.control.grid.events.DataGridBindDataListener;
import kd.bos.form.control.grid.events.DataGridSelectRowEvent;
import kd.bos.form.control.grid.events.DataGridSelectRowListener;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public class DataGrid
extends Container {
    private static final String WIDTH = "width";
    private static final String NUMBER_FIELD = "numberfield";
    private static final String IS_COL_PAGE_FIXED = "isColPageFixed";
    private static final String ZH_CN = "zh_CN";
    private static final String DATA = "data";
    private static final String DATA_INDEX = "dataindex";
    private static final String POST_COLS = "postcols";
    private static final String ROWS = "rows";
    private boolean showSeq;
    private List<DataGridColumn> dataGridColumns = new ArrayList<DataGridColumn>();
    private List<BeforeCreateDataGridColumnsListener> beforeCreateDataGridColumnsListeners = new ArrayList<BeforeCreateDataGridColumnsListener>();
    private List<DataGridBindDataListener> bindDataListeners = new ArrayList<DataGridBindDataListener>();
    private List<DataGridSelectRowListener> selectRowListeners = new ArrayList<DataGridSelectRowListener>();
    protected List<ItemClickListener> itemClickListeners = new ArrayList<ItemClickListener>();

    @SimplePropertyAttribute(name="ShowSeq")
    public boolean isShowSeq() {
        return this.showSeq;
    }

    public void setShowSeq(boolean showSeq) {
        this.showSeq = showSeq;
    }

    @KSMethod
    public void addBeforeCreateDataGridColumnsListener(BeforeCreateDataGridColumnsListener listener) {
        this.beforeCreateDataGridColumnsListeners.add(listener);
    }

    protected void fireBeforeCreateMobTableColumns(BeforeCreateDataGridColumnsEvent event) {
        for (BeforeCreateDataGridColumnsListener listener : this.beforeCreateDataGridColumnsListeners) {
            listener.beforeCreateDataGridColumns(event);
        }
    }

    @KSMethod
    public void addBindDataListener(DataGridBindDataListener listener) {
        this.bindDataListeners.add(listener);
    }

    public List<DataGridBindDataListener> getBindDataListeners() {
        return this.bindDataListeners;
    }

    @KSMethod
    public void addSelectRowListener(DataGridSelectRowListener listener) {
        this.selectRowListeners.add(listener);
    }

    @Override
    @KSMethod
    public void addItemClickListener(ItemClickListener listener) {
        this.itemClickListeners.add(listener);
    }

    public List<DataGridColumn> getDataGridColumns() {
        return this.dataGridColumns;
    }

    @Override
    public void setView(IFormView view) {
        super.setView(view);
    }

    @Override
    public void bindData(BindingContext bctx) {
        this.renderGridColumn();
        this.bindData();
    }

    private void renderGridColumn() {
        ArrayList<Map<String, Object>> cols = new ArrayList<Map<String, Object>>();
        this.createHiddenColumn(cols);
        this.createSysInnerColumns(cols);
        for (Control ctl : this.getItems()) {
            if (!(ctl instanceof DataGridColumn)) continue;
            this.getDataGridColumns().add((DataGridColumn)ctl);
        }
        BeforeCreateDataGridColumnsEvent event = new BeforeCreateDataGridColumnsEvent(this, this.getDataGridColumns());
        this.fireBeforeCreateMobTableColumns(event);
        this.getDataGridColumns().forEach(dataGridColumn -> cols.add(dataGridColumn.createColumn()));
        HashMap<String, ArrayList<Map<String, Object>>> args = new HashMap<String, ArrayList<Map<String, Object>>>();
        args.put("columns", cols);
        this.clientViewProxy.preInvokeControlMethod(this.getKey(), "setColumns", args);
    }

    private void createSysInnerColumns(List<Map<String, Object>> cols) {
        Map<String, Object> col = this.createColumn("seq", new LocaleString(ZH_CN, ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"DataGrid_0", (String)"bos-form-metadata", (Object[])new Object[0])));
        if (!this.isShowSeq()) {
            col.put("visible", false);
        }
        col.put("type", NUMBER_FIELD);
        col.put(IS_COL_PAGE_FIXED, true);
        cols.add(col);
    }

    private void createHiddenColumn(List<Map<String, Object>> cols) {
        String colKey = "rk";
        Map<String, Object> col = this.createColumn(colKey, new LocaleString(ZH_CN, colKey));
        col.put("visible", false);
        cols.add(col);
    }

    private Map<String, Object> createColumn(String key, LocaleString caption) {
        HashMap<String, Object> col = new HashMap<String, Object>();
        col.put("dataIndex", key);
        col.put("header", caption);
        col.put(WIDTH, 50);
        return col;
    }

    public void bindData() {
        HashMap<String, Map<String, Object>> meta = new HashMap<String, Map<String, Object>>();
        meta.put(DATA, this.getData());
        this.clientViewProxy.invokeControlMethod(this.getKey(), "setData", meta);
    }

    public Map<String, Object> getData() {
        DataGridBindDataEvent event = new DataGridBindDataEvent(this, this.getDataGridColumns());
        for (DataGridBindDataListener listener : this.getBindDataListeners()) {
            listener.dataGridBindData(event);
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(POST_COLS, event.getPostCols());
        data.put(DATA_INDEX, this.getDataIndex());
        data.put(ROWS, event.getData());
        return data;
    }

    private Map<String, Integer> getDataIndex() {
        HashMap<String, Integer> dataIndex = new HashMap<String, Integer>(16);
        dataIndex.put("rk", 0);
        dataIndex.put("seq", 1);
        int i = 2;
        for (DataGridColumn dataGridColumn : this.getDataGridColumns()) {
            dataIndex.put(dataGridColumn.getKey(), i);
            ++i;
        }
        return dataIndex;
    }

    @KSMethod
    @SdkInternal
    public void itemClick(int rowKey, List<Object> postRowData, String id, String operationKey) {
        ItemClickEvent evt = new ItemClickEvent(this, id, operationKey);
        DataGridSelectedRow selectedRow = new DataGridSelectedRow(rowKey, postRowData);
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("selectedRow", selectedRow);
        evt.setParamsMap(paramsMap);
        for (ItemClickListener l : this.itemClickListeners) {
            l.itemClick(evt);
        }
    }

    public void addRowSelection(int rowKey, List<Object> postRowData) {
        DataGridSelectedRow selectedRow = new DataGridSelectedRow(rowKey, postRowData);
        DataGridSelectRowEvent event = new DataGridSelectRowEvent(this, selectedRow, RowSelectAct.ADD_ROW);
        this.fireDataGridSelectRowEvent(event);
    }

    public void clearRowSelection(int rowKey, List<Object> postRowData) {
        DataGridSelectedRow selectedRow = new DataGridSelectedRow(rowKey, postRowData);
        DataGridSelectRowEvent event = new DataGridSelectRowEvent(this, selectedRow, RowSelectAct.CLEAR_ROW);
        this.fireDataGridSelectRowEvent(event);
    }

    public void selectPageAllRows() {
        DataGridSelectRowEvent event = new DataGridSelectRowEvent(this, RowSelectAct.SELECT_ALL);
        this.fireDataGridSelectRowEvent(event);
    }

    public void clearPageSelection() {
        DataGridSelectRowEvent event = new DataGridSelectRowEvent(this, RowSelectAct.CLEAR_ALL);
        this.fireDataGridSelectRowEvent(event);
    }

    private void fireDataGridSelectRowEvent(DataGridSelectRowEvent e) {
        for (DataGridSelectRowListener listener : this.selectRowListeners) {
            listener.dataGridSelectRow(e);
        }
    }
}

