/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.dynplugin;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.form.dynplugin.FormDynamicPluginReader;
import kd.bos.service.dynplugin.DynPlugin;

public class FormDynamicPluginCache {
    private static final CacheConfigInfo info;
    private static final String TYPE_NAME = "FormDynamicPluginCache";
    private FormDynamicPluginReader formDynamicPluginReader = new FormDynamicPluginReader();
    private static FormDynamicPluginCache _formDynPluginCache;

    private FormDynamicPluginCache() {
    }

    public static List<DynPlugin> getDynamicPlugins(String formNumber, String interfacetype, String eventmethod, String client) {
        try (EntityTraceSpan span = EntityTracer.create((String)TYPE_NAME, (String)"getDynamicPlugins");){
            if (span.isRealtime()) {
                span.addTag("formNumber", formNumber);
                span.addTag("interfacetype", interfacetype);
                span.addTag("eventmethod", eventmethod);
                span.addTag("client", client);
            }
            List dynamicPlugins = new ArrayList(0);
            Map<String, List<DynPlugin>> dynamicPluginMap = (Map<String, List<DynPlugin>>)FormDynamicPluginCache.getLocalCache(formNumber).get(FormDynamicPluginCache.getKey(formNumber, interfacetype, client));
            if (dynamicPluginMap != null) {
                dynamicPlugins = dynamicPluginMap.computeIfAbsent(eventmethod, p -> new ArrayList(0));
                if (span.isRealtime()) {
                    span.addLocaleTag("dynamicPlugins", dynamicPluginMap);
                }
                ArrayList<DynPlugin> arrayList = dynamicPlugins;
                return arrayList;
            }
            dynamicPluginMap = FormDynamicPluginCache._formDynPluginCache.formDynamicPluginReader.getDynamicPluginMap(formNumber, interfacetype, client);
            if (dynamicPluginMap != null) {
                FormDynamicPluginCache.getLocalCache(formNumber).put(FormDynamicPluginCache.getKey(formNumber, interfacetype, client), dynamicPluginMap);
                dynamicPlugins = dynamicPluginMap.computeIfAbsent(eventmethod, s -> new ArrayList());
                if (span.isRealtime()) {
                    span.addLocaleTag("dynamicPlugins", dynamicPluginMap);
                }
            }
            ArrayList<DynPlugin> arrayList = dynamicPlugins;
            return arrayList;
        }
    }

    public static void clearCacheByDynPluginIds(List<Object> dynPluginIds) {
        List<Map<String, String>> infos = FormDynamicPluginCache._formDynPluginCache.formDynamicPluginReader.getClearCacheInfosByDynPluginIds(dynPluginIds);
        FormDynamicPluginCache.batchClearCache(infos);
    }

    public static void clearCacheByDynPluginBindIds(List<Object> dynPluginBindIds) {
        List<Map<String, String>> infos = FormDynamicPluginCache._formDynPluginCache.formDynamicPluginReader.getClearCacheInfosByDynPluginBindIds(dynPluginBindIds);
        FormDynamicPluginCache.batchClearCache(infos);
    }

    public static void batchClearCache(List<Map<String, String>> dynPluginInfos) {
        if (dynPluginInfos != null && dynPluginInfos.size() > 0) {
            for (Map<String, String> dynPluginInfo : dynPluginInfos) {
                String formNumber = dynPluginInfo.get("formNumber");
                String interfacetype = dynPluginInfo.get("interfacetype");
                String client = dynPluginInfo.get("client");
                FormDynamicPluginCache.clearCache(formNumber, interfacetype, client);
            }
        }
    }

    private static void clearCache(String formNumber, String interfacetype, String client) {
        FormDynamicPluginCache._formDynPluginCache.formDynamicPluginReader.clearCache(formNumber, interfacetype, client);
        String key = FormDynamicPluginCache.getKey(formNumber, interfacetype, client);
        FormDynamicPluginCache.getLocalCache(formNumber).remove(new String[]{key});
    }

    private static LocalMemoryCache getLocalCache(String formNumber) {
        String region = CacheKeyUtil.getAcctId();
        return CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(region, "FormDynamicPlugin", info);
    }

    private static String getKey(String formNumber, String interfacetype, String client) {
        return formNumber + "-" + interfacetype + "-" + client;
    }

    static {
        int maxItemSize = 200000;
        int timeout = 300;
        info = new CacheConfigInfo();
        info.setTimeout(timeout);
        info.setMaxItemSize(maxItemSize);
        info.setTimeToLive(true);
        _formDynPluginCache = new FormDynamicPluginCache();
    }
}

