/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.field;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.AssistantProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.GroupProp;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.property.ParentBasedataProp;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.service.IAssistantDataService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.CoreBusinessDataServiceHelper;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public class AssistantEdit
extends BasedataEdit {
    private static final String FORMID_ASSISTANTDATAGROUP = "bos_assistantdatagroup";
    private static final String ASSISTANT_DATA_ENTITYID = "bos_assistantdata_detail";
    private static final String PROP_LONG_NUMBER = "longnumber";
    private static final String PROP_CTRL_STRATEGY = "ctrlstrategy";
    private static final String PROP_IS_LEAF = "isleaf";
    private static final String PROP_CREATE_ORG = "createorg";
    private static final String PROP_ENABLE = "enable";
    private static final String PROP_PARENT = "parent";
    private static final String BOS_FORM_METADATA = "bos-form-metadata";
    private String controlPropName;
    private boolean isParentAsst;

    @KSMethod
    @SimplePropertyAttribute
    public String getControlPropName() {
        return this.controlPropName;
    }

    public void setControlPropName(String controlPropName) {
        this.controlPropName = controlPropName;
    }

    @Override
    protected ListShowParameter createShowListForm(BasedataProp prop) {
        ListShowParameter para = super.createShowListForm(prop);
        AssistantProp asstProp = (AssistantProp)prop;
        this.isParentAsst = this.isParentAsst(asstProp);
        para.setCustomParam("isParentAsst", this.isParentAsst);
        Long grouId = Long.parseLong(asstProp.getAsstTypeId());
        if (StringUtils.isNotEmpty((CharSequence)this.controlPropName)) {
            para.setCustomParam("isChildAsst", true);
            if (StringUtils.isNotBlank((Object)grouId)) {
                DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue(this.controlPropName);
                Long parentId = null;
                if (dynamicObject != null) {
                    parentId = (Long)dynamicObject.getPkValue();
                    String parentName = dynamicObject.getString("name");
                    para.setCustomParam("assistantParentId", parentId.toString());
                    para.setCustomParam("assistantParentName", parentName);
                }
                ArrayList<QFilter> filters = new ArrayList<QFilter>();
                filters.add(new QFilter("group", "=", (Object)grouId));
                filters.add(new QFilter(PROP_PARENT, "=", (Object)parentId));
                ListFilterParameter listFilterParameter = new ListFilterParameter(filters, null);
                para.setListFilterParameter(listFilterParameter);
                para.setCustomParam("prop_assistant_type_id", grouId);
            }
        } else if (grouId > -1L) {
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            QFilter filter = new QFilter("group", "=", (Object)grouId);
            filters.add(filter);
            ListFilterParameter listFilterParameter = new ListFilterParameter(filters, null);
            para.setListFilterParameter(listFilterParameter);
            para.setCustomParam("prop_assistant_type_id", grouId);
        }
        para.setCaption(this.getGroupName(grouId));
        return para;
    }

    @Override
    protected ListShowParameter createShowMobileListForm(BasedataProp prop) {
        ListShowParameter para = super.createShowMobileListForm(prop);
        AssistantProp asstProp = (AssistantProp)prop;
        Long grouId = Long.parseLong(asstProp.getAsstTypeId());
        para.setCaption(this.getGroupName(grouId));
        return para;
    }

    @Override
    protected BaseShowParameter createShowForm(IBasedataField prop) {
        BaseShowParameter para = new BaseShowParameter();
        FormConfig formConfig = FormMetadataCache.getFormConfig(this.getBaseEntityId());
        para.setBillStatus(BillOperationStatus.ADDNEW);
        para.getOpenStyle().setShowType(formConfig.getShowType());
        String formId = formConfig.getEntityTypeId();
        if (StringUtils.isNotBlank((CharSequence)formId)) {
            para.setFormId(formId);
        }
        para.setCustomParam("_Assistant_Group_", ((AssistantProp)this.getProperty()).getAsstTypeId());
        return para;
    }

    private String getGroupName(Long grouId) {
        DynamicObject groupObj;
        String name = ResManager.loadKDString((String)"\u8f85\u52a9\u8d44\u6599\u8be6\u60c5", (String)"AssistantEdit_0", (String)BOS_FORM_METADATA, (Object[])new Object[0]);
        if (grouId != null && (groupObj = CoreBusinessDataServiceHelper.loadSingleFromCache(grouId, FORMID_ASSISTANTDATAGROUP, "id, name")) != null) {
            ILocaleString localeName = groupObj.getLocaleString("name");
            name = localeName != null ? localeName.getLocaleValue() : name;
        }
        return name;
    }

    @Override
    protected List<QFilter> getOtherFilters() {
        List<QFilter> filters = super.getOtherFilters();
        QFilter filter = new QFilter(PROP_IS_LEAF, "=", (Object)(this.isParentAsst ? "0" : "1"));
        filters.add(filter);
        AssistantProp assistantProp = (AssistantProp)this.getProperty();
        GroupProp groupProp = assistantProp.geGroupProp();
        if (groupProp != null) {
            QFilter f2;
            QFilter f1 = new QFilter(groupProp.getName(), "=", (Object)Long.parseLong(assistantProp.getAsstTypeId()));
            filters.add(f1);
            if (this.isFilterByOrg(assistantProp)) {
                filters.addAll(this.buildFilterByOrg(assistantProp));
            }
            if (StringUtils.isBlank((CharSequence)this.controlPropName)) {
                return filters;
            }
            DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue(this.controlPropName);
            Long parentId = null;
            if (dynamicObject != null) {
                parentId = (Long)dynamicObject.getPkValue();
            }
            if (this.isParentAsst) {
                Set<Object> children = this.getAllChildrenNonLeaf(parentId, Long.parseLong(assistantProp.getAsstTypeId()));
                f2 = new QFilter("id", "in", children);
            } else {
                f2 = new QFilter(PROP_PARENT, "=", (Object)parentId);
            }
            filters.add(f2);
        }
        return filters;
    }

    public String buildAsstFilter(String id, String parentId) {
        String specFilter = String.format("FID = '%s' ", id);
        if (!StringUtils.isEmpty((CharSequence)parentId)) {
            specFilter = specFilter + String.format(" and FParentId = '%s'", parentId);
        }
        return specFilter;
    }

    protected boolean isFilterByOrg(AssistantProp asstProp) {
        String orgField = asstProp.getOrgProp();
        MainEntityType dt = this.getDataModel().getDataEntityType();
        return !StringUtils.isEmpty((CharSequence)orgField) || !(dt instanceof MainEntityType) || dt.getMainOrg() != null;
    }

    protected List<QFilter> buildFilterByOrg(AssistantProp asstProp) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        String orgField = asstProp.getOrgProp();
        MainEntityType dt = this.getView().getModel().getDataEntityType();
        if (StringUtils.isBlank((CharSequence)orgField)) {
            orgField = dt.getMainOrg();
        }
        if (StringUtils.isBlank((CharSequence)orgField)) {
            return filters;
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue(orgField);
        if (org == null) {
            return filters;
        }
        long orgid = (Long)org.getPkValue();
        String assistType = asstProp.getAsstTypeId();
        Map objs = BusinessDataReader.loadFromCache((Object[])new String[]{assistType}, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)FORMID_ASSISTANTDATAGROUP));
        DynamicObject group = (DynamicObject)objs.get(Long.parseLong(assistType));
        long groupId = null == group ? 0L : (Long)group.getPkValue();
        IAssistantDataService assistantDataService = (IAssistantDataService)ServiceFactory.getService(IAssistantDataService.class);
        QFilter qfilter = assistantDataService.getAssistantDataFilter(Long.valueOf(groupId), Long.valueOf(orgid));
        filters.add(qfilter);
        return filters;
    }

    private boolean isParentAsst(AssistantProp prop) {
        DataEntityPropertyCollection properties = prop.getParent().getProperties();
        String itemId = this.getId();
        for (IDataEntityProperty property : properties) {
            String asstParentId;
            if (!(property instanceof AssistantProp) || !StringUtils.isNotEmpty((CharSequence)(asstParentId = ((AssistantProp)property).getAsstParentId())) || !asstParentId.equals(itemId)) continue;
            return true;
        }
        return false;
    }

    private Set<Object> getAllChildrenNonLeaf(Long parentId, Long groupId) {
        if (null == parentId || null == groupId) {
            return new HashSet<Object>(0);
        }
        DynamicObject parent = CoreBusinessDataServiceHelper.loadSingleFromCache(parentId, ASSISTANT_DATA_ENTITYID, "createorg,longnumber");
        String longNumber = parent.getString(PROP_LONG_NUMBER);
        ParentBasedataProp parentProperty = (ParentBasedataProp)EntityMetadataCache.getDataEntityType((String)ASSISTANT_DATA_ENTITYID).getProperties().get((Object)PROP_PARENT);
        String longNumberDLM = parentProperty.getLongNumberDLM();
        QFilter filter = new QFilter(PROP_ENABLE, "=", (Object)Boolean.TRUE);
        filter.and(PROP_LONG_NUMBER, "like", (Object)(longNumber + longNumberDLM + "%"));
        DynamicObject group = CoreBusinessDataServiceHelper.loadSingleFromCache(groupId, FORMID_ASSISTANTDATAGROUP, PROP_CTRL_STRATEGY);
        String ctrlStrategy = group.getString(PROP_CTRL_STRATEGY);
        if ("7".equals(ctrlStrategy)) {
            long createOrgId = parent.getLong(PROP_CREATE_ORG);
            filter.and(PROP_CREATE_ORG, "=", (Object)createOrgId);
        }
        filter.and(PROP_IS_LEAF, "=", (Object)Boolean.FALSE);
        Map allChildren = BusinessDataReader.loadFromCache((String)ASSISTANT_DATA_ENTITYID, (String)"id", (QFilter[])new QFilter[]{filter});
        return allChildren.keySet();
    }
}

