/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.field;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.base.BillLayoutScheme;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.IBillView;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.LayoutControlInfo;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.bill.BillLayoutParameter;
import kd.bos.entity.bill.BillLayoutSchemeAssignEntity;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.plugin.Plugin;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.BindingContext;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.IMobileView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ORMUtil;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.script.annotations.KSObject;
import kd.bos.util.JSONUtils;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public class BillTypeEdit
extends BasedataEdit
implements IConfirmCallBack {
    private static final Log log = LogFactory.getLog(BillTypeEdit.class);
    private static final String BOS_FORM_METADATA = "bos-form-metadata";
    public static final String CUSTOMPARAM_DISABLEBILLTYPE = "disableBillType";

    @Override
    public void click() {
        BillOperationStatus currentBillOperationStatus = this.getCurrentBillOperationStatus();
        if (currentBillOperationStatus == BillOperationStatus.ADDNEW) {
            super.click();
        } else {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u975e\u65b0\u589e\u72b6\u6001\uff0c\u65e0\u6cd5\u4fee\u6539\u5355\u636e\u7c7b\u578b", (String)"BillTypeEdit_0", (String)BOS_FORM_METADATA, (Object[])new Object[0]), MessageBoxOptions.YesNo);
        }
    }

    @Override
    protected ListShowParameter createShowListForm(BasedataProp prop) {
        ListShowParameter para = super.createShowListForm(prop);
        String billFormId = this.getView().getEntityId();
        QFilter f1 = new QFilter("billformid", "=", (Object)billFormId);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(f1);
        ListFilterParameter listFilterParameter = new ListFilterParameter(qFilters, null);
        para.setListFilterParameter(listFilterParameter);
        return para;
    }

    private BillOperationStatus getCurrentBillOperationStatus() {
        BillOperationStatus status = BillOperationStatus.ADDNEW;
        IDataEntityProperty property = this.getModel().getProperty("billstatus");
        if (property != null) {
            if (this.getView().getFormShowParameter().getStatus() == OperationStatus.VIEW) {
                ((IBillView)this.getView()).setBillStatus(BillOperationStatus.VIEW);
            } else {
                String value = (String)this.getModel().getValue("billstatus");
                if ("A".equals(value)) {
                    boolean bFromDb = this.getModel().getDataEntity().getDataEntityState().getFromDatabase();
                    if (bFromDb) {
                        ((IBillView)this.getView()).setBillStatus(BillOperationStatus.EDIT);
                    } else {
                        ((IBillView)this.getView()).setBillStatus(BillOperationStatus.ADDNEW);
                    }
                } else if ("B".equals(value)) {
                    ((IBillView)this.getView()).setBillStatus(BillOperationStatus.SUBMIT);
                } else if ("C".equals(value)) {
                    ((IBillView)this.getView()).setBillStatus(BillOperationStatus.AUDIT);
                }
            }
        }
        return status;
    }

    @Override
    protected List<QFilter> getOtherFilters() {
        List<QFilter> qFilters = super.getOtherFilters();
        String billFormId = this.getView().getEntityId();
        QFilter f1 = new QFilter("billformid", "=", (Object)billFormId);
        qFilters.add(f1);
        return qFilters;
    }

    @Override
    public void setItemByNumber(String number, int rowKey) {
        ListShowParameter listShowParameter;
        if (StringUtils.isNotBlank((CharSequence)number) && (listShowParameter = super.createAndSetListShowParameter("setItemByNumber")) != null) {
            BasedataProp basedataProp = (BasedataProp)this.getProperty();
            List qFilters = listShowParameter.getListFilterParameter().getQFilters();
            qFilters.add(new QFilter(basedataProp.getNumberProp(), "=", (Object)number));
            Map basedata = this.getModel().loadReferenceDataBatch(basedataProp.getDynamicComplexPropertyType(), qFilters);
            if (basedata.size() > 0) {
                super.setItemByNumber(number, rowKey);
                return;
            }
        }
        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u7684\u503c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BillTypeEdit_2", (String)BOS_FORM_METADATA, (Object[])new Object[0]), this.getDisplayName()));
    }

    @Override
    public void setItemByIdFromClient(List<Object> args) {
        Object newValue = args.get(0);
        if (newValue == null) {
            return;
        }
        IDataModel model = this.getView().getModel();
        DynamicObject oldValue = (DynamicObject)model.getValue(this.getFieldKey());
        String oldId = oldValue != null ? oldValue.getPkValue().toString() : null;
        String newId = newValue.toString();
        if (StringUtils.isBlank((CharSequence)newId)) {
            this.getView().updateView();
            return;
        }
        if (!newId.equalsIgnoreCase(oldId)) {
            this.prompt(args);
        }
    }

    private void prompt(List<Object> args) {
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        try {
            String billTypeClientArgs = JSONUtils.toString(args);
            pageCache.put("billTypeClientArgs", billTypeClientArgs);
        }
        catch (IOException e) {
            HashMap<String, List<Object>> tags = new HashMap<String, List<Object>>(1);
            tags.put("args", args);
            EntityTracer.throwException((String)"BillTypeEdit", (String)"prompt", null, (Throwable)e, tags);
            throw new KDException((Throwable)e, BosErrorCode.jSONParsing, new Object[]{"BillTypeEdit setItemByIdFromClient args error."});
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b\u5207\u6362\uff0c\u5c06\u6e05\u9664\u5355\u636e\u4fe1\u606f\uff0c\u662f\u5426\u786e\u8ba4\u5207\u6362\uff1f", (String)"BillTypeEdit_1", (String)BOS_FORM_METADATA, (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("switchbilltype", this));
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent event) {
        if ("switchbilltype".equals(event.getCallBackId())) {
            if (event.getResult() == MessageBoxResult.Yes) {
                if (this.getView().getFormShowParameter() instanceof BillShowParameter) {
                    ((BillShowParameter)this.getView().getFormShowParameter()).setCachePageId(null);
                }
                IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
                String billTypeClientArgs = pageCache.get("billTypeClientArgs");
                try {
                    List args = (List)JSONUtils.cast((String)billTypeClientArgs, ArrayList.class);
                    Object pkId = args.get(0);
                    if (LayoutControlInfo.isBillTypeLayout()) {
                        String formId = ORMUtil.getFormIdByBillTypeId(pkId instanceof String ? Long.parseLong((String)pkId) : (Long)pkId);
                        if (StringUtils.equals((CharSequence)formId, (CharSequence)this.getView().getFormShowParameter().getFormId())) {
                            super.setItemByIdFromClient(args);
                        }
                        this.showLayoutForm(formId, pkId, true);
                    }
                    if (this.showExchangeLayout(pkId)) {
                        return;
                    }
                    this.updateBillLayout(pkId);
                    super.setItemByIdFromClient(args);
                }
                catch (IOException e) {
                    HashMap<String, String> tags = new HashMap<String, String>(1);
                    tags.put("billTypeClientArgs", billTypeClientArgs);
                    EntityTracer.throwException((String)"BillTypeEdit", (String)"confirmCallBack", null, (Throwable)e, tags);
                    throw new KDException((Throwable)e, BosErrorCode.jSONParsing, new Object[]{"BillTypeEdit setItemByIdFromClient args error."});
                }
            } else if (event.getResult() == MessageBoxResult.Cancel) {
                Object v = this.getBindingBasedataValue(this.getModel().getValue(this.getFieldKey()));
                this.clientViewProxy.setFieldProperty(this.getKey(), "v", v);
            }
        }
    }

    @Override
    public void bindData(BindingContext bctx) {
        Map dataEntity;
        super.bindData(bctx);
        DynamicObject val = (DynamicObject)this.getProperty().getValue(bctx.getDataEntity());
        if (val != null && val.getPkValue() != null) {
            Long pk = (Long)val.getPkValue();
            boolean isMob = this.getView() instanceof IMobileView;
            Map<String, String> resultMap = ORMUtil.getFormIdByBillTypeId(pk, isMob);
            String formId = resultMap.get("formId");
            if (StringUtils.isNotBlank((CharSequence)formId) && !formId.equals(this.getView().getFormShowParameter().getFormId()) && !this.isDisableLayoutScheme(this.getView().getFormShowParameter()) && !this.isDisableBillType(this.getView().getFormShowParameter())) {
                if (LayoutControlInfo.isBillTypeLayout() && (!isMob || Boolean.parseBoolean(resultMap.get("isMobFormId")))) {
                    this.showLayoutForm(formId, pk);
                }
                return;
            }
        }
        if ((dataEntity = (Map)this.getView().getFormShowParameter().getCustomParam("dataEntity")) != null) {
            this.setCarryValue(dataEntity);
        }
    }

    private void setCarryValue(Map<String, Object> dataEntity) {
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam("entityId");
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityId);
        DynamicProperty proterty = null;
        IDataModel model = this.getModel();
        Map headFields = entityType.getFields();
        for (Map.Entry item : headFields.entrySet()) {
            Object val;
            proterty = (DynamicProperty)item.getValue();
            if (!(proterty instanceof IFieldHandle) || (val = dataEntity.get(proterty.getName())) == null) continue;
            if (proterty instanceof FieldProp) {
                model.setValue(proterty.getName(), val);
                continue;
            }
            if (!(proterty instanceof BasedataProp) && !(proterty instanceof MulBasedataProp)) continue;
            model.setItemValueByID(proterty.getName(), val, -1);
        }
    }

    private boolean showExchangeLayout(Object billTypePkId) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (!(formShowParameter instanceof BillShowParameter)) {
            return false;
        }
        BillLayoutScheme bls = this.getLayoutScheme(billTypePkId);
        BillShowParameter billShowParameter = bls.convertLayoutShowParameter((BillShowParameter)formShowParameter, false);
        if (LayoutControlInfo.isOutLog()) {
            BillLayoutSchemeAssignEntity blsa;
            Long tmpid = null;
            if (bls != null && (blsa = bls.getLayoutScheme()) != null) {
                tmpid = bls.getLayoutScheme().getId();
            }
            log.warn(String.format("layoutlog - BillTypeEdit.showExchangeLayout billShowParameter:%s, schemeid:%s, layoutnumber:%s, orgid:%s, billtype:%s", billShowParameter != null, tmpid, bls.getLayoutNumber(), bls.getLayoutValue().getOrgId(), bls.getLayoutValue().getBillTypeId()));
        }
        if (billShowParameter != null) {
            Object pkId = billShowParameter.getPkId();
            if (pkId != null && billShowParameter.getBillStatus() == BillOperationStatus.ADDNEW) {
                billShowParameter.setPkId(null);
            }
            this.getView().showForm(billShowParameter);
            return true;
        }
        return false;
    }

    private void updateBillLayout(Object pkId) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (!(formShowParameter instanceof BillShowParameter)) {
            return;
        }
        BillLayoutScheme bls = this.getLayoutScheme(pkId);
        BillLayoutSchemeAssignEntity blsa = bls.getLayoutScheme();
        if (blsa != null) {
            bls.updateBillLayout(this.getView());
            if (LayoutControlInfo.isOutLog()) {
                log.warn(String.format("layoutlog - BillTypeEdit.updateBillLayout  schemeid:%s, layoutnumber:%s, orgid:%s, billtype:%s", bls.getLayoutScheme().getId(), bls.getLayoutNumber(), bls.getLayoutValue().getOrgId(), bls.getLayoutValue().getBillTypeId()));
            }
        }
    }

    private BillLayoutScheme getLayoutScheme(Object billTypePkId) {
        BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        BillLayoutParameter blp = new BillLayoutParameter();
        Long newOrgValue = ((IBillModel)this.getModel()).getMainOrgId();
        long orgId = 0L;
        if (newOrgValue != null) {
            orgId = newOrgValue;
        }
        blp.setOrgId(orgId);
        long billTypeId = 0L;
        if (StringUtils.isNotBlank((Object)billTypePkId)) {
            try {
                billTypeId = Long.parseLong(billTypePkId.toString());
            }
            catch (Exception e) {
                billTypeId = 0L;
            }
        }
        blp.setBillTypeId(billTypeId);
        return new BillLayoutScheme((IBillModel)this.getModel(), billShowParameter, blp);
    }

    private void showLayoutForm(String formId, Object billTypePkId) {
        this.showLayoutForm(formId, billTypePkId, false);
    }

    private void showLayoutForm(String formId, Object billTypePkId, boolean isConfirm) {
        BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        List<Plugin> plugins = billShowParameter.getFormConfig().getPlugins();
        billShowParameter.setFormId(formId);
        billShowParameter.setBillTypeId(String.valueOf(billTypePkId));
        billShowParameter.getOpenStyle().setShowType(ShowType.InCurrentForm);
        billShowParameter.setCustomParam("mainOrgId", this.getMainOrgId());
        if (isConfirm && this.isCopyBill(billShowParameter)) {
            billShowParameter.setPkId(null);
        }
        billShowParameter.setFormConfig(FormMetadataCache.getFormConfig(formId));
        for (Plugin plugin : plugins) {
            if (!plugin.isDynamicPlugin()) continue;
            billShowParameter.addCustPlugin(plugin.getClassName());
        }
        billShowParameter.getCustomParams().put("bos_call_source_type", "billType_showLayoutForm");
        this.getView().showForm(billShowParameter);
    }

    private boolean isCopyBill(BillShowParameter billShowParameter) {
        if (!billShowParameter.getCustomParams().containsKey("iscopy")) {
            return false;
        }
        return billShowParameter.getCustomParams().containsKey("iscopy");
    }

    private Long getMainOrgId() {
        MainOrgProp mainOrgProperty = ((BillEntityType)this.getModel().getDataEntityType()).getMainOrgProperty();
        if (mainOrgProperty == null) {
            return null;
        }
        DynamicObject mainOrg = (DynamicObject)this.getModel().getValue(mainOrgProperty.getName());
        return mainOrg == null ? null : (Long)mainOrg.getPkValue();
    }

    private boolean isDisableLayoutScheme(FormShowParameter formShowParameter) {
        return this.getView().getFormShowParameter() instanceof BillShowParameter && ((BillShowParameter)formShowParameter).isDisableLayoutScheme();
    }

    private boolean isDisableBillType(FormShowParameter parameter) {
        return parameter.getCustomParam(CUSTOMPARAM_DISABLEBILLTYPE) == null ? false : (Boolean)parameter.getCustomParam(CUSTOMPARAM_DISABLEBILLTYPE);
    }
}

