/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.field;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CoreShowFormHelper;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.IPageCache;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public class DateEdit
extends DateTimeEdit
implements ICloseCallBack {
    String fmtString = "yyyy-MM-dd";
    private String minDate;
    private String maxDate;
    private Boolean isStart;
    private static final String BOS_FORM_METADATA = "bos-form-metadata";
    String relateddate;

    public DateEdit() {
        this("yyyy-MM-dd");
    }

    public DateEdit(String fmtString) {
        this.fmtString = fmtString;
    }

    @Override
    public void setIsStartDate(Boolean value) {
        this.isStart = value;
    }

    @Override
    @SimplePropertyAttribute
    public Boolean getIsStartDate() {
        return this.isStart;
    }

    @Override
    public void setRelatedDate(String value) {
        this.relateddate = value;
    }

    @Override
    @SimplePropertyAttribute
    public String getRelatedDate() {
        return this.relateddate;
    }

    @Override
    @Deprecated
    @SimplePropertyAttribute
    public String getMinDate() {
        return this.minDate;
    }

    @Override
    @Deprecated
    public void setMinDate(String min) {
        this.minDate = min;
    }

    @Override
    @Deprecated
    @SimplePropertyAttribute
    public String getMaxDate() {
        return this.maxDate;
    }

    @Override
    @Deprecated
    public void setMaxDate(String max) {
        this.maxDate = max;
    }

    @Override
    @KSMethod
    @SimplePropertyAttribute
    public String getFormatString() {
        return this.fmtString;
    }

    @Override
    public void setFormatString(String format) {
        this.fmtString = format;
    }

    @Override
    public void postBack(Object value, int rowIndex, int parentRowIndex) {
        super.postBack(this.toDateTime(value), rowIndex, parentRowIndex);
    }

    @Override
    public void postBack(String key, Object value, int rowIndex, int parentRowIndex) {
        this.view.getModel().setValue(key, value, rowIndex, parentRowIndex);
    }

    @Override
    public void postBack(String key, Object value) {
        this.view.getModel().setValue(key, value);
    }

    @Override
    Date toDateTime(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            try {
                Date date = this.getTimeZone().parse((String)value, (DateFormat)new SimpleDateFormat(this.fmtString));
                if (Boolean.getBoolean("mvc.dst.offset.enable")) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTimeZone(this.getTimeZone().getTimeZone());
                    calendar.setTime(date);
                    calendar.set(11, 12);
                    return calendar.getTime();
                }
                return date;
            }
            catch (ParseException e) {
                throw new KDBizException((Throwable)e, BosErrorCode.conversionNotSupported, new Object[]{ResManager.loadKDString((String)"\u65e5\u671f\u8f6c\u6362\u5931\u8d25", (String)"DateEdit_0", (String)BOS_FORM_METADATA, (Object[])new Object[0]), e});
            }
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        throw new KDBizException(BosErrorCode.conversionNotSupported, new Object[]{String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u65e5\u671f\u7c7b\u578b %s ", (String)"DateEdit_1", (String)BOS_FORM_METADATA, (Object[])new Object[0]), "")});
    }

    @Override
    public void focus() {
        IPageCache pageCache;
        boolean isStart;
        SimpleDateFormat dateFormat = new SimpleDateFormat(this.fmtString);
        String startDate = null;
        String endDate = null;
        if (this.getModel().getValue(this.getFieldKey()) != null) {
            startDate = dateFormat.format(this.getModel().getValue(this.getFieldKey()));
        }
        String dateString = startDate == null ? "" : startDate;
        boolean bl = isStart = this.isStart == null ? false : this.isStart;
        if (StringUtils.isNotBlank((CharSequence)this.getRelatedDate())) {
            if (this.getModel().getValue(this.getRelatedDate()) != null) {
                endDate = dateFormat.format(this.getModel().getValue(this.getRelatedDate()));
            }
            dateString = isStart ? dateString + "," + (endDate == null ? "" : endDate) : (endDate == null ? "" : endDate) + "," + dateString;
        }
        Date convertedMinDate = this.toDate(dateFormat, StringUtils.isNotBlank((CharSequence)(pageCache = this.getView().getPageCache()).get(this.getKey() + ".min")) ? pageCache.get(this.getKey() + ".min") : this.minDate);
        Date convertedMaxDate = this.toDate(dateFormat, StringUtils.isNotBlank((CharSequence)pageCache.get(this.getKey() + ".max")) ? pageCache.get(this.getKey() + ".max") : this.maxDate);
        String convertedMinDateString = convertedMinDate == null ? null : dateFormat.format(convertedMinDate);
        String convertedMaxDateString = convertedMaxDate == null ? null : dateFormat.format(convertedMaxDate);
        FormShowParameter formShowParameter = CoreShowFormHelper.createDateSelectShowForm(this.getKey(), dateString, "date", isStart, convertedMinDateString, convertedMaxDateString);
        formShowParameter.setCustomParam("mustInput", ((DateTimeProp)this.getProperty()).isMustInput());
        this.getView().showForm(formShowParameter);
    }

    private void setValue(String key, Object v) {
        IDataModel dataModel = (IDataModel)this.view.getService(IDataModel.class);
        IDataEntityProperty prop = dataModel.getProperty(key);
        if (prop.getParent() instanceof EntryType) {
            int rowIndex = dataModel.getEntryCurrentRowIndex(prop.getParent().getName());
            int parentRowIndex = 0;
            if (prop.getParent().getParent() instanceof EntryType) {
                parentRowIndex = dataModel.getEntryCurrentRowIndex(prop.getParent().getParent().getName());
            }
            this.postBack(key, v, rowIndex, parentRowIndex);
        } else {
            this.postBack(key, v);
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        Object value = e.getReturnData();
        String[] dates = value.toString().split(",");
        if (StringUtils.isNotBlank((CharSequence)this.getRelatedDate()) && dates.length == 2) {
            boolean isStart;
            String startDate = dates[0];
            String endDate = dates[1];
            boolean bl = isStart = this.isStart == null ? false : this.isStart;
            if (isStart) {
                this.setValue(this.getFieldKey(), startDate);
                this.setValue(this.getRelatedDate(), endDate);
            } else {
                this.setValue(this.getFieldKey(), endDate);
                this.setValue(this.getRelatedDate(), startDate);
            }
        } else if (dates.length == 0) {
            this.setValue(this.getFieldKey(), null);
        } else {
            this.setValue(this.getFieldKey(), value);
        }
    }

    @Override
    @KSMethod
    public void setMinDate(Date date) {
        if (date == null) {
            return;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(this.getFormatString());
        this.getView().getPageCache().put(this.getKey() + ".min", sdf.format(date));
        this.setDate(date, "min");
    }

    @Override
    @KSMethod
    public void setMaxDate(Date date) {
        if (date == null) {
            return;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(this.getFormatString());
        this.getView().getPageCache().put(this.getKey() + ".max", sdf.format(date));
        this.setDate(date, "max");
    }
}

