/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.field;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.filter.FilterUtil;
import kd.bos.entity.flex.FlexEntityMetaUtils;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.org.OrgRelationItem;
import kd.bos.form.BindingContext;
import kd.bos.form.CloseCallBack;
import kd.bos.form.CoreShowFormHelper;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IMobileView;
import kd.bos.form.IPageCache;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.MobileListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.param.ParameterReader;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public class OrgEdit
extends BasedataEdit {
    String orgFunc = null;
    String orgRtnSelFunc = null;
    boolean isOrgBaseAdmin = false;
    boolean isOnlyDisplayOrgLeaves = false;
    String viewTypeCache = null;
    private static final String KEY_LIST_SELECTED = "selected";
    private static final String ORGFUNCID = "orgFuncId";
    private static final String SPAN_TYPE_PLUGIN = "plugin";
    private static final String BOS_FORM_METADATA = "bos-form-metadata";
    private static final String VIEW_STYLE = "view_style";
    private static final String VIEW_STYLE_BILL = "bill";
    private static final String VIEW_STYLE_LIST = "list";
    private static final String VIEW_STYLE_TREE = "tree";
    private static final Log log = LogFactory.getLog(OrgEdit.class);

    @Override
    @KSMethod
    public void click() {
        if (this.getView() instanceof IMobileView) {
            BasedataProp prop = (BasedataProp)this.getProperty();
            if (prop != null) {
                String viewStyle;
                FormShowParameter para = this.createShowMobilePara();
                CloseCallBack closeCallBack = new CloseCallBack();
                closeCallBack.setControlKey(this.getKey());
                para.setCloseCallBack(closeCallBack);
                int row = this.getView().getModel().getEntryCurrentRowIndex(this.getProperty().getParent().getName());
                BeforeF7SelectEvent evt = new BeforeF7SelectEvent(this, row, this.getDataModel().getValue(this.key));
                evt.setFormShowParameter(para);
                if (this.beforeF7SelectListeners != null) {
                    for (BeforeF7SelectListener l : this.beforeF7SelectListeners) {
                        EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(l.getClass().getName() + ".beforeF7Select"));
                        Throwable throwable = null;
                        try {
                            l.beforeF7Select(evt);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (span == null) continue;
                            if (throwable != null) {
                                try {
                                    span.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            span.close();
                        }
                    }
                    if (evt.isCancel()) {
                        return;
                    }
                }
                if (VIEW_STYLE_LIST.equals(viewStyle = this.getViewStyleParameter())) {
                    String orgFuncId = (String)para.getCustomParam(ORGFUNCID);
                    if (StringUtils.isBlank((CharSequence)orgFuncId)) {
                        OrgProp orgProp = (OrgProp)prop;
                        orgFuncId = orgProp.getOrgFunc();
                    }
                    if (StringUtils.isBlank((CharSequence)orgFuncId) || "01".equals(orgFuncId)) {
                        MobileListShowParameter mpara = (MobileListShowParameter)para;
                        mpara.setBillFormId("bos_adminorg");
                        para = mpara;
                    }
                }
                this.view.showForm(para);
            }
        } else {
            super.click();
        }
    }

    @Override
    protected List<QFilter> getOtherFilters() {
        List<QFilter> otherFilters = super.getOtherFilters();
        otherFilters.addAll(FilterUtil.buildDataPermissionFilter((String)this.getBaseEntityId(), (boolean)this.isShowUsed(), (boolean)true));
        return otherFilters;
    }

    private FormShowParameter createShowMobilePara() {
        OrgProp orgProp = (OrgProp)this.getProperty();
        int f7Style = orgProp.getF7Style();
        String viewStyle = this.getViewStyleParameter();
        if (VIEW_STYLE_LIST.equals(viewStyle)) {
            f7Style = 2;
        } else if (VIEW_STYLE_TREE.equals(viewStyle)) {
            f7Style = 1;
        }
        if (2 == f7Style) {
            return this.createMobileListShowParameter(orgProp);
        }
        MobileFormShowParameter para = new MobileFormShowParameter();
        para.setFormId("bos_mobileorglist");
        para.getOpenStyle().setShowType(ShowType.Floating);
        para.setCustomParam("islookup", true);
        para.setCustomParam("isMulti", false);
        para.setCustomParam("_F7Style_", f7Style);
        boolean mustInput = orgProp.isMustInput();
        para.setCustomParam("mustInput", mustInput);
        List<QFilter> otherFilters = this.getOtherFilters();
        if (!otherFilters.isEmpty()) {
            HashSet<QFilter> otherFilterSet = new HashSet<QFilter>(otherFilters);
            QFilter otherFilter = null;
            for (QFilter otFilter : otherFilterSet) {
                if (otherFilter == null) {
                    otherFilter = otFilter;
                    continue;
                }
                otherFilter = otherFilter.and(otFilter);
            }
            if (otherFilter != null) {
                para.setCustomParam("_otherFilters_", otherFilter.toSerializedString());
            }
        }
        para.getCustomParams().putAll(this.getCustomParam());
        return para;
    }

    private String getViewStyleParameter() {
        String viewStyle = VIEW_STYLE_BILL;
        DynamicObject billParamObj = ParameterReader.getBillParameter((String)"bos_org");
        if (billParamObj != null && billParamObj.getDataEntityType().getProperties().containsKey((Object)VIEW_STYLE)) {
            viewStyle = billParamObj.getString(VIEW_STYLE);
        }
        return viewStyle;
    }

    private String getFormId() {
        String formId = "bos_org";
        String viewStyle = this.getViewStyleParameter();
        OrgProp orgProp = (OrgProp)this.getProperty();
        int f7Style = orgProp.getF7Style();
        String orgFuncId = orgProp.getOrgFunc();
        if (VIEW_STYLE_BILL.equals(viewStyle) && 2 == f7Style && (StringUtils.isBlank((CharSequence)orgFuncId) || "01".equals(orgProp.getOrgFunc()))) {
            formId = "bos_adminorg";
        }
        return formId;
    }

    private FormShowParameter createMobileListShowParameter(OrgProp orgProp) {
        ListFilterParameter listFilterParameter;
        MobileListShowParameter para = new MobileListShowParameter();
        String formId = this.getFormId();
        para.setLookUp(true);
        para.setBillFormId(formId);
        para.getOpenStyle().setShowType(ShowType.Floating);
        para.setSelectedRows(this.getPkIds());
        para.setMustInput(orgProp.isMustInput());
        FormConfig formConfig = FormMetadataCache.getMobListFormConfig(formId);
        if (null != formConfig) {
            para.setCaption(formConfig.getCaption().toString());
            String f7ListFormId = formConfig.getF7ListFormId();
            if (StringUtils.isNotBlank((CharSequence)f7ListFormId)) {
                para.setFormId(f7ListFormId);
            }
        }
        if (null != (listFilterParameter = para.getListFilterParameter())) {
            listFilterParameter.getQFilters().addAll(this.getOtherFilters());
        } else {
            ListFilterParameter filterParameter = new ListFilterParameter();
            filterParameter.setQFilters(this.getOtherFilters());
            para.setListFilterParameter(filterParameter);
        }
        return para;
    }

    @SimplePropertyAttribute
    public String getOrgFunc() {
        return this.orgFunc;
    }

    public void setOrgFunc(String orgFunc) {
        this.orgFunc = orgFunc;
    }

    @SimplePropertyAttribute
    public String getOrgRtnSelFunc() {
        return this.orgRtnSelFunc;
    }

    public void setOrgRtnSelFunc(String orgRtnSelFunc) {
        this.orgRtnSelFunc = orgRtnSelFunc;
    }

    @SimplePropertyAttribute
    public boolean getIsOrgBaseAdmin() {
        return this.isOrgBaseAdmin;
    }

    public void setIsOrgBaseAdmin(boolean isOrgBaseAdmin) {
        this.isOrgBaseAdmin = isOrgBaseAdmin;
    }

    @SimplePropertyAttribute
    public boolean getIsOnlyDisplayOrgLeaves() {
        return this.isOnlyDisplayOrgLeaves;
    }

    public void setIsOnlyDisplayOrgLeaves(boolean isOnlyDisplayOrgLeaves) {
        this.isOnlyDisplayOrgLeaves = isOnlyDisplayOrgLeaves;
    }

    public String getViewTypeCache() {
        return this.viewTypeCache;
    }

    public void setViewTypeCache(String viewTypeCache) {
        this.viewTypeCache = viewTypeCache;
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        String treeType = ((IPageCache)this.getView().getService(IPageCache.class)).get("orgF7SelViewTreeType");
        this.setOrgRtnSelFunc(treeType);
        super.closedCallBack(e);
    }

    @Override
    protected ListShowParameter createShowListForm(BasedataProp prop) {
        OrgProp orgProp = (OrgProp)prop;
        ListShowParameter para = CoreShowFormHelper.createShowListForm(prop.getBaseEntityId(), this.isEntryProperty(this.getProperty()), orgProp.getF7Style());
        if (FlexEntityMetaUtils.isOutLog()) {
            String orgFunc = orgProp.getOrgFunc();
            String params = SerializationUtils.toJsonString(para.getCustomParams());
            log.info(String.format("OrgEdit - createShowListForm createShowForm: prop.OrgFunc:%s, para.custemParam:%s", orgFunc, params));
        }
        Map<String, Object> customParamMap = para.getCustomParams();
        Map<String, Object> otherCustomParam = this.getCustomParam();
        if (customParamMap == null) {
            customParamMap = otherCustomParam;
        } else {
            customParamMap.putAll(otherCustomParam);
        }
        para.setCustomParams(customParamMap);
        if (FlexEntityMetaUtils.isOutLog()) {
            String orgFunc = orgProp.getOrgFunc();
            String params = SerializationUtils.toJsonString(para.getCustomParams());
            log.info(String.format("OrgEdit - createShowListForm getCustomParam: prop.OrgFunc:%s, para.custemParam:%s", orgFunc, params));
        }
        return para;
    }

    @Override
    protected BaseShowParameter createShowForm(IBasedataField prop) {
        BaseShowParameter showParameter = super.createShowForm(prop);
        if (prop == null || !(prop instanceof OrgProp)) {
            return showParameter;
        }
        OrgProp orgProp = (OrgProp)prop;
        if ("01".equals(orgProp.getOrgFunc())) {
            showParameter.setFormId("bos_adminorg");
        }
        return showParameter;
    }

    private Map<String, Object> getCustomParam() {
        Map customParamMap = ((OrgProp)this.getProperty()).getShowFormCustomParams();
        Object orgFuncID = customParamMap.get(ORGFUNCID);
        if (StringUtils.isNotBlank((CharSequence)this.orgFunc)) {
            orgFuncID = this.orgFunc;
            customParamMap.put(ORGFUNCID, orgFuncID);
        }
        if ("15".equals(this.viewTypeCache)) {
            orgFuncID = null;
        }
        if (StringUtils.isBlank(orgFuncID)) {
            customParamMap.put("islockfunc", false);
        } else {
            customParamMap.put("islockfunc", true);
        }
        customParamMap.put("isOrgBaseAdmin", this.isOrgBaseAdmin);
        customParamMap.put("isOnlyDisplayOrgLeaves", this.isOnlyDisplayOrgLeaves);
        Map<String, Object> relationMap = this.getOrgRelation();
        if (relationMap != null) {
            customParamMap.put("orgRelation", relationMap);
        }
        customParamMap.put(KEY_LIST_SELECTED, this.getPkIds());
        return customParamMap;
    }

    private Map<String, Object> getOrgRelation() {
        OrgProp p = (OrgProp)this.getProperty();
        List ralationList = p.getOrgRelation();
        if (ralationList == null || ralationList.isEmpty()) {
            return null;
        }
        Map mapRet = ((OrgRelationItem)ralationList.get(0)).toValidMap();
        String orgnumber = (String)mapRet.get("orgnumber");
        DynamicObject dy = (DynamicObject)this.getView().getModel().getValue(orgnumber);
        if (dy == null) {
            return null;
        }
        mapRet.put("orgpkid", dy.getPkValue());
        return mapRet;
    }

    @Override
    public void bindData(BindingContext bctx) {
        super.bindData(bctx);
    }

    public void endSelect(Object params) {
        if (params instanceof ArrayList) {
            String yzjOrgId = ((ArrayList)params).get(0).toString();
            IDataModel model = this.getView().getModel();
            Map orgMap = model.getOrgbyYzjorgId(yzjOrgId);
            Object orgId = orgMap.get("id");
            if (orgId == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u4e0d\u5b58\u5728\uff01", (String)"OrgEdit_0", (String)BOS_FORM_METADATA, (Object[])new Object[0]));
                return;
            }
            model.setValue(this.getFieldKey().toLowerCase(), orgId);
        }
    }
}

