/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.field;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.MobileBillShowParameter;
import kd.bos.bill.MobileFormPosition;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.data.ParameterHelper;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.ITreeEntryType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropChangedContainer;
import kd.bos.entity.filter.FilterUtil;
import kd.bos.entity.param.BillParam;
import kd.bos.entity.param.FuzzySearch;
import kd.bos.entity.param.MobileListF7Config;
import kd.bos.entity.param.ShowColumn;
import kd.bos.entity.property.IRefBillField;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.RefBillProp;
import kd.bos.entity.rule.RuleContainer;
import kd.bos.entity.rule.RuleExecuteContext;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.filter.helper.RefBillDataSearchHelper;
import kd.bos.filter.helper.RefBillQueryLookUpdataParameter;
import kd.bos.form.BindingContext;
import kd.bos.form.CloseCallBack;
import kd.bos.form.CoreShowFormHelper;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.IMobileView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.field.events.AfterBindingDataEvent;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BasedataEditListener;
import kd.bos.form.field.events.BasedataFuzzySearchEvent;
import kd.bos.form.field.events.BasedataFuzzySearchListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.BeforeF7ViewDetailEvent;
import kd.bos.form.field.events.BeforeQuickAddNewEvent;
import kd.bos.form.field.events.BeforeQuickAddNewListener;
import kd.bos.form.field.events.CellTipsClickEvent;
import kd.bos.form.field.events.CellTipsClickListener;
import kd.bos.form.rule.FormRuleExecuteContext;
import kd.bos.list.IMobileListView;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.MobileListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.parameter.MobileListParam;
import kd.bos.permission.api.PermissionService;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.service.ITimeService;
import kd.bos.service.IUserService;
import kd.bos.service.ServiceFactory;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public class RefBillEdit
extends FieldEdit
implements ICloseCallBack {
    private static final Log log = LogFactory.getLog(RefBillEdit.class);
    private static final int STOP_REFRESH_GRID_ROW_SIZE = 5;
    private static final String BOS_FORM_METADATA = "bos-form-metadata";
    private static final String SPAN_TYPE_PLUGIN = "plugin";
    private static final String SPAN_TYPE_BASEDATAEDIT = "RefBillEdit";
    private static final String SPAN_TAG_FIELDKEY = "fieldKey";
    private static final String SPAN_TAG_BILLENTITYID = "billentityid";
    protected List<BeforeF7SelectListener> beforeF7SelectListeners;
    protected List<BeforeQuickAddNewListener> beforeQuickAddNewListeners;
    protected List<BasedataFuzzySearchListener> fuzzySearchListeners;
    List<Consumer<BeforeF7ViewDetailEvent>> beforeF7ViewDetailListeners = new ArrayList<Consumer<BeforeF7ViewDetailEvent>>();
    protected List<CellTipsClickListener> cellTipsClickListeners;
    protected List<BasedataEditListener> basedataEditListeners;
    protected List<AfterF7SelectListener> afterF7SelectListeners;
    protected String displayProp;
    protected String editSearchProp;
    protected List<QFilter> qFilters;
    private String flexKey;
    protected boolean showOnlyAudited = true;
    private boolean f7MultipleSelect = true;
    private boolean f7BatchFill = true;
    private boolean is_ShowFrequent;
    private boolean batchFirePropChanged = false;
    private int displayStyle;
    private String layoutId;
    private boolean is_F7Click = false;
    private QFilter searchFilter = null;
    private List<Long> useOrgIds = new ArrayList<Long>(10);

    @SimplePropertyAttribute(name="ShowFrequent")
    public boolean isShowFrequent() {
        return this.is_ShowFrequent;
    }

    public void setShowFrequent(boolean isShowFrequent) {
        this.is_ShowFrequent = isShowFrequent;
    }

    @SimplePropertyAttribute
    public int getDisplayStyle() {
        return this.displayStyle;
    }

    public void setDisplayStyle(int displayStyle) {
        this.displayStyle = displayStyle;
    }

    @SimplePropertyAttribute(name="RefLayout")
    public String getLayoutId() {
        return this.layoutId;
    }

    public void setLayoutId(String layoutId) {
        this.layoutId = layoutId;
    }

    private boolean hasLayout() {
        return StringUtils.isNotEmpty((CharSequence)this.layoutId);
    }

    @SimplePropertyAttribute(name="ShlowOnlyAudited")
    @DefaultValueAttribute(value="true")
    public boolean isShowOnlyAudited() {
        return this.showOnlyAudited;
    }

    public void setShowOnlyAudited(boolean showOnlyAudited) {
        this.showOnlyAudited = showOnlyAudited;
    }

    @SimplePropertyAttribute(name="F7MultipleSelect")
    @DefaultValueAttribute(value="false")
    public boolean isF7MultipleSelect() {
        return this.f7MultipleSelect;
    }

    public void setF7MultipleSelect(boolean f7MultipleSelect) {
        this.f7MultipleSelect = f7MultipleSelect;
    }

    @SimplePropertyAttribute(name="F7BatchFill")
    @DefaultValueAttribute(value="true")
    public boolean isF7BatchFill() {
        return this.f7BatchFill;
    }

    public void setF7BatchFill(boolean f7BatchFill) {
        this.f7BatchFill = f7BatchFill;
    }

    public boolean isBatchFirePropChanged() {
        return this.batchFirePropChanged;
    }

    public void setBatchFirePropChanged(boolean batchFirePropChanged) {
        this.batchFirePropChanged = batchFirePropChanged;
    }

    @KSMethod
    public QFilter getQFilter() {
        if (this.getQFilters() != null && !this.getQFilters().isEmpty()) {
            return this.getQFilters().get(0);
        }
        return null;
    }

    @KSMethod
    public void setQFilter(QFilter qFilter) {
        if (this.qFilters == null) {
            this.qFilters = new ArrayList<QFilter>();
            this.qFilters.add(qFilter);
        }
        this.setQFilters(this.qFilters);
    }

    public void setQFilters(List<QFilter> qFilters) {
        ArrayList<String> filters = new ArrayList<String>(10);
        for (QFilter qFilter : qFilters) {
            filters.add(qFilter.toSerializedString());
        }
        String cacheKey = String.format("%s_%s_%s", this.getKey(), "prop", "qfilter");
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        pageCache.put(cacheKey, SerializationUtils.toJsonString(filters));
        this.qFilters = qFilters;
    }

    public List<QFilter> getQFilters() {
        String cacheKey = String.format("%s_%s_%s", this.getKey(), "prop", "qfilter");
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        if (this.qFilters == null && pageCache.get(cacheKey) != null) {
            List filters = SerializationUtils.fromJsonStringToList((String)pageCache.get(cacheKey), String.class);
            this.qFilters = new ArrayList<QFilter>(10);
            for (String filter : filters) {
                this.qFilters.add(QFilter.fromSerializedString((String)filter));
            }
        }
        return this.qFilters;
    }

    @SimplePropertyAttribute
    public String getDisplayProp() {
        return this.displayProp;
    }

    public void setDisplayProp(String displayProp) {
        this.displayProp = displayProp;
    }

    @SimplePropertyAttribute
    public String getEditSearchProp() {
        return this.editSearchProp;
    }

    public void setEditSearchProp(String editSearchProp) {
        this.editSearchProp = editSearchProp;
    }

    @SimplePropertyAttribute
    public String getFlexKey() {
        return this.flexKey;
    }

    public void setFlexKey(String flexKey) {
        this.flexKey = flexKey;
    }

    @KSMethod
    public void addBeforeF7SelectListener(BeforeF7SelectListener listener) {
        if (this.beforeF7SelectListeners == null) {
            this.beforeF7SelectListeners = new ArrayList<BeforeF7SelectListener>();
        }
        this.beforeF7SelectListeners.add(listener);
    }

    @KSMethod
    public void addAfterF7SelectListener(AfterF7SelectListener listener) {
        if (this.afterF7SelectListeners == null) {
            this.afterF7SelectListeners = new ArrayList<AfterF7SelectListener>();
        }
        this.afterF7SelectListeners.add(listener);
    }

    public void addBeforeF7ViewDetailListener(Consumer<BeforeF7ViewDetailEvent> listener) {
        this.beforeF7ViewDetailListeners.add(listener);
    }

    public void addBasedataFuzzySearchListener(BasedataFuzzySearchListener listener) {
        if (this.fuzzySearchListeners == null) {
            this.fuzzySearchListeners = new ArrayList<BasedataFuzzySearchListener>();
        }
        this.fuzzySearchListeners.add(listener);
    }

    public void addTipsClickListener(CellTipsClickListener listener) {
        if (this.cellTipsClickListeners == null) {
            this.cellTipsClickListeners = new ArrayList<CellTipsClickListener>();
        }
        this.cellTipsClickListeners.add(listener);
    }

    public void addBasedataEditListener(BasedataEditListener listener) {
        if (this.basedataEditListeners == null) {
            this.basedataEditListeners = new ArrayList<BasedataEditListener>();
        }
        this.basedataEditListeners.add(listener);
    }

    @KSMethod
    public void addBeforeQuickAddNewListener(BeforeQuickAddNewListener listener) {
        if (this.beforeQuickAddNewListeners == null) {
            this.beforeQuickAddNewListeners = new ArrayList<BeforeQuickAddNewListener>();
        }
        this.beforeQuickAddNewListeners.add(listener);
    }

    protected IDataEntityProperty getPrimaryKeyProp(EntityType mainEntityType) {
        return mainEntityType.findProperty(String.format("%s.%s", mainEntityType.getName(), mainEntityType.getPrimaryKey().getName()));
    }

    protected Object getPkId(int rowIndex) {
        IDataEntityProperty property;
        IDataModel model = (IDataModel)this.view.getService(IDataModel.class);
        DynamicObject baseObject = (DynamicObject)model.getValue((property = this.getProperty()).getName(), rowIndex);
        if (baseObject == null) {
            return null;
        }
        return baseObject.getPkValue();
    }

    protected IDataModel getDataModel() {
        return this.getModel();
    }

    protected boolean triggerBeforeF7(ListShowParameter para, String sourceMethod) {
        int row = 0;
        if (this.getProperty().getParent() instanceof EntryType) {
            row = this.getView().getModel().getEntryCurrentRowIndex(this.getProperty().getParent().getName());
            if (this.getView().getModel().getEntryRowCount(this.getProperty().getParent().getName()) == 0) {
                return false;
            }
        }
        BeforeF7SelectEvent evt = new BeforeF7SelectEvent(this, row, this.getDataModel().getValue(this.getFieldKey()), sourceMethod);
        evt.setFormShowParameter(para);
        if (this.beforeF7SelectListeners != null) {
            for (BeforeF7SelectListener l : this.beforeF7SelectListeners) {
                EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(l.getClass().getName() + ".beforeF7Select"));
                Throwable throwable = null;
                try {
                    l.beforeF7Select(evt);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (span == null) continue;
                    if (throwable != null) {
                        try {
                            span.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    span.close();
                }
            }
            for (QFilter qFilter : evt.getCustomQFilters()) {
                if (qFilter == null) continue;
                para.getListFilterParameter().getQFilters().add(qFilter);
            }
            if (evt.isCancel()) {
                this.buildDataPermissionFilter(para);
                return false;
            }
        }
        this.buildDataPermissionFilter(para);
        return true;
    }

    private void buildDataPermissionFilter(ListShowParameter para) {
        List buildDataPermissionFilter = FilterUtil.buildDataPermissionFilter((String)this.getBillEntityId(), (boolean)para.isShowUsed(), (boolean)para.isShowApproved());
        para.getListFilterParameter().getQFilters().addAll(buildDataPermissionFilter);
    }

    protected String getItemTypeName() {
        return ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u591a\u7c7b\u522b\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u3002", (String)"RefBillEdit_0", (String)BOS_FORM_METADATA, (Object[])new Object[0]);
    }

    protected void checkNullException() {
        if (StringUtils.isBlank((CharSequence)this.getBillEntityId())) {
            String name = this.getItemTypeName();
            throw new KDBizException(name);
        }
        if (FormMetadataCache.getListFormConfig(this.getBillEntityId()) == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u672a\u8bbe\u8ba1F7\u5217\u8868\u3002", (String)"RefBillEdit_1", (String)BOS_FORM_METADATA, (Object[])new Object[0]));
        }
    }

    public ListShowParameter getListShowParameter(String sourceMethod) {
        return this.createAndSetListShowParameter(sourceMethod);
    }

    protected ListShowParameter createAndSetListShowParameter(String sourceMethod) {
        ListShowParameter para = null;
        RefBillProp prop = (RefBillProp)this.getProperty();
        if (prop != null) {
            if (this.getView() instanceof IMobileView) {
                para = this.createShowMobileListForm(prop);
            } else {
                this.checkNullException();
                para = this.createShowListForm(prop);
            }
        }
        if (para == null) {
            return null;
        }
        if (this.getView() instanceof IMobileView) {
            para.setSelectedRows(this.getPkIds());
        }
        para.setShowApproved(true);
        para.setShowUsed(this.isShowOnlyAudited());
        this.setParamUseOrgId(para, (IRefBillField)prop);
        CloseCallBack closeCallBack = new CloseCallBack();
        closeCallBack.setControlKey(this.getKey());
        para.setCloseCallBack(closeCallBack);
        this.addFilter(para);
        if (!this.isShowOnlyAudited()) {
            para.setF7ClickByFilter(true);
        } else {
            String billStatus = prop.getBillStatus();
            if (StringUtils.isNotEmpty((CharSequence)billStatus)) {
                para.getListFilterParameter().getQFilters().add(new QFilter(billStatus, "=", (Object)"C"));
            }
        }
        para.setShowFrequent(this.isShowFrequent());
        if (!this.triggerBeforeF7(para, sourceMethod)) {
            return null;
        }
        if (this.getSearchFilter() != null) {
            para.getListFilterParameter().getQFilters().add(this.getSearchFilter());
        }
        para.setHasRight(true);
        para.setCustomParam("callFromRefBillEdit", Boolean.TRUE);
        return para;
    }

    protected Object[] getPkIds() {
        IDataModel model = this.getDataModel();
        IDataEntityProperty property = this.getProperty();
        ArrayList<Object> pkIds = new ArrayList<Object>();
        DynamicObject dynamicObject = (DynamicObject)model.getValue(property.getName());
        if (dynamicObject != null) {
            pkIds.add(dynamicObject.getPkValue());
        }
        return pkIds.toArray(new Object[0]);
    }

    protected BaseShowParameter createAndSetBaseShowParameter() {
        BaseShowParameter para = null;
        IRefBillField prop = (IRefBillField)this.getProperty();
        if (prop != null) {
            if (this.getBillEntityId() == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u591a\u7c7b\u522b\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u3002", (String)"RefBillEdit_0", (String)BOS_FORM_METADATA, (Object[])new Object[0]));
                return null;
            }
            para = this.createShowForm(prop);
        }
        if (para == null) {
            return null;
        }
        CloseCallBack closeCallBack = new CloseCallBack();
        closeCallBack.setActionId("_Quick_Add_New_");
        closeCallBack.setControlKey(this.getKey());
        para.setCloseCallBack(closeCallBack);
        return para;
    }

    public boolean isF7Click() {
        return this.is_F7Click;
    }

    public void setF7Click(boolean isF7Click) {
        this.is_F7Click = isF7Click;
    }

    public void click() {
        this.is_F7Click = true;
        ListShowParameter listShowParameter = this.createAndSetListShowParameter("click");
        if (listShowParameter == null) {
            return;
        }
        if (this.getView() instanceof IMobileView) {
            if (this.getMainEntityType() != null) {
                BillParam billParam = ParameterHelper.getBillParam((String)this.getMainEntityType().getName());
                if (billParam.getMobileListF7Config().isEnabled()) {
                    listShowParameter.setSelectedRows(this.getPkIds());
                    boolean isShowMobTreeForm = false;
                    String billFormId = listShowParameter.getBillFormId();
                    FormConfig cfg = FormMetadataCache.getMobListFormConfig(billFormId);
                    boolean hasPlugin = false;
                    if (cfg != null && !cfg.getPlugins().isEmpty()) {
                        hasPlugin = true;
                    }
                    if ("bos_moblisttabf7".equals(listShowParameter.getFormId()) && !hasPlugin && billParam.getMobileListF7Config().isEnabledTree()) {
                        isShowMobTreeForm = true;
                    }
                    FormShowParameter createGeneralF7ShowForm = null;
                    MobileListParam mobileListParam = this.createMobileListParam(listShowParameter, billParam.getMobileListF7Config());
                    createGeneralF7ShowForm = isShowMobTreeForm ? CoreShowFormHelper.createMobileTreeListF7ShowForm(this.getKey(), mobileListParam) : CoreShowFormHelper.createMobileListF7ShowForm(this.getKey(), mobileListParam);
                    if (StringUtils.isBlank((CharSequence)listShowParameter.getCaption())) {
                        createGeneralF7ShowForm.setCaption(this.getMainEntityType().getDisplayName().toString());
                    } else {
                        createGeneralF7ShowForm.setCaption(listShowParameter.getCaption());
                    }
                    this.view.showForm(createGeneralF7ShowForm);
                } else {
                    this.view.showForm(listShowParameter);
                }
            } else {
                this.view.showForm(listShowParameter);
            }
        } else {
            this.view.showForm(listShowParameter);
        }
    }

    private MobileListParam createMobileListParam(ListShowParameter listShowParameter, MobileListF7Config mobileListF7Config) {
        MobileListParam mobileListParam = new MobileListParam();
        mobileListParam.setListShowParameter(listShowParameter);
        mobileListParam.setShowModal(mobileListF7Config.isShowModal());
        mobileListParam.setIconField(mobileListF7Config.getIconField());
        mobileListParam.setPrimaryField(mobileListF7Config.getPrimaryField());
        mobileListParam.setSecondField(mobileListF7Config.getSecondField());
        mobileListParam.setPageRow(mobileListF7Config.getPageRow());
        mobileListParam.setShowSearch(mobileListF7Config.isShowSearch());
        mobileListParam.setShowFrequent(this.isShowFrequent());
        return mobileListParam;
    }

    public void quickAddNew(String text) {
        IRefBillField prop = (IRefBillField)this.getProperty();
        String orgPropKey = prop.getOrgProp();
        if (StringUtils.isNotBlank((CharSequence)orgPropKey)) {
            IDataModel model = this.getModel();
            DynamicObject org = (DynamicObject)model.getValue(orgPropKey);
            if (org != null) {
                IPageCache pageCache = (IPageCache)model.getService(IPageCache.class);
                pageCache.put("createOrg", org.getPkValue().toString());
            } else {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\u672a\u8bbe\u503c\u3002", (String)"RefBillEdit_2", (String)BOS_FORM_METADATA, (Object[])new Object[0]), model.getProperty(orgPropKey).getDisplayName()));
                return;
            }
        }
        long userId = Long.parseLong(RequestContext.get().getUserId());
        String appid = this.getView().getFormShowParameter().getAppId();
        boolean hasNewPermission = ((PermissionService)ServiceFactory.getService(PermissionService.class)).hasNewPermission(userId, appid, this.getBillEntityId());
        if (!hasNewPermission) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7528\u6237\u6ca1\u6709\u57fa\u7840\u8d44\u6599\u7684\u65b0\u589e\u6743\u9650", (String)"RefBillEdit_3", (String)BOS_FORM_METADATA, (Object[])new Object[0]));
            return;
        }
        BaseShowParameter baseShowParameter = this.createAndSetBaseShowParameter();
        BeforeQuickAddNewEvent e = new BeforeQuickAddNewEvent(this, baseShowParameter);
        this.fireBeforeQuickAddNew(e);
        if (!e.isCancel() && e.getShowParameter() != null) {
            this.view.showForm(baseShowParameter);
        }
    }

    private void fireBeforeQuickAddNew(BeforeQuickAddNewEvent e) {
        if (this.beforeQuickAddNewListeners != null) {
            for (BeforeQuickAddNewListener listener : this.beforeQuickAddNewListeners) {
                if (e.isCancel()) break;
                EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(listener.getClass().getName() + ".beforeQuickAddNew"));
                Throwable throwable = null;
                try {
                    listener.beforeQuickAddNew(e);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (span == null) continue;
                    if (throwable != null) {
                        try {
                            span.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    span.close();
                }
            }
        }
    }

    protected void addFilter(ListShowParameter listShowParameter) {
        listShowParameter.setListFilterParameter(new ListFilterParameter(this.getOtherFilters(), null));
    }

    protected BillEntityType getMainEntityType() {
        if (StringUtils.isBlank((CharSequence)this.getBillEntityId())) {
            return null;
        }
        return (BillEntityType)EntityMetadataCache.getDataEntityType((String)this.getBillEntityId());
    }

    protected ListShowParameter createShowListForm(RefBillProp prop) {
        if (!StringUtils.isEmpty((CharSequence)prop.getLayoutId())) {
            return CoreShowFormHelper.createShowListForm(prop.getLayoutId(), this.isEntryProperty((IDataEntityProperty)prop) && this.isF7MultipleSelect());
        }
        return CoreShowFormHelper.createShowListForm(this.getBillEntityId(), this.isEntryProperty((IDataEntityProperty)prop) && this.isF7MultipleSelect());
    }

    protected ListShowParameter createShowMobileListForm(RefBillProp prop) {
        ShowType showType;
        MobileListShowParameter para = new MobileListShowParameter();
        FormConfig formConfig = FormMetadataCache.getMobListFormConfig(this.getBillEntityId());
        if (formConfig == null) {
            KDBizException e = new KDBizException(ResManager.loadKDString((String)"\u65e0\u5bf9\u5e94\u79fb\u52a8\u7aef\u754c\u9762\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"RefBillEdit_7", (String)BOS_FORM_METADATA, (Object[])new Object[0]));
            HashMap<String, String> tags = new HashMap<String, String>(2);
            tags.put(SPAN_TAG_FIELDKEY, this.getFieldKey());
            tags.put(SPAN_TAG_BILLENTITYID, this.getBillEntityId());
            EntityTracer.throwException((String)SPAN_TYPE_BASEDATAEDIT, (String)"createShowMobileListForm", null, (Throwable)e, tags);
            throw e;
        }
        para.setCaption(formConfig.getCaption().toString());
        para.setLookUp(true);
        para.setBillFormId(this.getBillEntityId());
        if (formConfig.getShowType() == ShowType.MainNewTabPage) {
            showType = ShowType.Floating;
        } else {
            showType = ShowType.Modal;
            para.setPosition(MobileFormPosition.Bottom);
        }
        para.getOpenStyle().setShowType(showType);
        para.setMultiSelect(false);
        String formId = formConfig.getF7ListFormId();
        if (StringUtils.isNotBlank((CharSequence)formId)) {
            para.setFormId(formId);
        }
        para.setMustInput(prop.isMustInput());
        return para;
    }

    protected BaseShowParameter createShowForm(IRefBillField prop) {
        BaseShowParameter para = new BaseShowParameter();
        FormConfig formConfig = FormMetadataCache.getFormConfig(this.getBillEntityId());
        para.setBillStatus(BillOperationStatus.ADDNEW);
        ShowType showType = this.getView().getFormShowParameter().getOpenStyle().getShowType();
        para.getOpenStyle().setShowType(showType);
        if (showType == ShowType.NewTabPage) {
            para.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        } else if (showType == ShowType.InContainer) {
            para.getOpenStyle().setShowType(ShowType.Modal);
        }
        String formId = formConfig.getEntityTypeId();
        if (StringUtils.isNotBlank((CharSequence)formId)) {
            para.setFormId(formId);
        }
        return para;
    }

    protected String getBillEntityId() {
        return ((RefBillProp)this.getProperty()).getBillEntityId();
    }

    public void setItemByNumber(String number, int rowKey) {
        ListShowParameter listShowParameter = this.createAndSetListShowParameter("setItemByNumber");
        if (listShowParameter == null) {
            return;
        }
        int modelRowKey = rowKey;
        if (StringUtils.isBlank((CharSequence)this.getEntryKey())) {
            modelRowKey = 0;
        } else if (rowKey == -1) {
            IDataModel model = this.getDataModel();
            modelRowKey = model.getEntryCurrentRowIndex(this.getEntryKey());
        }
        this.setItemValueByNumber(number, modelRowKey, listShowParameter.getListFilterParameter().getQFilters());
        if (StringUtils.isNotBlank((CharSequence)number)) {
            this.addNewLineIfKeyField(1, rowKey);
        }
        AfterF7SelectEvent afterF7SelectEvent = new AfterF7SelectEvent(this, "", rowKey);
        ArrayList<String> inputTexts = new ArrayList<String>();
        inputTexts.add(number);
        afterF7SelectEvent.setInputTexts(inputTexts);
        this.fireAfterF7SelectListeners(afterF7SelectEvent);
    }

    public void setItemByNumber(String number) {
        this.setItemByNumber(number, -1);
    }

    @Override
    public void bindData(BindingContext bctx) {
        super.bindData(bctx);
    }

    @Override
    public Object getBindingValue(BindingContext bctx) {
        Object v = super.getBindingValue(bctx);
        if (v == null) {
            return null;
        }
        return this.getBindingRefBillValue(v);
    }

    protected Object getBindingRefBillValue(Object v) {
        Object bindValue = ((RefBillProp)this.getProperty()).getBindingRefBillValue(v, this.getDisplayProp());
        if (bindValue instanceof Object[] && this.basedataEditListeners != null) {
            AfterBindingDataEvent evt = new AfterBindingDataEvent(this, v);
            for (BasedataEditListener l : this.basedataEditListeners) {
                EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(l.getClass().getName() + ".afterBindingData"));
                Throwable throwable = null;
                try {
                    l.afterBindingData(evt);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (span == null) continue;
                    if (throwable != null) {
                        try {
                            span.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    span.close();
                }
            }
            Object[] bindValueArr = (Object[])bindValue;
            if (StringUtils.isNotBlank((Object)evt.getDisplayProp())) {
                bindValueArr[1] = evt.getDisplayProp();
            }
            if (StringUtils.isNotBlank((CharSequence)evt.getEditSearchProp())) {
                bindValueArr[2] = evt.getEditSearchProp();
            }
        }
        return bindValue;
    }

    public void cellTipsClick(int rowIndex, String tipsId) {
        if (this.cellTipsClickListeners != null) {
            CellTipsClickEvent e = new CellTipsClickEvent(this, rowIndex, tipsId);
            for (CellTipsClickListener l : this.cellTipsClickListeners) {
                EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(l.getClass().getName() + ".clickTips"));
                Throwable throwable = null;
                try {
                    l.clickTips(e);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (span == null) continue;
                    if (throwable != null) {
                        try {
                            span.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    span.close();
                }
            }
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        if (!(e.getReturnData() instanceof ListSelectedRowCollection)) {
            return;
        }
        ListSelectedRowCollection rows = (ListSelectedRowCollection)e.getReturnData();
        if (rows == null || rows.isEmpty() && !rows.isClearFlag()) {
            return;
        }
        int rowIndex = this.getCurrentRowIndex();
        EntryGrid entryGrid = null;
        if (this.isStopRefreshGridCell(rows)) {
            entryGrid = (EntryGrid)this.getView().getControl(this.getProperty().getParent().getName());
            entryGrid.setStopUpdateCell(true);
        }
        this.modelSetValue(rows, rows.isClearFlag());
        AfterF7SelectEvent afterF7SelectEvent = new AfterF7SelectEvent(this, e.getActionId(), rowIndex);
        afterF7SelectEvent.setListSelectedRowCollection(rows);
        this.fireAfterF7SelectListeners(afterF7SelectEvent);
        if (!(this.getView() instanceof IMobileView) && !rows.isEmpty()) {
            this.showFrequent(rows);
        }
        if (entryGrid != null) {
            entryGrid.setStopUpdateCell(false);
            entryGrid.bindData(new BindingContext(this.getModel().getDataEntity()));
        }
    }

    private void fireAfterF7SelectListeners(AfterF7SelectEvent afterF7SelectEvent) {
        if (this.afterF7SelectListeners != null) {
            for (AfterF7SelectListener l : this.afterF7SelectListeners) {
                EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(l.getClass().getName() + ".afterF7Select"));
                Throwable throwable = null;
                try {
                    l.afterF7Select(afterF7SelectEvent);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (span == null) continue;
                    if (throwable != null) {
                        try {
                            span.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    span.close();
                }
            }
        }
    }

    protected void showFrequent(ListSelectedRowCollection rows) {
        if (this.isShowFrequent()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("type", this.getMainEntityType().getName());
            ArrayList list = new ArrayList();
            map.put("data", list);
            for (ListSelectedRow row : rows) {
                ArrayList<String> vals = new ArrayList<String>();
                vals.add(row.getPrimaryKeyValue().toString());
                vals.add(row.getNumber());
                vals.add(row.getName());
                list.add(vals);
            }
            this.clientViewProxy.setFieldProperty(this.getKey(), "frequent", map);
        }
    }

    protected void modelSetValue(ListSelectedRowCollection rows) {
        this.modelSetValue(rows, false);
    }

    protected void modelSetValue(ListSelectedRowCollection rows, boolean isAllowEmptyRow) {
        IDataEntityProperty property = this.getProperty();
        boolean isSuspendPropChanged = false;
        RuleContainer ruleContainer = null;
        PropChangedContainer propChangedContainer = null;
        if (this.isBatchFirePropChanged() && rows.size() >= 5) {
            isSuspendPropChanged = true;
            ruleContainer = (RuleContainer)this.getView().getService(RuleContainer.class);
            ruleContainer.suspend((long)rows.size());
            propChangedContainer = (PropChangedContainer)this.getModel().getService(PropChangedContainer.class);
            propChangedContainer.suspend();
        }
        if (this.isEntryProperty(property)) {
            this.modelSetEntryValue(rows, isAllowEmptyRow);
        } else {
            this.modelSetHeadValue(rows, isAllowEmptyRow);
        }
        if (isSuspendPropChanged) {
            propChangedContainer.resume();
            ruleContainer.resume((RuleExecuteContext)new FormRuleExecuteContext(this.getView()));
        }
    }

    private void modelSetHeadValue(ListSelectedRowCollection rows, boolean isAllowEmptyRow) {
        IDataModel model = (IDataModel)this.view.getService(IDataModel.class);
        if (rows.isEmpty()) {
            if (isAllowEmptyRow) {
                model.setValue(this.getFieldKey(), null);
            }
            return;
        }
        Object value = null;
        if (!rows.isEmpty()) {
            value = rows.get(0).getPrimaryKeyValue();
        }
        model.setValue(this.getFieldKey(), value);
    }

    private void modelSetEntryValue(ListSelectedRowCollection rows, boolean isAllowEmptyRow) {
        IDataModel model = (IDataModel)this.view.getService(IDataModel.class);
        IDataEntityProperty property = this.getProperty();
        int rowIndex = model.getEntryCurrentRowIndex(property.getParent().getName());
        if (rows.isEmpty()) {
            if (isAllowEmptyRow) {
                model.setValue(property.getName(), null, rowIndex);
            }
            return;
        }
        if (property instanceof RefBillProp) {
            if (rows.size() > 1) {
                this.getModel().getDataEntity(true);
            }
            Map<Object, DynamicObject> bdObjs = this.loadReferenceDataBatch((RefBillProp)property, rows, rowIndex);
            if (property.getParent() instanceof ITreeEntryType) {
                String entryKey = property.getParent().getName();
                int nextCount = model.getEntryNextRowCount(entryKey, rowIndex);
                if (rows.size() > nextCount + 1) {
                    model.appendEntryRow(entryKey, rowIndex, rows.size() - nextCount - 1);
                }
                int[] rowIndexs = model.getEntryNextRows(entryKey, rowIndex, true);
                int i = 0;
                for (Object id : rows.getPrimaryKeyValues()) {
                    DynamicObject bdObj = bdObjs.get(id);
                    Object value = bdObj != null ? bdObj : id;
                    model.setValue(property.getName(), value, rowIndexs[i++]);
                }
            } else {
                int rowCount = model.getEntryRowCount(property.getParent().getName());
                if (rows.size() > 1) {
                    model.appendEntryRow(property.getParent().getName(), rowIndex, rows.size() - 1);
                }
                if (!this.isF7MultipleSelect()) {
                    DynamicObject bdObj = bdObjs.get(rows.get(0).getPrimaryKeyValue());
                    DynamicObject value = bdObj != null ? bdObj : rows.get(0).getPrimaryKeyValue();
                    model.setValue(property.getName(), (Object)value, rowIndex);
                    if (this.isF7BatchFill()) {
                        this.batchFill(rowIndex, rowCount, property.getName(), value);
                    }
                } else {
                    for (ListSelectedRow row : rows) {
                        DynamicObject bdObj = bdObjs.get(row.getPrimaryKeyValue());
                        Object value = bdObj != null ? bdObj : row.getPrimaryKeyValue();
                        model.setValue(property.getName(), value, rowIndex++);
                    }
                }
            }
        } else {
            throw new KDException(BosErrorCode.bOS, new Object[]{String.format(ResManager.loadKDString((String)"\u5c5e\u6027\u7c7b\u578b%s\u5fc5\u987b\u662f\u57fa\u7840\u8d44\u6599\u7c7b\u578b", (String)"RefBillEdit_4", (String)BOS_FORM_METADATA, (Object[])new Object[0]), property.getPropertyType().getName())});
        }
        if (!rows.isEmpty() || rows.isEmpty() && isAllowEmptyRow) {
            this.addNewLineIfKeyField(rows.size(), this.getCurrentRowIndex());
        }
    }

    private Map<Object, DynamicObject> loadReferenceDataBatch(RefBillProp property, ListSelectedRowCollection listSelectedRows, int rowIndex) {
        IDataModel model = this.view.getModel();
        DynamicObject row = model.getEntryRowEntity(property.getParent().getName(), rowIndex);
        DynamicObjectType bdType = (DynamicObjectType)property.getComplexType((Object)row);
        HashSet<Object> bdIds = new HashSet<Object>();
        for (ListSelectedRow listSelectedRow : listSelectedRows) {
            bdIds.add(listSelectedRow.getPrimaryKeyValue());
        }
        return model.loadReferenceDataBatch(bdType, bdIds.toArray());
    }

    private void batchFill(int rowIndex, int rows, String fieldKey, Object value) {
        IDataModel model = this.getModel();
        for (int i = 0; i < rows; ++i) {
            if (model.getValue(fieldKey, i) != null || i == rowIndex) continue;
            model.setValue(fieldKey, value, i);
        }
    }

    private boolean isStopRefreshGridCell(ListSelectedRowCollection rows) {
        if (rows == null || rows.isEmpty()) {
            return false;
        }
        if (!this.isEntryProperty(this.getProperty())) {
            return false;
        }
        return rows.size() >= 5;
    }

    protected boolean isEntryProperty(IDataEntityProperty property) {
        IDataEntityType propParentType = property.getParent();
        return propParentType instanceof EntryType;
    }

    protected int getCurrentRowIndex() {
        int rowIndex = -1;
        if (this.isEntryProperty(this.getProperty())) {
            rowIndex = this.getModel().getEntryCurrentRowIndex(this.getProperty().getParent().getName());
        }
        return rowIndex;
    }

    public void showMore(String searchValue) {
        BillEntityType dt = this.getMainEntityType();
        if (dt == null) {
            return;
        }
        FuzzySearch setting = this.loadLookUpSetting(dt);
        HashMap searchValueMap = new HashMap();
        ArrayList<String> valueList = new ArrayList<String>();
        if (!StringUtils.isBlank((CharSequence)searchValue)) {
            valueList.add(searchValue);
            searchValueMap.put("quanbu_id_6ab82085_7ef3_4a6d_9ad9_b02e54bfb06f", valueList);
        }
        this.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            beforeF7SelectEvent.getFormShowParameter().setCustomParam("searchValueMap", searchValueMap);
            beforeF7SelectEvent.getFormShowParameter().setCustomParam("searchFields", setting.getSearchFields());
        });
        this.click();
    }

    public void getLookUpList(List<Object> args) {
        this.checkNullException();
        if (args != null) {
            BillEntityType dt = this.getMainEntityType();
            if (dt == null) {
                this.lookUpListInvoke(new HashMap<String, Object>());
                return;
            }
            this.lookUpListInvoke(this.getLookUpData(args, dt));
        }
    }

    protected Map<String, Object> getLookUpData(List<Object> args, BillEntityType dt) {
        String searchKey = (String)args.get(1);
        int start = 1;
        FuzzySearch setting = this.loadLookUpSetting(dt);
        int top = this.displayStyle == 0 ? setting.getPageSize() : 50;
        List<String> showFields = setting.getComboListFields().stream().map(ShowColumn::getId).collect(Collectors.toList());
        HashMap<String, Integer> fieldsIndexMap = new HashMap<String, Integer>();
        this.getFieldIndexMap(dt, showFields, fieldsIndexMap);
        String fullSearchKey = searchKey.trim();
        List searchFields = setting.getSearchFields();
        this.searchFilter = RefBillDataSearchHelper.getSearchFilter(fullSearchKey, searchFields, dt.getName());
        ListShowParameter para = this.createAndSetListShowParameter("getLookUpList");
        RefBillQueryLookUpdataParameter queryLookUpdataParameter = new RefBillQueryLookUpdataParameter(dt, searchFields, showFields, fullSearchKey, 0, top, fieldsIndexMap);
        queryLookUpdataParameter.setPara(para);
        queryLookUpdataParameter.setDefaultSort(setting.isDefaultSort());
        queryLookUpdataParameter.setDisplayName(this.getDisplayName() == null ? "" : this.getDisplayName().getLocaleValue());
        RefBillDataSearchHelper baseDataSearchHelper = new RefBillDataSearchHelper(queryLookUpdataParameter);
        List<Object> allData = baseDataSearchHelper.queryLookUpdata();
        List<Object> queryData = new ArrayList<Object>();
        boolean hasNext = false;
        if (!allData.isEmpty()) {
            if (allData.size() < top) {
                top = allData.size();
            } else {
                top = allData.size() - 1;
                hasNext = true;
            }
            for (int i = start - 1; i < top; ++i) {
                queryData.add(allData.get(i));
            }
        }
        if (this.fuzzySearchListeners != null) {
            BasedataFuzzySearchEvent evt = new BasedataFuzzySearchEvent(this, queryData);
            for (BasedataFuzzySearchListener l : this.fuzzySearchListeners) {
                EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(l.getClass().getName() + ".handleData"));
                Throwable throwable = null;
                try {
                    l.handleData(evt);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (span == null) continue;
                    if (throwable != null) {
                        try {
                            span.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    span.close();
                }
            }
            queryData = evt.getQueryData();
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("columns", this.createShowColumns(setting, fieldsIndexMap));
        data.put("data", queryData);
        data.put("next", hasNext);
        data.put("k", this.key);
        data.put("size", setting.getPageSize());
        data.put("args", args);
        return data;
    }

    private List<ShowColumn> createShowColumns(FuzzySearch setting, Map<String, Integer> fieldsIndexMap) {
        int index = 0;
        ArrayList<ShowColumn> showColumns = new ArrayList<ShowColumn>();
        for (ShowColumn showColumn : setting.getComboListFields()) {
            if (fieldsIndexMap.containsKey(showColumn.getId())) {
                Integer i = fieldsIndexMap.get(showColumn.getId());
                if (i == index) {
                    showColumns.add(fieldsIndexMap.get(showColumn.getId()), showColumn);
                } else {
                    showColumns.add(new ShowColumn());
                    if (i == ++index) {
                        showColumns.add(fieldsIndexMap.get(showColumn.getId()), showColumn);
                    }
                }
            } else {
                showColumns.add(showColumn);
            }
            ++index;
        }
        return showColumns;
    }

    public QFilter getSearchFilter() {
        return this.searchFilter;
    }

    protected void getFieldIndexMap(BillEntityType basedataEntityType, List<String> showFields, Map<String, Integer> fieldsIndexMap) {
        this.getMainEntityType();
        fieldsIndexMap.putAll(RefBillDataSearchHelper.getFieldsIndexMap(basedataEntityType, showFields));
    }

    protected void lookUpListInvoke(Map<String, Object> data) {
        if (this.getProperty().getParent() instanceof EntryType) {
            int rowIndex = this.getCurrentRowIndex();
            data.put("r", rowIndex);
            String ctlKey = StringUtils.isBlank((CharSequence)this.getEntryControlKey()) ? this.getEntryKey() : this.getEntryControlKey();
            this.clientViewProxy.invokeControlMethod(ctlKey, "setLookUpListValue", data);
        } else {
            data.put("r", 0);
            this.clientViewProxy.invokeControlMethod(this.key, "setLookUpListValue", data);
        }
    }

    protected FuzzySearch loadLookUpSetting(BillEntityType refBDType) {
        String cachedKey;
        FuzzySearch setting = null;
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        String search = pageCache.get(cachedKey = "searchSetting" + refBDType.getName());
        if (search == null) {
            setting = RefBillDataSearchHelper.loadLookUpSetting(refBDType);
            pageCache.put(cachedKey, SerializationUtils.toJsonString((Object)setting));
        } else {
            setting = (FuzzySearch)SerializationUtils.fromJsonString((String)search, FuzzySearch.class);
        }
        this.setComboFieldCaption(refBDType, setting);
        return setting;
    }

    protected void setComboFieldCaption(BillEntityType refBDType, FuzzySearch setting) {
        RefBillDataSearchHelper.setComboFieldCaption(refBDType, setting);
    }

    protected FuzzySearch buildDefLookUpSetting(BasedataEntityType refBDType) {
        FuzzySearch setting = new FuzzySearch();
        String number = refBDType.getNumberProperty();
        String name = refBDType.getNameProperty();
        if (StringUtils.isNotBlank((CharSequence)number)) {
            ParameterHelper.addItem((FuzzySearch)setting, (String)number, (String)refBDType.findProperty(number).getDisplayName().toString(), (float)156.0f, (boolean)true);
        }
        if (StringUtils.isNotBlank((CharSequence)name) && !name.equals(number)) {
            ParameterHelper.addItem((FuzzySearch)setting, (String)name, (String)refBDType.findProperty(name).getDisplayName().toString(), (float)156.0f, (boolean)true);
        }
        return setting;
    }

    public void setItemByIdFromClient(List<Object> args) {
        if (args != null && StringUtils.isNotBlank((Object)args.get(0))) {
            Object baseData;
            ListShowParameter listShowParameter = this.createAndSetListShowParameter("setItemByIdFromClient");
            if (listShowParameter == null) {
                return;
            }
            Object pk = args.get(0);
            IDataModel model = this.getDataModel();
            int index = this.getCurrentRowIndex();
            if (this.isF7BatchFill() && this.isEntryProperty(this.prop) && !this.isF7MultipleSelect()) {
                int rows = model.getEntryRowCount(this.getEntryKey());
                this.batchFill(index, rows, this.getFieldKey(), pk);
            }
            this.setItemValueByID(pk, index, listShowParameter.getListFilterParameter().getQFilters());
            this.getView().setReturnData(args);
            if (this.isShowFrequent() && (baseData = this.getDataModel().getValue(this.getFieldKey(), index)) instanceof DynamicObject) {
                String numberKey = ((BasedataEntityType)((DynamicObject)baseData).getDataEntityType()).getNumberProperty();
                String nameKey = ((BasedataEntityType)((DynamicObject)baseData).getDataEntityType()).getNameProperty();
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("type", this.getMainEntityType().getName());
                ArrayList list = new ArrayList();
                map.put("data", list);
                ArrayList<Object> vals = new ArrayList<Object>();
                if (pk != null) {
                    vals.add(pk.toString());
                }
                vals.add(((DynamicObject)baseData).get(numberKey));
                vals.add(((DynamicObject)baseData).getString(nameKey));
                list.add(vals);
                this.clientViewProxy.setFieldProperty(this.getKey(), "frequent", map);
            }
            if (StringUtils.isNotBlank((Object)args.get(0))) {
                this.addNewLineIfKeyField(1, this.getCurrentRowIndex());
            }
            AfterF7SelectEvent afterF7SelectEvent = new AfterF7SelectEvent(this, "", 0);
            ArrayList<Object> inputValues = new ArrayList<Object>();
            inputValues.add(args.get(0));
            afterF7SelectEvent.setInputValues(inputValues);
            this.fireAfterF7SelectListeners(afterF7SelectEvent);
        }
    }

    protected void setItemValueByID(Object pk, int index, List<QFilter> baseQFilters) {
        if (!this.checkEditFieldStatus()) {
            throw new KDBizException(BosErrorCode.variableNotValid, new Object[]{String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u4fee\u6539\u9501\u5b9a\u5b57\u6bb5%s\u7684\u503c\u3002", (String)"RefBillEdit_5", (String)BOS_FORM_METADATA, (Object[])new Object[0]), this.getDisplayName())});
        }
        this.getDataModel().setItemValueByID(this.getFieldKey(), pk, index, baseQFilters);
    }

    protected void setItemValueByNumber(String number, int rowKey, List<QFilter> baseQFilters) {
        if (!this.checkEditFieldStatus()) {
            throw new KDBizException(BosErrorCode.variableNotValid, new Object[]{String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u4fee\u6539\u9501\u5b9a\u5b57\u6bb5%s\u7684\u503c\u3002", (String)"RefBillEdit_5", (String)BOS_FORM_METADATA, (Object[])new Object[0]), this.getDisplayName())});
        }
        this.getDataModel().setItemValueByNumber(this.getFieldKey(), number, rowKey, baseQFilters);
    }

    protected List<QFilter> getOtherFilters() {
        FormShowParameter showParameter;
        String entityNum;
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        if (this.getQFilters() != null) {
            filters.addAll(this.getQFilters());
        }
        String appId = this.getView().getFormShowParameter().getAppId();
        filters.addAll(FilterUtil.buildRefBillPropertyQFilters((IDataModel)this.getModel(), (String)this.getBillEntityId(), (IRefBillField)((IRefBillField)this.getProperty()), (String)appId, (String)this.getView().getFormShowParameter().getPermissionItemId()));
        long userId = Long.parseLong(RequestContext.get().getUserId());
        if (!this.is_F7Click) {
            ITimeService timeService = (ITimeService)this.getView().getService(ITimeService.class);
            IUserService userService = (IUserService)this.getView().getService(IUserService.class);
            String entityNumber = this.getMainEntityType().getName();
            filters.addAll(FilterUtil.buildDataPermFilter((long)userId, (String)appId, (String)entityNumber));
            filters.addAll(FilterUtil.buildSpecialDataPermFilter((ITimeService)timeService, (IUserService)userService, (String)appId, (String)entityNumber));
        }
        if ((entityNum = (showParameter = this.getView().getFormShowParameter()).getFormConfig().getEntityTypeId()) == null) {
            return filters;
        }
        HashMap customParam = new HashMap(16);
        PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
        QFilter qfilter = permissionService.getDataRuleForBdProp(userId, appId, entityNum, this.getKey(), this.getView().getFormShowParameter().getPermissionItemId(), this.useOrgIds, customParam);
        if (qfilter != null) {
            filters.add(qfilter);
        }
        return filters;
    }

    @Deprecated
    public void getF7ComboList() {
        BillEntityType dt = this.getMainEntityType();
        String entityName = dt.getName();
        String pk = dt.getPrimaryKey().getName();
        String numberProp = dt.getBillNo();
        String nameProp = dt.getBillNo();
        String fields = numberProp + "," + nameProp + "," + pk;
        int start = 1;
        int top = 20;
        ListShowParameter listShowParameter = this.createAndSetListShowParameter("f7combolist");
        if (listShowParameter == null) {
            return;
        }
        List filters = listShowParameter.getListFilterParameter().getQFilters();
        ORM orm = ORM.create();
        DataSet ds = orm.queryDataSet(this.getClass().getName(), entityName, fields, filters.toArray(new QFilter[0]), pk, top);
        DynamicObjectCollection queryCollection = orm.toPlainDynamicObjectCollection(ds, start - 1, top);
        HashMap<String, Serializable> data = new HashMap<String, Serializable>();
        ArrayList arrs = new ArrayList();
        Iterator iterator = queryCollection.iterator();
        while (iterator.hasNext()) {
            ArrayList<String> arr = new ArrayList<String>();
            DynamicObject dynamicObject = (DynamicObject)iterator.next();
            arr.add(dynamicObject.getString(numberProp));
            arr.add(dynamicObject.getString(nameProp));
            arr.add(dynamicObject.getString(pk));
            arrs.add(arr);
        }
        data.put("data", arrs);
        int rowIndex = 0;
        if (this.getProperty().getParent() instanceof EntryType) {
            String entryKey = this.getEntryKey();
            rowIndex = this.getModel().getEntryCurrentRowIndex(entryKey);
            data.put("r", Integer.valueOf(rowIndex));
            this.clientViewProxy.invokeControlMethod(entryKey, "setF7ComboListValue", data);
        } else {
            data.put("r", Integer.valueOf(rowIndex));
            this.clientViewProxy.invokeControlMethod(this.key, "setF7ComboListValue", data);
        }
    }

    private List<Object> getSelectBaseIds(ListSelectedRowCollection rows) {
        ArrayList<Object> baseIds = new ArrayList<Object>();
        for (ListSelectedRow row : rows) {
            Object val = row.getPrimaryKeyValue();
            baseIds.add(val);
        }
        return baseIds;
    }

    public void viewDetail(Map<String, Object> param) {
        OrgProp prop;
        int rowKey = (Integer)param.get("rowKey");
        Object pkObject = this.getPkId(rowKey);
        if (pkObject == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u5f15\u7528\u5355\u636e\u3002", (String)"RefBillEdit_6", (String)BOS_FORM_METADATA, (Object[])new Object[0]));
            return;
        }
        BeforeF7ViewDetailEvent beforeF7ViewDetailEvent = new BeforeF7ViewDetailEvent(this, rowKey, pkObject);
        for (Consumer<BeforeF7ViewDetailEvent> consumer : this.beforeF7ViewDetailListeners) {
            EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE_PLUGIN, (String)(consumer.getClass().getName() + ".accept"));
            Throwable throwable = null;
            try {
                consumer.accept(beforeF7ViewDetailEvent);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (span == null) continue;
                if (throwable != null) {
                    try {
                        span.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                span.close();
            }
        }
        if (beforeF7ViewDetailEvent.isCancel()) {
            return;
        }
        BillShowParameter parameter = this.getView() instanceof IMobileListView ? new MobileBillShowParameter() : new BaseShowParameter();
        this.setParamUseOrgId(parameter, (IRefBillField)((RefBillProp)this.getProperty()));
        String billEntityId = this.getBillEntityId();
        Object source = beforeF7ViewDetailEvent.getSource();
        if (source instanceof OrgEdit && "01".equals((prop = (OrgProp)((OrgEdit)source).getProperty()).getOrgFunc())) {
            billEntityId = "bos_adminorg";
        }
        String objId = String.valueOf(pkObject);
        String pageId = this.getView().getPageId();
        IFormView view = this.getView().getViewNoPlugin(pageId + objId);
        if (Objects.nonNull(view)) {
            IFormView viewNoPlugin;
            Tab tab;
            String mainPageId = (String)this.getView().getFormShowParameter().getCustomParam("mainPageId");
            if (StringUtils.isBlank((CharSequence)mainPageId)) {
                mainPageId = this.getView().getFormShowParameter().getParentPageId();
            }
            if ((tab = (Tab)(viewNoPlugin = this.getView().getViewNoPlugin(mainPageId)).getControl("_submaintab_")) != null) {
                tab.activeTab(pageId + objId);
                this.getView().sendFormAction(viewNoPlugin);
                return;
            }
        }
        FormConfig formConfig = FormMetadataCache.getFormConfig(billEntityId);
        LocaleString caption = formConfig.getCaption();
        parameter.setParentFormId(this.view.getFormShowParameter().getParentFormId());
        parameter.setStatus(OperationStatus.VIEW);
        parameter.getOpenStyle().setShowType(formConfig.getViewShowType());
        if (formConfig.getViewShowType() != ShowType.Modal) {
            parameter.getOpenStyle().setTargetKey("tabap");
        }
        parameter.setFormId(this.hasLayout() ? this.getLayoutId() : billEntityId);
        parameter.setPkId(objId);
        parameter.setBillStatus(BillOperationStatus.VIEW);
        parameter.setPageId(pageId + objId);
        IDataEntityProperty property = this.getProperty();
        IDataModel model = this.getModel();
        DynamicObject billObject = (DynamicObject)model.getValue(property.getName(), rowKey);
        BillEntityType type = (BillEntityType)billObject.getDataEntityType();
        parameter.setCaption(caption.toString());
        if (formConfig.getViewShowType() != ShowType.Modal && !StringUtils.isBlank((CharSequence)type.getBillNo()) && !this.isBlank(billObject.get(type.getBillNo()))) {
            parameter.setCaption(caption.toString() + "-" + billObject.get(type.getBillNo()));
        }
        parameter.setCustomParam("PERM_IGNORE_CHECKAPP", true);
        this.getView().showForm(parameter);
    }

    private boolean isBlank(Object value) {
        if (StringUtils.isBlank((Object)value)) {
            return true;
        }
        if (value instanceof OrmLocaleValue) {
            OrmLocaleValue local = (OrmLocaleValue)value;
            return local.isEmpty();
        }
        return false;
    }

    protected void setParamUseOrgId(FormShowParameter parameter, IRefBillField refBillField) {
        long orgId = 0L;
        if (StringUtils.isNotEmpty((CharSequence)refBillField.getOrgProp())) {
            Object value = this.getDataModel().getValue(refBillField.getOrgProp() + "_id");
            if (value != null) {
                orgId = (Long)value;
            }
        } else {
            String mainOrg = this.getModel().getDataEntityType().getMainOrg();
            orgId = StringUtils.isNotBlank((CharSequence)mainOrg) ? this.getMainOrgId(mainOrg) : 0L;
        }
        this.useOrgIds.add(orgId);
        if (parameter instanceof ListShowParameter) {
            ((ListShowParameter)parameter).setUseOrgId(orgId);
        } else {
            ((BaseShowParameter)parameter).setUseOrgId(orgId);
        }
    }

    protected long getMainOrgId(String mainOrg) {
        DynamicObject obj = this.getModel().getDataEntity();
        long orgId = 0L;
        Object orgObj = obj.get(mainOrg);
        if (orgObj == null) {
            return orgId;
        }
        if (orgObj instanceof DynamicObject) {
            orgId = Long.parseLong(String.valueOf(((DynamicObject)orgObj).getPkValue()));
        } else if (orgObj instanceof Long) {
            orgId = (Long)orgObj;
        }
        return orgId;
    }
}

