/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.field.format;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import kd.bos.algo.DataSet;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.FlexEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.flex.FlexEntityMetaUtils;
import kd.bos.entity.flex.FlexProperty;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.list.column.FlexColumnDesc;
import kd.bos.entity.nameversion.NameVersionService;
import kd.bos.entity.property.AssistantProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.flex.FlexService;
import kd.bos.form.field.format.FieldFormatContext;
import kd.bos.form.flex.FlexValueFormatUtils;
import kd.bos.ksql.util.LRUCacheMap;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.Distinctable;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.WithEntityEntryDistinctable;
import kd.bos.util.CollectionUtils;
import kd.bos.util.ConfigurationChangeListener;
import kd.bos.util.ConfigurationUtil;
import kd.sdk.annotation.SdkPublic;
import org.apache.commons.collections.MapUtils;
import org.jetbrains.annotations.Nullable;

@SdkPublic
public class FlexValueFormatter {
    private static final Log log = LogFactory.getLog(FlexValueFormatter.class);
    String propKey;
    FieldFormatContext formatContext;
    Map<String, BaseFlexEntityTypeCollection> baseKeyMapFlexProperties;
    private Map<String, FlexProperty> flexKeyPropertyMap = new HashMap<String, FlexProperty>();
    private Map<Long, FlexProperty> flexIdPropertyMap = new HashMap<Long, FlexProperty>();
    Map<String, Map<Object, List<DynamicObject>>> baseDataCache = new LRUCacheMap(20);
    private Map<String, Map<Object, List<Long>>> basePkFlexSplitColsCache = new LRUCacheMap(16);
    private ORM orm;
    private static final String CACHE_SIZE = "flex.valueformat.cachesize";
    private static int flexValueFormatterCacheSize = Integer.parseInt(System.getProperty("flex.valueformat.cachesize", "50000"));
    private static final String FORMAT = "%s:%s";
    private String reportOrgIdField;
    private Object reportCurrentOrgId;

    public void setBaseKeyMapFlexProperties(Map<String, BaseFlexEntityTypeCollection> baseKeyMapFlexProperties) {
        this.baseKeyMapFlexProperties = baseKeyMapFlexProperties;
    }

    public Map<Object, List<Long>> getBasePkFlexSplitCols(String baseKey) {
        return this.basePkFlexSplitColsCache.get(baseKey);
    }

    protected void setOrm(ORM orm) {
        this.orm = orm;
    }

    protected ORM getOrm() {
        if (this.orm == null) {
            return ORM.create();
        }
        return this.orm;
    }

    public String getReportOrgIdField() {
        return this.reportOrgIdField;
    }

    public void setReportOrgIdField(String reportOrgIdField) {
        this.reportOrgIdField = reportOrgIdField;
    }

    public Object getReportCurrentOrgId() {
        return this.reportCurrentOrgId;
    }

    public void setReportCurrentOrgId(Object reportCurrentOrgId) {
        this.reportCurrentOrgId = reportCurrentOrgId;
    }

    public FlexValueFormatter(FieldFormatContext formatContext, String propKey) {
        this.propKey = propKey;
        this.formatContext = formatContext;
    }

    public FlexValueFormatter() {
    }

    public Object getDisplayValueForReport(DynamicObject v, FlexProp flexProp, String basePropKey) {
        FlexProperty flexProperty;
        if (flexProp == null) {
            return "";
        }
        Object val = flexProp.getValue((Object)v);
        if (val == null) {
            return "";
        }
        if (!(val instanceof DynamicObject)) {
            return "";
        }
        DynamicProperty dp2 = v.getDynamicObjectType().getProperty(basePropKey);
        if (dp2 == null) {
            return "";
        }
        DynamicObject baseVal = v.getDynamicObject(basePropKey);
        if (baseVal == null) {
            return "";
        }
        Map<String, String> flexValMap = FlexValueFormatter.getFlexValueMap(flexProp, v);
        if (flexValMap == null) {
            return "";
        }
        if (this.flexKeyPropertyMap.isEmpty()) {
            List flexProperties = FlexEntityMetaUtils.getFlexProperties((int)flexProp.getFlexTypeId());
            for (FlexProperty fp : flexProperties) {
                this.flexKeyPropertyMap.put(fp.getFlexField(), fp);
                this.flexIdPropertyMap.put(fp.getId(), fp);
            }
        }
        ArrayList<FlexProperty> flexPropertyList = null;
        DynamicObject relateBaseData = v.getDynamicObject(basePropKey);
        List<Long> flexPropertyIds = FlexValueFormatter.getBasedataUsedFlexProperties(relateBaseData);
        flexPropertyList = new ArrayList<FlexProperty>(flexPropertyIds.size());
        for (Long id : flexPropertyIds) {
            flexProperty = this.flexIdPropertyMap.get(id);
            if (flexProperty == null) {
                log.info("FlexValueFormatter.getDisplayValueForReport \u5f39\u6027\u57df\u5c5e\u6027\u7684\u5f39\u6027\u57df\u5b57\u6bb5\u4e0d\u5b58\u5728\uff0cid\uff1a" + id);
                throw new KDBizException(BosErrorCode.nullError, new Object[]{String.format(ResManager.loadKDString((String)"\u5f39\u6027\u57df\u5c5e\u6027\u7684\u5f39\u6027\u57df\u5b57\u6bb5%s\u4e0d\u5b58\u5728\u3002", (String)"FlexValueFormatter_0", (String)"bos-form-metadata", (Object[])new Object[0]), id)});
            }
            flexPropertyList.add(flexProperty);
        }
        if (flexProp.getFlexTypeId() == 2) {
            for (String flexField : flexValMap.keySet()) {
                flexProperty = this.flexKeyPropertyMap.get(flexField);
                if (flexProperty == null) {
                    log.info("FlexValueFormatter.getDisplayValueForReport \u6838\u7b97\u7ef4\u5ea6 \u5f39\u6027\u57df\u5c5e\u6027\u7684\u5f39\u6027\u57df\u5b57\u6bb5\u4e0d\u5b58\u5728\uff0cid\uff1a" + flexField);
                    throw new KDBizException(BosErrorCode.nullError, new Object[]{String.format(ResManager.loadKDString((String)"\u5f39\u6027\u57df\u5c5e\u6027\u7684\u5f39\u6027\u57df\u5b57\u6bb5%s\u4e0d\u5b58\u5728\u3002", (String)"FlexValueFormatter_0", (String)"bos-form-metadata", (Object[])new Object[0]), flexField)});
                }
                if (flexPropertyIds.contains(flexProperty.getId())) continue;
                flexPropertyList.add(flexProperty);
            }
        }
        return this.getReportFlexDisplayValue(v, flexProp, flexValMap, flexPropertyList);
    }

    private List<Object> getReportFlexDisplayValue(DynamicObject v, FlexProp flexProp, Map<String, String> flexValMap, List<FlexProperty> flexPropertyList) {
        ArrayList<Object> arr = new ArrayList<Object>();
        if (this.formatContext != null) {
            this.getBaseFlexEntityTypes();
        }
        for (FlexProperty propertyObject : flexPropertyList) {
            Object value;
            DynamicProperty dp = FlexEntityMetaUtils.createProperty((String)flexProp.getName(), (FlexProperty)propertyObject);
            String valueType = propertyObject.getValueType();
            if ("1".equals(valueType) || "2".equals(valueType)) {
                FlexProperty.DisplayStyle displayStyle = propertyObject.getDisplayStyle();
                ((BasedataProp)dp).setDisplayProp(displayStyle.getDisplayProperty().toString());
            }
            if (!(dp instanceof BasedataProp) && !(dp instanceof AssistantProp) && !(dp instanceof TextProp) || ObjectUtils.isEmpty((Object)(value = this.getFlexClientValueMap(v, (IDataEntityProperty)dp, flexValMap, true).get("alias")))) continue;
            arr.add(value);
        }
        return arr;
    }

    @Deprecated
    public static Object getReportDisplayValue(DynamicObject v, FlexProp flexProp, String basePropKey) {
        if (flexProp == null) {
            return "";
        }
        Object val = flexProp.getValue((Object)v);
        if (val == null) {
            return "";
        }
        if (!(val instanceof DynamicObject)) {
            return "";
        }
        DynamicProperty dp2 = v.getDynamicObjectType().getProperty(basePropKey);
        if (dp2 == null) {
            return "";
        }
        DynamicObject baseVal = v.getDynamicObject(basePropKey);
        if (baseVal == null) {
            return FlexValueFormatUtils.getReportDisplayValue(v, flexProp);
        }
        DynamicObject relateBaseData = v.getDynamicObject(basePropKey);
        List<Long> flexPropertyIds = FlexValueFormatter.getBasedataUsedFlexProperties(relateBaseData);
        FlexEntityType met = FlexEntityMetaUtils.getBasedataPropFlexEntityType((String)v.getDataEntityType().getName(), (String)flexProp.getName(), (int)flexProp.getFlexTypeId(), flexPropertyIds);
        List properties = met instanceof FlexEntityType ? met.getOrderProperties() : met.getProperties();
        Map<String, String> flexValMap = FlexValueFormatter.getFlexValueMap(flexProp, v);
        ArrayList<Object> arr = new ArrayList<Object>();
        FlexValueFormatter fv = new FlexValueFormatter(null, null);
        Iterator iterator = properties.iterator();
        while (iterator.hasNext()) {
            Object value;
            IDataEntityProperty flexObjectProp = (IDataEntityProperty)iterator.next();
            if (!(flexObjectProp instanceof BasedataProp) && !(flexObjectProp instanceof AssistantProp) && !(flexObjectProp instanceof TextProp) || ObjectUtils.isEmpty((Object)(value = fv.getFlexClientValueMap(v, flexObjectProp, flexValMap, false).get("alias")))) continue;
            arr.add(value);
        }
        return arr;
    }

    public static Map<String, String> getFlexValueMap(DynamicObject v, FlexProp flexProp, String basePropKey) {
        DynamicObject baseVal = FlexValueFormatter.getDynamicObject(v, flexProp, basePropKey);
        if (baseVal == null) {
            return new HashMap<String, String>(0);
        }
        return FlexValueFormatter.getFlexValueMap(flexProp, v);
    }

    public Object getListDisplayValue(DynamicObject v, FlexProp flexProp, String basePropKey) {
        DynamicObject baseVal = FlexValueFormatter.getDynamicObject(v, flexProp, basePropKey);
        if (baseVal == null) {
            return "";
        }
        Map<String, String> flexValMap = FlexValueFormatter.getFlexValueMap(flexProp, v);
        ArrayList<Map<String, Object>> arr = new ArrayList<Map<String, Object>>();
        MainEntityType met = this.getBaseFlexEntityType(basePropKey, baseVal.getPkValue(), flexProp, v);
        List properties = met instanceof FlexEntityType ? ((FlexEntityType)met).getOrderProperties() : met.getProperties();
        Iterator iterator = properties.iterator();
        while (iterator.hasNext()) {
            IDataEntityProperty flexObjectProp = (IDataEntityProperty)iterator.next();
            if (!(flexObjectProp instanceof BasedataProp) && !(flexObjectProp instanceof AssistantProp) && !(flexObjectProp instanceof TextProp)) continue;
            arr.add(this.getFlexClientValueMap(v, flexObjectProp, flexValMap, false));
        }
        return arr;
    }

    @Nullable
    private static DynamicObject getDynamicObject(DynamicObject v, FlexProp flexProp, String basePropKey) {
        if (flexProp == null) {
            return null;
        }
        Object val = flexProp.getValue((Object)v);
        if (val == null) {
            return null;
        }
        if (!(val instanceof DynamicObject)) {
            return null;
        }
        DynamicProperty dp2 = v.getDynamicObjectType().getProperty(basePropKey);
        if (dp2 == null) {
            return null;
        }
        DynamicObject baseVal = v.getDynamicObject(basePropKey);
        if (baseVal == null) {
            return null;
        }
        return baseVal;
    }

    private MainEntityType getBaseFlexEntityType(String basePropKey, Object basePkId, FlexProp flexProp, DynamicObject v) {
        boolean isFlexListBatchLoad = FlexEntityMetaUtils.isFlexListBatchLoad();
        if (!isFlexListBatchLoad) {
            DynamicObject relateBaseData = v.getDynamicObject(basePropKey);
            List<Long> flexPropertyIds = FlexValueFormatter.getBasedataUsedFlexProperties(relateBaseData);
            return FlexEntityMetaUtils.getBasedataPropFlexEntityType((String)v.getDataEntityType().getName(), (String)flexProp.getName(), (int)flexProp.getFlexTypeId(), flexPropertyIds);
        }
        Map<String, BaseFlexEntityTypeCollection> tmp = this.getBaseFlexEntityTypes();
        BaseFlexEntityType baseFlexEntityType = tmp.get(basePropKey).getBaseFlexEntityTypeMap(basePkId);
        if (baseFlexEntityType == null) {
            BasedataProp masterProp;
            DynamicObject baseObj;
            BasedataEntityType relateBDType = (BasedataEntityType)tmp.get(basePropKey).getBaseProp().getComplexType();
            DynamicObject relateBaseData = v.getDynamicObject(basePropKey);
            if (StringUtils.isBlank((CharSequence)relateBDType.getFlexProperty()) && relateBDType.getMasteridType() == 2 && (baseObj = (DynamicObject)(masterProp = (BasedataProp)relateBDType.getProperty(relateBDType.getMasteridPropName())).getValueFast((Object)relateBaseData)) != null) {
                baseFlexEntityType = tmp.get(basePropKey).getBaseFlexEntityTypeMap(baseObj.getPkValue());
            }
            if (baseFlexEntityType == null) {
                List<Long> baseFlexProperties = FlexValueFormatter.getBasedataUsedFlexProperties(relateBaseData);
                FlexEntityType met = FlexEntityMetaUtils.getBasedataPropFlexEntityType((String)"", (String)this.propKey, (int)flexProp.getFlexTypeId(), baseFlexProperties);
                if (met == null) {
                    met = MainEntityType.Empty;
                }
                return met;
            }
        }
        return baseFlexEntityType.getFlexEntityType();
    }

    private static List<Long> getBasedataUsedFlexProperties(DynamicObject relateBaseData) {
        if (relateBaseData == null || !(relateBaseData.getDataEntityType() instanceof BasedataEntityType)) {
            return new ArrayList<Long>();
        }
        BasedataEntityType relateBDType = (BasedataEntityType)relateBaseData.getDataEntityType();
        String relateBDEntityNumber = relateBDType.getName();
        Object relateBDPKValue = relateBaseData.getPkValue();
        String relateBDFlexPropertyKey = relateBDType.getFlexProperty();
        if (StringUtils.isBlank((CharSequence)relateBDType.getFlexProperty()) && relateBDType.getMasteridType() == 2) {
            BasedataProp masterProp = (BasedataProp)relateBDType.getProperty(relateBDType.getMasteridPropName());
            relateBDFlexPropertyKey = ((BasedataEntityType)masterProp.getComplexType()).getFlexProperty();
            relateBDEntityNumber = masterProp.getBaseEntityId();
            DynamicObject masterObj = (DynamicObject)masterProp.getValue((Object)relateBaseData);
            if (masterObj == null) {
                return new ArrayList<Long>();
            }
            relateBDPKValue = masterObj.getPkValue();
        }
        return FlexService.getBaseUseFlexProperties((String)relateBDEntityNumber, (Object)relateBDPKValue, (String)relateBDFlexPropertyKey);
    }

    public void preLoadFlexValueToCache(List<FlexProp> flexProps, DynamicObjectCollection dataEntities) {
        HashMap<String, Object> flexEntityTypeColls = new HashMap<String, Object>();
        for (FlexProp flexProp : flexProps) {
            String basePropertyKey = flexProp.getBasePropertyKey();
            DynamicProperty dp2 = dataEntities.getDynamicObjectType().getProperty(basePropertyKey);
            if (dp2 == null) continue;
            Object baseFlexEntityTypeColl = (BaseFlexEntityTypeCollection)flexEntityTypeColls.get(basePropertyKey);
            if (baseFlexEntityTypeColl == null) {
                baseFlexEntityTypeColl = new BaseFlexEntityTypeCollection();
                flexEntityTypeColls.put(basePropertyKey, baseFlexEntityTypeColl);
            }
            ((BaseFlexEntityTypeCollection)baseFlexEntityTypeColl).setBaseProp((BasedataProp)dp2);
            ((BaseFlexEntityTypeCollection)baseFlexEntityTypeColl).setFlexProp(flexProp);
        }
        HashMap flexFieldValueMap = new HashMap();
        HashMap basePropPKIds = new HashMap();
        for (DynamicObject dataEntity : dataEntities) {
            for (BaseFlexEntityTypeCollection baseFlexEntityTypeColl : flexEntityTypeColls.values()) {
                HashSet<Object> basePKIds;
                BasedataEntityType relateBDType = (BasedataEntityType)baseFlexEntityTypeColl.getBaseProp().getComplexType();
                String basePropName = relateBDType.getName();
                DynamicObject baseObj = (DynamicObject)baseFlexEntityTypeColl.getBaseProp().getValueFast((Object)dataEntity);
                if (baseObj != null && StringUtils.isBlank((CharSequence)relateBDType.getFlexProperty()) && relateBDType.getMasteridType() == 2) {
                    BasedataProp masterProp = (BasedataProp)relateBDType.getProperty(relateBDType.getMasteridPropName());
                    basePropName = masterProp.getBaseEntityId();
                    baseObj = (DynamicObject)masterProp.getValueFast((Object)baseObj);
                }
                if ((basePKIds = (HashSet<Object>)basePropPKIds.get(basePropName)) == null) {
                    basePKIds = new HashSet<Object>();
                    basePropPKIds.put(basePropName, basePKIds);
                }
                if (baseObj == null) continue;
                Object pkId = baseObj.getPkValue();
                basePKIds.add(pkId);
                Object flexValue = baseFlexEntityTypeColl.getFlexProp().getValueFast((Object)dataEntity);
                if (!(flexValue instanceof DynamicObject)) continue;
                Map flexMap = (Map)SerializationUtils.fromJsonString((String)((DynamicObject)flexValue).get("value").toString(), Map.class);
                for (Map.Entry entry : flexMap.entrySet()) {
                    String flexField = (String)entry.getKey();
                    Object value = entry.getValue();
                    if (this.baseDataCache.get(flexField) != null && this.baseDataCache.get(flexField).containsKey(value)) continue;
                    HashSet flexVals = (HashSet)flexFieldValueMap.get(flexField);
                    if (flexVals == null) {
                        flexVals = new HashSet();
                        flexFieldValueMap.put(flexField, flexVals);
                    }
                    flexVals.add(value);
                }
            }
        }
        for (Map.Entry entry : flexFieldValueMap.entrySet()) {
            FlexProperty fp = FlexEntityMetaUtils.getFlexProperty((String)((String)entry.getKey()));
            if (!"1".equals(fp.getValueType()) && !"2".equals(fp.getValueType())) continue;
            BasedataProp bp = (BasedataProp)FlexEntityMetaUtils.createProperty((String)((String)entry.getKey()), (FlexProperty)fp);
            DynamicObjectType baseDataType = (DynamicObjectType)bp.getComplexType();
            Map map = this.baseDataCache.computeIfAbsent((String)entry.getKey(), (Function<String, Map<Object, List<DynamicObject>>>)((Function<String, Map>)k -> new LRUCacheMap(flexValueFormatterCacheSize)));
            map.putAll(this.loadBasedata((BasedataEntityType)baseDataType, ((Set)entry.getValue()).toArray()));
        }
        for (Map.Entry entry : basePropPKIds.entrySet()) {
            for (BaseFlexEntityTypeCollection baseFlexEntityTypeColl : flexEntityTypeColls.values()) {
                boolean isMaster;
                BasedataEntityType baseEntityType = (BasedataEntityType)baseFlexEntityTypeColl.getBaseProp().getComplexType();
                String relateBDEntityNumber = baseEntityType.getName();
                String relateBDFlexPropertyKey = baseEntityType.getFlexProperty();
                boolean bl = isMaster = StringUtils.isBlank((CharSequence)relateBDFlexPropertyKey) && baseEntityType.getMasteridType() == 2;
                if (isMaster) {
                    BasedataProp masterProp = (BasedataProp)baseEntityType.getProperty(baseEntityType.getMasteridPropName());
                    relateBDFlexPropertyKey = ((BasedataEntityType)masterProp.getComplexType()).getFlexProperty();
                    relateBDEntityNumber = masterProp.getBaseEntityId();
                }
                if (!StringUtils.equals((CharSequence)relateBDEntityNumber, (CharSequence)((CharSequence)entry.getKey()))) continue;
                try {
                    Object[] baseIds = ((Set)entry.getValue()).toArray(new Object[0]);
                    if (baseIds.length <= 0) continue;
                    Map flexPropertyIds = FlexService.getBaseUseFlexProperties((String)relateBDEntityNumber, (String)relateBDFlexPropertyKey, (Object[])baseIds);
                    this.basePkFlexSplitColsCache.put(relateBDEntityNumber, flexPropertyIds);
                }
                catch (Exception e) {
                    log.error("FlexValueFormatter.preLoadFlexValueToCache : e = " + e);
                }
            }
        }
    }

    public DynamicObject getFlexData(String flexId, String flexField, Object pkValue, BasedataEntityType basedataEntityType) {
        List<DynamicObject> data;
        Map<Object, List<DynamicObject>> flexMap = this.baseDataCache.get(flexField);
        if (!MapUtils.isEmpty(flexMap) && !CollectionUtils.isEmpty(data = flexMap.get(pkValue))) {
            return data.get(0);
        }
        Map<Object, DynamicObject> datas = this.loadFromCache(new Object[]{pkValue}, (DynamicObjectType)basedataEntityType, Boolean.TRUE);
        HashMap data2 = new HashMap(datas.size());
        for (Map.Entry<Object, DynamicObject> entry : datas.entrySet()) {
            ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(1);
            list.add(entry.getValue());
            data2.put(entry.getKey(), list);
        }
        if (FlexEntityMetaUtils.isOutLog()) {
            FlexEntityMetaUtils.outLog((String)"FlexValueFormatter", (String)"getFlexData", (String)String.format("flex base %s:%s(%s) cache not find.", flexId, flexField, pkValue.toString()));
        }
        if (!this.baseDataCache.containsKey(flexField)) {
            this.baseDataCache.put(flexField, (Map<Object, List<DynamicObject>>)new LRUCacheMap(flexValueFormatterCacheSize));
        }
        this.baseDataCache.get(flexField).put(pkValue, (List<DynamicObject>)data2.get(pkValue));
        if (!CollectionUtils.isEmpty((Collection)((Collection)data2.get(pkValue)))) {
            return (DynamicObject)((List)data2.get(pkValue)).get(0);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, BaseFlexEntityTypeCollection> getBaseFlexEntityTypes() {
        if (this.baseKeyMapFlexProperties != null) {
            return this.baseKeyMapFlexProperties;
        }
        int preLoadFlexEntityTypeSize = this.formatContext.getPerPageSize();
        DynamicObjectCollection dataEntities = this.formatContext.getPageData();
        HashMap<String, BaseFlexEntityTypeCollection> flexEntityTypeColls = new HashMap<String, BaseFlexEntityTypeCollection>();
        for (AbstractColumnDesc desc : this.formatContext.getCols()) {
            if (!(desc instanceof FlexColumnDesc)) continue;
            String basePropKey = ((FlexColumnDesc)desc).getBasePropKey();
            DynamicProperty dp2 = dataEntities.getDynamicObjectType().getProperty(basePropKey);
            if (dp2 == null) continue;
            Object baseFlexEntityTypeColl = (BaseFlexEntityTypeCollection)flexEntityTypeColls.get(basePropKey);
            if (baseFlexEntityTypeColl == null) {
                baseFlexEntityTypeColl = new BaseFlexEntityTypeCollection();
                flexEntityTypeColls.put(basePropKey, (BaseFlexEntityTypeCollection)baseFlexEntityTypeColl);
            }
            ((BaseFlexEntityTypeCollection)baseFlexEntityTypeColl).setBaseProp((BasedataProp)dp2);
            ((BaseFlexEntityTypeCollection)baseFlexEntityTypeColl).setFlexProp((FlexProp)((FlexColumnDesc)desc).getFieldProp());
        }
        HashMap flexFieldValueMap = new HashMap();
        HashMap basePropPKIds = new HashMap();
        for (int i = 0; i < preLoadFlexEntityTypeSize; ++i) {
            DynamicObject dr = (DynamicObject)dataEntities.get(i);
            for (BaseFlexEntityTypeCollection baseFlexEntityTypeColl : flexEntityTypeColls.values()) {
                void var13_15;
                Set set;
                BasedataEntityType relateBDType = (BasedataEntityType)baseFlexEntityTypeColl.getBaseProp().getComplexType();
                String basePropName = relateBDType.getName();
                Object baseObj = (DynamicObject)baseFlexEntityTypeColl.getBaseProp().getValueFast((Object)dr);
                if (baseObj == null) continue;
                if (StringUtils.isBlank((CharSequence)relateBDType.getFlexProperty()) && relateBDType.getMasteridType() == 2) {
                    BasedataProp basedataProp = (BasedataProp)relateBDType.getProperty(relateBDType.getMasteridPropName());
                    basePropName = basedataProp.getBaseEntityId();
                    baseObj = (DynamicObject)basedataProp.getValueFast(baseObj);
                }
                if ((set = (Set)basePropPKIds.get(basePropName)) == null) {
                    HashSet hashSet = new HashSet();
                    basePropPKIds.put(basePropName, hashSet);
                }
                if (baseObj == null) continue;
                Object pkId = baseObj.getPkValue();
                var13_15.add(pkId);
                Object flexValue = baseFlexEntityTypeColl.getFlexProp().getValueFast((Object)dr);
                if (!(flexValue instanceof DynamicObject)) continue;
                Map flexMap = (Map)SerializationUtils.fromJsonString((String)((DynamicObject)flexValue).get("value").toString(), Map.class);
                for (Map.Entry entry : flexMap.entrySet()) {
                    String flexField = (String)entry.getKey();
                    Object value = entry.getValue();
                    if (this.baseDataCache.get(flexField) != null && this.baseDataCache.get(flexField).containsKey(value)) continue;
                    HashSet flexVals = (HashSet)flexFieldValueMap.get(flexField);
                    if (flexVals == null) {
                        flexVals = new HashSet();
                        flexFieldValueMap.put(flexField, flexVals);
                    }
                    flexVals.add(value);
                }
            }
        }
        HashMap mulBaseFlexProperties = new HashMap(16);
        for (Map.Entry flexPropertiesEntry : basePropPKIds.entrySet()) {
            Map baseFlexProperties = FlexService.getFlexProperties((String)((String)flexPropertiesEntry.getKey()), (Object[])((Set)flexPropertiesEntry.getValue()).toArray());
            mulBaseFlexProperties.put(flexPropertiesEntry.getKey(), baseFlexProperties);
        }
        for (Object baseFlexEntityTypeColl : flexEntityTypeColls.values()) {
            Map baseFlexProperties;
            BasedataEntityType relateBDType = (BasedataEntityType)((BaseFlexEntityTypeCollection)baseFlexEntityTypeColl).getBaseProp().getComplexType();
            String baseEntityName = relateBDType.getName();
            if (StringUtils.isBlank((CharSequence)relateBDType.getFlexProperty()) && relateBDType.getMasteridType() == 2) {
                BasedataProp masterProp = (BasedataProp)relateBDType.getProperty(relateBDType.getMasteridPropName());
                baseEntityName = masterProp.getBaseEntityId();
            }
            if ((baseFlexProperties = (Map)mulBaseFlexProperties.get(baseEntityName)) == null) continue;
            for (Map.Entry entry : baseFlexProperties.entrySet()) {
                Object basObj = entry.getKey();
                int flexTypeId = ((BaseFlexEntityTypeCollection)baseFlexEntityTypeColl).getFlexProp().getFlexTypeId();
                FlexEntityType met = FlexEntityMetaUtils.getBasedataPropFlexEntityType((String)"", (String)this.propKey, (int)flexTypeId, (List)((List)entry.getValue()));
                if (met == null) {
                    met = MainEntityType.Empty;
                }
                BaseFlexEntityType baseFlexEntityType = new BaseFlexEntityType();
                baseFlexEntityType.setFlexEntityType((MainEntityType)met);
                baseFlexEntityType.setFlexProperties((List)entry.getValue());
                ((BaseFlexEntityTypeCollection)baseFlexEntityTypeColl).addBaseFlexEntityType(basObj, baseFlexEntityType);
            }
        }
        this.baseKeyMapFlexProperties = flexEntityTypeColls;
        for (Map.Entry entry : flexFieldValueMap.entrySet()) {
            FlexProperty fp = FlexEntityMetaUtils.getFlexProperty((String)((String)entry.getKey()));
            if (!"1".equals(fp.getValueType()) && !"2".equals(fp.getValueType())) continue;
            BasedataProp bp = (BasedataProp)FlexEntityMetaUtils.createProperty((String)((String)entry.getKey()), (FlexProperty)fp);
            DynamicObjectType baseDataType = (DynamicObjectType)bp.getComplexType();
            Map map = this.baseDataCache.computeIfAbsent((String)entry.getKey(), (Function<String, Map<Object, List<DynamicObject>>>)((Function<String, Map>)k -> new LRUCacheMap(flexValueFormatterCacheSize)));
            map.putAll(this.loadBasedata((BasedataEntityType)baseDataType, ((Set)entry.getValue()).toArray()));
        }
        return this.baseKeyMapFlexProperties;
    }

    protected Map<Object, List<DynamicObject>> loadBasedata(BasedataEntityType type, Object[] masterIds) {
        if (Boolean.getBoolean("flex.personal.enable") && StringUtils.isNotBlank((CharSequence)this.getMainOrgByContext()) && StringUtils.isNotBlank((CharSequence)type.getMasteridPropName())) {
            QFilter[] filters = new QFilter[]{new QFilter(type.getMasteridPropName(), "in", (Object)masterIds)};
            ArrayList idList = new ArrayList(10);
            try (DataSet ds = this.getOrm().queryDataSet("FLEX_BASEDATA_LOADER", type.getName(), "id", filters, null, -1, (Distinctable)WithEntityEntryDistinctable.get());){
                ds.forEach(row -> idList.add(row.get(0)));
            }
            Map<Object, DynamicObject> datas = this.loadFromCache(idList.toArray(), (DynamicObjectType)type, Boolean.TRUE);
            HashMap<Object, List<DynamicObject>> map = new HashMap<Object, List<DynamicObject>>(datas.size());
            if (!datas.isEmpty()) {
                for (DynamicObject data : datas.values()) {
                    map.computeIfAbsent(data.get(type.getMasteridPropName()), k -> new ArrayList(1)).add(data);
                }
            }
            return map;
        }
        Map<Object, DynamicObject> datas = this.loadFromCache(masterIds, (DynamicObjectType)type, Boolean.TRUE);
        HashMap<Object, List<DynamicObject>> map = new HashMap<Object, List<DynamicObject>>(datas.size());
        for (Map.Entry<Object, DynamicObject> data : datas.entrySet()) {
            ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(1);
            list.add(data.getValue());
            map.put(data.getKey(), list);
        }
        return map;
    }

    protected Map<Object, DynamicObject> loadFromCache(Object[] pkArray, DynamicObjectType dt, boolean loadReferenceData) {
        return BusinessDataReader.loadFromCache((Object[])pkArray, (DynamicObjectType)dt, (boolean)loadReferenceData);
    }

    private static Map<String, String> getFlexValueMap(FlexProp flexProp, DynamicObject dataEntity) {
        DynamicObject flexObject = (DynamicObject)flexProp.getValue((Object)dataEntity);
        DynamicProperty p1 = flexProp.getDynamicComplexPropertyType().getProperty("value");
        Object flexValue = null;
        if (flexObject != null) {
            flexValue = p1.getValue((Object)flexObject);
        }
        if (flexValue != null) {
            return (Map)SerializationUtils.fromJsonString((String)flexValue.toString(), Map.class);
        }
        return null;
    }

    private String getMainOrgByContext() {
        if (this.formatContext != null && !this.formatContext.isForExport()) {
            if (this.formatContext.getKeyFields() != null) {
                return this.formatContext.getKeyFields().get("mainOrgId");
            }
        } else {
            if (!StringUtils.isEmpty((CharSequence)this.getReportOrgIdField())) {
                return this.getReportOrgIdField();
            }
            if (this.getReportCurrentOrgId() != null) {
                return "exists";
            }
        }
        return null;
    }

    protected Object getBaseDataValueByOrg(List<DynamicObject> baseDataValueList, DynamicObject currentRow) {
        BasedataEntityType dataEntityType;
        MainOrgProp mainOrgProperty;
        if (baseDataValueList == null || baseDataValueList.isEmpty()) {
            return null;
        }
        DynamicObject returnData = baseDataValueList.get(0);
        Object mainOrgId = this.getMainOrgId(currentRow);
        if (mainOrgId != null && (mainOrgProperty = (dataEntityType = (BasedataEntityType)baseDataValueList.get(0).getDataEntityType()).getMainOrgProperty()) != null) {
            for (DynamicObject baseDataValue : baseDataValueList) {
                DynamicObject mainOrg;
                Object value = mainOrgProperty.getValue((Object)baseDataValue);
                if (!(value instanceof DynamicObject) || !mainOrgId.equals((mainOrg = (DynamicObject)value).getPkValue())) continue;
                returnData = baseDataValue;
                break;
            }
        }
        return NameVersionService.getInstance().getNameVersionData(returnData, currentRow);
    }

    private Object getMainOrgId(DynamicObject currentRow) {
        Object mainOrgId = null;
        if (this.getReportCurrentOrgId() != null) {
            mainOrgId = this.getReportCurrentOrgId();
        } else {
            String mainOrgIdField = this.getMainOrgByContext();
            if (!StringUtils.isEmpty((CharSequence)mainOrgIdField) && (mainOrgId = currentRow.get(mainOrgIdField)) instanceof DynamicObject) {
                mainOrgId = ((DynamicObject)mainOrgId).get("id");
            }
        }
        return mainOrgId;
    }

    private Map<String, Object> getFlexClientValueMap(DynamicObject currentRow, IDataEntityProperty flexObjectProp, Map<String, String> valueMap, boolean isFromReport) {
        String keyShort = "k";
        String valueShort = "v";
        String aliasShort = "alias";
        HashMap<String, Object> flexValueMap = new HashMap<String, Object>();
        if (valueMap == null) {
            flexValueMap.put(keyShort, flexObjectProp.getName());
            flexValueMap.put(valueShort, "");
            flexValueMap.put(aliasShort, "");
        } else {
            String[] keys = flexObjectProp.getName().split("__");
            String value = valueMap.get(keys[1]);
            if (value != null) {
                if (flexObjectProp instanceof BasedataProp) {
                    flexValueMap.put(keyShort, flexObjectProp.getName());
                    Object baseValue = value;
                    BasedataProp baseProp = (BasedataProp)flexObjectProp;
                    DynamicObjectType flexDataType = (DynamicObjectType)baseProp.getComplexType();
                    int dbType = flexDataType.getPrimaryKey().getDbType();
                    if (dbType == -5) {
                        baseValue = Long.parseLong(String.valueOf(baseValue));
                    }
                    List<DynamicObject> baseDataObjectValueList = null;
                    if (this.baseDataCache.get(keys[1]) != null) {
                        baseDataObjectValueList = this.baseDataCache.get(keys[1]).get(baseValue);
                    }
                    if (baseDataObjectValueList == null) {
                        Map<Object, List<DynamicObject>> map = this.loadBasedata((BasedataEntityType)flexDataType, new Object[]{baseValue});
                        baseDataObjectValueList = map.get(baseValue);
                        if (FlexEntityMetaUtils.isOutLog()) {
                            FlexEntityMetaUtils.outLog((String)"FlexValueFormatter", (String)"", (String)String.format("flex base %s:%s(%s) cache not find.", flexObjectProp.getName(), keys[1], baseValue.toString()));
                        }
                        if (isFromReport) {
                            if (!this.baseDataCache.containsKey(keys[1])) {
                                this.baseDataCache.put(keys[1], (Map<Object, List<DynamicObject>>)new LRUCacheMap(flexValueFormatterCacheSize));
                            }
                            this.baseDataCache.get(keys[1]).put(baseValue, baseDataObjectValueList);
                        }
                    }
                    String displayProperty = baseProp.getDisplayProp();
                    Object[] arrValue = (Object[])baseProp.getBindingBasedataValue(this.getBaseDataValueByOrg(baseDataObjectValueList, currentRow), displayProperty);
                    boolean valIsNull = true;
                    for (Object v : arrValue) {
                        if (v == null || !StringUtils.isNotBlank((CharSequence)v.toString())) continue;
                        valIsNull = false;
                        break;
                    }
                    if (valIsNull) {
                        flexValueMap.put(valueShort, "");
                    } else {
                        flexValueMap.put(valueShort, arrValue);
                    }
                    String alias = "";
                    if (arrValue[0] != null && StringUtils.isNotBlank((CharSequence)arrValue[0].toString()) || arrValue[1] != null && StringUtils.isNotBlank((CharSequence)arrValue[1].toString())) {
                        String displayProp = ((BasedataProp)flexObjectProp).getDisplayProp();
                        Object displayVal = displayProp.equals("number") ? arrValue[0] : (displayProp.equals("name") ? arrValue[1] : (displayProp.equalsIgnoreCase("longNumber") ? arrValue[3] : (displayProp.equals("fullName") ? arrValue[4] : (displayProp.equals("number,fullName") ? String.format("%s,%s", arrValue[0], arrValue[4]) : String.format("%s,%s", arrValue[0], arrValue[1])))));
                        alias = String.format(FORMAT, ((BasedataProp)flexObjectProp).getDisplayName(), displayVal);
                    }
                    flexValueMap.put(aliasShort, alias);
                } else if (flexObjectProp instanceof TextProp) {
                    flexValueMap.put(keyShort, flexObjectProp.getName());
                    flexValueMap.put(valueShort, value);
                    String alias = "";
                    if (StringUtils.isNotBlank((Object)value)) {
                        alias = String.format(FORMAT, ((TextProp)flexObjectProp).getDisplayName(), value);
                    }
                    flexValueMap.put(aliasShort, alias);
                }
            } else {
                flexValueMap.put(keyShort, flexObjectProp.getName());
                flexValueMap.put(valueShort, "");
                flexValueMap.put(aliasShort, "");
            }
        }
        return flexValueMap;
    }

    private Map<Object, MainEntityType> getBaseFlexEntityTypes(BasedataProp baseProp, FlexProp flexProp, DynamicObjectCollection dataEntities) {
        int rowCount = dataEntities.size();
        Object[] basePKIds = new Object[rowCount];
        for (int i = 0; i < rowCount; ++i) {
            DynamicObject dataEntity = (DynamicObject)dataEntities.get(i);
            basePKIds[i] = baseProp.getValueFast((Object)dataEntity);
        }
        Map baseFlexProperties = FlexService.getFlexProperties((String)baseProp.getComplexType().getName(), (Object[])basePKIds);
        HashMap<Object, MainEntityType> baseFlexEntityTypes = new HashMap<Object, MainEntityType>();
        for (Map.Entry entry : baseFlexProperties.entrySet()) {
            Object basObj = entry.getKey();
            MainEntityType met = (MainEntityType)baseFlexEntityTypes.get(basObj);
            if (met != null) continue;
            met = FlexEntityMetaUtils.getBasedataPropFlexEntityType((String)"", (String)this.propKey, (int)flexProp.getFlexTypeId(), (List)((List)baseFlexProperties.get(basObj)));
            if (met == null) {
                met = MainEntityType.Empty;
            }
            baseFlexEntityTypes.put(basObj, met);
        }
        return baseFlexEntityTypes;
    }

    static {
        ConfigurationUtil.observeChange((String)CACHE_SIZE, (ConfigurationChangeListener)new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                flexValueFormatterCacheSize = Integer.parseInt(System.getProperty(FlexValueFormatter.CACHE_SIZE, "50000"));
            }
        });
    }

    static class FlexValueDataRowCollection {
        FlexValueDataRowCollection() {
        }
    }

    static class FlexValueDataRow {
        MainEntityType mainEntityType;
        DynamicObject dataEntity;
        BasedataProp baseProp;
        FlexProp flexProp;
        List<Object> clientData = new ArrayList<Object>();

        public List<IDataEntityProperty> getProperties() {
            if (this.mainEntityType instanceof FlexEntityType) {
                return ((FlexEntityType)this.mainEntityType).getOrderProperties();
            }
            return new ArrayList<IDataEntityProperty>();
        }

        public DynamicObject getDataEntity() {
            return this.dataEntity;
        }

        public void setDataEntity(DynamicObject dataEntity) {
            this.dataEntity = dataEntity;
        }

        public FlexValueDataRow(DynamicObject dataEntity, BasedataProp baseProp, FlexProp flexProp, MainEntityType met) {
            this.dataEntity = dataEntity;
            this.baseProp = baseProp;
            this.flexProp = flexProp;
            this.mainEntityType = met;
        }

        public Object getBasedataId() {
            return this.baseProp.getValueFast((Object)this.dataEntity);
        }

        public Map<String, String> getFlexValueMap() {
            return this.getFlexValueMap(this.flexProp, this.dataEntity);
        }

        public List<Object> getClientData() {
            return this.clientData;
        }

        private Map<String, String> getFlexValueMap(FlexProp flexProp, DynamicObject dataEntity) {
            DynamicObject flexObject = (DynamicObject)flexProp.getValue((Object)dataEntity);
            DynamicProperty p1 = flexProp.getDynamicComplexPropertyType().getProperty("value");
            Object flexValue = null;
            if (flexObject != null) {
                flexValue = p1.getValue((Object)flexObject);
            }
            if (flexValue != null) {
                return (Map)SerializationUtils.fromJsonString((String)flexValue.toString(), Map.class);
            }
            return null;
        }
    }

    static class FormatDynamicObjectData {
        FormatDynamicObjectData() {
        }
    }

    static class BaseFlexEntityType {
        List<Long> flexProperties = new ArrayList<Long>();
        MainEntityType flexEntityType;

        BaseFlexEntityType() {
        }

        public List<Long> getFlexProperties() {
            return this.flexProperties;
        }

        public void setFlexProperties(List<Long> flexProperties) {
            this.flexProperties = flexProperties;
        }

        public MainEntityType getFlexEntityType() {
            return this.flexEntityType;
        }

        public void setFlexEntityType(MainEntityType flexEntityType) {
            this.flexEntityType = flexEntityType;
        }
    }

    static class BaseFlexEntityTypeCollection {
        BasedataProp baseProp;
        FlexProp flexProp;
        Map<Object, BaseFlexEntityType> baseFlexEntityTypeMap = new ConcurrentHashMap<Object, BaseFlexEntityType>();

        public BasedataProp getBaseProp() {
            return this.baseProp;
        }

        public FlexProp getFlexProp() {
            return this.flexProp;
        }

        public void setBaseProp(BasedataProp baseProp) {
            this.baseProp = baseProp;
        }

        public void setFlexProp(FlexProp flexProp) {
            this.flexProp = flexProp;
        }

        public BaseFlexEntityType getBaseFlexEntityTypeMap(Object basePkId) {
            return this.baseFlexEntityTypeMap.get(basePkId);
        }

        public void addBaseFlexEntityType(Object basePkId, BaseFlexEntityType baseFlexEntityType) {
            this.baseFlexEntityTypeMap.put(basePkId, baseFlexEntityType);
        }
    }
}

