/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.flex;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.entity.flex.CreateFlexMetaArgs;
import kd.bos.entity.flex.FlexEntityMetaUtils;
import kd.bos.entity.flex.FlexType;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.ControlTypes;
import kd.bos.form.FormConfig;
import kd.bos.form.control.Control;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.RuntimeFlexMetaService;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class FlexFormMetaUtils {
    static FlexFormMetaCollection flexFormMetas = new FlexFormMetaCollection();

    public static void clearFlexFormMeta() {
        flexFormMetas.clear();
    }

    public static FlexType getFlexType(int id) {
        return FlexEntityMetaUtils.getFlexType((int)id);
    }

    public static FormConfig getFormConfig(CreateFlexMetaArgs args) {
        FlexFormMeta flexFormMeta = FlexFormMetaUtils.getFlexMeta(args);
        return flexFormMeta.formConfig;
    }

    public static Map<String, Object> getClientFormMeta(CreateFlexMetaArgs args) {
        FlexFormMeta flexFormMeta = FlexFormMetaUtils.getFlexMeta(args);
        return flexFormMeta.clientFormMeta;
    }

    public static List<Control> getFlexControl(CreateFlexMetaArgs args) {
        FlexFormMeta flexFormMeta = FlexFormMetaUtils.getFlexMeta(args);
        return flexFormMeta.flexControlList;
    }

    private static FlexFormMeta getFlexMeta(CreateFlexMetaArgs args) {
        Object ret = null;
        FlexFormMeta flexFormMeta = new FlexFormMeta();
        flexFormMeta.propertyIds = args.getPropertyIds();
        try {
            RuntimeFlexMetaService service = (RuntimeFlexMetaService)ServiceFactory.getService(RuntimeFlexMetaService.class);
            String className = service.getRuntimeFlexMetaClassName();
            Class<?> flexMeta = Class.forName(className);
            Method getFormConfig = flexMeta.getMethod("getFormConfig", new Class[0]);
            Method getClientFormMeta = flexMeta.getMethod("getClientFormMeta", new Class[0]);
            Method getControls = flexMeta.getMethod("getControls", new Class[0]);
            Object flexMetaInstance = flexMeta.getConstructor(CreateFlexMetaArgs.class).newInstance(args);
            ret = getFormConfig.invoke(flexMetaInstance, new Object[0]);
            flexFormMeta.formConfig = (FormConfig)ret;
            ret = getClientFormMeta.invoke(flexMetaInstance, new Object[0]);
            flexFormMeta.clientFormMeta = (Map)ret;
            ret = getControls.invoke(flexMetaInstance, new Object[0]);
            List controlJsonList = (List)ret;
            for (String str : controlJsonList) {
                flexFormMeta.flexControlList.add((Control)ControlTypes.fromJsonString(str));
            }
            return flexFormMeta;
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new KDException((Throwable)e, BosErrorCode.cannotLoadBeanClass, new Object[]{e.getMessage()});
        }
    }

    private static class FlexFormMetaCollection {
        Map<String, List<FlexFormMeta>> flexFormMetaMap = new ConcurrentHashMap<String, List<FlexFormMeta>>();

        private FlexFormMetaCollection() {
        }

        void add(String formKey, String flexFieldKey, FlexFormMeta flexFormMeta) {
            String key = this.getCacheKey(formKey, flexFieldKey);
            List<FlexFormMeta> list = this.flexFormMetaMap.get(key);
            if (list == null) {
                list = new ArrayList<FlexFormMeta>();
                this.flexFormMetaMap.put(key, list);
            }
            list.add(flexFormMeta);
        }

        FlexFormMeta get(String formKey, String flexFieldKey, List<Long> propertyIds) {
            String key = this.getCacheKey(formKey, flexFieldKey);
            List<FlexFormMeta> flexFormMetaList = this.flexFormMetaMap.get(key);
            if (flexFormMetaList == null) {
                return null;
            }
            for (FlexFormMeta flexFormMeta : flexFormMetaList) {
                if (!this.compareList(flexFormMeta.propertyIds, propertyIds)) continue;
                return flexFormMeta;
            }
            return null;
        }

        boolean compareList(List<Long> oldPropertyIds, List<Long> newPropertyIds) {
            if (oldPropertyIds == null && newPropertyIds == null) {
                return true;
            }
            if (oldPropertyIds != null && newPropertyIds == null || oldPropertyIds == null && newPropertyIds != null) {
                return false;
            }
            if (oldPropertyIds.size() != newPropertyIds.size()) {
                return false;
            }
            for (Long id : newPropertyIds) {
                if (oldPropertyIds.contains(id)) continue;
                return false;
            }
            return true;
        }

        String getCacheKey(String formKey, String flexFieldKey) {
            return String.format("%s_flex_%s", formKey, flexFieldKey);
        }

        void clear() {
            this.flexFormMetaMap.clear();
        }
    }

    private static class FlexFormMeta {
        List<Long> propertyIds;
        FormConfig formConfig = new FormConfig();
        Map<String, Object> clientFormMeta = new HashMap<String, Object>();
        List<Control> flexControlList = new ArrayList<Control>();
        static FlexFormMeta INSTANCE = new FlexFormMeta();

        FlexFormMeta() {
        }
    }
}

