/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.gpt;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.TypesContainer;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.gpt.IGPTAction;
import kd.bos.form.gpt.IGPTFormAction;
import kd.bos.form.gpt.IGPTService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.ExceptionUtils;
import org.apache.commons.lang.reflect.MethodUtils;

public class GPTServiceImpl
implements IGPTService {
    private static Log logger = LogFactory.getLog(GPTServiceImpl.class);

    @Override
    public Object invokeGptAction(String clazz, String method, Object ... args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        logger.info(String.format("invoke Gpt Action class: %s , method:%s begin", clazz, method));
        Object result = false;
        try {
            Object obj = TypesContainer.createInstance((String)clazz);
            if (!(obj instanceof IGPTFormAction) && !(obj instanceof IGPTAction)) {
                throw new KDBizException(new ErrorCode("ai.invokeGptAction", "invalid invoke. %s"), new Object[]{String.format("invalid invoke. class:%s", clazz)});
            }
            result = MethodUtils.invokeMethod((Object)obj, (String)method, (Object[])args);
        }
        catch (Exception e) {
            logger.error(String.format("Invoke class: %s , method: %s Error! msg:%s, stack:%s", clazz, method, e.getMessage(), ExceptionUtils.getExceptionStackTraceMessage((Exception)e)));
            if (e instanceof InvocationTargetException) {
                InvocationTargetException ite = (InvocationTargetException)e;
                Throwable t = ite.getTargetException();
                String msg = t.getMessage();
                if (msg == null) {
                    msg = t.getClass().getSimpleName();
                }
                throw new KDBizException(t, new ErrorCode("ai.invokeGptAction", msg), new Object[]{msg});
            }
            throw e;
        }
        return result;
    }

    @Override
    public Map<String, Object> getObject(String clazz) throws InvocationTargetException {
        StringBuilder builder = new StringBuilder();
        builder.append("invoke Gpt Action class: ").append(clazz).append(" begin");
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        int status = 1;
        String type = "";
        try {
            Object obj = TypesContainer.createInstance((String)clazz);
            if (obj instanceof IGPTFormAction) {
                type = "IGPTFormAction";
            } else if (obj instanceof IGPTAction) {
                type = "IGPTAction";
            }
            result.put("type", type);
        }
        catch (Exception e) {
            status = 0;
            logger.error(String.format("GPT clazz:%s instance error, err:%s", clazz, e.getMessage()), (Throwable)e);
        }
        result.put("status", status);
        builder.append("invoke Gpt Action class: ").append(clazz).append(" end");
        logger.info(builder.toString());
        return result;
    }
}

