/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.mcontrol;

import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Map;
import kd.bos.base.MobileBaseShowParameter;
import kd.bos.bill.MobileBillShowParameter;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.TypesContainer;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.gray.AppGroupUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.list.ListShowParameter;
import kd.bos.list.MobileListShowParameter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.sdk.annotation.SdkInternal;

public class MTabBar
extends Container {
    @SdkInternal
    public void showForm(Map<String, Object> args) {
        if (CollectionUtils.isEmpty(args)) {
            return;
        }
        Object formId = args.get("formId");
        Object modelType = args.get("type");
        if (formId == null || modelType == null || StringUtils.isEmpty((Object)formId.toString())) {
            return;
        }
        String number = this.getNumberById(formId.toString());
        if (!modelType.toString().startsWith("mobile")) {
            return;
        }
        Class<?> clasz = this.getType().get(modelType.toString());
        if (clasz == null) {
            return;
        }
        FormShowParameter showParameter = (FormShowParameter)TypesContainer.createInstance(clasz);
        OpenStyle openStyle = new OpenStyle();
        openStyle.setShowType(ShowType.InContainer);
        openStyle.setTargetKey(args.get("targetKey").toString());
        showParameter.setOpenStyle(openStyle);
        switch (modelType.toString()) {
            case "mobilelist": {
                ((ListShowParameter)showParameter).setBillFormId(number);
                break;
            }
            case "mobileform": {
                showParameter.setFormId(number);
                break;
            }
            case "mobilebill": 
            case "mobilebase": {
                showParameter.setFormId(number + "_mob");
                break;
            }
        }
        this.getView().showForm(showParameter);
    }

    @SdkInternal
    public void activeForm(Map<String, Object> args) {
        IFormView childView;
        Object pageId = args.get("pageId");
        if (pageId != null && (childView = this.getView().getViewNoPlugin(pageId.toString())) != null) {
            childView.getFormShowParameter().setHasRight(true);
            childView.activate();
            this.getView().sendFormAction(childView);
        }
    }

    private String getNumberById(String id) {
        String sql = String.format("select FNumber from %s where FId = ? ", this.getGrayTableName("T_META_FORMDESIGN"));
        Object[] params = new SqlParameter[]{new SqlParameter(":FId", 12, (Object)id)};
        ResultSetHandler<String> action = new ResultSetHandler<String>(){

            public String handle(ResultSet rs) throws Exception {
                if (rs.next()) {
                    return rs.getString(1);
                }
                return null;
            }
        };
        String number = (String)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)action);
        return number;
    }

    private String getGrayTableName(String tabName) {
        String appGroup = AppGroupUtils.getCurrentAppGroup();
        if (StringUtils.isEmpty((Object)appGroup) || "defaultGroup".equals(appGroup)) {
            return tabName;
        }
        return String.format("%s_%s", tabName, appGroup);
    }

    private Map<String, Class<?>> getType() {
        HashMap ptypes = new HashMap(16);
        ptypes.put("mobilebase", MobileBaseShowParameter.class);
        ptypes.put("mobilebill", MobileBillShowParameter.class);
        ptypes.put("mobileform", MobileFormShowParameter.class);
        ptypes.put("mobilelist", MobileListShowParameter.class);
        return ptypes;
    }
}

