/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.mcontrol.mobtable;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.form.mcontrol.mobtable.IMobTableDataProvider;
import kd.bos.form.mcontrol.mobtable.IMobTableModel;
import kd.bos.form.mcontrol.mobtable.IMobTablePackageDataHandler;
import kd.bos.form.mcontrol.mobtable.MobTable;
import kd.bos.form.mcontrol.mobtable.MobTableData;
import kd.bos.form.mcontrol.mobtable.MobTableDataProvider;
import kd.bos.form.mcontrol.mobtable.MobTablePackageDataHandler;
import kd.bos.form.mcontrol.mobtable.events.IMobTablePackageDataHandlerListener;
import kd.bos.form.mcontrol.mobtable.events.MobTableDataProviderArgs;
import kd.bos.form.mcontrol.mobtable.events.MobTableHandleResult;
import kd.bos.form.mcontrol.mobtable.events.MobTablePackageDataHandlerArgs;
import kd.bos.form.mcontrol.mobtable.events.MobTablePackageDataHandlerEvent;
import kd.bos.form.mcontrol.mobtable.tablecolumn.MobTableColumn;

public class MobTableModel
implements IMobTableModel {
    private static final String DATA_INDEX = "dataindex";
    private static final String ROW_COUNT = "rowcount";
    private static final String ROWS = "rows";
    private List<MobTableColumn> mobTableColumns;
    private IMobTableDataProvider mobTableDataProvider;
    private List<IMobTablePackageDataHandlerListener> mobTablePackageDataListeners = new ArrayList<IMobTablePackageDataHandlerListener>();
    private IMobTablePackageDataHandler mobTablePackageDataHandler;
    private String entityId;
    private EntityType entityType;
    private String entityTypeId;
    private String entryKey;
    private Object pkId;
    private MobTable control;

    @Override
    public void setMobTableColumns(List<MobTableColumn> mobTableColumns) {
        this.mobTableColumns = mobTableColumns;
        this.initMobTableDataProvider();
    }

    @Override
    public List<MobTableColumn> getMobTableColumns() {
        return this.mobTableColumns;
    }

    @Override
    public IMobTableDataProvider getMobTableDataProvider() {
        return this.mobTableDataProvider;
    }

    @Override
    public void setMobTableDataProvider(IMobTableDataProvider mobTableDataProvider) {
        this.mobTableDataProvider = mobTableDataProvider;
    }

    public void setMobTablePackageDataListeners(List<IMobTablePackageDataHandlerListener> mobTablePackageDataListeners) {
        this.mobTablePackageDataListeners = mobTablePackageDataListeners;
    }

    public IMobTablePackageDataHandler getMobTablePackageDataHandler() {
        return this.mobTablePackageDataHandler;
    }

    public void setMobTablePackageDataHandler(IMobTablePackageDataHandler mobTablePackageDataHandler) {
        this.mobTablePackageDataHandler = mobTablePackageDataHandler;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public String getEntityTypeId() {
        return this.entityTypeId;
    }

    public void setEntityTypeId(String entityTypeId) {
        this.entityTypeId = entityTypeId;
    }

    @Override
    @Deprecated
    public EntityType getDataEntityType() {
        if (this.entityType == null && StringUtils.isNotBlank((CharSequence)this.getEntityId())) {
            this.entityType = EntityMetadataCache.getDataEntityType((String)this.getEntityTypeId());
        }
        return this.entityType;
    }

    @Override
    public void setDataEntityType(EntityType value) {
        this.entityType = value;
    }

    @Override
    public String getEntryKey() {
        return this.entryKey;
    }

    public void setEntryKey(String entryKey) {
        this.entryKey = entryKey;
    }

    @Override
    public Object getPkId() {
        return this.pkId;
    }

    public void setPkId(Object pkId) {
        this.pkId = pkId;
    }

    public MobTable getControl() {
        return this.control;
    }

    public void setControl(MobTable control) {
        this.control = control;
    }

    private void initMobTableDataProvider() {
        if (this.mobTableDataProvider == null) {
            this.mobTableDataProvider = new MobTableDataProvider();
        }
    }

    @Override
    public MobTableData getData() {
        MobTableDataProviderArgs mobTableDataProviderArgs = this.createMobTableDataProviderArgs();
        DynamicObjectCollection pageData = this.getMobTableDataProvider().getData(mobTableDataProviderArgs);
        MobTablePackageDataHandlerEvent event = new MobTablePackageDataHandlerEvent(this);
        this.fireCreateMobTablePackageDataHandler(event);
        IMobTablePackageDataHandler dataHandler = this.getMobTablePackageDataHandler();
        if (dataHandler == null) {
            dataHandler = new MobTablePackageDataHandler();
        }
        MobTablePackageDataHandlerArgs dataHandlerArgs = MobTableModel.convertToHandlerArgs(mobTableDataProviderArgs);
        dataHandlerArgs.setEntityId(this.getEntityId());
        dataHandlerArgs.setControl(this.getControl());
        DynamicObjectCollection newPageData = dataHandler.getData(dataHandlerArgs) != null ? dataHandler.getData(dataHandlerArgs) : pageData;
        dataHandlerArgs.setPageData(newPageData);
        dataHandler.handleSummary(dataHandlerArgs);
        MobTableHandleResult handleResult = dataHandler.handleData(dataHandlerArgs);
        handleResult.setDataIndexMap(this.getDataIndex());
        List<Object> rows = handleResult.getRows();
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(DATA_INDEX, this.getDataIndex());
        data.put(ROW_COUNT, handleResult.getRowCount() != null ? handleResult.getRowCount().intValue() : rows.size());
        data.put(ROWS, rows);
        MobTableData mobTableData = new MobTableData();
        mobTableData.setData(data);
        mobTableData.setFmtInfo(handleResult.getFmtInfo());
        return mobTableData;
    }

    private void fireCreateMobTablePackageDataHandler(MobTablePackageDataHandlerEvent event) {
        for (IMobTablePackageDataHandlerListener packageDataListener : this.mobTablePackageDataListeners) {
            packageDataListener.createMobTablePackageDataHandler(event);
        }
        if (event.getMobTablePackageDataHandler() != null) {
            this.setMobTablePackageDataHandler(event.getMobTablePackageDataHandler());
        }
    }

    private MobTableDataProviderArgs createMobTableDataProviderArgs() {
        MobTableDataProviderArgs providerArgs = new MobTableDataProviderArgs();
        providerArgs.setMobTableColumns(this.getMobTableColumns());
        providerArgs.setEntityType(this.getDataEntityType());
        providerArgs.setEntityTypeId(this.getEntityTypeId());
        providerArgs.setEntryKey(this.getEntryKey());
        providerArgs.setPkId(this.getPkId());
        return providerArgs;
    }

    public static MobTablePackageDataHandlerArgs convertToHandlerArgs(MobTableDataProviderArgs providerArgs) {
        MobTablePackageDataHandlerArgs dataHandlerArgs = new MobTablePackageDataHandlerArgs();
        dataHandlerArgs.setMobTableColumns(providerArgs.getMobTableColumns());
        dataHandlerArgs.setEntityTypeId(providerArgs.getEntityTypeId());
        dataHandlerArgs.setEntryKey(providerArgs.getEntryKey());
        dataHandlerArgs.setPkId(providerArgs.getPkId());
        return dataHandlerArgs;
    }

    private Map<String, Integer> getDataIndex() {
        HashMap<String, Integer> dataIndex = new HashMap<String, Integer>(16);
        dataIndex.put("rk", 0);
        dataIndex.put("fseq", 1);
        dataIndex.put("id", 2);
        dataIndex.put("pid", 3);
        int i = 4;
        for (MobTableColumn mobTableColumn : this.getMobTableColumns()) {
            dataIndex.put(mobTableColumn.getFieldKey(), i);
            ++i;
        }
        dataIndex.put("l", i);
        dataIndex.put("s", i + 1);
        dataIndex.put("vi", i + 2);
        dataIndex.put("cprop", i + 3);
        return dataIndex;
    }
}

