/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.mcontrol.mobtable;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.NumberFormatProvider;
import kd.bos.entity.datamodel.FmtField;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.QtyProp;
import kd.bos.entity.property.UnitProp;
import kd.bos.form.BindingContext;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.container.FormRoot;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.mcontrol.mobtable.IMobTablePackageDataHandler;
import kd.bos.form.mcontrol.mobtable.MobTable;
import kd.bos.form.mcontrol.mobtable.MobTableRowBuilder;
import kd.bos.form.mcontrol.mobtable.MobTableRowData;
import kd.bos.form.mcontrol.mobtable.events.IMobTablePrepareDataListener;
import kd.bos.form.mcontrol.mobtable.events.MobTableHandleResult;
import kd.bos.form.mcontrol.mobtable.events.MobTablePackageDataHandlerArgs;
import kd.bos.form.mcontrol.mobtable.events.MobTablePrepareDataArgs;
import kd.bos.form.mcontrol.mobtable.tablecolumn.AmountMobTableColumn;
import kd.bos.form.mcontrol.mobtable.tablecolumn.DecimalMobTableColumn;
import kd.bos.form.mcontrol.mobtable.tablecolumn.MobTableColumn;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class MobTablePackageDataHandler
implements IMobTablePackageDataHandler {
    private static final Log logger = LogFactory.getLog(MobTablePackageDataHandler.class);
    private static final String RK = "rk";
    private static final String TABLE_DATA = "table_data";

    @Override
    public DynamicObjectCollection getData(MobTablePackageDataHandlerArgs args) {
        DynamicObjectCollection pageData = new DynamicObjectCollection();
        Object pkId = args.getPkId();
        String entryKey = args.getEntryKey();
        String entityTypeId = args.getEntityTypeId();
        if (Objects.equals(pkId, 0) || StringUtils.isBlank((Object)pkId) || StringUtils.isBlank((CharSequence)entryKey) || StringUtils.isBlank((CharSequence)entityTypeId)) {
            return pageData;
        }
        try {
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityTypeId);
            DynamicObject dataEntity = BusinessDataReader.loadSingle((Object)pkId, (DynamicObjectType)entityType);
            pageData = dataEntity.getDynamicObjectCollection(entryKey);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return pageData;
    }

    @Override
    public MobTableHandleResult handleData(MobTablePackageDataHandlerArgs args) {
        DynamicObjectCollection pageData = args.getPageData();
        List<MobTableColumn> mobTableColumns = args.getMobTableColumns();
        IFormView view = args.getView();
        String entityTypeId = args.getEntityTypeId();
        String entryKey = args.getEntryKey();
        ArrayList<MobTableRowData> mobTableRowDataList = new ArrayList<MobTableRowData>(10);
        MobTableHandleResult mobTableHandleResult = new MobTableHandleResult();
        if (StringUtils.isBlank((CharSequence)entityTypeId) || StringUtils.isBlank((CharSequence)entryKey)) {
            mobTableHandleResult.setFmtInfo(this.getFmtInfo(args));
            return mobTableHandleResult;
        }
        Map<String, FieldEdit> entryGridControlItems = this.getEntryGridControlItems(entityTypeId, entryKey);
        for (int index = 0; index < pageData.size(); ++index) {
            MobTableRowData mobTableRowData = MobTableRowBuilder.buildTemplateRowData(index, mobTableColumns);
            HashMap<String, Object> cpropData = new HashMap<String, Object>(16);
            for (MobTableColumn col : mobTableColumns) {
                FieldEdit fldEdit = entryGridControlItems.get(col.getMobTableField());
                if (fldEdit == null) continue;
                fldEdit.setView(view);
                Object formatVal = fldEdit.getBindingValue(new BindingContext(pageData.get(index), index));
                mobTableRowData.setValue(col.getFieldKey(), formatVal);
                mobTableRowData.setCpropMap(this.getCpropData(col, pageData, index, cpropData));
            }
            mobTableRowDataList.add(mobTableRowData);
        }
        this.cacheMobTableRowDataList(mobTableRowDataList, args.getControl());
        mobTableHandleResult.setMobTableRowDataList(mobTableRowDataList);
        mobTableHandleResult.setFmtInfo(this.getFmtInfo(args));
        return mobTableHandleResult;
    }

    @Override
    public void handleSummary(MobTablePackageDataHandlerArgs args) {
        HashMap<String, BigDecimal> sumMap = new HashMap<String, BigDecimal>(16);
        HashMap<String, BigDecimal> avgMap = new HashMap<String, BigDecimal>(16);
        HashMap<String, BigDecimal> maxMap = new HashMap<String, BigDecimal>(16);
        HashMap<String, BigDecimal> minMap = new HashMap<String, BigDecimal>(16);
        HashMap<String, BigDecimal> cntMap = new HashMap<String, BigDecimal>(16);
        List<MobTableColumn> mobTableColumns = args.getMobTableColumns();
        for (MobTableColumn mobTableColumn : mobTableColumns) {
            int summaryType = 0;
            if (mobTableColumn instanceof DecimalMobTableColumn) {
                summaryType = ((DecimalMobTableColumn)mobTableColumn).getSummary();
            } else if (mobTableColumn instanceof AmountMobTableColumn) {
                summaryType = ((AmountMobTableColumn)mobTableColumn).getSummary();
            }
            String fieldKey = mobTableColumn.getFieldKey();
            switch (summaryType) {
                case 1: {
                    sumMap.put(fieldKey, new BigDecimal(0));
                    break;
                }
                case 4: {
                    avgMap.put(fieldKey, new BigDecimal(0));
                    break;
                }
                case 2: {
                    maxMap.put(fieldKey, null);
                    break;
                }
                case 3: {
                    minMap.put(fieldKey, null);
                    break;
                }
                case 5: {
                    cntMap.put(fieldKey, new BigDecimal(0));
                    break;
                }
            }
        }
        if (sumMap.isEmpty() && avgMap.isEmpty() && maxMap.isEmpty() && minMap.isEmpty() && cntMap.isEmpty()) {
            return;
        }
        if (args.getControl() == null) {
            return;
        }
        DynamicObjectCollection pageData = args.getPageData();
        if (pageData == null) {
            return;
        }
        HashMap<String, BigDecimal> calcSumMap = new HashMap<String, BigDecimal>(16);
        sumMap.keySet().forEach(k -> calcSumMap.put((String)k, new BigDecimal(0)));
        avgMap.keySet().forEach(k -> calcSumMap.put((String)k, new BigDecimal(0)));
        HashMap<String, String> mobTableColMap = new HashMap<String, String>(16);
        for (MobTableColumn mobTableColumn : mobTableColumns) {
            if (!StringUtils.isNotBlank((CharSequence)mobTableColumn.getMobTableField())) continue;
            mobTableColMap.put(mobTableColumn.getFieldKey(), mobTableColumn.getMobTableField());
        }
        int rowCount = 0;
        for (DynamicObject row : pageData) {
            this.calcSum(row, mobTableColMap, calcSumMap, (v1, v2) -> v2 != null ? v1.add((BigDecimal)v2) : v1);
            this.calcSum(row, mobTableColMap, maxMap, (v1, v2) -> v1 == null ? v2 : (v1.compareTo((BigDecimal)v2) > 0 ? v1 : v2));
            this.calcSum(row, mobTableColMap, minMap, (v1, v2) -> v1 == null ? v2 : (v1.compareTo((BigDecimal)v2) < 0 ? v1 : v2));
            ++rowCount;
        }
        IFormView iFormView = args.getView();
        String ctlKey = args.getControl().getKey();
        HashMap<String, Boolean> floatBottomData = new HashMap<String, Boolean>(16);
        floatBottomData.put("__cilentFormat", true);
        HashMap floatBottomData2 = new HashMap(16);
        sumMap.forEach((k, v) -> floatBottomData.put((String)k, (Boolean)calcSumMap.get(k)));
        int rowCnt = rowCount;
        avgMap.forEach((k, v) -> {
            if (rowCnt != 0) {
                floatBottomData.put((String)k, (Boolean)((Object)((BigDecimal)calcSumMap.get(k)).divide(new BigDecimal(rowCnt), 10, 0)));
            }
        });
        cntMap.forEach((k, v) -> floatBottomData2.put(k, rowCnt));
        maxMap.forEach((k, v) -> Optional.ofNullable(maxMap.get(k)).map(val -> floatBottomData.put((String)k, (Boolean)val)));
        minMap.forEach((k, v) -> Optional.ofNullable(minMap.get(k)).map(val -> floatBottomData.put((String)k, (Boolean)val)));
        IClientViewProxy clientViewProxy = (IClientViewProxy)iFormView.getService(IClientViewProxy.class);
        if (!floatBottomData.isEmpty()) {
            clientViewProxy.invokeControlMethod(ctlKey, "setFloatButtomData", floatBottomData);
        }
        if (!floatBottomData2.isEmpty()) {
            clientViewProxy.invokeControlMethod(ctlKey, "setFloatButtomData", floatBottomData2);
        }
    }

    private void calcSum(DynamicObject row, Map<String, String> mobTableColMap, Map<String, BigDecimal> calcMap, BiFunction<BigDecimal, BigDecimal, BigDecimal> calc) {
        for (Map.Entry<String, BigDecimal> entry : calcMap.entrySet()) {
            String mobTableField = mobTableColMap.get(entry.getKey());
            if (!StringUtils.isNotBlank((CharSequence)mobTableField) || row.getDynamicObjectType().getProperties().get((Object)mobTableField) == null) continue;
            Object value = row.get(mobTableField);
            if (value instanceof BigDecimal) {
                calcMap.compute(entry.getKey(), (k, v) -> (BigDecimal)calc.apply((BigDecimal)v, (BigDecimal)value));
                continue;
            }
            if (!(value instanceof Integer)) continue;
            calcMap.compute(entry.getKey(), (k, v) -> (BigDecimal)calc.apply((BigDecimal)v, new BigDecimal((Integer)value)));
        }
    }

    protected void cacheMobTableRowDataList(List<MobTableRowData> mobTableRowDataList, MobTable mobTable) {
        LinkedHashSet<String> prepareColKeys = new LinkedHashSet<String>(16);
        for (IMobTablePrepareDataListener listener : mobTable.getPrepareDataListener()) {
            MobTablePrepareDataArgs prepareDataArgs = new MobTablePrepareDataArgs(mobTable);
            listener.onPrepareData(prepareDataArgs);
            prepareColKeys.addAll(prepareDataArgs.getMobTableColKeys());
        }
        ArrayList<Map<String, Object>> cacheDataMapList = new ArrayList<Map<String, Object>>(10);
        for (MobTableRowData mobTableRowData : mobTableRowDataList) {
            Map<String, Object> rowDataMap = mobTableRowData.getRowDataMap(prepareColKeys);
            if (rowDataMap.isEmpty()) continue;
            rowDataMap.put(RK, mobTableRowData.getRowIndex());
            cacheDataMapList.add(rowDataMap);
        }
        if (cacheDataMapList.size() > 0) {
            mobTable.getView().getPageCache().put(String.format("%s_%s", mobTable.getKey(), TABLE_DATA), SerializationUtils.toJsonString(cacheDataMapList));
        }
    }

    private Map<String, FieldEdit> getEntryGridControlItems(String entityId, String entryKey) {
        FormRoot rootControl = FormMetadataCache.getRootControl(entityId);
        HashMap<String, Control> cacheControls = new HashMap<String, Control>();
        this.getAllControl(rootControl.getItems(), cacheControls);
        EntryGrid entryGrid = (EntryGrid)cacheControls.get(entryKey);
        ArrayList<FieldEdit> fieldEdits = new ArrayList<FieldEdit>();
        this.addFieldEditToList(fieldEdits, entryGrid.getItems());
        return fieldEdits.stream().collect(Collectors.toMap(Control::getKey, item -> item));
    }

    private void addFieldEditToList(List<FieldEdit> fieldEdits, List<Control> items) {
        for (Control c : items) {
            if (c instanceof Container) {
                this.addFieldEditToList(fieldEdits, ((Container)c).getItems());
                continue;
            }
            if (!(c instanceof FieldEdit)) continue;
            fieldEdits.add((FieldEdit)c);
        }
    }

    private Map<String, Object> getCpropData(MobTableColumn col, DynamicObjectCollection pageData, int index, Map<String, Object> cpropData) {
        IDataEntityType dataEntityType = ((DynamicObject)pageData.get(index)).getDataEntityType();
        if (dataEntityType != null && dataEntityType.getProperties() != null) {
            IDataEntityProperty property;
            if (col instanceof AmountMobTableColumn) {
                AmountProp prop = (AmountProp)dataEntityType.getProperties().get((Object)col.getMobTableField());
                String currencyFieldName = prop.getControlPropName();
                if (StringUtils.isNotBlank((CharSequence)currencyFieldName)) {
                    DynamicObject currencyfield = null;
                    try {
                        currencyfield = ((DynamicObject)pageData.get(index)).getDynamicObject(currencyFieldName);
                    }
                    catch (Exception e) {
                        logger.error((Throwable)e);
                    }
                    if (currencyfield != null) {
                        String number = currencyfield.getString("number");
                        String name = (String)currencyfield.getLocaleString("name").get((Object)"zh_CN");
                        cpropData.put(currencyFieldName, Arrays.asList(number, name, number, "", ""));
                    }
                }
            } else if (col instanceof DecimalMobTableColumn && (property = (IDataEntityProperty)dataEntityType.getProperties().get((Object)col.getMobTableField())) instanceof QtyProp) {
                IDataEntityType entityType;
                IDataEntityProperty unitProp;
                String controlPropName = ((QtyProp)property).getControlPropName();
                DynamicObject obj = (DynamicObject)pageData.get(index);
                if (StringUtils.isNotBlank((CharSequence)controlPropName) && (unitProp = (IDataEntityProperty)(entityType = obj.getDataEntityType()).getProperties().get((Object)controlPropName)) instanceof UnitProp) {
                    DynamicObject unitObj = null;
                    try {
                        unitObj = obj.getDynamicObject(controlPropName);
                    }
                    catch (Exception e) {
                        logger.error((Throwable)e);
                    }
                    if (unitObj != null) {
                        cpropData.put(controlPropName, unitObj.getString("number"));
                    }
                }
            }
        }
        return cpropData;
    }

    private void getAllControl(List<Control> items, Map<String, Control> cacheControls) {
        for (Control control : items) {
            cacheControls.put(control.getKey(), control);
            if (!(control instanceof Container)) continue;
            this.getAllControl(((Container)control).getItems(), cacheControls);
        }
    }

    @Override
    public Map<String, Object> getFmtInfo(MobTablePackageDataHandlerArgs args) {
        DynamicObjectCollection pageData = args.getPageData();
        List<MobTableColumn> mobTableColumns = args.getMobTableColumns();
        String entityTypeId = args.getEntityTypeId();
        String entryKey = args.getEntryKey();
        HashMap<String, Object> numFmtInfo = new HashMap<String, Object>();
        numFmtInfo.put("colfmt", Collections.emptyMap());
        numFmtInfo.put("currencyfmt", Collections.emptyMap());
        numFmtInfo.put("unitfmt", Collections.emptyMap());
        numFmtInfo.put("timezonefmt", Collections.emptyMap());
        if (StringUtils.isBlank((CharSequence)entityTypeId) || pageData.isEmpty()) {
            return numFmtInfo;
        }
        ArrayList<FmtField> fmtFields = new ArrayList<FmtField>();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityTypeId);
        List entryEntitys = entityType.getProperties().getCollectionProperties(false);
        for (ICollectionProperty property : entryEntitys) {
            if (!(property instanceof EntryProp) || !StringUtils.equals((CharSequence)entryKey, (CharSequence)property.getName())) continue;
            for (MobTableColumn col : mobTableColumns) {
                FmtField fmtField;
                IDataEntityProperty prop = (IDataEntityProperty)property.getItemType().getProperties().get((Object)col.getMobTableField());
                if (prop instanceof DecimalProp) {
                    fmtField = new FmtField(prop, col.getFieldKey(), ((DecimalProp)prop).getControlPropName());
                    fmtFields.add(fmtField);
                    continue;
                }
                if (!(prop instanceof DateTimeProp)) continue;
                fmtField = new FmtField(prop, col.getFieldKey(), prop instanceof DateProp ? null : ((DateTimeProp)prop).getRelateOrg());
                fmtFields.add(fmtField);
            }
        }
        NumberFormatProvider numberFormatProvider = new NumberFormatProvider(fmtFields, pageData);
        numFmtInfo.put("colfmt", numberFormatProvider.getColfmt());
        numFmtInfo.put("currencyfmt", numberFormatProvider.getCurrencyfmt());
        numFmtInfo.put("unitfmt", numberFormatProvider.getUnitfmt());
        numFmtInfo.put("timezonefmt", numberFormatProvider.getTimeZoneFmt());
        return numFmtInfo;
    }
}

