/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.operate;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import kd.bos.dataentity.TypesContainer;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.bos.form.operate.IFormMutexService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.sysparam.SystemParamService;
import kd.bos.service.ServiceFactory;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class CoreMutexHelper {
    private static final Log log = LogFactory.getLog(CoreMutexHelper.class);
    public static final String ENTITY_KEY = "MUTEX_ENTITY_KEY";
    public static final String OPERATION_KEY = "MUTEX_OPER_KEY";
    public static final String OBJ_PKID = "MUTEX_OBJ_ID";
    public static final String HENTITY_ID = "HMUTEX_ENTITY_ID";
    public static final String HOBJ_PKID = "HMUTEX_OBJ_ID";
    public static final String HYPERLINK = "HYPERLINK";
    private static final String MUTEX_REQUIRE_ERROR = "MUTEX_REQUIRE_ERROR";
    private static final String BOS_FORM_METADATA = "bos-form-metadata";
    public static final String INTENT_KEY = "INTENTKEY_";
    private static String mobLockTimeOutMinute = System.getProperty("mutex.locktimeout.mob", "30");
    public static final String MUTEX_CALL_SOURCE = "default";

    private CoreMutexHelper() {
    }

    public static String requireIntent(IFormView view, String entityId, Object pkId, StringBuilder errMsg) {
        return CoreMutexHelper.getServiceBySafeModel(view).requireIntent(entityId, pkId).getIntentKey();
    }

    private static IFormMutexService getServiceBySafeModel(IFormView view) {
        IFormMutexService service = (IFormMutexService)view.getService(IFormMutexService.class);
        if (service == null) {
            try {
                Class classType = TypesContainer.getOrRegister((String)"kd.bos.mvc.form.FormMutexService");
                Constructor constructor = classType.getConstructor(IFormView.class);
                service = (IFormMutexService)constructor.newInstance(view);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new KDException("IFormMutexService not register");
            }
        }
        return service;
    }

    public static boolean isOpenIntentLocks() {
        boolean intentlocks = false;
        try {
            SystemParamService paramService = (SystemParamService)ServiceFactory.getService(SystemParamService.class);
            intentlocks = Boolean.TRUE.equals(paramService.loadPublicParameterFromCache("intentlocks"));
        }
        catch (Exception e) {
            log.error("invoke isOpenIntentLocks error: %s", (Object)e.getMessage());
        }
        return intentlocks;
    }
}

